/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.switching;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateAspectCommand
extends AbstractScriptCommand<AccessoryScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivateAspectCommand.class);
    public static final String KEY = "activateAspect";
    public static final String HELP = "<div class=\"codeblock\">activateAspect" + ActivateAspectCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] <accessoryNumber>=<aspectNumber>") + "</div>" + ActivateAspectCommand.prepareHelpHtml("\nActivate the aspect of accessory.");
    private int[] vidPid;
    private boolean processAllNodes;
    private List<AccessoryAspectTask> taskList = new LinkedList<AccessoryAspectTask>();

    public ActivateAspectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    /*
     * Exception decompiling
     */
    public void parse(String commandLine) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    public List<AccessoryAspectTask> getTaskList() {
        return this.taskList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(AccessoryScripting scripting, ApplicationContext context) {
        LOGGER.info("Activate aspects: {}", this.taskList);
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
        if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                throw new ScriptExecutionException("No matching node with provided VID/PID found.", this);
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set CV values.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        block0: while (iterator.hasNext()) {
            NodeInterface node = (NodeInterface)iterator.next();
            Iterator<AccessoryAspectTask> iterator2 = this.taskList.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                AccessoryAspectTask task = iterator2.next();
                scripting.setActiveAspect(node.getSwitchingNode(), task.getAccessoryNumber(), task.getAspectNumber());
            }
            break;
        }
        return;
    }

    public static class AccessoryAspectTask {
        private final int accessoryNumber;
        private final int aspectNumber;

        public AccessoryAspectTask(int accessoryNumber, int aspectNumber) {
            this.accessoryNumber = accessoryNumber;
            this.aspectNumber = aspectNumber;
        }

        public int getAccessoryNumber() {
            return this.accessoryNumber;
        }

        public int getAspectNumber() {
            return this.aspectNumber;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

