/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.switching;

import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFeedbackAndExpectCommand<T extends PortScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryFeedbackAndExpectCommand.class);
    public static final String KEY = "feedbackQueryState";
    public static final String HELP = "<div class=\"codeblock\">feedbackQueryState" + QueryFeedbackAndExpectCommand.prepareHelpHtml(" [--wait=<wait in seconds>] [--message=<dialog message>] <portNumber> <expectedStatus [FREE|OCCUPIED]>") + "</div>" + QueryFeedbackAndExpectCommand.prepareHelpHtml("\nQuery the status of a feedback port.\n\nUse the --wait parameter to show a dialog if the status is not the expected status already.\n\nExample:\n") + "<div class=\"codeblock\">" + QueryFeedbackAndExpectCommand.prepareHelpHtml("feedbackQueryState --wait=50 5 OCCUPIED") + "</div>" + QueryFeedbackAndExpectCommand.prepareHelpHtml("This will wait for max. 50s if status of feedback port is not OCCUPIED\n\n") + "<div class=\"codeblock\">" + QueryFeedbackAndExpectCommand.prepareHelpHtml("feedbackQueryState --wait=50 --message=\"Press the red button on the device!\" 5 OCCUPIED") + "</div>" + QueryFeedbackAndExpectCommand.prepareHelpHtml("This will wait for max. 50s if status of feedback port is not OCCUPIED. The message in the dialog is: Press the red button on the device!");
    private boolean showWaitDialog;
    private int waitSeconds = 60;
    private int portNum;
    private String dialogMessage;
    private FeedbackPortStatus expectedPortStatus;

    protected QueryFeedbackAndExpectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        this.line = commandLine.trim();
        if (!this.line.startsWith(this.getKey())) {
            LOGGER.info("Invalid command is scanned, key does not match.");
            throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
        }
        String arguments = this.line.substring(KEY.length() + 1);
        int skipItems = 0;
        int startIndex = arguments.indexOf("--wait=");
        if (startIndex > -1) {
            LOGGER.info("Show wait dialog if status does not match.");
            this.showWaitDialog = true;
            this.waitSeconds = ScriptUtils.parseIntParam("--wait=\\d+", arguments);
            skipItems = startIndex + "--wait=".length() + Integer.toString(this.waitSeconds).length();
        }
        if ((startIndex = arguments.indexOf("--message=")) > -1) {
            this.dialogMessage = ScriptUtils.parseStringParam("(?<=--message=)?\\\"(?s)(.*)?\\\"", arguments);
            skipItems = startIndex + "--message=".length() + 2 + this.dialogMessage.length();
        }
        try (Scanner scanner = new Scanner(arguments.substring(skipItems));){
            this.portNum = scanner.nextInt();
            this.expectedPortStatus = FeedbackPortStatus.fromString((String)scanner.next().toUpperCase());
        }
        LOGGER.info("Parsed command, portNum: {}, expectedPortStatus: {}", (Object)this.portNum, (Object)this.expectedPortStatus);
    }

    public boolean isShowWaitDialog() {
        return this.showWaitDialog;
    }

    public int getWaitSeconds() {
        return this.waitSeconds;
    }

    public String getDialogMessage() {
        return this.dialogMessage;
    }

    public int getPortNum() {
        return this.portNum;
    }

    public FeedbackPortStatus getExpectedPortStatus() {
        return this.expectedPortStatus;
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Query the feedback status, portNum: {}, expectedPortStatus: {}", (Object)this.portNum, (Object)this.expectedPortStatus);
        NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
        if (this.showWaitDialog) {
            if (StringUtils.isBlank((CharSequence)this.dialogMessage)) {
                String nodeLabel = StringUtils.isNotBlank((CharSequence)node.getLabel()) ? node.getLabel() : ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
                this.dialogMessage = "Wait for change of occupancy state of port " + this.portNum + " on node: " + nodeLabel;
            }
            scripting.assertPortStatusActionWithDialog(node.getUniqueId(), this.waitSeconds, this.dialogMessage, LcOutputType.FEEDBACKPORT, this.portNum, (BidibStatus)this.expectedPortStatus);
        } else {
            scripting.assertPortStatusAction(node.getUniqueId(), LcOutputType.FEEDBACKPORT, this.portNum, (BidibStatus)this.expectedPortStatus);
        }
    }
}

