/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.switching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFeedbackRailcomAndExpectCommand
extends AbstractScriptCommand<PortScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryFeedbackRailcomAndExpectCommand.class);
    public static final String KEY = "feedbackQueryRailcom";
    public static final String HELP = "<div class=\"codeblock\">feedbackQueryRailcom" + QueryFeedbackRailcomAndExpectCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] [--uid=<uniqueId>] [--wait=<wait in seconds>] [--message=<dialog message>] --portNumber=<portNumber> --expectedLocoAddress=<loco-address>") + "</div>" + QueryFeedbackRailcomAndExpectCommand.prepareHelpHtml("\nQuery the status of a feedback port.\n\nUse the --wait parameter to show a dialog if the status is not the expected status already.\n\nExample:\n") + "<div class=\"codeblock\">" + QueryFeedbackRailcomAndExpectCommand.prepareHelpHtml("feedbackQueryRailcom --uid=0x0D86002CEC --wait=50 --portNumber=5 --expectedLocoAddress=3") + "</div>" + QueryFeedbackRailcomAndExpectCommand.prepareHelpHtml("This will wait for max. 50s if feedback port 5 has not loco address 3\n\n") + "<div class=\"codeblock\">" + QueryFeedbackRailcomAndExpectCommand.prepareHelpHtml("feedbackQueryRailcom --wait=50 --message=\"Put the loco on the tracks!\" --portNumber=5 --expectedLocoAddress=3") + "</div>" + QueryFeedbackRailcomAndExpectCommand.prepareHelpHtml("This will wait for max. 50s if status of feedback port 5 has not loco address 3. The message in the dialog is: Put the loco on the tracks!");
    private boolean showWaitDialog;
    private int waitSeconds = 60;
    private int[] vidPid;
    private boolean processAllNodes;
    private String uniqueId;
    private int portNumber;
    private String dialogMessage;
    private int expectedLocoAddress;

    protected QueryFeedbackRailcomAndExpectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        this.setLine(commandLine.trim());
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.uniqueId = scanner.next("--uid=(0x|0X)?[a-fA-F0-9]+").substring(6);
            }
            catch (Exception ex) {
                LOGGER.info("No uniqueId found. Fallback to VID/PID.");
            }
            if (this.uniqueId == null) {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
                if (this.line.indexOf("--all") > -1) {
                    LOGGER.info("Process all nodes is activated.");
                    this.processAllNodes = true;
                    scanner.next();
                }
            }
        }
        String arguments = this.line.substring(KEY.length() + 1);
        int startIndex = arguments.indexOf("--wait=");
        if (startIndex > -1) {
            LOGGER.info("Show wait dialog if status does not match.");
            this.showWaitDialog = true;
            this.waitSeconds = ScriptUtils.parseIntParam("--wait=\\d+", arguments);
        }
        if ((startIndex = arguments.indexOf("--message=")) > -1) {
            this.dialogMessage = ScriptUtils.parseStringParam("(?<=--message=)?\\\"(?s)(.*)?\\\"", arguments);
        }
        this.portNumber = ScriptUtils.parseIntParam("--portNumber=\\d+", arguments);
        this.expectedLocoAddress = ScriptUtils.parseIntParam("--expectedLocoAddress=\\d+", arguments);
        LOGGER.info("Parsed command, portNumber: {}, expectedLocoAddress: {}", (Object)this.portNumber, (Object)this.expectedLocoAddress);
    }

    public boolean isShowWaitDialog() {
        return this.showWaitDialog;
    }

    public int getWaitSeconds() {
        return this.waitSeconds;
    }

    public String getDialogMessage() {
        return this.dialogMessage;
    }

    public int getPortNum() {
        return this.portNumber;
    }

    public int getExpectedLocoAddress() {
        return this.expectedLocoAddress;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(PortScripting scripting, ApplicationContext context) {
        LOGGER.info("Query the feedback status, portNum: {}, expectedLocoAddress: {}", (Object)this.portNumber, (Object)this.expectedLocoAddress);
        ArrayList<NodeInterface> nodes = new ArrayList<NodeInterface>();
        if (this.uniqueId != null) {
            long uniqueId = 0L;
            Pattern pattern = Pattern.compile("(0x|0X)?([a-fA-F0-9]+)");
            Matcher matcher = pattern.matcher(this.uniqueId);
            if (!matcher.matches()) {
                this.addError(context, "No UniqueId provided.");
                return;
            }
            String raw = matcher.group(2);
            uniqueId = Long.parseLong(raw, 16);
            LOGGER.info("UniqueId: {}", (Object)uniqueId);
            NodeInterface node = scripting.getNodeByUniqueIdWithoutClassBits(NodeUtils.getUniqueId((long)uniqueId));
            if (node == null) {
                throw new ScriptExecutionException("No matching node with provided uniqueId found.", this);
            }
            nodes.add(node);
        } else if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found, VID: " + this.vidPid[0] + ", PID: " + this.vidPid[1]);
                throw new IllegalArgumentException("No matching node with provided VID/PID found, VID: " + this.vidPid[0] + ", PID: " + this.vidPid[1]);
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set command station state.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            NodeInterface node = (NodeInterface)iterator.next();
            LOGGER.info("Found node: {}", (Object)node);
            if (this.showWaitDialog) {
                if (StringUtils.isBlank((CharSequence)this.dialogMessage)) {
                    String nodeLabel = StringUtils.isNotBlank((CharSequence)node.getLabel()) ? node.getLabel() : ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
                    this.dialogMessage = "Wait for change of occupancy state of port " + this.portNumber + " on node: " + nodeLabel;
                }
                scripting.assertPortRailcomActionWithDialog(node.getUniqueId(), this.waitSeconds, this.dialogMessage, this.portNumber, this.expectedLocoAddress);
                continue;
            }
            scripting.assertPortRailcomAction(node.getUniqueId(), this.portNumber, this.expectedLocoAddress);
        }
        return;
    }
}

