/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.switching;

import java.util.Scanner;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInputAndExpectCommand<T extends PortScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryInputAndExpectCommand.class);
    public static final String KEY = "inputQueryState";
    public static final String HELP = "<div class=\"codeblock\">inputQueryState" + QueryInputAndExpectCommand.prepareHelpHtml(" <portNumber> <expectedStatus [ON|OFF]>") + "</div>" + QueryInputAndExpectCommand.prepareHelpHtml("\nQuery the input state of the port and compare the state to the expected state.");
    private int portNum;
    private InputPortStatus expectedPortStatus;

    protected QueryInputAndExpectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.portNum = scanner.nextInt();
            this.expectedPortStatus = InputPortStatus.fromString((String)scanner.next().toUpperCase());
        }
        LOGGER.info("Parsed command, portNum: {}, expectedPortStatus: {}", (Object)this.portNum, (Object)this.expectedPortStatus);
    }

    public int getPortNum() {
        return this.portNum;
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Query the input status, portNum: {}, expectedPortStatus: {}", (Object)this.portNum, (Object)this.expectedPortStatus);
        NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
        scripting.assertPortStatusAction(node != null ? node.getSwitchingNode() : null, LcOutputType.INPUTPORT, this.portNum, (BidibStatus)this.expectedPortStatus);
    }
}

