/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.switching;

import java.util.Scanner;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServoPortCommand<T extends PortScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServoPortCommand.class);
    public static final String KEY = "servo";
    public static final String HELP = "<div class=\"codeblock\">servo" + ServoPortCommand.prepareHelpHtml(" <portNumber> <position>") + "</div>" + ServoPortCommand.prepareHelpHtml("\nSet the position of the servo port.");
    private int portNum;
    private int position;

    public ServoPortCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.portNum = scanner.nextInt();
            this.position = scanner.nextInt();
        }
        LOGGER.info("Parsed command, portNum: {}, position: {}", (Object)this.portNum, (Object)this.position);
    }

    public int getPortNum() {
        return this.portNum;
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Set the status, portNum: {}, position: {}", (Object)this.portNum, (Object)this.position);
        NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
        scripting.sendPortValueAction(node != null ? node.getSwitchingNode() : null, LcOutputType.SERVOPORT, this.portNum, this.position);
    }
}

