/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.switching;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.booster.BoosterCurrentAssertCommand;
import org.bidib.wizard.common.script.booster.BoosterQueryStateCommand;
import org.bidib.wizard.common.script.booster.BoosterSetStateCommand;
import org.bidib.wizard.common.script.booster.CommandStationDriveCommand;
import org.bidib.wizard.common.script.booster.CommandStationGetStateCommand;
import org.bidib.wizard.common.script.booster.CommandStationQueryStateAndExpectCommand;
import org.bidib.wizard.common.script.booster.CommandStationSetStateCommand;
import org.bidib.wizard.common.script.common.AbortCommand;
import org.bidib.wizard.common.script.common.ConnectCommand;
import org.bidib.wizard.common.script.common.DisconnectCommand;
import org.bidib.wizard.common.script.common.EchoAndShowConfirmDialogCommand;
import org.bidib.wizard.common.script.common.EchoCommand;
import org.bidib.wizard.common.script.common.EvaluateAndAssertCommand;
import org.bidib.wizard.common.script.common.ExecuteProcessCommand;
import org.bidib.wizard.common.script.common.ScriptOptionCommand;
import org.bidib.wizard.common.script.common.SelectFirstNodeCommand;
import org.bidib.wizard.common.script.common.SelectNodeCommand;
import org.bidib.wizard.common.script.common.WaitCommand;
import org.bidib.wizard.common.script.debug.ConnectDebugCommand;
import org.bidib.wizard.common.script.debug.DisconnectDebugCommand;
import org.bidib.wizard.common.script.debug.SendDebugTextCommand;
import org.bidib.wizard.common.script.node.ConfigPortCommand;
import org.bidib.wizard.common.script.node.CvGetAssertEqualsCommand;
import org.bidib.wizard.common.script.node.CvSetCommand;
import org.bidib.wizard.common.script.node.FeatureGetAllCommand;
import org.bidib.wizard.common.script.node.FeatureSetCommand;
import org.bidib.wizard.common.script.node.IdentifyStateCommand;
import org.bidib.wizard.common.script.node.NodeDebugSendTextCommand;
import org.bidib.wizard.common.script.node.QueryIdentifyStateAndExpectCommand;
import org.bidib.wizard.common.script.node.StringGetAssertEqualsCommand;
import org.bidib.wizard.common.script.node.StringSetCommand;
import org.bidib.wizard.common.script.switching.ActivateAndWaitForAspectCommand;
import org.bidib.wizard.common.script.switching.ActivateAspectCommand;
import org.bidib.wizard.common.script.switching.ConfigCommand;
import org.bidib.wizard.common.script.switching.EvaluatedKeyProvider;
import org.bidib.wizard.common.script.switching.LightPortCommand;
import org.bidib.wizard.common.script.switching.MotorPortCommand;
import org.bidib.wizard.common.script.switching.QueryFeedbackAndExpectCommand;
import org.bidib.wizard.common.script.switching.QueryFeedbackRailcomAndExpectCommand;
import org.bidib.wizard.common.script.switching.QueryInputAndExpectCommand;
import org.bidib.wizard.common.script.switching.ServoPortCommand;
import org.bidib.wizard.common.script.switching.SoundPortCommand;
import org.bidib.wizard.common.script.switching.SwitchPairPortCommand;
import org.bidib.wizard.common.script.switching.SwitchPortCommand;
import org.bidib.wizard.common.script.test.CvGetEmergencyIPCommand;
import org.bidib.wizard.common.script.test.CvGetMacCommand;
import org.bidib.wizard.common.script.test.ReadMotFuncJsonCommand;
import org.bidib.wizard.common.script.test.SearchNetBidibDeviceAndConnectCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchFunctionsScriptCommandFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchFunctionsScriptCommandFactory.class);
    private Map<String, Class<?>> scriptCommands = new HashMap();
    private final ConsoleService consoleService;

    public SwitchFunctionsScriptCommandFactory(ConsoleService consoleService) {
        this.consoleService = consoleService;
        this.scriptCommands.put("activateAndWaitForAspect", ActivateAndWaitForAspectCommand.class);
        this.scriptCommands.put("activateAspect", ActivateAspectCommand.class);
        this.scriptCommands.put("light", LightPortCommand.class);
        this.scriptCommands.put("motor", MotorPortCommand.class);
        this.scriptCommands.put("servo", ServoPortCommand.class);
        this.scriptCommands.put("sound", SoundPortCommand.class);
        this.scriptCommands.put("switch", SwitchPortCommand.class);
        this.scriptCommands.put("switchpair", SwitchPairPortCommand.class);
        this.scriptCommands.put("wait", WaitCommand.class);
        this.scriptCommands.put("config", ConfigCommand.class);
        this.scriptCommands.put("configPort", ConfigPortCommand.class);
        this.scriptCommands.put("selectFirstNode", SelectFirstNodeCommand.class);
        this.scriptCommands.put("selectNode", SelectNodeCommand.class);
        this.scriptCommands.put("boosterSetState", BoosterSetStateCommand.class);
        this.scriptCommands.put("boosterQueryState", BoosterQueryStateCommand.class);
        this.scriptCommands.put("boosterCurrentAssert", BoosterCurrentAssertCommand.class);
        this.scriptCommands.put("csSetState", CommandStationSetStateCommand.class);
        this.scriptCommands.put("csGetState", CommandStationGetStateCommand.class);
        this.scriptCommands.put("csQueryState", CommandStationQueryStateAndExpectCommand.class);
        this.scriptCommands.put("csDrive", CommandStationDriveCommand.class);
        this.scriptCommands.put("inputQueryState", QueryInputAndExpectCommand.class);
        this.scriptCommands.put("feedbackQueryState", QueryFeedbackAndExpectCommand.class);
        this.scriptCommands.put("feedbackQueryRailcom", QueryFeedbackRailcomAndExpectCommand.class);
        this.scriptCommands.put("cvSet", CvSetCommand.class);
        this.scriptCommands.put("cvGetAssertEquals", CvGetAssertEqualsCommand.class);
        this.scriptCommands.put("featureSet", FeatureSetCommand.class);
        this.scriptCommands.put("featureGetAll", FeatureGetAllCommand.class);
        this.scriptCommands.put("stringSet", StringSetCommand.class);
        this.scriptCommands.put("stringGetAssertEquals", StringGetAssertEqualsCommand.class);
        this.scriptCommands.put("cvGetMacCommand", CvGetMacCommand.class);
        this.scriptCommands.put("cvGetEmergencyIPCommand", CvGetEmergencyIPCommand.class);
        this.scriptCommands.put("echo", EchoCommand.class);
        this.scriptCommands.put("echoAndShowConfirmDialog", EchoAndShowConfirmDialogCommand.class);
        this.scriptCommands.put("abort", AbortCommand.class);
        this.scriptCommands.put("exec", ExecuteProcessCommand.class);
        this.scriptCommands.put("identifyState", IdentifyStateCommand.class);
        this.scriptCommands.put("queryIdentifyState", QueryIdentifyStateAndExpectCommand.class);
        this.scriptCommands.put("connect", ConnectCommand.class);
        this.scriptCommands.put("disconnect", DisconnectCommand.class);
        this.scriptCommands.put("connectDebugInterface", ConnectDebugCommand.class);
        this.scriptCommands.put("disconnectDebugInterface", DisconnectDebugCommand.class);
        this.scriptCommands.put("sendDebugText", SendDebugTextCommand.class);
        this.scriptCommands.put("readMotFuncJson", ReadMotFuncJsonCommand.class);
        this.scriptCommands.put("searchNetBidibDeviceAndConnect", SearchNetBidibDeviceAndConnectCommand.class);
        this.scriptCommands.put("nodeDebugSendText", NodeDebugSendTextCommand.class);
        this.scriptCommands.put("scriptOption", ScriptOptionCommand.class);
        this.scriptCommands.put("evaluateAndAssert", EvaluateAndAssertCommand.class);
    }

    public ScriptCommand<Scripting> parse(String line) {
        try (Scanner scanner = new Scanner(line);){
            String evaluatedKey;
            String key = scanner.next();
            ScriptCommand<Scripting> command = this.getScriptCommand(key);
            if (command instanceof EvaluatedKeyProvider && (evaluatedKey = ((EvaluatedKeyProvider)command).getEvaluatedKey(scanner)) != null) {
                command = this.getScriptCommand(evaluatedKey);
            }
            if (command != null) {
                command.parse(line);
            }
            ScriptCommand<Scripting> scriptCommand = command;
            return scriptCommand;
        }
    }

    private ScriptCommand<Scripting> getScriptCommand(String key) {
        Class<?> clazz = this.scriptCommands.get(key);
        if (clazz == null) {
            LOGGER.warn("Command is not registered: {}", (Object)key);
            throw new IllegalArgumentException("Command is not registered: " + key);
        }
        try {
            return (ScriptCommand)clazz.getDeclaredConstructor(ConsoleService.class).newInstance(this.consoleService);
        }
        catch (Exception ex) {
            LOGGER.warn("Create switch function script command class failed.", (Throwable)ex);
            return null;
        }
    }

    public List<String> prepareHelp() {
        LinkedList<String> helpItems = new LinkedList<String>();
        TreeSet<String> keys = new TreeSet<String>(this.scriptCommands.keySet());
        for (String key : keys) {
            ScriptCommand<Scripting> command = this.getScriptCommand(key);
            command.getHelp().ifPresent(help -> helpItems.add((String)help));
        }
        return helpItems;
    }
}

