/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.switching;

import java.util.Scanner;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPortCommand<T extends PortScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPortCommand.class);
    public static final String KEY = "switch";
    public static final String HELP = "<div class=\"codeblock\">switch" + SwitchPortCommand.prepareHelpHtml(" <portNumber> [ON|OFF|TEST]") + "</div>" + SwitchPortCommand.prepareHelpHtml("\nSet the status of the switch port.");
    private int portNum;
    private SwitchPortStatus portStatus;

    public SwitchPortCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.portNum = scanner.nextInt();
            this.portStatus = SwitchPortStatus.fromString((String)scanner.next());
        }
        LOGGER.info("Parsed command, portNum: {}, portStatus: {}", (Object)this.portNum, (Object)this.portStatus);
    }

    public int getPortNum() {
        return this.portNum;
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Set the status, portNum: {}, portStatus: {}", (Object)this.portNum, (Object)this.portStatus);
        NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
        scripting.sendPortStatusAction(node != null ? node.getSwitchingNode() : null, LcOutputType.SWITCHPORT, this.portNum, (BidibStatus)this.portStatus);
    }
}

