/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.script.node.types.CvType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvGetMacCommand<T extends NodeScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvGetMacCommand.class);
    public static final String KEY = "cvGetMacCommand";
    public static final String HELP = "<div class=\"codeblock\">cvGetMacCommand" + CvGetMacCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] --firstCV=<cvKeyStart>") + "</div>" + CvGetMacCommand.prepareHelpHtml("\nGet the CV value(s) and combine the read values to a MAC address. The formatted MAC address is stored in the parameter map of the script context and can be used with placeholder key \"macAddress\" for parameter subsitution (see echo command).");
    private int[] vidPid;
    private boolean processAllNodes;
    private final List<CvType> cvValues = new ArrayList<CvType>();

    public CvGetMacCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        block12: {
            try (Scanner scanner = new Scanner(commandLine);){
                Pattern pattern;
                Matcher matcher;
                if (!this.getKey().equals(scanner.next())) {
                    LOGGER.info("Invalid command is scanned, key does not match.");
                    throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
                }
                this.line = commandLine.trim();
                String arguments = this.line.substring(KEY.length() + 1);
                try {
                    this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                    if (this.vidPid != null) {
                        LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                    }
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.info("Parse VID/PID failed.", (Throwable)ex);
                    throw new IllegalArgumentException("Parse VID/PID failed.\n" + this.getHelpHtml());
                }
                if (arguments.indexOf("--all") > -1) {
                    LOGGER.info("Process all nodes is activated.");
                    this.processAllNodes = true;
                }
                if ((matcher = (pattern = Pattern.compile("--firstCV=\\w+")).matcher(arguments)).find()) {
                    String cvPair = matcher.group();
                    String[] values = cvPair.split("=");
                    int firstCvNumber = Integer.parseInt(values[1]);
                    for (int index = 0; index < 6; ++index) {
                        this.cvValues.add(new CvType(Integer.toString(firstCvNumber + index), null));
                    }
                    break block12;
                }
                LOGGER.warn("Mandatory parameter firstCV is missing.");
                throw new IllegalArgumentException("Mandatory parameter firstCV is missing.\n" + this.getHelpHtml());
            }
        }
        LOGGER.info("Parsed command, cvValues: {}", this.cvValues);
    }

    public List<CvType> getCvValues() {
        return Collections.unmodifiableList(this.cvValues);
    }

    protected String getFormattedMACAddress() {
        if (this.cvValues == null || this.cvValues.size() != 6) {
            LOGGER.warn("The CV values to prepare the MAC address are not available.");
            throw new IllegalArgumentException("The CV values to prepare the MAC address are not available.");
        }
        StringBuilder sb = new StringBuilder(18);
        for (CvType cvType : this.cvValues) {
            String val = cvType.getCvValue();
            if (StringUtils.isBlank((CharSequence)val)) {
                throw new IllegalArgumentException("The CV value to prepare the MAC address are not available. Current cvType: " + cvType);
            }
            int intVal = Integer.parseInt(val);
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", intVal));
        }
        return sb.toString();
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Get the cv values: {}", this.cvValues);
        ArrayList<NodeInterface> nodes = new ArrayList<NodeInterface>();
        if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                return;
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set CV values.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        List<CvType> cvTypes = this.cvValues;
        Iterator iterator = nodes.iterator();
        block0: while (true) {
            if (!iterator.hasNext()) {
                String formattedMacAddress = this.getFormattedMACAddress();
                Map<String, Object> parameters = ScriptUtils.getParameters(context);
                LOGGER.info("Register the formatted macAddress: {}", (Object)formattedMacAddress);
                parameters.put("macAddress", formattedMacAddress);
                return;
            }
            NodeInterface node = (NodeInterface)iterator.next();
            List<ConfigurationVariable> cvReadList = scripting.getCv(node.getUniqueId(), cvTypes.toArray(new CvType[0]));
            Iterator<CvType> iterator2 = this.cvValues.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                CvType currentCv = iterator2.next();
                String cvNumber = currentCv.getCvNumber();
                ConfigurationVariable readCv = cvReadList.stream().filter(cv -> cvNumber.equals(cv.getName())).findFirst().orElse(null);
                if (readCv == null) {
                    this.addError(context, "No CV value returned for CV number: " + cvNumber);
                    throw new IllegalStateException("No CV value returned for CV number: " + cvNumber);
                }
                currentCv.setCvValue(readCv.getValue());
            }
            break;
        }
    }
}

