/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.test;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.test.TestScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadMotFuncJsonCommand
extends AbstractScriptCommand<TestScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadMotFuncJsonCommand.class);
    public static final String KEY = "readMotFuncJson";
    public static final String HELP = "<div class=\"codeblock\">readMotFuncJson" + ReadMotFuncJsonCommand.prepareHelpHtml(" [--V<vid>:P<pid>] --namespace=<namespace> --index=<stringId> --responseTimeout=<response timeout in seconds> --value=\"<string>\" --termination=\"<termination string>\"\n") + "</div>" + ReadMotFuncJsonCommand.prepareHelpHtml("\nRead the Mot-Func json values from the node. The timeout is the maximum value in seconds to wait for the string values from the node.\nThe value is the command string to request the data from the node.\nThe termination is the value that is compared to signal the end of the transmission, e.g. \"MJLI END\".");
    private int[] vidPid;
    private int namespace;
    private int index;
    private String value;
    private int responseTimeout;
    private String termination;

    public ReadMotFuncJsonCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("Parse VID/PID failed.", (Throwable)ex);
                throw new IllegalArgumentException("Parse VID/PID failed.\n" + this.getHelpHtml());
            }
            this.namespace = ScriptUtils.parseIntParam("--namespace=\\d+", arguments);
            this.index = ScriptUtils.parseIntParam("--index=\\d+", arguments);
            this.value = ScriptUtils.parseStringParam("(?<=--value=)([\"'])(?:(?=(\\\\?))\\2.)*?\\1", arguments);
            this.termination = ScriptUtils.parseStringParam("(?<=--termination=)([\"'])(?:(?=(\\\\?))\\2.)*?\\1", arguments);
            if (this.value.length() > 40) {
                LOGGER.warn("Max length of value exceeded: {}", (Object)this.value.length());
                throw new IllegalArgumentException("Max length of value exceeded: " + this.value.length());
            }
        }
        LOGGER.info("Parsed command, namespace: {}", (Object)this.namespace);
    }

    public int getNamespace() {
        return this.namespace;
    }

    public int getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.value;
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public String getTermination() {
        return this.termination;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(TestScripting scripting, ApplicationContext context) {
        LOGGER.info("Set the string, namespace: {}, index: {}, value: '{}', , termination: '{}'", new Object[]{this.namespace, this.index, this.value, this.termination});
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
        if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                return;
            }
            nodes.add((NodeInterface)currentNodes.get(0));
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set CV values.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            NodeInterface node = (NodeInterface)iterator.next();
            scripting.setStringAndHandleReponse(node.getUniqueId(), this.namespace, this.index, this.value, this.responseTimeout, (connectionId, responseNode, namespace, index, chunk, logConsole) -> {
                LOGGER.info("Received response chunk: {}", (Object)chunk);
                try {
                    logConsole.accept(chunk);
                }
                catch (Exception ex) {
                    LOGGER.warn("Add received data to console failed.", (Throwable)ex);
                }
                if (this.termination.equals(chunk)) {
                    LOGGER.info("Received the end marker: {}", (Object)chunk);
                    return false;
                }
                return true;
            });
        }
        return;
    }
}

