/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.test.TestScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNetBidibDeviceAndConnectCommand
extends AbstractScriptCommand<TestScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchNetBidibDeviceAndConnectCommand.class);
    public static final String KEY = "searchNetBidibDeviceAndConnect";
    public static final String HELP = "<div class=\"codeblock\">searchNetBidibDeviceAndConnect" + SearchNetBidibDeviceAndConnectCommand.prepareHelpHtml(" --id=<connectionId> --startingIp=<ip-address> --addressCount=<address count> [--retry=<retry count>]") + "</div>" + SearchNetBidibDeviceAndConnectCommand.prepareHelpHtml("\nSearch a netBiDiB device by ping in the provided ip range and connect to the device.");
    private String connectionId;
    private String startingIp;
    private int addressCount;
    private int retryCount;
    private final List<String> ipList = new ArrayList<String>();

    public SearchNetBidibDeviceAndConnectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    protected String getConnectionId() {
        return this.connectionId;
    }

    protected String getStartingIp() {
        return this.startingIp;
    }

    protected int getAddressCount() {
        return this.addressCount;
    }

    protected int getRetryCount() {
        return this.retryCount;
    }

    protected List<String> getIpList() {
        return this.ipList;
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.connectionId = scanner.next("--id=(.+)").substring(5);
            }
            catch (Exception ex) {
                LOGGER.warn("No connectionId found.", (Throwable)ex);
                throw new RuntimeException("connect: No connectionId found.");
            }
            Pattern pattern = Pattern.compile("--startingIp=(\\d+|\\.?)+");
            Matcher matcher = pattern.matcher(arguments);
            if (matcher.find()) {
                String cvPair = matcher.group();
                String[] values = cvPair.split("=");
                this.startingIp = values[1];
                InetAddressValidator validator = InetAddressValidator.getInstance();
                if (!validator.isValid(this.startingIp)) {
                    LOGGER.warn("Validating provided startingIp failed: {}", (Object)this.startingIp);
                    throw new IllegalArgumentException("Validating provided startingIp failed: " + this.startingIp + ".\n");
                }
            } else {
                LOGGER.warn("Mandatory parameter startingIp is missing.");
                throw new IllegalArgumentException("Mandatory parameter startingIp is missing.\n" + this.getHelpHtml());
            }
            try {
                this.addressCount = ScriptUtils.parseIntParam(scanner, "--addressCount=\\d+");
            }
            catch (IllegalArgumentException iaEx) {
                LOGGER.warn("Parse addressCount value failed.", (Throwable)iaEx);
                throw new IllegalArgumentException("Mandatory parameter addressCount is missing.\n" + this.getHelpHtml());
            }
            try {
                this.retryCount = ScriptUtils.parseIntParam(scanner, "--retryCount=(\\d+)");
            }
            catch (Exception ex) {
                LOGGER.info("No retryCount found.");
            }
            LOGGER.info("Parsed command, connectionId: {}, startingIp: {}, addressCount: {}, retryCount: {}", new Object[]{this.connectionId, this.startingIp, this.addressCount, this.retryCount});
        }
    }

    @Override
    protected void internalExecute(TestScripting scripting, ApplicationContext context) {
        this.prepareIpAddressList();
        String ipToUse = scripting.findReachableDevice(this.ipList, this.retryCount);
        if (ipToUse == null) {
            LOGGER.warn("No device found in provided address range, startingIp: {}, addressCount: {}", (Object)this.startingIp, (Object)this.addressCount);
            throw new ScriptExecutionException("No device found.");
        }
        LOGGER.info("Prepare connection to address: {}", (Object)ipToUse);
        scripting.connect("main", ipToUse);
    }

    protected void prepareIpAddressList() {
        String[] addressParts = this.startingIp.split("\\.");
        int startingAddr = Integer.parseInt(addressParts[3]);
        for (int index = 0; index < this.addressCount; ++index) {
            String address = String.format("%s.%s.%s.%d", addressParts[0], addressParts[1], addressParts[2], startingAddr + index);
            this.ipList.add(address);
        }
    }
}

