/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.utils;

import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.jbidibc.messages.enums.AccessoryOkayEnum;
import org.bidib.jbidibc.messages.enums.AnalogPortEnum;
import org.bidib.jbidibc.messages.enums.BacklightPortEnum;
import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.enums.CriticalFunctionEnum;
import org.bidib.jbidibc.messages.enums.FlagEnum;
import org.bidib.jbidibc.messages.enums.InputEnum;
import org.bidib.jbidibc.messages.enums.InputPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LightPortEnum;
import org.bidib.jbidibc.messages.enums.MacroEnum;
import org.bidib.jbidibc.messages.enums.MotorPortEnum;
import org.bidib.jbidibc.messages.enums.ServoPortEnum;
import org.bidib.jbidibc.messages.enums.SoundPortEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.wizard.api.model.PortsProvider;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.AnalogPortAction;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.CriticalFunction;
import org.bidib.wizard.api.model.function.DelayFunction;
import org.bidib.wizard.api.model.function.FlagFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.LightPortAction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.model.function.MotorPortAction;
import org.bidib.wizard.api.model.function.RandomDelayFunction;
import org.bidib.wizard.api.model.function.ServoMoveQueryFunction;
import org.bidib.wizard.api.model.function.ServoPortAction;
import org.bidib.wizard.api.model.function.SoundPortAction;
import org.bidib.wizard.api.model.function.SwitchPairPortAction;
import org.bidib.wizard.api.model.function.SwitchPortAction;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.AccessoryOkayStatus;
import org.bidib.wizard.model.status.AnalogPortStatus;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.CriticalFunctionStatus;
import org.bidib.wizard.model.status.FlagStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.InputStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.model.status.ServoPortStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConversionUtils.class);

    public static BidibStatus toBidibStatus(BidibEnum status) {
        AccessoryOkayStatus result = null;
        if (status != null) {
            if (status instanceof AccessoryOkayEnum) {
                result = AccessoryOkayStatus.valueOf((AccessoryOkayEnum)((AccessoryOkayEnum)status));
            } else if (status instanceof AnalogPortEnum) {
                result = AnalogPortStatus.valueOf((AnalogPortEnum)((AnalogPortEnum)status));
            } else if (status instanceof BacklightPortEnum) {
                result = BacklightPortStatus.valueOf((BacklightPortEnum)((BacklightPortEnum)status));
            } else if (status instanceof CriticalFunctionEnum) {
                result = CriticalFunctionStatus.valueOf((CriticalFunctionEnum)((CriticalFunctionEnum)status));
            } else if (status instanceof FlagEnum) {
                result = FlagStatus.valueOf((FlagEnum)((FlagEnum)status));
            } else if (status instanceof InputEnum) {
                result = InputStatus.valueOf((InputEnum)((InputEnum)status));
            } else if (status instanceof InputPortEnum) {
                result = InputPortStatus.valueOf((InputPortEnum)((InputPortEnum)status));
            } else if (status instanceof LightPortEnum) {
                result = LightPortStatus.valueOf((LightPortEnum)((LightPortEnum)status));
            } else if (status instanceof MacroEnum) {
                result = MacroStatus.valueOf((MacroEnum)((MacroEnum)status));
            } else if (status instanceof MotorPortEnum) {
                result = MotorPortStatus.valueOf((MotorPortEnum)((MotorPortEnum)status));
            } else if (status instanceof ServoPortEnum) {
                result = ServoPortStatus.valueOf((ServoPortEnum)((ServoPortEnum)status));
            } else if (status instanceof SoundPortEnum) {
                result = SoundPortStatus.valueOf((SoundPortEnum)((SoundPortEnum)status));
            } else if (status instanceof SwitchPortEnum) {
                result = SwitchPortStatus.valueOf((SwitchPortEnum)((SwitchPortEnum)status));
            } else {
                throw new RuntimeException("cannot map " + status.getClass().getSimpleName() + " to a status");
            }
        }
        return result;
    }

    public static Function<?> getFunction(LcOutputType outputType, BidibStatus status) {
        DelayFunction result = null;
        LOGGER.info("Prepare the function for outputType: {}, status: {}", (Object)outputType, (Object)status);
        switch (outputType) {
            case ACCESSORY_OKAY_INPUTQUERY0: {
                result = new AccessoryOkayFunction(AccessoryOkayStatus.QUERY0);
                break;
            }
            case ACCESSORY_OKAY_INPUTQUERY1: {
                result = new AccessoryOkayFunction(AccessoryOkayStatus.QUERY1);
                break;
            }
            case ACCESSORY_OKAY_NF: {
                result = new AccessoryOkayFunction(AccessoryOkayStatus.NO_FEEDBACK);
                break;
            }
            case ANALOGPORT: {
                result = new AnalogPortAction((AnalogPortStatus)status);
                break;
            }
            case BACKLIGHTPORT: {
                result = new BacklightPortAction((BacklightPortStatus)status);
                break;
            }
            case LIGHTPORT: {
                result = new LightPortAction((LightPortStatus)status);
                break;
            }
            case MOTORPORT: {
                result = new MotorPortAction((MotorPortStatus)status);
                break;
            }
            case SERVOPORT: {
                result = new ServoPortAction((ServoPortStatus)status);
                break;
            }
            case SOUNDPORT: {
                result = new SoundPortAction((SoundPortStatus)status);
                break;
            }
            case SWITCHPORT: {
                result = new SwitchPortAction((SwitchPortStatus)status);
                break;
            }
            case SWITCHPAIRPORT: {
                result = new SwitchPairPortAction((SwitchPortStatus)status);
                break;
            }
            case DELAY_FIXED: {
                result = new DelayFunction();
                break;
            }
            case RANDOM_DELAY: {
                result = new RandomDelayFunction();
                break;
            }
            case INPUT_QUERY0: {
                result = new InputFunction(InputStatus.QUERY0);
                break;
            }
            case INPUT_QUERY1: {
                result = new InputFunction(InputStatus.QUERY1);
                break;
            }
            case FLAG_CLEAR: {
                result = new FlagFunction(FlagStatus.CLEAR);
                break;
            }
            case FLAG_SET: {
                result = new FlagFunction(FlagStatus.SET);
                break;
            }
            case FLAG_QUERY: 
            case FLAG_QUERY1: {
                result = new FlagFunction(FlagStatus.QUERY_1);
                break;
            }
            case FLAG_QUERY0: {
                result = new FlagFunction(FlagStatus.QUERY_0);
                break;
            }
            case BEGIN_CRITICAL: {
                result = new CriticalFunction(CriticalFunctionStatus.BEGIN);
                break;
            }
            case END_CRITICAL: {
                result = new CriticalFunction(CriticalFunctionStatus.END);
                break;
            }
            case START_MACRO: {
                result = new MacroFunction(MacroStatus.START);
                break;
            }
            case STOP_MACRO: {
                result = new MacroFunction(MacroStatus.STOP);
                break;
            }
            case END_OF_MACRO: {
                result = new MacroFunction(MacroStatus.END);
                break;
            }
            case SERVOMOVE_QUERY: {
                result = new ServoMoveQueryFunction();
                break;
            }
            default: {
                throw new RuntimeException("Cannot map output type " + outputType.getClass().getSimpleName() + " to a function");
            }
        }
        return result;
    }

    public static Port<? extends BidibStatus> getPort(PortsProvider node, LcOutputType outputType, final int portNumber) {
        Port port = null;
        List ports = null;
        switch (outputType) {
            case ANALOGPORT: {
                ports = node.getAnalogPorts();
                break;
            }
            case BACKLIGHTPORT: {
                ports = node.getBacklightPorts();
                break;
            }
            case LIGHTPORT: {
                ports = node.getLightPorts();
                break;
            }
            case MOTORPORT: {
                ports = node.getMotorPorts();
                break;
            }
            case SERVOPORT: {
                ports = node.getServoPorts();
                break;
            }
            case SOUNDPORT: {
                ports = node.getSoundPorts();
                break;
            }
            case INPUT_QUERY0: 
            case INPUT_QUERY1: 
            case INPUTPORT: {
                ports = node.getInputPorts();
                break;
            }
            case SWITCHPORT: {
                ports = node.getSwitchPorts();
                break;
            }
            case SWITCHPAIRPORT: {
                ports = node.getSwitchPairPorts();
                break;
            }
            default: {
                throw new RuntimeException("Cannot map output type " + outputType.getDeclaringClass().getSimpleName() + " to a port.");
            }
        }
        if (ports != null && portNumber >= 0) {
            port = (Port)IterableUtils.find((Iterable)ports, (Predicate)new Predicate<Port<?>>(){

                public boolean evaluate(Port<?> port) {
                    return port.getId() == portNumber;
                }
            });
            LOGGER.info("Search for port with portNumber: {}, found port: {}", (Object)portNumber, (Object)port);
        } else {
            LOGGER.warn("No ports available or portNumber out of range for outputType: {} on node: {}", (Object)outputType, (Object)node);
        }
        return port;
    }

    public static Port<? extends BidibStatus> getPort(PortsProvider node, final int portNumber) {
        Port<? extends BidibStatus> port = null;
        if (node.isFlatPortModel()) {
            GenericPort genericPort = (GenericPort)IterableUtils.find((Iterable)node.getGenericPorts(), (Predicate)new Predicate<GenericPort>(){

                public boolean evaluate(GenericPort genericPort) {
                    return genericPort.getPortNumber() == portNumber;
                }
            });
            if (genericPort != null) {
                port = ConversionUtils.getPort(node, genericPort.getCurrentPortType(), portNumber);
                LOGGER.info("Found port to return: {}", port);
            }
        } else {
            LOGGER.error("Get the port without port type from typed port model is not supported.");
        }
        return port;
    }

    public static LcOutputType getOutputType(Function<?> function) {
        LcOutputType result = null;
        if (function instanceof AccessoryOkayFunction && function.getAction() == AccessoryOkayStatus.QUERY0) {
            result = LcOutputType.ACCESSORY_OKAY_INPUTQUERY0;
        } else if (function instanceof AccessoryOkayFunction && function.getAction() == AccessoryOkayStatus.QUERY1) {
            result = LcOutputType.ACCESSORY_OKAY_INPUTQUERY1;
        } else if (function instanceof AccessoryOkayFunction && function.getAction() == AccessoryOkayStatus.NO_FEEDBACK) {
            result = LcOutputType.ACCESSORY_OKAY_NF;
        } else if (function instanceof AnalogPortAction) {
            result = LcOutputType.ANALOGPORT;
        } else if (function instanceof CriticalFunction && function.getAction() == CriticalFunctionStatus.END) {
            result = LcOutputType.END_CRITICAL;
        } else if (function instanceof CriticalFunction && function.getAction() == CriticalFunctionStatus.BEGIN) {
            result = LcOutputType.BEGIN_CRITICAL;
        } else if (function instanceof DelayFunction) {
            result = LcOutputType.DELAY_FIXED;
        } else if (function instanceof FlagFunction && function.getAction() == FlagStatus.CLEAR) {
            result = LcOutputType.FLAG_CLEAR;
        } else if (function instanceof FlagFunction && function.getAction() == FlagStatus.SET) {
            result = LcOutputType.FLAG_SET;
        } else if (function instanceof FlagFunction && function.getAction() == FlagStatus.QUERY_1) {
            result = LcOutputType.FLAG_QUERY1;
        } else if (function instanceof FlagFunction && function.getAction() == FlagStatus.QUERY_0) {
            result = LcOutputType.FLAG_QUERY0;
        } else if (function instanceof InputFunction && function.getAction() == InputStatus.QUERY0) {
            result = LcOutputType.INPUT_QUERY0;
        } else if (function instanceof InputFunction && function.getAction() == InputStatus.QUERY1) {
            result = LcOutputType.INPUT_QUERY1;
        } else if (function instanceof BacklightPortAction) {
            result = LcOutputType.BACKLIGHTPORT;
        } else if (function instanceof LightPortAction) {
            result = LcOutputType.LIGHTPORT;
        } else if (function instanceof MacroFunction && function.getAction() == MacroStatus.STOP) {
            result = LcOutputType.STOP_MACRO;
        } else if (function instanceof MacroFunction && function.getAction() == MacroStatus.START) {
            result = LcOutputType.START_MACRO;
        } else if (function instanceof MacroFunction && function.getAction() == MacroStatus.END) {
            result = LcOutputType.END_OF_MACRO;
        } else if (function instanceof MotorPortAction) {
            result = LcOutputType.MOTORPORT;
        } else if (function instanceof RandomDelayFunction) {
            result = LcOutputType.RANDOM_DELAY;
        } else if (function instanceof ServoPortAction) {
            result = LcOutputType.SERVOPORT;
        } else if (function instanceof SoundPortAction) {
            result = LcOutputType.SOUNDPORT;
        } else if (function instanceof SwitchPortAction) {
            result = LcOutputType.SWITCHPORT;
        } else if (function instanceof SwitchPairPortAction) {
            result = LcOutputType.SWITCHPAIRPORT;
        } else if (function instanceof ServoMoveQueryFunction) {
            result = LcOutputType.SERVOMOVE_QUERY;
        } else {
            throw new RuntimeException("cannot map function type " + function.getClass().getSimpleName() + " to an output type");
        }
        return result;
    }
}

