/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.utils;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bidib.api.json.types.firmware.ChangeLog;
import org.bidib.jbidibc.exchange.bidib.FirmwareException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareUtils.class);
    private static final String REGEX_FILENAME = "(\\-|\\.)[0-9]+";
    private static final String REGEX_CV_FILENAME = "BiDiBCV-([0-9]{1,3})-([0-9]{1,3})(-.+)?\\.xml";

    public static boolean hasVersionInFilename(String filename) {
        Matcher m = Pattern.compile(REGEX_FILENAME).matcher(filename);
        int start = m.regionStart();
        int end = m.regionEnd();
        LOGGER.debug("Region start: {}, end: {}", (Object)start, (Object)end);
        int totalFound = 0;
        while (m.find()) {
            String text;
            LOGGER.debug("groupCount: {}", (Object)m.groupCount());
            if (m.groupCount() > 0 && m.group(1) != null) {
                text = m.group(0);
                LOGGER.debug("1. Found text: [{}]", (Object)text);
                ++totalFound;
                continue;
            }
            text = m.group(0);
            LOGGER.debug("Plain [{}]", (Object)text);
        }
        return totalFound > 2;
    }

    public static String getVidAndPid(String filename) {
        Matcher m = Pattern.compile(REGEX_CV_FILENAME).matcher(filename);
        if (m.matches() && m.groupCount() >= 2) {
            String vid = m.group(1);
            String pid = m.group(2);
            return vid + "-" + pid;
        }
        return null;
    }

    public static boolean hasVersionInDefaultLablesFilename(String filename) {
        Matcher m = Pattern.compile(REGEX_FILENAME).matcher(filename);
        int start = m.regionStart();
        int end = m.regionEnd();
        LOGGER.info("Region start: {}, end: {}", (Object)start, (Object)end);
        int totalFound = 0;
        while (m.find()) {
            String text;
            LOGGER.debug("groupCount: {}", (Object)m.groupCount());
            if (m.groupCount() > 0 && m.group(1) != null) {
                text = m.group(0);
                LOGGER.debug("1. Found text: [{}]", (Object)text);
                ++totalFound;
                continue;
            }
            text = m.group(0);
            LOGGER.debug("Plain [{}]", (Object)text);
        }
        return totalFound > 2;
    }

    public static void assertFileExists(File firmwareFile, String filename) {
        try (ZipFile zipFile = new ZipFile(firmwareFile);){
            ZipEntry zipEntry = zipFile.getEntry(filename);
            if (zipEntry == null) {
                LOGGER.warn("File not found in zip: {}", (Object)filename);
                throw new FirmwareException("File not found in zip: " + filename);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Check for file inside ZIP failed.", (Throwable)ex);
            throw new FirmwareException("Check for file inside ZIP failed.");
        }
    }

    public static void loadChangeLog(ObjectMapper objectMapper, File firmwareArchive, String changeLogFileName, Consumer<ChangeLog> changeLogConsumer) {
        File changeLogFile = new File(changeLogFileName);
        try (ZipFile zipFile = new ZipFile(firmwareArchive);){
            ZipEntry zipEntry = zipFile.getEntry(changeLogFileName);
            if (zipEntry == null) {
                LOGGER.warn("File not found in zip: {}", (Object)changeLogFileName);
                throw new FirmwareException("File not found in zip: " + changeLogFileName);
            }
            Throwable[] throwableHolder = new Throwable[1];
            AtomicBoolean foundChangeLog = new AtomicBoolean();
            FirmwareUtils.getZipEntryContent(zipFile, zipEntry, reader -> {
                try {
                    ChangeLog changelog = (ChangeLog)objectMapper.readValue((Reader)reader, ChangeLog.class);
                    changeLogConsumer.accept(changelog);
                    foundChangeLog.set(true);
                }
                catch (JsonMappingException ex) {
                    LOGGER.warn("Read changelog failed with JsonMappingException.", (Throwable)ex);
                    LOGGER.warn("Reason: {}", (Object)ex.getMessage());
                    throwableHolder[0] = ex;
                }
                catch (IOException ex) {
                    LOGGER.warn("Read changelog failed.", (Throwable)ex);
                    throwableHolder[0] = ex;
                }
            });
            if (throwableHolder[0] != null) {
                Throwable th = throwableHolder[0];
                throw new FirmwareException("Load changelog failed.", th);
            }
            if (!foundChangeLog.get()) {
                throw new FirmwareException("No changelog available.");
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Get changelog failed.", (Throwable)ex);
            throw new FirmwareException("Get changelog failed, file: " + changeLogFile);
        }
    }

    private static void getZipEntryContent(ZipFile zipFile, ZipEntry zipEntry, Consumer<BufferedReader> contentConsumer) throws IOException {
        if (zipEntry != null) {
            try (InputStream is = zipFile.getInputStream(zipEntry);
                 BufferedReader input = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                contentConsumer.accept(input);
            }
        }
    }
}

