/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageUtils.class);

    public static ImageIcon createImageIcon(Class<?> clazz, String path) {
        URL imgURL = clazz.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        LOGGER.error("Couldn't find file: {}", (Object)path);
        return null;
    }

    public static ImageIcon createImageIcon(Class<?> clazz, String path, int width, int height) {
        if (path == null) {
            LOGGER.error("The path to the icon is not provided!");
            throw new IllegalArgumentException("The path to the icon is not provided!");
        }
        URL imgURL = clazz.getResource(path);
        if (imgURL != null) {
            try {
                BufferedImage image = ImageIO.read(imgURL);
                return new ImageIcon(Scalr.resize((BufferedImage)image, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]));
            }
            catch (IOException ex) {
                LOGGER.warn("Create imageIcon failed: {}", (Object)path, (Object)ex);
            }
        } else {
            LOGGER.error("Couldn't find file for imageIcon: {}", (Object)path);
        }
        return null;
    }

    public static ImageIcon loadImageIcon(Class<?> clazz, String path, int width, int height) {
        InputStream imgURL = clazz.getResourceAsStream(path);
        if (imgURL != null) {
            try {
                BufferedImage image = ImageIO.read(imgURL);
                return new ImageIcon(Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]));
            }
            catch (IOException ex) {
                LOGGER.warn("Load image failed: {}", (Object)path, (Object)ex);
            }
        } else {
            LOGGER.error("Couldn't find file: {}", (Object)path);
        }
        return null;
    }

    public static ImageIcon loadImageIcon(File file, int width, int height) {
        try {
            BufferedImage image = ImageIO.read(file);
            return new ImageIcon(Scalr.resize((BufferedImage)image, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]));
        }
        catch (IOException ex) {
            LOGGER.warn("Load image failed: {}", (Object)file, (Object)ex);
            return null;
        }
    }

    public static Image rotateImage(Image img, double degree) {
        BufferedImage bufImg = ImageUtils.toBufferedImage(img);
        double angle = Math.toRadians(degree);
        return ImageUtils.tilt(bufImg, angle);
    }

    public static BufferedImage tilt(BufferedImage image, double angle) {
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = image.getWidth();
        int h = image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        GraphicsConfiguration gc = ImageUtils.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(neww, newh, 3);
        Graphics2D g = result.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(angle, w / 2, h / 2);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon mergeIcons(Icon i1, Icon i2, int offsetTopRight) {
        Image image1 = ((ImageIcon)i1).getImage();
        Image image2 = ((ImageIcon)i2).getImage();
        BufferedImage image = new BufferedImage(i1.getIconWidth(), i1.getIconWidth(), 3);
        Graphics g = ((Image)image).getGraphics();
        try {
            g.drawImage(image1, 0, 0, null);
            g.drawImage(image2, i1.getIconWidth() - i2.getIconWidth(), offsetTopRight, null);
        }
        finally {
            g.dispose();
        }
        return new ImageIcon(image);
    }
}

