/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.utils;

import org.bidib.jbidibc.core.node.MacroNode;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.function.EmptyFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.FunctionUtils;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.common.utils.ConversionUtils;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroConversionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroConversionHelper.class);

    public int prepareLcMacroSteps(MacroNode macroNode, PortModelEnum portModel, Macro macro) throws ProtocolException {
        if (macro == null) {
            LOGGER.warn("No macro provided.");
            throw new IllegalArgumentException("No macro provided.");
        }
        LOGGER.info("Prepare the macro points to transfer.");
        int stepNumber = 0;
        for (Function function : macro.getFunctions()) {
            LOGGER.info("Prepare macro function to transfer: {}", (Object)function);
            if (function == null || function instanceof EmptyFunction) continue;
            byte delay = FunctionUtils.getDelay((Function)function);
            int outputNumber = FunctionUtils.getOutputNumber((Function)function);
            Integer value = FunctionUtils.getValue((Function)function);
            BidibStatus status = function.getAction();
            BidibPort bidibPort = null;
            LcOutputType portType = null;
            if (portModel != PortModelEnum.type && delay != ByteUtils.getLowByte((int)255)) {
                portType = LcOutputType.SWITCHPORT;
                bidibPort = BidibPort.prepareBidibPort((int)outputNumber);
            } else {
                portType = ConversionUtils.getOutputType(function);
                bidibPort = BidibPort.prepareBidibPort((byte)portType.getType(), (byte)ByteUtils.getLowByte((int)outputNumber));
            }
            LcMacro lcMacro = null;
            if (delay != ByteUtils.getLowByte((int)255)) {
                byte byte5 = 0;
                if (LcOutputType.MOTORPORT == portType) {
                    LOGGER.info("Prepare the value based on the status.");
                    byte5 = ByteUtils.getLowByte((Integer)value);
                    if (MotorPortStatus.BACKWARD == status) {
                        byte5 = ByteUtils.setBit((byte)byte5, (boolean)true, (int)7);
                    }
                    LOGGER.info("Prepared the byte5 for motor port: 0x{}", (Object)ByteUtils.byteToHex((byte)byte5));
                } else {
                    byte5 = value != null ? ByteUtils.getLowByte((Integer)value).byteValue() : status.getType().getType();
                }
                lcMacro = new LcMacro(ByteUtils.getLowByte((int)macro.getId()), ByteUtils.getLowByte((int)stepNumber++), delay, bidibPort.getLowValue(), bidibPort.getHighValue(), byte5);
            } else {
                lcMacro = new LcMacro(ByteUtils.getLowByte((int)macro.getId()), ByteUtils.getLowByte((int)stepNumber++), delay, portType.getType(), ByteUtils.getLowByte((int)outputNumber), 0);
            }
            LOGGER.info("Prepared new macro point: {}", (Object)lcMacro);
            macroNode.setMacroStep(lcMacro);
            if (!(function instanceof MacroFunction) || ((MacroFunction)function).getAction() != MacroStatus.END) continue;
            break;
        }
        return stepNumber;
    }
}

