/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.utils;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.AnalogPortAction;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.CriticalFunction;
import org.bidib.wizard.api.model.function.DelayFunction;
import org.bidib.wizard.api.model.function.EmptyFunction;
import org.bidib.wizard.api.model.function.FlagFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.LightPortAction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.model.function.MotorPortAction;
import org.bidib.wizard.api.model.function.RandomDelayFunction;
import org.bidib.wizard.api.model.function.ServoMoveQueryFunction;
import org.bidib.wizard.api.model.function.ServoPortAction;
import org.bidib.wizard.api.model.function.SoundPortAction;
import org.bidib.wizard.api.model.function.SwitchPairPortAction;
import org.bidib.wizard.api.model.function.SwitchPortAction;
import org.bidib.wizard.model.status.BidibStatus;

public class MacroListUtils {
    public static Macro findMacroByMacroNumber(List<Macro> macros, final int macroNum) {
        Macro macro = (Macro)IterableUtils.find(macros, (Predicate)new Predicate<Macro>(){

            public boolean evaluate(Macro port) {
                return port.getId() == macroNum;
            }
        });
        return macro;
    }

    public static Function<? extends BidibStatus>[] prepareAvailableFunctions(NodeInterface selectedNode) {
        LinkedList<Object> functions = new LinkedList<Object>();
        if (selectedNode.hasAnalogPorts()) {
            functions.add(new AnalogPortAction());
        }
        functions.add(new CriticalFunction());
        functions.add(new FlagFunction());
        if (selectedNode.hasInputPorts()) {
            functions.add(new InputFunction());
        }
        if (selectedNode.hasLightPorts()) {
            functions.add(new LightPortAction());
        }
        functions.add(new MacroFunction());
        if (selectedNode.hasMotorPorts()) {
            functions.add(new MotorPortAction());
        }
        if (selectedNode.hasServoPorts()) {
            functions.add(new ServoPortAction());
            functions.add(new ServoMoveQueryFunction());
        }
        if (selectedNode.hasSoundPorts()) {
            functions.add(new SoundPortAction());
        }
        if (selectedNode.hasSwitchPorts()) {
            functions.add(new SwitchPortAction());
        }
        if (selectedNode.getSwitchPairPorts().size() > 0) {
            functions.add(new SwitchPairPortAction());
        }
        if (selectedNode.getAccessories().size() > 0) {
            functions.add(new AccessoryOkayFunction());
        }
        if (selectedNode.hasBacklightPorts()) {
            functions.add(new BacklightPortAction());
        }
        functions.add(new DelayFunction());
        functions.add(new RandomDelayFunction());
        functions.add(new EmptyFunction());
        return functions.toArray(new Function[0]);
    }
}

