/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.common.utils.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkAddressHelper.class);
    public static final String SYSTEM_PROPERTY_NET_IFACES = "org.bidib.jbidibc.discovery.network.useInterfaces";
    public static final String SYSTEM_PROPERTY_NET_ADDRESSES = "org.bidib.jbidibc.discovery.network.useAddresses";
    public static final String SYSTEM_PROPERTY_NET_LOCAL_ADDRESS = "org.bidib.jbidibc.discovery.network.useLocalAddress";
    protected final Set<String> useInterfaces = new HashSet<String>();
    protected final Set<String> useAddresses = new HashSet<String>();
    protected final List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
    protected final List<InetAddress> bindAddresses = new ArrayList<InetAddress>();

    public NetworkAddressHelper() {
        String useAddressesString;
        String useInterfacesString = System.getProperty(SYSTEM_PROPERTY_NET_IFACES);
        if (useInterfacesString != null) {
            String[] userInterfacesStrings = useInterfacesString.split(",");
            this.useInterfaces.addAll(Arrays.asList(userInterfacesStrings));
        }
        if ((useAddressesString = System.getProperty(SYSTEM_PROPERTY_NET_ADDRESSES)) != null) {
            String[] useAddressesStrings = useAddressesString.split(",");
            this.useAddresses.addAll(Arrays.asList(useAddressesStrings));
        }
        this.discoverNetworkInterfaces();
        this.discoverBindAddresses();
        if (this.networkInterfaces.size() == 0 || this.bindAddresses.size() == 0) {
            LOG.warn("No usable network interface or addresses found");
            if (this.requiresNetworkInterface()) {
                throw new IllegalStateException("Could not discover any usable network interfaces and/or addresses");
            }
        }
    }

    protected boolean requiresNetworkInterface() {
        return true;
    }

    public Iterator<NetworkInterface> getNetworkInterfaces() {
        return new Synchronized<NetworkInterface>(this.networkInterfaces){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<NetworkInterface> list = NetworkAddressHelper.this.networkInterfaces;
                synchronized (list) {
                    NetworkAddressHelper.this.networkInterfaces.remove(index);
                }
            }
        };
    }

    public InetAddress[] getBindAddresses() {
        return this.bindAddresses.toArray(new InetAddress[0]);
    }

    public boolean hasUsableNetwork() {
        return this.networkInterfaces.size() > 0 && this.bindAddresses.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverNetworkInterfaces() throws InitializationException {
        try {
            Enumeration<NetworkInterface> interfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface iface : Collections.list(interfaceEnumeration)) {
                LOG.trace("Analyzing network interface: {}", (Object)iface.getDisplayName());
                if (NetworkAddressHelper.isUsableNetworkInterface(iface, this.useInterfaces)) {
                    LOG.debug("Discovered usable network interface: {}, name: {}", (Object)iface.getDisplayName(), (Object)iface.getName());
                    List<NetworkInterface> list = this.networkInterfaces;
                    synchronized (list) {
                        this.networkInterfaces.add(iface);
                        continue;
                    }
                }
                LOG.trace("Ignoring non-usable network interface: " + iface.getDisplayName());
            }
        }
        catch (Exception ex) {
            throw new InitializationException("Could not not analyze local network interfaces: " + ex, ex);
        }
    }

    public static boolean isUsableNetworkInterface(NetworkInterface iface, Set<String> useInterfaces) {
        LOG.trace("Current network interface, displayName: {}, name: {}", (Object)iface.getDisplayName(), (Object)iface.getName());
        try {
            if (!iface.isUp()) {
                LOG.trace("Skipping network interface (down): " + iface.getDisplayName());
                return false;
            }
            if (NetworkAddressHelper.getInetAddresses(iface).size() == 0) {
                LOG.trace("Skipping network interface without bound IP addresses: " + iface.getDisplayName());
                return false;
            }
            if (iface.getName().toLowerCase(Locale.ROOT).startsWith("vmnet") || iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ROOT).contains("vmnet")) {
                LOG.trace("Skipping network interface (VMWare): " + iface.getDisplayName());
                return false;
            }
            if (iface.getName().toLowerCase(Locale.ROOT).startsWith("vnic")) {
                LOG.trace("Skipping network interface (Parallels): " + iface.getDisplayName());
                return false;
            }
            if (iface.getName().toLowerCase(Locale.ROOT).startsWith("vboxnet") || iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ROOT).startsWith("virtual")) {
                LOG.trace("Skipping network interface (Virtual Box): " + iface.getDisplayName());
                return false;
            }
            if (iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ROOT).startsWith("hyper-v")) {
                LOG.trace("Skipping network interface (Hyper-V): {}", (Object)iface.getDisplayName());
                return false;
            }
            if (iface.getName().toLowerCase(Locale.ROOT).contains("tap-windows") || iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ROOT).contains("tap-windows")) {
                LOG.trace("Skipping network interface (named '*tap-windows*'): " + iface.getDisplayName());
                return false;
            }
            if (iface.getName().toLowerCase(Locale.ROOT).contains("virtual")) {
                LOG.trace("Skipping network interface (named '*virtual*'): " + iface.getDisplayName());
                return false;
            }
            if (iface.getName().toLowerCase(Locale.ROOT).startsWith("ppp")) {
                LOG.trace("Skipping network interface (PPP): " + iface.getDisplayName());
                return false;
            }
            if (iface.isLoopback()) {
                LOG.trace("Skipping network interface (ignoring loopback): " + iface.getDisplayName());
                return false;
            }
            if (useInterfaces != null && useInterfaces.size() > 0 && !useInterfaces.contains(iface.getName())) {
                LOG.trace("Skipping unwanted network interface (-Dorg.bidib.jbidibc.discovery.network.useInterfaces): " + iface.getName());
                return false;
            }
            if (!iface.supportsMulticast()) {
                LOG.warn("Network interface may not be multicast capable: " + iface.getDisplayName());
            }
            return true;
        }
        catch (SocketException ex) {
            LOG.warn("Detect if network interface is usable failed.", (Throwable)ex);
            return false;
        }
    }

    protected static List<InetAddress> getInetAddresses(NetworkInterface networkInterface) {
        return Collections.list(networkInterface.getInetAddresses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverBindAddresses() throws InitializationException {
        try {
            List<NetworkInterface> list = this.networkInterfaces;
            synchronized (list) {
                Iterator<NetworkInterface> it = this.networkInterfaces.iterator();
                while (it.hasNext()) {
                    NetworkInterface networkInterface = it.next();
                    LOG.trace("Discovering addresses of interface: " + networkInterface.getDisplayName());
                    int usableAddresses = 0;
                    for (InetAddress inetAddress : NetworkAddressHelper.getInetAddresses(networkInterface)) {
                        if (inetAddress == null) {
                            LOG.warn("Network has a null address: " + networkInterface.getDisplayName());
                            continue;
                        }
                        if (this.isUsableAddress(networkInterface, inetAddress)) {
                            LOG.debug("Discovered usable network interface address: " + inetAddress.getHostAddress());
                            ++usableAddresses;
                            List<InetAddress> list2 = this.bindAddresses;
                            synchronized (list2) {
                                this.bindAddresses.add(inetAddress);
                                continue;
                            }
                        }
                        LOG.trace("Ignoring non-usable network interface address: " + inetAddress.getHostAddress());
                    }
                    if (usableAddresses != 0) continue;
                    LOG.trace("Network interface has no usable addresses, removing: " + networkInterface.getDisplayName());
                    it.remove();
                }
            }
        }
        catch (Exception ex) {
            throw new InitializationException("Could not not analyze local network interfaces: " + ex, ex);
        }
    }

    protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
        if (address instanceof Inet6Address && address.isLinkLocalAddress()) {
            LOG.info("Skipping link local ipv6 address: " + address);
            return false;
        }
        if (address.isAnyLocalAddress()) {
            LOG.info("Skipping any local address: " + address);
            return false;
        }
        if (address.isLoopbackAddress()) {
            LOG.trace("Skipping loopback address: " + address);
            return false;
        }
        if (this.useAddresses.size() > 0 && !this.useAddresses.contains(address.getHostAddress())) {
            LOG.trace("Skipping unwanted address: " + address);
            return false;
        }
        return true;
    }

    public static InetAddress getLocalAddressOfType(Class<? extends InetAddress> cl) throws UnknownHostException {
        try {
            InetAddress localAddress;
            String overrideIP = System.getProperty(SYSTEM_PROPERTY_NET_LOCAL_ADDRESS);
            if (StringUtils.isNotBlank((CharSequence)overrideIP)) {
                return InetAddress.getByName(overrideIP.trim());
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> localAddresses = new ArrayList<InetAddress>();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                LOG.debug("Current network interface: {}", (Object)current);
                if (!NetworkAddressHelper.isUsableNetworkInterface(current, Collections.emptySet())) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress adr = addresses.nextElement();
                    if (!cl.isInstance(adr)) continue;
                    localAddresses.add(adr);
                }
            }
            if (localAddresses.isEmpty()) {
                localAddress = InetAddress.getLocalHost();
                LOG.debug("No local addresses detected, resolved to: {}", (Object)localAddress);
                return localAddress;
            }
            localAddress = (InetAddress)localAddresses.get(0);
            if (localAddresses.size() > 1) {
                InetAddress localHost;
                if (Inet4Address.class.equals(cl)) {
                    localHost = Inet4Address.getLocalHost();
                    if (localAddresses.contains(localHost)) {
                        localAddress = localHost;
                        LOG.debug("Found local IPv4 in local addresses, resolved to: {}", (Object)localAddress);
                    }
                } else if (Inet6Address.class.equals(cl) && localAddresses.contains(localHost = Inet6Address.getLocalHost())) {
                    localAddress = localHost;
                    LOG.debug("Found local IPv6 in local addresses, resolved to: {}", (Object)localAddress);
                }
            }
            LOG.debug("Local address resolved to: {}", (Object)localAddress);
            return localAddress;
        }
        catch (Exception e) {
            LOG.debug("Local address not resolvable.");
            return InetAddress.getLocalHost();
        }
    }

    public static abstract class Synchronized<E>
    implements Iterator<E> {
        final Iterator<E> wrapped;
        int nextIndex = 0;
        boolean removedCurrent = false;

        public Synchronized(Collection<E> collection) {
            this.wrapped = new CopyOnWriteArrayList<E>(collection).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            this.removedCurrent = false;
            ++this.nextIndex;
            return this.wrapped.next();
        }

        @Override
        public void remove() {
            if (this.nextIndex == 0) {
                throw new IllegalStateException("Call next() first");
            }
            if (this.removedCurrent) {
                throw new IllegalStateException("Already removed current, call next()");
            }
            this.synchronizedRemove(this.nextIndex - 1);
            this.removedCurrent = true;
        }

        protected abstract void synchronizedRemove(int var1);
    }
}

