/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SearchPathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchPathUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> findFiles(final String fileName, boolean searchSubDirs, String ... searchPaths) {
        LOGGER.debug("Find files in searchPaths: {}", new Object[]{searchPaths});
        final LinkedList<File> files = new LinkedList<File>();
        for (String searchPath : searchPaths) {
            LOGGER.debug("Prepared filename to load file: {}", (Object)fileName.toString());
            if (searchPath.startsWith("classpath:")) {
                int beginIndex = "classpath:".length();
                Object lookup = "/" + searchPath.substring(beginIndex);
                lookup = ((String)lookup).replaceAll("\\\\", "/");
                LOGGER.info("Lookup file internally: {}", lookup);
                URL pathString = SearchPathUtils.class.getResource((String)lookup);
                LOGGER.info("Prepared pathString: {}", (Object)pathString);
                if (pathString == null) {
                    LOGGER.info("No resource for lookup '{}' found.", lookup);
                    continue;
                }
                FileSystem fs = null;
                try {
                    URI lookupURI = pathString.toURI();
                    LOGGER.info("Prepared lookupURI: {}", (Object)lookupURI);
                    final String[] array = lookupURI.toString().split("!");
                    Path path = null;
                    if (array.length > 1) {
                        HashMap env = new HashMap();
                        LOGGER.debug("Create new filesystem for: {}", (Object)array[0]);
                        fs = FileSystems.newFileSystem(URI.create(array[0]), env);
                        path = fs.getPath(array[1], new String[0]);
                        LOGGER.debug("Prepared path: {}", (Object)path);
                    } else {
                        path = Paths.get(lookupURI);
                    }
                    final FileSystem fsInner = fs;
                    Files.walkFileTree(path.getParent(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            LOGGER.info("Current file: {}", (Object)path);
                            if (FilenameUtils.wildcardMatch((String)path.toString(), (String)fileName, (IOCase)IOCase.INSENSITIVE)) {
                                LOGGER.info("Found matching path: {}, absolutePath: {}", (Object)path, (Object)path.toAbsolutePath());
                                File file = null;
                                if (fsInner != null) {
                                    String filePath = array[0] + "!" + path.toAbsolutePath();
                                    file = new File(filePath);
                                } else {
                                    file = path.toFile();
                                }
                                LOGGER.info("Add matching file: {}", (Object)file);
                                files.add(file);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                            if (e == null) {
                                LOGGER.info("Current directory: {}", (Object)dir);
                                return FileVisitResult.CONTINUE;
                            }
                            throw e;
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.warn("Convert uri to path failed.", (Throwable)e);
                }
                finally {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Close filesystem failed.", (Throwable)ex);
                        }
                    }
                }
                LOGGER.debug("Found matching files: {}", files);
                continue;
            }
            LOGGER.debug("Search for files in searchPath: {}", (Object)searchPath);
            File searchFile = new File(searchPath, fileName);
            File searchDirectory = searchFile.getParentFile();
            if (searchDirectory.exists()) {
                WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{fileName}).setIoCase(IOCase.INSENSITIVE).get();
                files.addAll(FileUtils.listFiles((File)searchDirectory, (IOFileFilter)fileFilter, (IOFileFilter)(searchSubDirs ? TrueFileFilter.INSTANCE : null)));
                LOGGER.debug("Found matching files: {}", files);
                continue;
            }
            LOGGER.info("The directory to search does not exist: {}", (Object)searchDirectory.toString());
        }
        return files;
    }

    public static List<Resource> findResources(String fileName, boolean searchSubDirs, String ... searchPaths) {
        LOGGER.info("Find files in searchPaths: {}", new Object[]{searchPaths});
        LinkedList<Resource> files = new LinkedList<Resource>();
        for (String searchPath : searchPaths) {
            LOGGER.info("Prepared filename to load file: {}, searchPath: {}", (Object)fileName, (Object)searchPath);
            if (searchPath.startsWith("classpath:")) {
                int beginIndex = "classpath:".length();
                Object lookup = "/" + searchPath.substring(beginIndex);
                lookup = ((String)lookup).replaceAll("\\\\", "/");
                LOGGER.info("Lookup file internally: {}", lookup);
                try {
                    String filenameSearch = fileName.toString();
                    String searchPathResolver = "classpath*:" + (String)lookup + "/" + filenameSearch;
                    LOGGER.info("Prepared searchPathResolver: {}", (Object)searchPathResolver);
                    Resource[] resources = new PathMatchingResourcePatternResolver(SearchPathUtils.class.getClassLoader()).getResources(searchPathResolver);
                    LOGGER.info("Found resources: {}", Arrays.asList(resources));
                    for (Resource resource : resources) {
                        LOGGER.info("Current resource: {}", (Object)resource);
                        files.add(resource);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Convert uri to path failed.", (Throwable)e);
                }
                LOGGER.debug("Found matching files: {}", files);
                continue;
            }
            LOGGER.debug("Search for files in searchPath: {}", (Object)searchPath);
            File searchFile = new File(searchPath, fileName);
            File searchDirectory = searchFile.getParentFile();
            if (searchDirectory.exists()) {
                try {
                    WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{fileName}).setIoCase(IOCase.INSENSITIVE).get();
                    Collection listFiles = FileUtils.listFiles((File)searchDirectory, (IOFileFilter)fileFilter, (IOFileFilter)(searchSubDirs ? TrueFileFilter.INSTANCE : null));
                    for (File file : listFiles) {
                        LOGGER.info("Current file: {}", (Object)file);
                        files.add((Resource)new FileSystemResource(file));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Convert uri to path failed.", (Throwable)e);
                }
                LOGGER.debug("Found matching files: {}", files);
                continue;
            }
            LOGGER.info("The directory to search does not exist: {}", (Object)searchDirectory.toString());
        }
        return files;
    }

    public static String lookupFilesInClasspath(String searchPath, SoftwareVersion softwareVersion, String filename, String lookup, String filenameSearch) {
        int beginIndex = "classpath:".length();
        LinkedList<Object> files = new LinkedList<Object>();
        try {
            String mapperPackagePath = "classpath*:" + (String)lookup + filenameSearch;
            LOGGER.info("Prepared mapperPackagePath: {}", (Object)mapperPackagePath);
            Resource[] resources = new PathMatchingResourcePatternResolver(SearchPathUtils.class.getClassLoader()).getResources(mapperPackagePath);
            LOGGER.info("Found resources: {}", Arrays.asList(resources));
            for (Object object : resources) {
                LOGGER.info("Current resource: {}", object);
                files.add(object);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Convert uri to path failed.", (Throwable)e);
        }
        LOGGER.info("Found matching files: {}", files);
        if (CollectionUtils.isNotEmpty(files)) {
            LinkedList<Resource> fileCollection = new LinkedList<Resource>();
            for (Resource resource : files) {
                fileCollection.add(resource);
            }
            Resource vendorCvFile = SearchPathUtils.findMatchingVendorCVResource(fileCollection, filename.toString(), softwareVersion);
            LOGGER.info("Matching vendorCvFile: {}", (Object)vendorCvFile);
            if (vendorCvFile != null) {
                String string = vendorCvFile.getFilename();
                lookup = searchPath.substring(beginIndex) + "/" + string;
                LOGGER.info("Prepared vendor CV lookup: {}", lookup);
            } else {
                LOGGER.warn("No matching vendorCV file found.");
                lookup = null;
            }
        } else {
            LOGGER.info("No matching vendorCV file found!");
            lookup = null;
        }
        return lookup;
    }

    protected static Resource findMatchingVendorCVResource(Collection<Resource> files, String defaultFilename, SoftwareVersion softwareVersion) {
        if (CollectionUtils.isNotEmpty(files)) {
            LOGGER.info("Search for matching CV definition for software version: {}", (Object)softwareVersion);
            Resource defaultCvDefinition = null;
            Resource cvDefinition = null;
            TreeMap weightedMap = new TreeMap(Collections.reverseOrder());
            for (Resource resource : files) {
                if (resource == null || resource.getFilename() == null) continue;
                String fileName = FilenameUtils.getBaseName((String)resource.getFilename());
                LOGGER.info("Check if filename is matching: {}", (Object)fileName);
                int index = fileName.lastIndexOf("-");
                if (index > -1 && index < fileName.length()) {
                    String lastPart = fileName.substring(index + 1);
                    LOGGER.info("Check last part: {}", (Object)lastPart);
                    if (lastPart.matches("^\\d+(\\.\\d+){0,2}")) {
                        String[] splited = lastPart.split("\\.");
                        LOGGER.info("Found version schema: {}", (Object[])splited);
                        int majorVersion = Integer.parseInt(splited[0]);
                        int minorVersion = -1;
                        if (splited.length > 1) {
                            minorVersion = Integer.parseInt(splited[1]);
                        }
                        int microVersion = -1;
                        if (splited.length > 2) {
                            microVersion = Integer.parseInt(splited[2]);
                        }
                        LOGGER.info("Found version, major: {}, minor: {}, micro: {}", new Object[]{majorVersion, minorVersion, microVersion});
                        SoftwareVersion current = new SoftwareVersion(majorVersion, minorVersion, microVersion){

                            public int compareTo(SoftwareVersion other) {
                                LOGGER.info("Compare sw version, other: {}, this: {}", (Object)other, (Object)this);
                                int myVersion = this.toInt();
                                int otherVersion = other.toInt();
                                if (this.secondVersion == -1) {
                                    SoftwareVersion myVersion2 = new SoftwareVersion(this.firstVersion, 255, 255);
                                    myVersion = myVersion2.toInt();
                                    LOGGER.info("Skip compare the micro version, otherVersion: {}, myVersion: {}", (Object)otherVersion, (Object)myVersion);
                                } else if (this.thirdVersion == -1) {
                                    SoftwareVersion myVersion2 = new SoftwareVersion(this.firstVersion, this.secondVersion, 255);
                                    myVersion = myVersion2.toInt();
                                    LOGGER.info("Skip compare the micro version, otherVersion: {}, myVersion: {}", (Object)otherVersion, (Object)myVersion);
                                }
                                return otherVersion - myVersion;
                            }
                        };
                        int difference = current.compareTo(softwareVersion);
                        LOGGER.info("The comparison difference: {}", (Object)difference);
                        weightedMap.put(difference, resource);
                        if (difference == 0) {
                            LOGGER.info("Found excactly matching version in file: {}", (Object)resource);
                            cvDefinition = resource;
                            break;
                        }
                    } else {
                        LOGGER.info("Last part does not match version schema: {}", (Object)lastPart);
                    }
                }
                String resourceFilename = resource.getFilename();
                if (defaultFilename == null || !resourceFilename.equalsIgnoreCase(defaultFilename)) continue;
                LOGGER.info("Found the default CV definition: {}", (Object)resource);
                defaultCvDefinition = resource;
            }
            LOGGER.info("Weighted map: {}", weightedMap);
            if (cvDefinition == null && MapUtils.isNotEmpty(weightedMap)) {
                for (Map.Entry entry : weightedMap.entrySet()) {
                    if ((Integer)entry.getKey() > 0) continue;
                    cvDefinition = (Resource)entry.getValue();
                    LOGGER.info("Use closest cvDefinition: {}", (Object)cvDefinition);
                    break;
                }
            }
            if (cvDefinition == null) {
                LOGGER.info("Use defaultCvDefinition: {}", defaultCvDefinition);
                cvDefinition = defaultCvDefinition;
            }
            return cvDefinition;
        }
        return null;
    }
}

