/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.utils;

import java.awt.Dimension;
import java.awt.Point;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowPositionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowPositionUtils.class);

    public static Point decodeWindowPos(String encodedWindowPosition) {
        try {
            if (StringUtils.isNotBlank((CharSequence)encodedWindowPosition)) {
                int[] tokens = new int[5];
                String[] st = encodedWindowPosition.split(",");
                for (int index = 0; index < tokens.length; ++index) {
                    tokens[index] = Integer.parseInt(st[index]);
                }
                return new Point(tokens[0], tokens[1]);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get encoded window position failed: {}", (Object)encodedWindowPosition, (Object)ex);
        }
        return null;
    }

    public static Dimension decodeWindowSize(String encodedWindowPosition) {
        try {
            if (StringUtils.isNotBlank((CharSequence)encodedWindowPosition)) {
                int[] tokens = new int[5];
                String[] st = encodedWindowPosition.split(",");
                for (int index = 0; index < tokens.length; ++index) {
                    tokens[index] = Integer.parseInt(st[index]);
                }
                return new Dimension(tokens[2], tokens[3]);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get encoded window size failed: {}", (Object)encodedWindowPosition, (Object)ex);
        }
        return null;
    }

    public static int decodeExtendedState(String encodedWindowPosition) {
        try {
            if (StringUtils.isNotBlank((CharSequence)encodedWindowPosition)) {
                int[] tokens = new int[5];
                String[] st = encodedWindowPosition.split(",");
                for (int index = 0; index < tokens.length; ++index) {
                    tokens[index] = Integer.parseInt(st[index]);
                }
                return tokens[4];
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get encoded window size failed: {}", (Object)encodedWindowPosition, (Object)ex);
        }
        return 0;
    }

    public static String encodedWindowPosition(Point windowPosition, Dimension windowSize, int extendedState) {
        try {
            String encodedWindowPosition = String.format("%1$d,%2$d,%3$d,%4$d,%5$d", (int)windowPosition.getX(), (int)windowPosition.getY(), (int)windowSize.getWidth(), (int)windowSize.getHeight(), extendedState);
            return encodedWindowPosition;
        }
        catch (Exception ex) {
            LOGGER.warn("Encode window position failed.", (Throwable)ex);
            return null;
        }
    }
}

