/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.graph.SimpleDirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitiveClosure {
    public static final TransitiveClosure INSTANCE = new TransitiveClosure();

    private TransitiveClosure() {
    }

    public <V, E> void closeSimpleDirectedGraph(SimpleDirectedGraph<V, E> simpleDirectedGraph) {
        Set set = simpleDirectedGraph.vertexSet();
        HashSet hashSet = new HashSet();
        int n = this.computeBinaryLog(set.size());
        boolean bl = false;
        for (int i = 0; !bl && i < n; ++i) {
            bl = true;
            for (Object v : set) {
                hashSet.clear();
                for (Object e : simpleDirectedGraph.outgoingEdgesOf(v)) {
                    Object v2 = simpleDirectedGraph.getEdgeTarget(e);
                    for (Object e2 : simpleDirectedGraph.outgoingEdgesOf(v2)) {
                        Object v3 = simpleDirectedGraph.getEdgeTarget(e2);
                        if (v.equals(v3) || simpleDirectedGraph.getEdge(v, v3) != null) continue;
                        hashSet.add(v3);
                        bl = false;
                    }
                }
                for (Object e : hashSet) {
                    simpleDirectedGraph.addEdge(v, e);
                }
            }
        }
    }

    private int computeBinaryLog(int n) {
        assert (n >= 0);
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }
}

