/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.decorations;

import com.github.weisj.darklaf.platform.CustomTitlePane;
import com.github.weisj.darklaf.platform.DecorationsConstants;
import com.github.weisj.darklaf.platform.decorations.NativeDecorationsManager;
import com.github.weisj.darklaf.platform.decorations.NativeDecorationsRootLayout;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicRootPaneUI;

public abstract class AbstractNativeDecorationsRootPaneUI
extends BasicRootPaneUI
implements DecorationsConstants {
    private static final int TITLE_PANE_CONTENT_LAYER = JLayeredPane.FRAME_CONTENT_LAYER + 1;
    private final PropertyChangeListener decorationsPropertyChangeListener = new DecorationsPropertyChangeListener();
    private final HierarchyListener decorationsHierarchyListener = new DecorationsHierarchyListener();
    private final NativeDecorationsManager decorationsManager;
    private Window window;
    private CustomTitlePane titlePane;
    private LayoutManager layoutManager;
    private LayoutManager oldLayout;
    private JRootPane rootPane;
    protected int windowDecorationsStyle = -1;

    public AbstractNativeDecorationsRootPaneUI(NativeDecorationsManager decorationsManager) {
        this.decorationsManager = decorationsManager;
    }

    protected CustomTitlePane titlePane() {
        return this.titlePane;
    }

    protected NativeDecorationsManager decorationsManager() {
        return this.decorationsManager;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.rootPane = (JRootPane)c;
        this.windowDecorationsStyle = this.rootPane.getWindowDecorationStyle();
        this.updateClientDecoration();
        this.installCustomListeners(this.rootPane);
    }

    @Override
    protected void installDefaults(JRootPane c) {
        super.installDefaults(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.rootPane);
        this.uninstallCustomListeners(this.rootPane);
        this.layoutManager = null;
        this.rootPane = null;
    }

    private void installCustomListeners(JRootPane root) {
        root.addPropertyChangeListener(this.decorationsPropertyChangeListener);
        root.addHierarchyListener(this.decorationsHierarchyListener);
    }

    protected void uninstallCustomListeners(JRootPane root) {
        root.removePropertyChangeListener(this.decorationsPropertyChangeListener);
        root.removeHierarchyListener(this.decorationsHierarchyListener);
    }

    private void updateClientDecoration() {
        if (this.decorationsEnabled(this.rootPane)) {
            this.uninstallClientDecorations(this.rootPane);
            if (this.decorationsManager.isCustomDecorationSupported()) {
                this.installClientDecorations(this.rootPane);
            }
        }
    }

    protected abstract void onDecorationsUninstall(JRootPane var1);

    protected abstract void onDecorationsInstall(JRootPane var1);

    protected abstract boolean shouldRemoveDecorations();

    private void installClientDecorations(JRootPane root) {
        this.updateWindow(this.rootPane.getParent());
        this.onDecorationsInstall(root);
        int style = this.decorationsStyleFromWindow(this.window, this.windowDecorationsStyle < 0 ? root.getWindowDecorationStyle() : this.windowDecorationsStyle);
        CustomTitlePane titlePane = this.decorationsManager.createTitlePane(root, style, this.window);
        this.installLayout(root);
        this.setTitlePane(root, titlePane);
        if (titlePane != null) {
            titlePane.setDecorationsStyle(this.windowDecorationsStyle);
        }
    }

    private void updateWindow(Component parent) {
        this.window = AbstractNativeDecorationsRootPaneUI.getWindow(parent);
        this.windowDecorationsStyle = this.decorationsStyleFromWindow(this.window, this.windowDecorationsStyle);
        if (this.titlePane != null) {
            this.titlePane.setDecorationsStyle(this.windowDecorationsStyle);
        }
    }

    protected int decorationsStyleFromWindow(Window window, int windowDecorationsStyle) {
        if (AbstractNativeDecorationsRootPaneUI.isUndecorated(window) || PropertyUtil.getBooleanProperty((JComponent)this.rootPane, (String)"JRootPane.noDecorations")) {
            return 0;
        }
        if (windowDecorationsStyle != 0) {
            return windowDecorationsStyle;
        }
        if (window instanceof JFrame) {
            return 1;
        }
        if (window instanceof JDialog) {
            return 2;
        }
        return windowDecorationsStyle;
    }

    private void setTitlePane(JRootPane root, CustomTitlePane titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        CustomTitlePane oldTitlePane = this.titlePane();
        if (oldTitlePane != null) {
            layeredPane.remove((Component)oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, TITLE_PANE_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    private void uninstallClientDecorations(JRootPane root) {
        if (root != null) {
            this.onDecorationsUninstall(root);
            root.removeHierarchyListener(this.decorationsHierarchyListener);
            if (this.titlePane != null) {
                boolean removeDecorations = this.shouldRemoveDecorations();
                this.titlePane.uninstall(removeDecorations);
                this.setTitlePane(root, null);
            }
            this.uninstallLayout(root);
            int style = root.getWindowDecorationStyle();
            if (style == 0) {
                root.repaint();
                root.revalidate();
            }
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = new NativeDecorationsRootLayout(this);
        }
        this.oldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.oldLayout != null) {
            root.setLayout(this.oldLayout);
            this.oldLayout = null;
        }
    }

    private boolean decorationsEnabled(JRootPane rootPane) {
        return !(rootPane.getParent() instanceof JInternalFrame) && !PropertyUtil.getBooleanProperty((JComponent)rootPane, (String)"JRootPane.noDecorationsUpdate") && rootPane.getParent() != null;
    }

    private static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    private static boolean isUndecorated(Window window) {
        if (window instanceof Frame) {
            return ((Frame)window).isUndecorated();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).isUndecorated();
        }
        return false;
    }

    private class DecorationsPropertyChangeListener
    implements PropertyChangeListener {
        private DecorationsPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("ancestor".equals(propertyName) || "JRootPane.noDecorations".equals(propertyName)) {
                AbstractNativeDecorationsRootPaneUI.this.updateWindow(AbstractNativeDecorationsRootPaneUI.this.rootPane.getParent());
            }
        }
    }

    private class DecorationsHierarchyListener
    implements HierarchyListener {
        private DecorationsHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (AbstractNativeDecorationsRootPaneUI.this.rootPane == null) {
                return;
            }
            Container parent = AbstractNativeDecorationsRootPaneUI.this.rootPane.getParent();
            if (parent == null) {
                return;
            }
            if (parent.getClass().getName().startsWith("org.jdesktop.jdic.tray") || parent.getClass().getName().equals("javax.swing.Popup$HeavyWeightWindow")) {
                SwingUtilities.invokeLater(() -> {
                    if (AbstractNativeDecorationsRootPaneUI.this.rootPane != null) {
                        AbstractNativeDecorationsRootPaneUI.this.rootPane.removeHierarchyListener(this);
                    }
                });
            }
            if (e.getChangeFlags() == 1L && AbstractNativeDecorationsRootPaneUI.getWindow(AbstractNativeDecorationsRootPaneUI.this.rootPane) != AbstractNativeDecorationsRootPaneUI.this.window) {
                AbstractNativeDecorationsRootPaneUI.this.updateClientDecoration();
            }
        }
    }
}

