/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.decorations;

import com.github.weisj.darklaf.platform.decorations.BasicNativeDecorationsRootPaneUI;
import com.github.weisj.darklaf.platform.decorations.DecorationsColorProvider;
import com.github.weisj.darklaf.platform.decorations.NativeDecorationsManager;
import com.github.weisj.darklaf.properties.color.DarkColorModelHSL;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.properties.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public final class ExternalLafDecorator {
    private static ExternalLafDecorator instance;
    private final NativeDecorationsManager decorationsManager;
    private final PropertyChangeListener propertyChangeListener;
    private boolean installed;
    private final DecorationsColorProvider fallbackColorProvider;
    private DecorationsColorProvider colorProvider;

    private ExternalLafDecorator() {
        this.colorProvider = this.fallbackColorProvider = new DefaultDecorationsColorProvider();
        this.decorationsManager = new NativeDecorationsManager();
        this.propertyChangeListener = evt -> {
            if ("lookAndFeel".equals(evt.getPropertyName())) {
                this.installExtraProperties();
            }
        };
    }

    public static ExternalLafDecorator instance() {
        if (instance == null) {
            instance = new ExternalLafDecorator();
        }
        return instance;
    }

    public NativeDecorationsManager decorationsManager() {
        return this.decorationsManager;
    }

    public void install() {
        if (this.installed) {
            return;
        }
        this.installed = true;
        this.decorationsManager.initialize();
        UIManager.addPropertyChangeListener(this.propertyChangeListener);
        this.installExtraProperties();
    }

    public void uninstall() {
        if (!this.installed) {
            return;
        }
        this.installed = false;
        UIManager.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void setColorProvider(DecorationsColorProvider colorProvider) {
        this.colorProvider = colorProvider;
        if (colorProvider == null) {
            this.colorProvider = this.fallbackColorProvider;
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    private void putOrCopy(String key, Function<DecorationsColorProvider, Color> getter, Properties props, UIDefaults uiDefaults) {
        Object other = uiDefaults.get(key);
        if (other == null) {
            other = getter.apply(this.colorProvider);
        }
        if (other == null) {
            other = getter.apply(this.fallbackColorProvider);
        }
        props.put(key, other);
    }

    private void installExtraProperties() {
        IconLoader.updateThemeStatus((Object)new Object());
        this.colorProvider.onLafChanged();
        DecorationsColorProvider.TitleColor titleColor = this.colorProvider.windowTitleColor();
        Properties props = new Properties();
        UIDefaults defaults = UIManager.getDefaults();
        this.putOrCopy("borderSecondary", DecorationsColorProvider::borderColor, props, defaults);
        this.putOrCopy("hoverHighlight", DecorationsColorProvider::hoverBackgroundColor, props, defaults);
        this.putOrCopy("clickHighlight", DecorationsColorProvider::clickBackgroundColor, props, defaults);
        this.putOrCopy("background", DecorationsColorProvider::backgroundColor, props, defaults);
        this.putOrCopy("textForeground", DecorationsColorProvider::activeForegroundColor, props, defaults);
        this.putOrCopy("textForegroundInactive", DecorationsColorProvider::inactiveForegroundColor, props, defaults);
        this.putOrCopy("textForegroundSecondary", DecorationsColorProvider::inactiveForegroundColor, props, defaults);
        this.putOrCopy("windowButton", DecorationsColorProvider::windowButtonColor, props, defaults);
        this.putOrCopy("windowButtonDisabled", DecorationsColorProvider::inactiveWindowButtonColor, props, defaults);
        this.putOrCopy("windowCloseHovered", p -> new DarkColorUIResource(Color.WHITE), props, defaults);
        if (!this.decorationsManager.supportsNativeTitleText()) {
            Consumer<String> adjustColor = s -> props.put(s, this.adjustForegroundColor((Color)props.get(s), titleColor));
            adjustColor.accept("textForeground");
            adjustColor.accept("textForegroundSecondary");
            adjustColor.accept("textForegroundInactive");
        }
        this.decorationsManager.loadDecorationProperties(props, defaults);
        props.remove("borderSecondary");
        props.remove("hoverHighlight");
        props.remove("clickHighlight");
        props.remove("background");
        props.remove("textForeground");
        props.remove("textForegroundInactive");
        props.remove("textForegroundSecondary");
        props.remove("windowButton");
        props.remove("windowButtonDisabled");
        props.remove("windowCloseHovered");
        defaults.putAll(props);
        defaults.put("Theme.dark", (Object)(titleColor == DecorationsColorProvider.TitleColor.LIGHT ? 1 : 0));
        defaults.put("Theme.macos.useSwingTitleLabel", (Object)(titleColor == DecorationsColorProvider.TitleColor.CUSTOM ? 1 : 0));
        defaults.put("RootPaneUI", BasicNativeDecorationsRootPaneUI.class.getName());
    }

    private Color adjustForegroundColor(Color color, DecorationsColorProvider.TitleColor titleColor) {
        if (titleColor == DecorationsColorProvider.TitleColor.CUSTOM) {
            return color;
        }
        double[] hslFG = DarkColorModelHSL.RGBtoHSLValues((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
        double brightness = titleColor == DecorationsColorProvider.TitleColor.LIGHT ? 0.9 : 0.1;
        return DarkColorModelHSL.getColorFromHSLValues((double)hslFG[0], (double)hslFG[1], (double)brightness);
    }

    private static class DefaultDecorationsColorProvider
    implements DecorationsColorProvider {
        private Color foreground;
        private Color background;
        private Color disabledForeground;

        private DefaultDecorationsColorProvider() {
        }

        @Override
        public void onLafChanged() {
            JLabel label = new JLabel();
            label.setOpaque(true);
            this.foreground = new DarkColorUIResource(label.getForeground());
            this.background = new DarkColorUIResource(label.getBackground());
            label.setEnabled(false);
            this.disabledForeground = new DarkColorUIResource(label.getForeground());
        }

        @Override
        public Color backgroundColor() {
            return this.background;
        }

        @Override
        public Color activeForegroundColor() {
            return this.foreground;
        }

        @Override
        public Color inactiveForegroundColor() {
            return this.disabledForeground;
        }

        @Override
        public DecorationsColorProvider.TitleColor windowTitleColor() {
            if (ColorUtil.getPerceivedBrightness((Color)this.background) <= 125.0) {
                return DecorationsColorProvider.TitleColor.LIGHT;
            }
            return DecorationsColorProvider.TitleColor.DARK;
        }
    }
}

