/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.decorations;

import com.github.weisj.darklaf.platform.CustomTitlePane;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.platform.decorations.AbstractNativeDecorationsRootPaneUI;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JRootPane;

class NativeDecorationsRootLayout
implements LayoutManager2 {
    private static final Logger LOGGER = LogUtil.getLogger(NativeDecorationsRootLayout.class);
    private final AbstractNativeDecorationsRootPaneUI ui;

    NativeDecorationsRootLayout(AbstractNativeDecorationsRootPaneUI ui) {
        this.ui = ui;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    private boolean hasValidMenuBar(JRootPane root) {
        return root.getJMenuBar() != null && root.getJMenuBar().getParent() == root.getLayeredPane();
    }

    private Dimension calculateLayoutSize(Container parent, Function<Container, Dimension> measure) {
        Dimension mbd;
        int cpWidth = 0;
        int cpHeight = 0;
        int mbWidth = 0;
        int mbHeight = 0;
        int tpWidth = 0;
        int tpHeight = 0;
        Insets i = parent.getInsets();
        JRootPane root = (JRootPane)parent;
        CustomTitlePane titlePane = this.getTitlePane(root);
        Dimension cpd = root.getContentPane() != null ? measure.apply(root.getContentPane()) : root.getSize();
        LOGGER.finer("JRootPane content size: " + cpd);
        if (cpd != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (this.hasValidMenuBar(root) && (mbd = measure.apply(root.getJMenuBar())) != null) {
            mbWidth = mbd.width;
            mbHeight = mbd.height;
        }
        if (titlePane != null && this.shouldDisplayTitlePane(titlePane)) {
            Dimension tpd = measure.apply((Container)titlePane);
            if (tpd != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            LOGGER.finer("JRootPane titlePane size: " + tpd);
        }
        int totalWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth);
        int totalHeight = this.shouldLayerTitlePane(root) ? Math.max(cpHeight + mbHeight, tpHeight) : cpHeight + mbHeight + tpHeight;
        return new Dimension(totalWidth + i.left + i.right, totalHeight + i.top + i.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateLayoutSize(parent, Container::getPreferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateLayoutSize(parent, Container::getMinimumSize);
    }

    protected CustomTitlePane getTitlePane(JRootPane root) {
        return this.ui.titlePane();
    }

    @Override
    public void layoutContainer(Container parent) {
        JRootPane root = (JRootPane)parent;
        Rectangle b = root.getBounds();
        Insets i = root.getInsets();
        b.setLocation(0, 0);
        b.x += i.left;
        b.y += i.top;
        b.width -= i.left + i.right;
        b.height -= i.top + i.bottom;
        if (root.getLayeredPane() != null) {
            root.getLayeredPane().setBounds(b.x, b.y, b.width, b.height);
        }
        if (root.getGlassPane() != null) {
            root.getGlassPane().setBounds(b.x, b.y, b.width, b.height);
        }
        this.ui.decorationsManager().adjustContentArea(root, b);
        this.layoutContent(root, b.x, b.y, b.width, b.height);
    }

    public void layoutContent(JRootPane root, int x, int y, int w, int h) {
        Dimension tpd;
        int nextY = y;
        CustomTitlePane titlePane = this.getTitlePane(root);
        if (titlePane != null && (tpd = titlePane.getPreferredSize()) != null) {
            int tpHeight = tpd.height;
            titlePane.setBounds(x, y, w, tpHeight);
            if (!this.shouldLayerTitlePane(root)) {
                nextY += tpHeight;
            }
        }
        if (this.hasValidMenuBar(root)) {
            Dimension mbd = root.getJMenuBar().getPreferredSize();
            root.getJMenuBar().setBounds(x, nextY, w, mbd.height);
            nextY += mbd.height;
        }
        if (root.getContentPane() != null) {
            root.getContentPane().setBounds(x, nextY, w, h < nextY ? 0 : h - nextY);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        int totalHeight;
        int totalWidth;
        Dimension tpd;
        Dimension mbd;
        Dimension cpd;
        int cpWidth = Integer.MAX_VALUE;
        int cpHeight = Integer.MAX_VALUE;
        int mbHeight = Integer.MAX_VALUE;
        int tpHeight = Integer.MAX_VALUE;
        Insets i = target.getInsets();
        JRootPane root = (JRootPane)target;
        CustomTitlePane titlePane = this.ui.titlePane();
        if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (this.hasValidMenuBar(root) && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
            mbHeight = mbd.height;
        }
        if (titlePane != null && this.shouldDisplayTitlePane(titlePane) && (tpd = titlePane.getMaximumSize()) != null) {
            tpHeight = tpd.height;
        }
        if ((totalWidth = cpWidth) != Integer.MAX_VALUE) {
            totalWidth += i.left + i.right;
        }
        if ((totalHeight = cpHeight) < Integer.MAX_VALUE) {
            if (tpHeight < Integer.MAX_VALUE && !this.shouldLayerTitlePane(root)) {
                totalHeight += tpHeight;
            }
            if (mbHeight < Integer.MAX_VALUE) {
                totalHeight += mbHeight;
            }
            totalHeight += i.top + i.bottom;
        }
        return new Dimension(totalWidth, totalHeight);
    }

    private boolean shouldDisplayTitlePane(CustomTitlePane customTitlePane) {
        return customTitlePane.getDecorationStyle() != 0;
    }

    private boolean shouldLayerTitlePane(JRootPane root) {
        return SystemInfo.isMac && PropertyUtil.getBooleanProperty((JComponent)root, (String)"apple.awt.fullWindowContent");
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

