/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.jserialcomm;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.serial.LineStatusListener;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSerialCommSerialConnector
extends AbstractBaseBidib<MessageReceiver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSerialCommSerialConnector.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private SerialPort comPort;
    private MessageReceiver messageReceiver;
    private LineStatusListener lineStatusListener;
    private ScheduledExecutorService lineStatusWorker;
    private ByteArrayOutputStream sendBuffer = new ByteArrayOutputStream(100);

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public LineStatusListener getLineStatusListener() {
        return this.lineStatusListener;
    }

    public void setLineStatusListener(LineStatusListener lineStatusListener) {
        this.lineStatusListener = lineStatusListener;
    }

    protected boolean isImplAvaiable() {
        return this.comPort != null;
    }

    public boolean isOpened() {
        return this.comPort != null && this.comPort.isOpen();
    }

    protected void internalOpen(String portName, Context context) throws PortNotFoundException, PortNotOpenedException {
        super.internalOpen(portName, context);
        LOGGER.info("Create the lineStatusWorker thread pool: {}", (Object)this.lineStatusWorker);
        this.lineStatusWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("jserialLineStatusWorkers-thread-%d").build());
        Boolean useHardwareFlowControl = (Boolean)context.get("serial.useHardwareFlowControl", Boolean.class, (Object)Boolean.TRUE);
        LOGGER.info("Open port with portName: {}, useHardwareFlowControl: {}", (Object)portName, (Object)useHardwareFlowControl);
        MessageReceiver serialMessageReceiver = this.getMessageReceiver();
        this.comPort = SerialPort.getCommPort((String)portName);
        if (useHardwareFlowControl.booleanValue()) {
            this.comPort.setFlowControl(17);
        } else {
            this.comPort.setFlowControl(0);
        }
        Integer baudRate = (Integer)context.get("serial.baudrate", Integer.class, (Object)115200);
        LOGGER.info("Open port with baudRate: {}", (Object)baudRate);
        this.comPort.setComPortParameters(baudRate.intValue(), 8, 1, 0);
        boolean opened = this.comPort.openPort();
        if (!opened) {
            LOGGER.warn("Port was not opened: {}", (Object)portName);
            throw new PortNotOpenedException("Port was not opened: " + portName, "unknown");
        }
        this.startReceiverAndQueues(serialMessageReceiver, context);
        this.comPort.addDataListener((SerialPortDataListener)new MessageListener());
        if (useHardwareFlowControl.booleanValue()) {
            try {
                LOGGER.info("Activate DTR.");
                this.comPort.setDTR();
            }
            catch (Exception e) {
                LOGGER.warn("Set DTR true failed.", (Throwable)e);
            }
        }
        this.fireCtsChanged(true, true);
        this.setConnected(true);
    }

    private void portDisconnected() {
        Thread worker = new Thread(() -> {
            LOGGER.info("Start close port because port disconnected was signalled.");
            try {
                this.close();
            }
            catch (Exception ex) {
                LOGGER.warn("Close after error failed.", (Throwable)ex);
            }
            LOGGER.warn("The port was closed.");
        });
        worker.start();
    }

    public boolean close() {
        if (this.comPort != null) {
            LOGGER.info("Start closing the port: {}", (Object)this.comPort);
            long start = System.currentTimeMillis();
            SerialPort comPortToClose = this.comPort;
            this.comPort = null;
            LOGGER.info("Close the port, comPort: {}", (Object)comPortToClose);
            comPortToClose.removeDataListener();
            comPortToClose.closePort();
            MessageReceiver serialMessageReceiver = this.getMessageReceiver();
            this.stopReceiverAndQueues(serialMessageReceiver);
            this.firstPacketSent = false;
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            this.fireCtsChanged(false, true);
            this.setConnected(false);
            LOGGER.info("Shutdown the lineStatusWorker: {}", (Object)this.lineStatusWorker);
            if (this.lineStatusWorker != null) {
                try {
                    this.lineStatusWorker.shutdownNow();
                    this.lineStatusWorker.awaitTermination(500L, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    LOGGER.warn("Terminate lineStatusWorker failed.", (Throwable)ex);
                }
                this.lineStatusWorker = null;
            }
            return true;
        }
        LOGGER.info("No port to close available.");
        return false;
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        for (SerialPort serialPort : SerialPort.getCommPorts()) {
            portIdentifiers.add(serialPort.getSystemPortName());
        }
        return portIdentifiers;
    }

    protected void fireCtsChanged(boolean ready, boolean manualEvent) {
        LOGGER.info("CTS has changed, ready: {}", (Object)ready);
        this.lineStatusWorker.schedule(() -> {
            if (this.lineStatusListener != null) {
                this.lineStatusListener.notifyLineStatusChanged(ready, manualEvent);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    protected void sendData(ByteArrayOutputStream data, RawMessageListener rawMessageListener) {
        if (this.comPort != null && data != null) {
            try {
                int sent;
                if (!this.firstPacketSent) {
                    LOGGER.info("Send initial sequence.");
                    try {
                        byte[] initialSequence = new byte[]{ByteUtils.MAGIC};
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)initialSequence.length, (Object)ByteUtils.bytesToHex((byte[])initialSequence));
                        }
                        if (rawMessageListener != null) {
                            rawMessageListener.notifySend(initialSequence);
                        }
                        this.comPort.writeBytes(initialSequence, initialSequence.length);
                        Thread.sleep(10L);
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)initialSequence.length, (Object)ByteUtils.bytesToHex((byte[])initialSequence));
                        }
                        if (rawMessageListener != null) {
                            rawMessageListener.notifySend(initialSequence);
                        }
                        this.comPort.writeBytes(initialSequence, initialSequence.length);
                        this.firstPacketSent = true;
                        LOGGER.info("Send initial sequence passed.");
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Send initial sequence failed.", (Throwable)ex);
                    }
                }
                this.sendBuffer.reset();
                SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)this.sendBuffer);
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)this.sendBuffer.toByteArray().length, (Object)ByteUtils.bytesToHex((byte[])this.sendBuffer.toByteArray()));
                }
                if (rawMessageListener != null) {
                    rawMessageListener.notifySend(this.sendBuffer.toByteArray());
                }
                if ((sent = this.comPort.writeBytes(this.sendBuffer.toByteArray(), this.sendBuffer.size())) == 0) {
                    MSG_RAW_LOGGER.warn(">> sent bytes: {}", (Object)sent);
                    byte[] bytes = data.toByteArray();
                    LOGGER.error("The message has not been sent to comPort: {}, message: {}", (Object)this.comPort, (Object)ByteUtils.bytesToHex((byte[])bytes));
                    throw new RuntimeException("Write message to output failed: " + ByteUtils.bytesToHex((byte[])bytes));
                }
                MSG_RAW_LOGGER.info(">> sent bytes: {}", (Object)sent);
            }
            catch (IOException ex) {
                byte[] bytes = data.toByteArray();
                LOGGER.warn("Send message to output stream failed: [{}] - {}", (Object)bytes.length, (Object)ByteUtils.bytesToHex((byte[])bytes));
                throw new RuntimeException("Send message to output stream failed: " + ByteUtils.bytesToHex((byte[])bytes), ex);
            }
            finally {
                this.sendBuffer.reset();
            }
        }
    }

    private final class MessageListener
    implements SerialPortMessageListener {
        private MessageListener() {
        }

        public int getListeningEvents() {
            return 0x10000010;
        }

        public byte[] getMessageDelimiter() {
            return new byte[]{ByteUtils.getLowByte((int)254)};
        }

        public boolean delimiterIndicatesEndOfMessage() {
            return true;
        }

        public void serialEvent(SerialPortEvent event) {
            LOGGER.trace("serialEvent, eventType: {}", (Object)event.getEventType());
            switch (event.getEventType()) {
                case 16: {
                    byte[] data = event.getReceivedData();
                    JSerialCommSerialConnector.this.receive(data, data.length);
                    break;
                }
                case 0x10000000: {
                    LOGGER.warn("Port was disconnected.");
                    JSerialCommSerialConnector.this.portDisconnected();
                    break;
                }
            }
        }
    }
}

