/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.jserialcomm;

import com.fazecast.jSerialComm.SerialPort;
import java.util.ArrayList;
import java.util.List;
import org.bidib.jbidibc.messages.exception.InvalidLibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortIdentifierUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortIdentifierUtils.class);

    public static List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            SerialPort[] serials;
            for (SerialPort serialPort : serials = SerialPort.getCommPorts()) {
                portIdentifiers.add(serialPort.getSystemPortName());
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        return portIdentifiers;
    }
}

