/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.jserialcomm.debug;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortMessageListenerWithExceptions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.debug.AbstractDebugReader;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.LineEndingEnum;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugReader
extends AbstractDebugReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReader.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"DEBUG_RAW");
    static final int DEFAULT_TIMEOUT = 300;
    private SerialPort port;
    private Semaphore portSemaphore = new Semaphore(1);
    private Semaphore sendSemaphore = new Semaphore(1);
    private AtomicBoolean closeInProgress = new AtomicBoolean();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();

    public DebugReader(DebugMessageProcessor messageReceiver) {
        super(messageReceiver);
    }

    public void initialize() {
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        for (SerialPort serialPort : SerialPort.getCommPorts()) {
            portIdentifiers.add(serialPort.getSystemPortName());
        }
        return portIdentifiers;
    }

    private SerialPort internalOpen(String portName, int baudRate, Context context) throws PortNotFoundException, PortNotOpenedException {
        this.closeInProgress.set(false);
        this.startReceiveQueueWorker();
        Boolean useHardwareFlowControl = context != null ? (Boolean)context.get("serial.useHardwareFlowControl", Boolean.class, (Object)Boolean.FALSE) : Boolean.FALSE;
        LOGGER.info("Open port with portName: {}, useHardwareFlowControl: {}", (Object)portName, (Object)useHardwareFlowControl);
        this.port = SerialPort.getCommPort((String)portName);
        if (useHardwareFlowControl.booleanValue()) {
            this.port.setFlowControl(17);
        } else {
            this.port.setFlowControl(0);
        }
        LOGGER.info("Open port with baudRate: {}", (Object)baudRate);
        this.port.setComPortParameters(baudRate, 8, 1, 0);
        boolean opened = this.port.openPort();
        if (!opened) {
            LOGGER.warn("Port was not opened: {}", (Object)portName);
            throw new PortNotOpenedException("Port was not opened: " + portName, "unknown");
        }
        this.getConnectionListener().opened(portName);
        this.getMessageReceiver().enable();
        this.port.addDataListener((SerialPortDataListener)new MessageListener());
        if (useHardwareFlowControl.booleanValue()) {
            try {
                LOGGER.info("Activate DTR.");
                this.port.setDTR();
            }
            catch (Exception e) {
                LOGGER.warn("Set DTR true failed.", (Throwable)e);
            }
        }
        return this.port;
    }

    private void portDisconnected() {
        Thread worker = new Thread(() -> {
            LOGGER.info("Start close port because port disconnected was signalled.");
            try {
                this.close();
            }
            catch (Exception ex) {
                LOGGER.warn("Close after error failed.", (Throwable)ex);
            }
            LOGGER.warn("The port was closed.");
        });
        worker.start();
    }

    public void close() {
        if (this.port != null) {
            LOGGER.debug("Close the port.");
            long start = System.currentTimeMillis();
            SerialPort comPortToClose = this.port;
            this.port = null;
            LOGGER.info("Close the port, comPort: {}", (Object)comPortToClose);
            comPortToClose.removeDataListener();
            comPortToClose.closePort();
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            this.getMessageReceiver().disable();
            this.stopReceiveQueueWorker();
            try {
                if (this.getConnectionListener() != null) {
                    this.getConnectionListener().closed(this.getRequestedPortName());
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Notify connection listener failed.", (Throwable)ex);
            }
            this.setRequestedPortName(null);
        }
    }

    public boolean isOpened() {
        return this.port != null && this.port.isOpen();
    }

    public void open(String portName, int baudRate, ConnectionListener connectionListener, Context context) throws PortNotFoundException, PortNotOpenedException {
        block12: {
            this.setConnectionListener(connectionListener);
            if (this.port == null) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}", (Object)portName);
                SerialPort serialPort = SerialPort.getCommPort((String)portName);
                if (serialPort == null) {
                    LOGGER.warn("Requested port is not available: {}", (Object)portName);
                    throw new PortNotFoundException(portName);
                }
                String commPort = serialPort.getSystemPortName();
                LOGGER.info("Set the requestedPortName: {}, baudRate: {}", (Object)portName, (Object)baudRate);
                this.setRequestedPortName(portName);
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        this.port = this.internalOpen(commPort, baudRate, context);
                        LOGGER.info("The port was opened internally.");
                        break block12;
                    }
                    catch (PortNotFoundException | PortNotOpenedException ex) {
                        LOGGER.warn("Open communication failed.", ex);
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new PortNotOpenedException(portName, "portInUse");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    public void send(String message, LineEndingEnum lineEnding) {
        if (this.port != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)message);
                }
                OutputStream output = this.port.getOutputStream();
                output.write(message.getBytes());
                output.write(lineEnding.getValues());
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    public void send(byte[] content) {
        if (this.port != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)content.length, (Object)ByteUtils.bytesToHex((byte[])content));
                }
                OutputStream output = this.port.getOutputStream();
                output.write(content);
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(byte[] data, int len) {
        LOGGER.debug("Start receiving messages.");
        DebugReader debugReader = this;
        synchronized (debugReader) {
            LOGGER.debug("Starting message receiver.");
            try {
                if (len > 0) {
                    this.output.write(data, 0, len);
                    this.addDataToReceiveQueue(this.output);
                    if (this.output != null && this.output.size() > 0) {
                        LOGGER.warn("Data in output: {}", (Object)this.output.toString());
                    }
                } else {
                    LOGGER.error("No input available.");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private final class MessageListener
    implements SerialPortMessageListenerWithExceptions {
        private MessageListener() {
        }

        public int getListeningEvents() {
            return 0x10000010;
        }

        public byte[] getMessageDelimiter() {
            return new byte[0];
        }

        public boolean delimiterIndicatesEndOfMessage() {
            return true;
        }

        public void serialEvent(SerialPortEvent event) {
            LOGGER.trace("serialEvent, eventType: {}", (Object)event.getEventType());
            switch (event.getEventType()) {
                case 16: {
                    byte[] data = event.getReceivedData();
                    DebugReader.this.receive(data, data.length);
                    break;
                }
                case 0x10000000: {
                    LOGGER.warn("Port was disconnected.");
                    DebugReader.this.portDisconnected();
                    break;
                }
            }
        }

        public void catchException(Exception ex) {
            LOGGER.warn("The serial port delivered an exception.", (Throwable)ex);
        }
    }
}

