/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothL2CAPClientConnection;
import com.intel.bluetooth.BluetoothL2CAPConnectionNotifier;
import com.intel.bluetooth.BluetoothRFCommClientConnection;
import com.intel.bluetooth.BluetoothRFCommConnectionNotifier;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.UtilsStringTokenizer;
import com.intel.bluetooth.gcf.socket.ServerSocketConnection;
import com.intel.bluetooth.gcf.socket.SocketConnection;
import com.intel.bluetooth.obex.OBEXClientSessionImpl;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXSessionNotifierImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

public abstract class MicroeditionConnector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static Hashtable suportScheme = new Hashtable();
    private static Hashtable srvParams = new Hashtable();
    private static Hashtable cliParams = new Hashtable();
    private static Hashtable cliParamsL2CAP = new Hashtable();
    private static Hashtable srvParamsL2CAP = new Hashtable();
    private static final String AUTHENTICATE = "authenticate";
    private static final String AUTHORIZE = "authorize";
    private static final String ENCRYPT = "encrypt";
    private static final String MASTER = "master";
    private static final String NAME = "name";
    private static final String RECEIVE_MTU = "receivemtu";
    private static final String TRANSMIT_MTU = "transmitmtu";
    private static final String EXT_BLUECOVE_L2CAP_PSM = "bluecovepsm";
    private static final String ANDROID = "android";
    static /* synthetic */ Class class$java$lang$String;

    private MicroeditionConnector() {
    }

    static void copyAll(Hashtable dest, Hashtable src) {
        Enumeration en = src.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            dest.put(key, src.get(key));
        }
    }

    static String validParamName(Hashtable map, String paramName) {
        String validName = (String)map.get(paramName.toLowerCase());
        if (validName != null) {
            return validName;
        }
        if (ANDROID.equals(paramName)) {
            return ANDROID;
        }
        return null;
    }

    public static Connection open(String name) throws IOException {
        return MicroeditionConnector.openImpl(name, 3, false, true);
    }

    private static Connection openImpl(String name, int mode, boolean timeouts, boolean allowServer) throws IOException {
        boolean isServer;
        int hostEnd;
        DebugLog.debug("connecting", name);
        String host = null;
        String portORuuid = null;
        Hashtable<String, String> values = new Hashtable<String, String>();
        int schemeEnd = name.indexOf("://");
        if (schemeEnd == -1) {
            throw new ConnectionNotFoundException(name);
        }
        String scheme = name.substring(0, schemeEnd);
        if (!suportScheme.containsKey(scheme)) {
            throw new ConnectionNotFoundException(scheme);
        }
        boolean schemeBluetooth = scheme.equals("btspp") || scheme.equals("btgoep") || scheme.equals("btl2cap");
        boolean isL2CAP = scheme.equals("btl2cap");
        boolean isTCPOBEX = scheme.equals("tcpobex");
        BluetoothStack bluetoothStack = null;
        if (schemeBluetooth) {
            bluetoothStack = BlueCoveImpl.instance().getBluetoothStack();
        }
        if ((hostEnd = name.indexOf(58, scheme.length() + 3)) > -1) {
            Hashtable params;
            host = name.substring(scheme.length() + 3, hostEnd);
            isServer = host.equals("localhost");
            if (isTCPOBEX) {
                params = new Hashtable();
                isServer = host.length() == 0;
            } else {
                params = isL2CAP ? (isServer ? srvParamsL2CAP : cliParamsL2CAP) : (isServer ? srvParams : cliParams);
            }
            String paramsStr = name.substring(hostEnd + 1);
            UtilsStringTokenizer tok = new UtilsStringTokenizer(paramsStr, ";");
            portORuuid = tok.hasMoreTokens() ? tok.nextToken() : paramsStr;
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken();
                int equals = t.indexOf(61);
                if (equals > -1) {
                    String param = t.substring(0, equals);
                    String value = t.substring(equals + 1);
                    String validName = MicroeditionConnector.validParamName(params, param);
                    if (validName != null) {
                        String hasValue = (String)values.get(validName);
                        if (hasValue != null && !hasValue.equals(value)) {
                            throw new IllegalArgumentException("duplicate param [" + param + "] value [" + value + "]");
                        }
                        values.put(validName, value);
                        continue;
                    }
                    throw new IllegalArgumentException("invalid param [" + param + "] value [" + value + "]");
                }
                throw new IllegalArgumentException("invalid param [" + t + "]");
            }
        } else if (isTCPOBEX) {
            host = name.substring(scheme.length() + 3);
            isServer = host.length() == 0;
        } else {
            throw new IllegalArgumentException(name.substring(scheme.length() + 3));
        }
        if (isTCPOBEX && (portORuuid == null || portORuuid.length() == 0)) {
            portORuuid = String.valueOf(650);
        }
        if (host == null || portORuuid == null) {
            throw new IllegalArgumentException();
        }
        BluetoothConnectionNotifierParams notifierParams = null;
        BluetoothConnectionParams connectionParams = null;
        boolean isAndroid = values.containsKey(ANDROID);
        int channel = 0;
        if (isServer) {
            if (!allowServer) {
                throw new IllegalArgumentException("Can't use server connection URL");
            }
            if (values.get(NAME) == null) {
                values.put(NAME, "BlueCove");
            } else if (schemeBluetooth) {
                MicroeditionConnector.validateBluetoothServiceName((String)values.get(NAME));
            }
            if (schemeBluetooth) {
                String bluecove_ext_psm;
                notifierParams = new BluetoothConnectionNotifierParams(new UUID(portORuuid, false), MicroeditionConnector.paramBoolean(values, AUTHENTICATE), MicroeditionConnector.paramBoolean(values, ENCRYPT), MicroeditionConnector.paramBoolean(values, AUTHORIZE), (String)values.get(NAME), MicroeditionConnector.paramBoolean(values, MASTER));
                notifierParams.timeouts = timeouts;
                if (notifierParams.encrypt && !notifierParams.authenticate) {
                    if (values.get(AUTHENTICATE) == null) {
                        notifierParams.authenticate = true;
                    } else {
                        throw new BluetoothConnectionException(6, "encryption requires authentication");
                    }
                }
                if (notifierParams.authorize && !notifierParams.authenticate) {
                    if (values.get(AUTHENTICATE) == null) {
                        notifierParams.authenticate = true;
                    } else {
                        throw new BluetoothConnectionException(6, "authorization requires authentication");
                    }
                }
                if (isL2CAP && (bluecove_ext_psm = (String)values.get(EXT_BLUECOVE_L2CAP_PSM)) != null) {
                    if ((bluetoothStack.getFeatureSet() & 0x10) == 0) {
                        throw new IllegalArgumentException("bluecovepsm extension not supported on this stack");
                    }
                    int psm = Integer.parseInt(bluecove_ext_psm, 16);
                    MicroeditionConnector.validateL2CAPPSM(psm, bluecove_ext_psm);
                    notifierParams.bluecove_ext_psm = psm;
                }
            }
        } else {
            if (!isAndroid) {
                try {
                    channel = Integer.parseInt(portORuuid, isL2CAP ? 16 : 10);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("channel " + portORuuid);
                }
                if (channel < 0) {
                    throw new IllegalArgumentException("channel " + portORuuid);
                }
            }
            if (schemeBluetooth) {
                if (!isAndroid) {
                    if (isL2CAP) {
                        MicroeditionConnector.validateL2CAPPSM(channel, portORuuid);
                    } else if (channel < 1 || channel > 30) {
                        throw new IllegalArgumentException("RFCOMM channel " + portORuuid);
                    }
                    connectionParams = new BluetoothConnectionParams(RemoteDeviceHelper.getAddress(host), channel, MicroeditionConnector.paramBoolean(values, AUTHENTICATE), MicroeditionConnector.paramBoolean(values, ENCRYPT));
                } else {
                    try {
                        connectionParams = (BluetoothConnectionParams)Class.forName("com.intel.bluetooth.AndroidBluetoothConnectionParams").getConstructor(Long.TYPE, Boolean.TYPE, Boolean.TYPE).newInstance(RemoteDeviceHelper.getAddress(host), MicroeditionConnector.paramBoolean(values, AUTHENTICATE), MicroeditionConnector.paramBoolean(values, ENCRYPT));
                        connectionParams.getClass().getMethod("setServiceUUID", class$java$lang$String == null ? (class$java$lang$String = MicroeditionConnector.class$("java.lang.String")) : class$java$lang$String).invoke((Object)connectionParams, portORuuid);
                    }
                    catch (Exception ex) {
                        throw new BluetoothConnectionException(4, ex.toString());
                    }
                }
                connectionParams.timeouts = timeouts;
                if (connectionParams.encrypt && !connectionParams.authenticate) {
                    if (values.get(AUTHENTICATE) == null) {
                        connectionParams.authenticate = true;
                    } else {
                        throw new BluetoothConnectionException(6, "encryption requires authentication");
                    }
                }
                connectionParams.timeout = BlueCoveImpl.getConfigProperty("bluecove.connect.timeout", 120000);
            }
        }
        OBEXConnectionParams obexConnectionParams = null;
        if (scheme.equals("tcpobex") || scheme.equals("btgoep")) {
            obexConnectionParams = new OBEXConnectionParams();
            obexConnectionParams.timeouts = timeouts;
            obexConnectionParams.timeout = BlueCoveImpl.getConfigProperty("bluecove.obex.timeout", 120000);
            obexConnectionParams.mtu = BlueCoveImpl.getConfigProperty("bluecove.obex.mtu", 1024);
        }
        if (scheme.equals("btspp")) {
            if (isServer) {
                return new BluetoothRFCommConnectionNotifier(bluetoothStack, notifierParams);
            }
            return new BluetoothRFCommClientConnection(bluetoothStack, connectionParams);
        }
        if (scheme.equals("btgoep")) {
            if (isServer) {
                notifierParams.obex = true;
                return new OBEXSessionNotifierImpl(new BluetoothRFCommConnectionNotifier(bluetoothStack, notifierParams), obexConnectionParams);
            }
            return new OBEXClientSessionImpl(new BluetoothRFCommClientConnection(bluetoothStack, connectionParams), obexConnectionParams);
        }
        if (scheme.equals("btl2cap")) {
            if (isServer) {
                return new BluetoothL2CAPConnectionNotifier(bluetoothStack, notifierParams, MicroeditionConnector.paramL2CAPMTU(values, RECEIVE_MTU), MicroeditionConnector.paramL2CAPMTU(values, TRANSMIT_MTU));
            }
            return new BluetoothL2CAPClientConnection(bluetoothStack, connectionParams, MicroeditionConnector.paramL2CAPMTU(values, RECEIVE_MTU), MicroeditionConnector.paramL2CAPMTU(values, TRANSMIT_MTU));
        }
        if (scheme.equals("tcpobex")) {
            if (isServer) {
                try {
                    channel = Integer.parseInt(portORuuid);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("port " + portORuuid);
                }
                return new OBEXSessionNotifierImpl(new ServerSocketConnection(channel), obexConnectionParams);
            }
            return new OBEXClientSessionImpl(new SocketConnection(host, channel), obexConnectionParams);
        }
        if (scheme.equals("socket")) {
            if (isServer) {
                try {
                    channel = Integer.parseInt(portORuuid);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("port " + portORuuid);
                }
                return new ServerSocketConnection(channel);
            }
            return new SocketConnection(host, channel);
        }
        throw new ConnectionNotFoundException("scheme [" + scheme + "]");
    }

    private static void validateL2CAPPSM(int channel, String channelAsString) throws IllegalArgumentException {
        if (channel < 5 || channel > 65535) {
            throw new IllegalArgumentException("PCM " + channelAsString);
        }
        if (channel < 4097 && !BlueCoveImpl.getConfigProperty("bluecove.jsr82.psm_minimum_off", false)) {
            throw new IllegalArgumentException("PCM " + channelAsString + ", PCM values restricted by JSR-82 to minimum " + 4097 + ", see BlueCoveConfigProperties.PROPERTY_JSR_82_PSM_MINIMUM_OFF");
        }
        if ((channel & 0x100) != 0) {
            throw new IllegalArgumentException("9th bit set in PCM " + channelAsString);
        }
        byte lsByte = (byte)(0xFF & channel);
        if (lsByte % 2 == 0) {
            throw new IllegalArgumentException("PSM value " + channelAsString + " least significant byte must be odd");
        }
        byte msByte = (byte)((0xFF00 & channel) >> 8);
        if (msByte % 2 == 1) {
            throw new IllegalArgumentException("PSM value " + channelAsString + " most significant byte must be even");
        }
    }

    private static void validateBluetoothServiceName(String serviceName) {
        if (serviceName.length() == 0) {
            throw new IllegalArgumentException("zero length service name");
        }
        String allowNameCharactes = " -_";
        for (int i = 0; i < serviceName.length(); ++i) {
            char c = serviceName.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || " -_".indexOf(c) != -1) continue;
            throw new IllegalArgumentException("Illegal character '" + c + "' in service name");
        }
    }

    private static boolean paramBoolean(Hashtable values, String name) {
        String v = (String)values.get(name);
        if (v == null) {
            return false;
        }
        if ("true".equals(v)) {
            return true;
        }
        if ("false".equals(v)) {
            return false;
        }
        throw new IllegalArgumentException("invalid param value " + name + "=" + v);
    }

    private static int paramL2CAPMTU(Hashtable values, String name) {
        String v = (String)values.get(name);
        if (v == null) {
            if (name.equals(TRANSMIT_MTU)) {
                return -1;
            }
            return 672;
        }
        try {
            int mtu = Integer.parseInt(v);
            if (mtu >= 48) {
                return mtu;
            }
            if (mtu > 0 && mtu < 48 && name.equals(TRANSMIT_MTU)) {
                return 48;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid MTU value " + v);
        }
        throw new IllegalArgumentException("invalid MTU param value " + name + "=" + v);
    }

    public static Connection open(String name, int mode) throws IOException {
        return MicroeditionConnector.openImpl(name, mode, false, true);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        return MicroeditionConnector.openImpl(name, mode, timeouts, true);
    }

    public static DataInputStream openDataInputStream(String name) throws IOException {
        return new DataInputStream(MicroeditionConnector.openInputStream(name));
    }

    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        return new DataOutputStream(MicroeditionConnector.openOutputStream(name));
    }

    public static InputStream openInputStream(String name) throws IOException {
        InputConnection con = (InputConnection)MicroeditionConnector.openImpl(name, 1, false, false);
        try {
            InputStream inputStream = con.openInputStream();
            return inputStream;
        }
        finally {
            con.close();
        }
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        OutputConnection con = (OutputConnection)MicroeditionConnector.openImpl(name, 2, false, false);
        try {
            OutputStream outputStream = con.openOutputStream();
            return outputStream;
        }
        finally {
            con.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        cliParams.put(AUTHENTICATE, AUTHENTICATE);
        cliParams.put(ENCRYPT, ENCRYPT);
        cliParams.put(MASTER, MASTER);
        MicroeditionConnector.copyAll(srvParams, cliParams);
        srvParams.put(AUTHORIZE, AUTHORIZE);
        srvParams.put(NAME, NAME);
        MicroeditionConnector.copyAll(cliParamsL2CAP, cliParams);
        cliParamsL2CAP.put(RECEIVE_MTU, RECEIVE_MTU);
        cliParamsL2CAP.put(TRANSMIT_MTU, TRANSMIT_MTU);
        MicroeditionConnector.copyAll(srvParamsL2CAP, cliParamsL2CAP);
        srvParamsL2CAP.put(AUTHORIZE, AUTHORIZE);
        srvParamsL2CAP.put(NAME, NAME);
        srvParamsL2CAP.put(EXT_BLUECOVE_L2CAP_PSM, EXT_BLUECOVE_L2CAP_PSM);
        suportScheme.put("btspp", Boolean.TRUE);
        suportScheme.put("btgoep", Boolean.TRUE);
        suportScheme.put("tcpobex", Boolean.TRUE);
        suportScheme.put("btl2cap", Boolean.TRUE);
        suportScheme.put("socket", Boolean.TRUE);
    }
}

