/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial;

import com.pi4j.io.gpio.exception.UnsupportedBoardType;
import com.pi4j.system.SystemInfo;
import java.io.File;
import java.io.IOException;

public class SerialPort {
    public static String getDefaultPort() throws IOException, InterruptedException, UnsupportedBoardType {
        return SerialPort.getDefaultPort(SystemInfo.getBoardType());
    }

    public static String getDefaultPort(SystemInfo.BoardType board) throws UnsupportedBoardType {
        switch (board) {
            case RaspberryPi_A: 
            case RaspberryPi_B_Rev1: 
            case RaspberryPi_B_Rev2: 
            case RaspberryPi_A_Plus: 
            case RaspberryPi_B_Plus: 
            case RaspberryPi_ComputeModule: 
            case RaspberryPi_2B: 
            case RaspberryPi_Zero: 
            case RaspberryPi_ComputeModule3: 
            case RaspberryPi_ZeroW: 
            case RaspberryPi_Alpha: 
            case RaspberryPi_Unknown: {
                return "/dev/ttyAMA0";
            }
            case RaspberryPi_3B: 
            case RaspberryPi_3B_Plus: {
                File s0ComPort = new File("/dev/ttyS0");
                if (s0ComPort.exists()) {
                    return "/dev/ttyS0";
                }
                return "/dev/ttyAMA0";
            }
            case BananaPi: {
                return "/dev/ttyS2";
            }
            case BananaPro: {
                return "/dev/ttyS2";
            }
            case Bpi_M1: {
                break;
            }
            case Bpi_M1P: {
                break;
            }
            case Bpi_M2: {
                break;
            }
            case Bpi_M2M: {
                break;
            }
            case Bpi_M2P: {
                break;
            }
            case Bpi_M2P_H2_Plus: {
                break;
            }
            case Bpi_M2P_H5: {
                break;
            }
            case Bpi_M2U: {
                break;
            }
            case Bpi_M2U_V40: {
                break;
            }
            case Bpi_M3: {
                break;
            }
            case Bpi_M64: {
                break;
            }
            case Bpi_R1: {
                break;
            }
            case NanoPi_A64: {
                break;
            }
            case NanoPi_K2: {
                break;
            }
            case NanoPi_M1: {
                break;
            }
            case NanoPi_M1_Plus: {
                break;
            }
            case NanoPi_M3: {
                break;
            }
            case NanoPi_NEO: {
                break;
            }
            case NanoPi_NEO2: {
                break;
            }
            case NanoPi_NEO2_Plus: {
                break;
            }
            case NanoPi_NEO_Air: {
                break;
            }
            case NanoPi_S2: {
                break;
            }
            case Odroid: {
                break;
            }
            case OrangePi: {
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        throw new UnsupportedBoardType();
    }
}

