/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.jni;

import com.pi4j.jni.AnalogInputEvent;
import com.pi4j.jni.AnalogInputListener;
import com.pi4j.util.NativeLibraryLoader;
import java.util.Vector;

public class AnalogInputMonitor {
    private static Vector<AnalogInputListener> listeners = new Vector();
    private Object lock;

    private AnalogInputMonitor() {
    }

    public static native int enablePinValueChangeCallback(int var0, int var1, double var2);

    public static native int disablePinValueChangeCallback(int var0);

    private static void pinValueChangeCallback(int pin, double value) {
        Vector listenersClone = (Vector)listeners.clone();
        for (int i = 0; i < listenersClone.size(); ++i) {
            AnalogInputListener listener = (AnalogInputListener)listenersClone.elementAt(i);
            if (listener == null) continue;
            AnalogInputEvent event = new AnalogInputEvent(listener, pin, value);
            listener.pinValueChange(event);
        }
    }

    public static synchronized void addListener(AnalogInputListener listener) {
        if (!listeners.contains(listener)) {
            listeners.addElement(listener);
        }
    }

    public static synchronized void removeListener(AnalogInputListener listener) {
        if (listeners.contains(listener)) {
            listeners.removeElement(listener);
        }
    }

    public static synchronized boolean hasListener(AnalogInputListener listener) {
        return listeners.contains(listener);
    }

    static {
        NativeLibraryLoader.load("libpi4j.so");
    }
}

