/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import org.bidib.jbidibc.messages.enums.FirmwareUpdateOperation;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.FwUpdateOpMessage;
import org.bidib.jbidibc.messages.message.FwUpdateStatResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.InterfaceNode;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.SimulatorRegistry;
import org.bidib.jbidibc.simulation.events.NodeLostEvent;
import org.bidib.wizard.simulation.GBMboostMasterSimulator;
import org.bidib.wizard.simulation.LightControlSimulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareErrorSimulator
extends LightControlSimulator
implements InterfaceNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareErrorSimulator.class);
    private SimulatorRegistry simulatorRegistry;
    private int dataBlocksReceived;

    public FirmwareErrorSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    public void setSimulatorRegistry(SimulatorRegistry simulatorRegistry) {
        this.simulatorRegistry = simulatorRegistry;
    }

    protected byte[] processFwUpdateOpRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            SimulatorNode master;
            FwUpdateOpMessage fwUpdateOpMessage = (FwUpdateOpMessage)bidibMessage;
            FirmwareUpdateOperation operation = fwUpdateOpMessage.getOperation();
            LOGGER.info("processFwUpdateOpRequest, operation: {}", (Object)operation);
            int timeout = 0;
            int status = 255;
            switch (operation) {
                case ENTER: {
                    status = 0;
                    LOGGER.warn("Send no answer on ENTER request. Send NODE_LOST instead.");
                    break;
                }
                case DATA: {
                    status = 2;
                    ++this.dataBlocksReceived;
                    if (this.dataBlocksReceived <= 0 || this.dataBlocksReceived >= 200 || this.dataBlocksReceived % 15 != 0) break;
                    LOGGER.warn("Return a timeout > 0");
                    timeout = 30;
                    break;
                }
                case SETDEST: {
                    status = 2;
                    break;
                }
                case EXIT: {
                    status = 1;
                    LOGGER.warn("Send no answer on EXIT request.");
                    break;
                }
            }
            FwUpdateStatResponse fwUpdateStatResponse = new FwUpdateStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)status), ByteUtils.getLowByte((int)timeout));
            response = fwUpdateStatResponse.getContent();
            if (operation == FirmwareUpdateOperation.EXIT && (master = this.simulatorRegistry.getSimulator("0")) instanceof GBMboostMasterSimulator) {
                NodeLostEvent nodeLostEvent = new NodeLostEvent(this.getNodeAddress(), this.getUniqueId());
                ((GBMboostMasterSimulator)master).nodeLostEvent(nodeLostEvent);
                return response;
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create fwUpdateStat response failed.", (Throwable)ex);
        }
        return response;
    }

    public void addSubNode(SimulatorNode simulator) {
    }
}

