/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.FeedbackSpeedResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulator(vid="13", pid="134")
public class GBM16TSSimulator
extends DefaultNodeSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GBM16TSSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.GBMboostMasterPanel";
    private final Map<Integer, FeedbackPort> feedbackPorts = new HashMap<Integer, FeedbackPort>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusValid = new AtomicBoolean();
    private final AtomicBoolean statusSignal = new AtomicBoolean();
    protected static final int MAX_NUM_OF_FEEDBACK_PORTS = 16;
    private boolean startFeedbackWorker = true;
    protected final ScheduledExecutorService feedbackAddrWorker;
    private int interval = 3000;
    private int currentLocoPosition = -1;
    private int timestamp;
    private int decoderAddress = 10;
    private int locationAddress = 120;

    public GBM16TSSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
        this.uniqueId = uniqueId & 0xFFFFFFFFFFFFL | 0x40000000000000L;
        LOGGER.info("Provided uniqueId: {}", (Object)this.uniqueId);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("feedbackAddrWorkers-thread-%d").build();
        this.feedbackAddrWorker = Executors.newScheduledThreadPool(1, namedThreadFactory);
    }

    protected void prepareFeatures() {
        super.prepareFeatures();
        this.features.add(new Feature(0, 16));
        this.features.add(new Feature(1, 1));
        this.features.add(new Feature(2, 1));
        this.features.add(new Feature(3, 100));
        this.features.add(new Feature(8, 1));
        this.features.add(new Feature(9, 1));
        this.features.add(new Feature(10, 1));
        this.features.add(new Feature(11, 1));
        this.features.add(new Feature(12, 100));
        this.features.add(new Feature(13, 1));
        this.features.add(new Feature(14, 1));
        this.features.add(new Feature(28, 5));
        this.features.add(new Feature(29, 1));
        this.features.add(new Feature(30, 1));
        this.features.add(new Feature(252, 24));
        this.features.add(new Feature(254, 1));
    }

    protected void prepareCVs() {
        super.prepareCVs();
        this.configurationVariables.put("1", "1");
        this.configurationVariables.put("7", "27");
        this.configurationVariables.put("9", "128");
        this.configurationVariables.put("36", "1");
        this.configurationVariables.put("37", "5");
        this.configurationVariables.put("38", "5");
        this.configurationVariables.put("39", "2");
        this.configurationVariables.put("40", "16");
        this.configurationVariables.put("42", "5");
        this.configurationVariables.put("43", "15");
        this.configurationVariables.put("44", "16");
        this.configurationVariables.put("45", "8");
        this.configurationVariables.put("46", "3");
        this.configurationVariables.put("47", "1");
        this.configurationVariables.put("48", "0");
        this.configurationVariables.put("49", "2");
        this.configurationVariables.put("50", "0");
        this.configurationVariables.put("51", "3");
        this.configurationVariables.put("52", "87");
        this.configurationVariables.put("53", "232");
        this.configurationVariables.put("54", "3");
        this.configurationVariables.put("55", "2");
        this.configurationVariables.put("56", "0");
        this.configurationVariables.put("57", "4");
        this.configurationVariables.put("58", "0");
        this.configurationVariables.put("59", "255");
        this.configurationVariables.put("60", "255");
        this.configurationVariables.put("61", "0");
        this.configurationVariables.put("62", "255");
        this.configurationVariables.put("63", "255");
        this.configurationVariables.put("64", "0");
        this.configurationVariables.put("65", "0");
        this.configurationVariables.put("66", "0");
        this.configurationVariables.put("70", "85");
        this.configurationVariables.put("104", "1");
        this.configurationVariables.put("105", "13");
        this.configurationVariables.put("106", "100");
        this.configurationVariables.put("107", "0");
        this.configurationVariables.put("108", "2");
        this.configurationVariables.put("109", "7");
        this.configurationVariables.put("110", "2");
        this.configurationVariables.put("136", "0");
        this.configurationVariables.put("137", "8");
        this.configurationVariables.put("138", "4");
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.setupFeedbackPorts();
        super.start();
        if (this.isFeedbackChangesEnabled() && this.startFeedbackWorker) {
            this.feedbackAddrWorker.scheduleWithFixedDelay(() -> {
                try {
                    int portNum = this.currentLocoPosition;
                    LOGGER.info("Trigger feedback address, portNum: {}", (Object)portNum);
                    FeedbackPortSetStatusEvent evtFree = null;
                    if (portNum > -1) {
                        portNum = this.currentLocoPosition;
                        if (portNum < 0) {
                            portNum = 15;
                        }
                        evtFree = new FeedbackPortSetStatusEvent(this.getAddress(), portNum, FeedbackPortStatus.FREE);
                    }
                    ++this.currentLocoPosition;
                    if (this.currentLocoPosition >= 16) {
                        this.currentLocoPosition = 0;
                    }
                    FeedbackPortSetStatusEvent evtOcc = new FeedbackPortSetStatusEvent(this.getAddress(), this.currentLocoPosition, FeedbackPortStatus.OCCUPIED);
                    this.setFeedbackPortStatus(evtOcc);
                    this.triggerFeedbackAddressResponse(this.currentLocoPosition);
                    Thread.sleep(500L);
                    if (evtFree != null) {
                        this.setFeedbackPortStatus(evtFree);
                        this.triggerFeedbackAddressResponse(evtFree.getPortNum());
                    }
                    int delayValue = ThreadLocalRandom.current().nextInt(300, 4000);
                    LOGGER.info("Wait for next execution, delayValue: {}", (Object)delayValue);
                    Thread.sleep(delayValue);
                }
                catch (Exception ex) {
                    LOGGER.warn("Trigger the feedback address failed.", (Throwable)ex);
                }
                LOGGER.info("Trigger feedback address has finished.");
            }, 5000L, this.interval, TimeUnit.MILLISECONDS);
        } else {
            LOGGER.info("The feedback address publisher is not started.");
        }
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        if (this.feedbackAddrWorker != null) {
            LOGGER.info("Stop the booster diag worker.");
            this.feedbackAddrWorker.shutdownNow();
        }
        super.stop();
    }

    private void setupFeedbackPorts() {
        for (int id = 0; id < 16; ++id) {
            FeedbackPort port = new FeedbackPort();
            port.setId(id);
            port.setStatus(FeedbackPortStatus.FREE);
            this.feedbackPorts.put(id, port);
        }
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 32: {
                response = this.processBmGetRangeRequest(bidibMessage);
                break;
            }
            case 33: {
                this.processBmMirrorMultipleRequest(bidibMessage);
                break;
            }
            case 34: {
                this.processBmMirrorOccupiedRequest(bidibMessage);
                break;
            }
            case 35: {
                this.processBmMirrorFreeRequest(bidibMessage);
                break;
            }
            case 36: {
                this.processBmAddrGetRangeRequest(bidibMessage);
                break;
            }
            case 37: {
                response = this.processBmGetConfidenceRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processBmGetRangeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackGetRangeMessage: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            FeedbackGetRangeMessage feedbackGetRangeMessage = (FeedbackGetRangeMessage)bidibMessage;
            int baseAddress = feedbackGetRangeMessage.getBeginRange();
            int end = feedbackGetRangeMessage.getEndRange();
            int feedbackSize = feedbackGetRangeMessage.getEndRange() - feedbackGetRangeMessage.getBeginRange();
            int value = 0;
            int index = 0;
            int feedbackByteSize = feedbackSize / 8 + (feedbackSize % 8 > 0 ? 1 : 0);
            byte[] feedbackMultiple = new byte[feedbackByteSize];
            int position = feedbackMultiple.length;
            for (int portNum = end; portNum > baseAddress; --portNum) {
                value = (byte)((value & 0xFF) << 1);
                FeedbackPort fbp = this.feedbackPorts.get(portNum - 1);
                int status = 0;
                if (fbp != null) {
                    status = ByteUtils.getLowByte((int)((FeedbackPortStatus)fbp.getStatus()).getType().getType(), (int)1);
                }
                feedbackMultiple[position - 1] = value = (int)((byte)(value | status));
                if (++index <= 7) continue;
                value = 0;
                index = 0;
                --position;
            }
            LOGGER.info("Prepared feedback multiple: {}", (Object)ByteUtils.bytesToHex((byte[])feedbackMultiple));
            FeedbackMultipleResponse feedbackMultipleResponse = new FeedbackMultipleResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)baseAddress), ByteUtils.getLowByte((int)feedbackSize), feedbackMultiple);
            response = feedbackMultipleResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackMultiple response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processBmMirrorMultipleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackMirrorMultipleMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorOccupiedRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorOccupiedRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorFreeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorFreeRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmAddrGetRangeRequest(BidibMessageInterface bidibMessage) {
        try {
            for (FeedbackPort port : this.feedbackPorts.values()) {
                int detectorNumber = port.getId();
                ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
                List addresses = port.getAddresses();
                if (CollectionUtils.isNotEmpty((Collection)addresses)) {
                    for (FeedbackAddressData addressData : addresses) {
                        EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                        AddressTypeEnum addressType = null;
                        switch (enrailmentDirection) {
                            case LOCOMOTIVE_LEFT: 
                            case LOCOMOTIVE_RIGHT: {
                                addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                                break;
                            }
                            case BASIC_ACCESSORY: {
                                addressType = AddressTypeEnum.ACCESSORY;
                                break;
                            }
                            case EXTENDED_ACCESSORY: {
                                addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                                break;
                            }
                        }
                        AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                        bidibAddresses.add(bidibAddress);
                    }
                }
                FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorNumber, bidibAddresses);
                byte[] response = feedbackAddressResponse.getContent();
                LOGGER.info("Prepare feedbackAddressResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackAddress response failed.", (Throwable)ex);
        }
    }

    protected byte[] processBmGetConfidenceRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            byte valid = (byte)(this.statusValid.get() ? 1 : 0);
            byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
            byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(bidibMessage.getAddr(), this.getNextSendNum(), valid, freeze, signal);
            response = feedbackConfidenceResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackConfidence response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishFeedbackPortChange(Port<?> port) {
        FeedbackPort feedbackPort = (FeedbackPort)port;
        FeedbackPortStatus status = (FeedbackPortStatus)feedbackPort.getStatus();
        LOGGER.info("The feedbackport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getId(), status));
    }

    public void queryStatus(Class<?> portClass) {
        if (FeedbackPort.class.equals(portClass)) {
            for (FeedbackPort feedbackPort : this.feedbackPorts.values()) {
                this.publishFeedbackPortChange((Port<?>)feedbackPort);
            }
            this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
        }
    }

    private void triggerFeedbackAddressResponse(int portNum) {
        LOGGER.info("Trigger the feedback address repsonse, portNum: {}", (Object)portNum);
        byte[] response = null;
        LinkedList<FeedbackAddressData> addresses = new LinkedList<FeedbackAddressData>();
        byte lowByte = 3;
        byte highByte = ByteUtils.getLowByte((int)128);
        int address = ByteUtils.getWord((byte)lowByte, (byte)((byte)(highByte & 0x3F)));
        AddressData addressDataIn = new AddressData(address, AddressTypeEnum.valueOf((byte)((byte)((highByte & 0xC0) >> 6))));
        addresses.add(new FeedbackAddressData(addressDataIn.getAddress(), EnrailmentDirectionEnum.LOCOMOTIVE_RIGHT));
        try {
            FeedbackPort feedbackPort = this.feedbackPorts.get(portNum);
            int detectorNumber = feedbackPort.getId();
            ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
            if (FeedbackPortStatus.OCCUPIED == feedbackPort.getStatus() && CollectionUtils.isNotEmpty(addresses)) {
                for (FeedbackAddressData addressData : addresses) {
                    EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                    AddressTypeEnum addressType = null;
                    switch (enrailmentDirection) {
                        case LOCOMOTIVE_LEFT: 
                        case LOCOMOTIVE_RIGHT: {
                            addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                            break;
                        }
                        case BASIC_ACCESSORY: {
                            addressType = AddressTypeEnum.ACCESSORY;
                            break;
                        }
                        case EXTENDED_ACCESSORY: {
                            addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                            break;
                        }
                    }
                    AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                    bidibAddresses.add(bidibAddress);
                }
            }
            FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(this.nodeAddress, this.getNextSendNum(), detectorNumber, bidibAddresses);
            response = feedbackAddressResponse.getContent();
            this.sendSpontanousResponse(response);
            if (FeedbackPortStatus.OCCUPIED == feedbackPort.getStatus()) {
                int speedValue = ThreadLocalRandom.current().nextInt(2, 100);
                FeedbackSpeedResponse feedbackSpeedResponse = new FeedbackSpeedResponse(this.nodeAddress, this.getNextSendNum(), address, speedValue);
                this.sendSpontanousResponse(feedbackSpeedResponse.getContent());
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create FeedbackAddressResponse failed.", (Throwable)ex);
        }
    }

    @EventSubscriber(eventClass=FeedbackConfidenceSetEvent.class)
    public void feedbackConfidenceSetEvent(FeedbackConfidenceSetEvent feedbackConfidenceEvent) {
        String nodeAddress = feedbackConfidenceEvent.getNodeAddr();
        LOGGER.info("The change of the feedback confidence was requested, nodeAddress: {}", (Object)nodeAddress);
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        this.statusValid.set(feedbackConfidenceEvent.getValid());
        this.statusFreeze.set(feedbackConfidenceEvent.getFreeze());
        this.statusSignal.set(feedbackConfidenceEvent.getSignal());
        byte valid = (byte)(this.statusValid.get() ? 1 : 0);
        byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
        byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
        try {
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(this.nodeAddress, this.getNextSendNum(), valid, freeze, signal);
            LOGGER.info("Prepared feedbackConfidenceResponse: {}", (Object)feedbackConfidenceResponse);
            this.sendSpontanousResponse(feedbackConfidenceResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send feedbackConfidenceResponse failed.", (Throwable)ex);
        }
        this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
    }

    private void publishFeedbackConfidenceStatusEvent(boolean valid, boolean freeze, boolean signal) {
        LOGGER.info("The feedbackport confidence status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackConfidenceStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), valid, freeze, signal));
    }

    @EventSubscriber(eventClass=FeedbackPortSetStatusEvent.class)
    public void feedbackPortSetStatus(FeedbackPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the feedback port was requested.");
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        try {
            this.invertFeedbackPortStatus(portNum);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Publish feedback status failed.", (Throwable)ex);
        }
    }

    private int getTimestamp() {
        this.timestamp += 10;
        if (this.timestamp > 65000) {
            this.timestamp = 0;
        }
        return this.timestamp;
    }

    private boolean hasTimestampFeature() {
        Feature feature = Feature.findFeature((Collection)this.features, (int)30);
        return feature != null && feature.getValue() > 0;
    }

    private int getDecoderAddress() {
        ++this.decoderAddress;
        if (this.decoderAddress > 15) {
            this.decoderAddress = 10;
        }
        return this.decoderAddress;
    }

    private int getLocationAddress() {
        ++this.locationAddress;
        if (this.locationAddress > 150) {
            this.locationAddress = 120;
        }
        return this.locationAddress;
    }

    protected void invertFeedbackPortStatus(int portNum) throws ProtocolException {
        FeedbackPort port = this.feedbackPorts.get(portNum);
        if (port != null) {
            FeedbackFreeResponse response = null;
            switch ((FeedbackPortStatus)port.getStatus()) {
                case FREE: {
                    port.setStatus(FeedbackPortStatus.OCCUPIED);
                    if (this.hasTimestampFeature()) {
                        response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum, this.getTimestamp());
                        break;
                    }
                    response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                    break;
                }
                default: {
                    port.setStatus(FeedbackPortStatus.FREE);
                    response = new FeedbackFreeResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                }
            }
            LOGGER.info("Prepared the FeedbackFreeResponse: {}", (Object)response);
            this.sendSpontanousResponse(response.getContent());
            this.publishFeedbackPortChange((Port<?>)port);
        } else {
            LOGGER.warn("The requested feedback port is not available: {}", (Object)portNum);
        }
    }

    protected void setFeedbackPortStatus(FeedbackPortSetStatusEvent statusEvent) throws ProtocolException {
        int portNum = statusEvent.getPortNum();
        FeedbackPort port = this.feedbackPorts.get(portNum);
        if (port != null) {
            FeedbackFreeResponse response = null;
            switch (statusEvent.getStatus()) {
                case OCCUPIED: {
                    port.setStatus(FeedbackPortStatus.OCCUPIED);
                    if (this.hasTimestampFeature()) {
                        response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum, this.getTimestamp());
                        break;
                    }
                    response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                    break;
                }
                default: {
                    port.setStatus(FeedbackPortStatus.FREE);
                    response = new FeedbackFreeResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                }
            }
            LOGGER.info("Prepared the FeedbackFreeResponse: {}", (Object)response);
            this.sendSpontanousResponse(response.getContent());
            this.publishFeedbackPortChange((Port<?>)port);
        } else {
            LOGGER.warn("The requested feedback port is not available: {}", (Object)portNum);
        }
    }
}

