/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.enums.PositionLocationEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BoostDiagnosticResponse;
import org.bidib.jbidibc.messages.message.BoostOffMessage;
import org.bidib.jbidibc.messages.message.BoostOnMessage;
import org.bidib.jbidibc.messages.message.BoostStatResponse;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.FeedbackPositionResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulator(vid="13", pid="103")
public class GBMboostNodeSimulator
extends DefaultNodeSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GBMboostNodeSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.GBMboostMasterPanel";
    private final Map<Integer, FeedbackPort> feedbackPorts = new HashMap<Integer, FeedbackPort>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean(false);
    private final AtomicBoolean statusVoid = new AtomicBoolean(false);
    private final AtomicBoolean statusNoSignal = new AtomicBoolean(false);
    private BoosterState boosterState = BoosterState.OFF;
    protected static final int MAX_NUM_OF_FEEDBACK_PORTS = 48;
    protected final ScheduledExecutorService boosterDiagWorker = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("simBoostDiagWorkers-thread-%d").build());
    private ScheduledFuture<?> futureTriggerBoostDiagnostic;
    private ScheduledFuture<?> futureTriggerFeedbackMessage;
    private int timestamp;
    private int decoderAddress = 10;
    private int locationAddress = 120;

    public GBMboostNodeSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    protected void prepareFeatures() {
        super.prepareFeatures();
        this.features.add(new Feature(0, 48));
        this.features.add(new Feature(1, 1));
        this.features.add(new Feature(30, 1));
        this.features.add(new Feature(2, 1));
        this.features.add(new Feature(3, 20));
        this.features.add(new Feature(8, 1));
        this.features.add(new Feature(9, 1));
        this.features.add(new Feature(10, 1));
        this.features.add(new Feature(11, 1));
        this.features.add(new Feature(12, 10));
        this.features.add(new Feature(13, 1));
        this.features.add(new Feature(14, 1));
        this.features.add(new Feature(17, 1));
        this.features.add(new Feature(18, 1));
        this.features.add(new Feature(19, 8));
        this.features.add(new Feature(20, 30));
        this.features.add(new Feature(21, 0));
        this.features.add(new Feature(22, 155));
        this.features.add(new Feature(23, 200));
        this.features.add(new Feature(26, 0));
        this.features.add(new Feature(27, 0));
        this.features.add(new Feature(28, 5));
        this.features.add(new Feature(29, 1));
        this.features.add(new Feature(252, 24));
        this.features.add(new Feature(254, 1));
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.setupFeedbackPorts();
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        if (this.boosterDiagWorker != null) {
            LOGGER.info("Stop the booster diag worker.");
            this.boosterDiagWorker.shutdownNow();
        }
        super.stop();
    }

    private void setupFeedbackPorts() {
        for (int id = 0; id < 48; ++id) {
            FeedbackPort port = new FeedbackPort();
            port.setId(id);
            port.setStatus(FeedbackPortStatus.FREE);
            this.feedbackPorts.put(id, port);
        }
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 32: {
                response = this.processBmGetRangeRequest(bidibMessage);
                break;
            }
            case 33: {
                this.processBmMirrorMultipleRequest(bidibMessage);
                break;
            }
            case 34: {
                this.processBmMirrorOccupiedRequest(bidibMessage);
                break;
            }
            case 35: {
                this.processBmMirrorFreeRequest(bidibMessage);
                break;
            }
            case 36: {
                this.processBmAddrGetRangeRequest(bidibMessage);
                break;
            }
            case 37: {
                response = this.processBmGetConfidenceRequest(bidibMessage);
                break;
            }
            case 50: {
                response = this.processBoostQueryRequest(bidibMessage);
                break;
            }
            case 49: {
                response = this.processBoostOnRequest(bidibMessage);
                break;
            }
            case 48: {
                response = this.processBoostOffRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processBmGetRangeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackGetRangeMessage: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            FeedbackGetRangeMessage feedbackGetRangeMessage = (FeedbackGetRangeMessage)bidibMessage;
            int baseAddress = feedbackGetRangeMessage.getBeginRange();
            int end = feedbackGetRangeMessage.getEndRange();
            int feedbackSize = feedbackGetRangeMessage.getEndRange() - feedbackGetRangeMessage.getBeginRange();
            int value = 0;
            int index = 0;
            int feedbackByteSize = feedbackSize / 8 + (feedbackSize % 8 > 0 ? 1 : 0);
            byte[] feedbackMultiple = new byte[feedbackByteSize];
            int position = feedbackMultiple.length;
            for (int portNum = end; portNum > baseAddress; --portNum) {
                value = (byte)((value & 0xFF) << 1);
                FeedbackPort fbp = this.feedbackPorts.get(portNum - 1);
                int status = 0;
                if (fbp != null) {
                    status = ByteUtils.getLowByte((int)((FeedbackPortStatus)fbp.getStatus()).getType().getType(), (int)1);
                }
                feedbackMultiple[position - 1] = value = (int)((byte)(value | status));
                if (++index <= 7) continue;
                value = 0;
                index = 0;
                --position;
            }
            LOGGER.info("Prepared feedback multiple: {}", (Object)ByteUtils.bytesToHex((byte[])feedbackMultiple));
            FeedbackMultipleResponse feedbackMultipleResponse = new FeedbackMultipleResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)baseAddress), ByteUtils.getLowByte((int)feedbackSize), feedbackMultiple);
            response = feedbackMultipleResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackMultiple response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processBmMirrorMultipleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackMirrorMultipleMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorOccupiedRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorOccupiedRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorFreeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorFreeRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmAddrGetRangeRequest(BidibMessageInterface bidibMessage) {
        try {
            for (FeedbackPort port : this.feedbackPorts.values()) {
                int detectorNumber = port.getId();
                ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
                List addresses = port.getAddresses();
                if (CollectionUtils.isNotEmpty((Collection)addresses)) {
                    for (FeedbackAddressData addressData : addresses) {
                        EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                        AddressTypeEnum addressType = null;
                        switch (enrailmentDirection) {
                            case LOCOMOTIVE_LEFT: 
                            case LOCOMOTIVE_RIGHT: {
                                addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                                break;
                            }
                            case BASIC_ACCESSORY: {
                                addressType = AddressTypeEnum.ACCESSORY;
                                break;
                            }
                            case EXTENDED_ACCESSORY: {
                                addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                                break;
                            }
                        }
                        AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                        bidibAddresses.add(bidibAddress);
                    }
                }
                FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorNumber, bidibAddresses);
                byte[] response = feedbackAddressResponse.getContent();
                LOGGER.info("Prepare feedbackAddressResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackAddress response failed.", (Throwable)ex);
        }
    }

    protected byte[] processBmGetConfidenceRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            byte valid = (byte)(this.statusVoid.get() ? 1 : 0);
            byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
            byte signal = (byte)(this.statusNoSignal.get() ? 1 : 0);
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(bidibMessage.getAddr(), this.getNextSendNum(), valid, freeze, signal);
            response = feedbackConfidenceResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackConfidence response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processBoostQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the BoostQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            BoostStatResponse boostStatResponse = new BoostStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.boosterState);
            response = boostStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create BoostStatResponse response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processBoostOnRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the BoostOn request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            BoostOnMessage boostOnMessage = (BoostOnMessage)bidibMessage;
            byte broadcast = boostOnMessage.getBroadcast();
            LOGGER.info("BoostOn with broadcast: {}", (Object)broadcast);
            if (broadcast == 0) {
                // empty if block
            }
            this.boosterState = BoosterState.ON;
            this.statusNoSignal.set(false);
            BoostStatResponse boostStatResponse = new BoostStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.boosterState);
            response = boostStatResponse.getContent();
            this.triggerConfidenceResponse();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create BoostStatResponse response failed.", (Throwable)ex);
        }
        if (this.futureTriggerBoostDiagnostic == null) {
            Feature curMeasInterval = this.features.stream().filter(f -> f.getFeatureEnum().equals((Object)FeatureEnum.FEATURE_BST_CURMEAS_INTERVAL)).findFirst().orElse(null);
            LOGGER.info("Schedule the boost diagnostic trigger, curMeasInterval: {}", (Object)curMeasInterval);
            int interval = (curMeasInterval != null ? curMeasInterval.getValue() : 200) * 10;
            this.futureTriggerBoostDiagnostic = this.boosterDiagWorker.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Trigger boost diag");
                    try {
                        GBMboostNodeSimulator.this.triggerBoostDiagnosticResponse();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Trigger the boost diagnostic failed.", (Throwable)ex);
                    }
                    LOGGER.info("Trigger boost has finished.");
                }
            }, 500L, interval, TimeUnit.MILLISECONDS);
        }
        if (this.isFeedbackChangesEnabled() && this.futureTriggerFeedbackMessage == null) {
            LOGGER.info("Schedule the feedback message trigger");
            int interval = 5;
            this.futureTriggerFeedbackMessage = this.boosterDiagWorker.scheduleAtFixedRate(() -> {
                LOGGER.info("Trigger feedback response");
                try {
                    this.triggerFeedbackResponse();
                }
                catch (Exception ex) {
                    LOGGER.warn("Trigger the feedback response failed.", (Throwable)ex);
                }
                LOGGER.info("Trigger feedback response has finished.");
            }, 5L, interval, TimeUnit.SECONDS);
        }
        return response;
    }

    protected byte[] processBoostOffRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the BoostOff request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            BoostOffMessage boostOffMessage = (BoostOffMessage)bidibMessage;
            byte broadcast = boostOffMessage.getBroadcast();
            LOGGER.info("BoostOn with broadcast: {}", (Object)broadcast);
            if (broadcast == 0) {
                // empty if block
            }
            this.boosterState = BoosterState.OFF;
            this.statusNoSignal.set(true);
            BoostStatResponse boostStatResponse = new BoostStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.boosterState);
            response = boostStatResponse.getContent();
            this.triggerConfidenceResponse();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create BoostStatResponse response failed.", (Throwable)ex);
        }
        if (this.futureTriggerBoostDiagnostic != null) {
            LOGGER.info("Stop the boost diagnostic trigger.");
            boolean success = this.futureTriggerBoostDiagnostic.cancel(false);
            LOGGER.info("Stopped the boost diagnostic trigger, success: {}", (Object)success);
            this.futureTriggerBoostDiagnostic = null;
        }
        if (this.futureTriggerFeedbackMessage != null) {
            LOGGER.info("Stop the feedback message trigger.");
            boolean success = this.futureTriggerFeedbackMessage.cancel(false);
            LOGGER.info("Stopped the feedback message trigger, success: {}", (Object)success);
            this.futureTriggerFeedbackMessage = null;
        }
        return response;
    }

    protected void triggerBoostDiagnosticResponse() {
        byte[] response = null;
        int currentValue = ThreadLocalRandom.current().nextInt(10, 181);
        int tempValue = ThreadLocalRandom.current().nextInt(25, 70);
        LOGGER.info("Trigger the boostDiagnostic repsonse, currentValue: {}, tempValue: {}", (Object)currentValue, (Object)tempValue);
        try {
            BoostDiagnosticResponse boostDiagnosticResponse = new BoostDiagnosticResponse(this.nodeAddress, this.getNextSendNum(), currentValue, 169, tempValue);
            response = boostDiagnosticResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create boostDiagnostic response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }

    protected void triggerConfidenceResponse() {
        LOGGER.info("Trigger the confidence repsonse");
        byte valid = (byte)(this.statusVoid.get() ? 1 : 0);
        byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
        byte signal = (byte)(this.statusNoSignal.get() ? 1 : 0);
        try {
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(this.nodeAddress, this.getNextSendNum(), valid, freeze, signal);
            LOGGER.info("Prepared feedbackConfidenceResponse: {}", (Object)feedbackConfidenceResponse);
            this.sendSpontanousResponse(feedbackConfidenceResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send feedbackConfidenceResponse failed.", (Throwable)ex);
        }
    }

    protected void triggerFeedbackResponse() {
        int maxPortId = Feature.getIntFeatureValue((Collection)this.features, (int)0);
        Random generator = new Random();
        int portNum = generator.nextInt(maxPortId);
        try {
            this.changeFeedbackPortStatus(portNum);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Publish feedback status failed for portNum: {}", (Object)portNum, (Object)ex);
        }
    }

    private void publishFeedbackPortChange(Port<?> port) {
        FeedbackPort feedbackPort = (FeedbackPort)port;
        FeedbackPortStatus status = (FeedbackPortStatus)feedbackPort.getStatus();
        LOGGER.info("The feedbackport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getId(), status));
    }

    public void queryStatus(Class<?> portClass) {
        if (FeedbackPort.class.equals(portClass)) {
            for (FeedbackPort feedbackPort : this.feedbackPorts.values()) {
                this.publishFeedbackPortChange((Port<?>)feedbackPort);
            }
            this.publishFeedbackConfidenceStatusEvent(this.statusVoid.get(), this.statusFreeze.get(), this.statusNoSignal.get());
        }
    }

    @EventSubscriber(eventClass=FeedbackConfidenceSetEvent.class)
    public void feedbackConfidenceSetEvent(FeedbackConfidenceSetEvent feedbackConfidenceEvent) {
        String nodeAddress = feedbackConfidenceEvent.getNodeAddr();
        LOGGER.info("The change of the feedback confidence was requested, nodeAddress: {}", (Object)nodeAddress);
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        this.statusVoid.set(feedbackConfidenceEvent.getValid());
        this.statusFreeze.set(feedbackConfidenceEvent.getFreeze());
        this.statusNoSignal.set(feedbackConfidenceEvent.getSignal());
        this.triggerConfidenceResponse();
        this.publishFeedbackConfidenceStatusEvent(this.statusVoid.get(), this.statusFreeze.get(), this.statusNoSignal.get());
    }

    private void publishFeedbackConfidenceStatusEvent(boolean statusVoid, boolean freeze, boolean noSignal) {
        LOGGER.info("The feedbackport confidence status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackConfidenceStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), statusVoid, freeze, noSignal));
    }

    @EventSubscriber(eventClass=FeedbackPortSetStatusEvent.class)
    public void feedbackPortSetStatus(FeedbackPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the feedback port was requested.");
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        try {
            this.changeFeedbackPortStatus(portNum);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Publish feedback status failed.", (Throwable)ex);
        }
    }

    private int getTimestamp() {
        this.timestamp += 10;
        if (this.timestamp > 65000) {
            this.timestamp = 0;
        }
        return this.timestamp;
    }

    private boolean hasTimestampFeature() {
        Feature feature = Feature.findFeature((Collection)this.features, (int)30);
        return feature != null && feature.getValue() > 0;
    }

    private int getDecoderAddress() {
        ++this.decoderAddress;
        if (this.decoderAddress > 15) {
            this.decoderAddress = 10;
        }
        return this.decoderAddress;
    }

    private int getLocationAddress() {
        ++this.locationAddress;
        if (this.locationAddress > 150) {
            this.locationAddress = 120;
        }
        return this.locationAddress;
    }

    protected void changeFeedbackPortStatus(int portNum) throws ProtocolException {
        FeedbackPort port = this.feedbackPorts.get(portNum);
        if (port != null) {
            FeedbackFreeResponse response = null;
            FeedbackPositionResponse responsePosition = null;
            switch ((FeedbackPortStatus)port.getStatus()) {
                case FREE: {
                    port.setStatus(FeedbackPortStatus.OCCUPIED);
                    response = this.hasTimestampFeature() ? new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum, this.getTimestamp()) : new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                    int locationType = ByteUtils.getInt((byte)PositionLocationEnum.LOCATOR_BADGE.getType());
                    responsePosition = new FeedbackPositionResponse(this.getNodeAddress(), this.getNextSendNum(), this.getDecoderAddress(), locationType, this.getLocationAddress());
                    break;
                }
                default: {
                    port.setStatus(FeedbackPortStatus.FREE);
                    response = new FeedbackFreeResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                }
            }
            this.sendSpontanousResponse(response.getContent());
            if (responsePosition != null) {
                this.sendSpontanousResponse(responsePosition.getContent());
            }
            this.publishFeedbackPortChange((Port<?>)port);
        } else {
            LOGGER.warn("The requested feedback port is not available: {}", (Object)portNum);
        }
    }
}

