/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DccATidData;
import org.bidib.jbidibc.messages.DecoderIdAddressData;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.TidData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.enums.DccAOpCodeBm;
import org.bidib.jbidibc.messages.enums.DccAdvSelectInfoOpCode;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.enums.RcPlusPhase;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryMessage;
import org.bidib.jbidibc.messages.message.CommandStationBinaryStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationDccAdvAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDccAdvMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationQueryMessage;
import org.bidib.jbidibc.messages.message.CommandStationRcPlusAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationRcPlusMessage;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationStateResponse;
import org.bidib.jbidibc.messages.message.FeedbackCvResponse;
import org.bidib.jbidibc.messages.message.FeedbackDccAResponse;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.InterfaceNode;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulator(vid="13", pid="132")
public class IF2Simulator
extends DefaultNodeSimulator
implements InterfaceNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(IF2Simulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.GBMboostMasterPanel";
    private CommandStationState commandStationState = CommandStationState.OFF;
    private Map<Integer, Integer> mapLocoCV = new LinkedHashMap<Integer, Integer>();
    private TidData tid = new TidData(new DecoderUniqueIdData(218893066L, 13), 1);
    private DccATidData dccAdvTid = new DccATidData(2826, 1);
    private List<DccAdvDecoderInfo> dccAdvDecoders = new LinkedList<DccAdvDecoderInfo>();
    private DccAdvDecoderInfo activeDccAdvDecoder;

    public IF2Simulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
        this.uniqueId = uniqueId & 0xFFFFFFFFFFFFL | 0x90000000000000L;
    }

    protected void prepareFeatures() {
        super.prepareFeatures();
        this.features.add(new Feature(100, 1));
        this.features.add(new Feature(101, 20));
        this.features.add(new Feature(102, 1));
        this.features.add(new Feature(103, 1));
        this.features.add(new Feature(106, 3));
        this.features.add(new Feature(107, 0));
        this.features.add(new Feature(108, 1));
        this.features.add(new Feature(109, 1));
        this.features.add(new Feature(111, 13));
    }

    protected void prepareCVs() {
        super.prepareCVs();
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.mapLocoCV.put(1, 3);
        this.mapLocoCV.put(29, 0);
        this.mapLocoCV.put(28, 3);
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 98: {
                response = this.processCsSetStateRequest(bidibMessage);
                break;
            }
            case 103: {
                response = this.processCsPomRequest(bidibMessage);
                break;
            }
            case 111: {
                response = this.processCsProgRequest(bidibMessage);
                break;
            }
            case 100: {
                response = this.processCsDriveRequest(bidibMessage);
                break;
            }
            case 101: {
                response = this.processCsAccessoryRequest(bidibMessage);
                break;
            }
            case 104: {
                response = this.processCsRcPlusRequest(bidibMessage);
                break;
            }
            case 106: {
                response = this.processCsQueryRequest(bidibMessage);
                break;
            }
            case 102: {
                response = this.processCsBinStateRequest(bidibMessage);
                break;
            }
            case 107: {
                response = this.processCsDccAdvRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processCsSetStateRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsSetState request: {}", (Object)bidibMessage);
        if (Feature.getIntFeatureValue((Collection)this.features, (int)FeatureEnum.FEATURE_STRING_DEBUG.getNumber()) > 0) {
            try {
                StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), 1, 3, new byte[]{16, 66, 105, 68, 105, 66, 32, 68, 101, 99, 111, 100, 101, 114, 32, 45, 32});
                this.sendSpontanousResponse(stringResponse.getContent());
                StringResponse stringResponse2 = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), 1, 3, new byte[]{6, 48, 46, 50, 46, 48, 10});
                this.sendSpontanousResponse(stringResponse2.getContent());
                StringResponse stringResponse3 = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), 1, 4, new byte[]{17, 83, 48, 54, 48, 55, 48, 48, 51, 70, 52, 67, 49, 50, 48, 51, 10, 13});
                this.sendSpontanousResponse(stringResponse3.getContent());
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create CommandStationState response failed.", (Throwable)ex);
            }
        }
        byte[] response = null;
        try {
            CommandStationSetStateMessage commandStationSetStateMessage = (CommandStationSetStateMessage)bidibMessage;
            CommandStationState state = commandStationSetStateMessage.getState();
            LOGGER.info("The requested command station state is: {}", (Object)state);
            switch (state) {
                case OFF: {
                    this.commandStationState = CommandStationState.OFF;
                    break;
                }
                case STOP: 
                case SOFTSTOP: {
                    this.commandStationState = CommandStationState.STOP;
                    break;
                }
                case GO: 
                case GO_IGN_WD: {
                    this.commandStationState = CommandStationState.GO;
                    break;
                }
                case PROG: {
                    this.commandStationState = CommandStationState.PROG;
                    break;
                }
                case QUERY: {
                    LOGGER.info("Query command station state requested, return the current command station state!");
                    break;
                }
                default: {
                    LOGGER.warn("Unprocessed command station state: {}", (Object)state);
                }
            }
            LOGGER.info("Return current command station state: {}", (Object)this.commandStationState);
            CommandStationStateResponse commandStationStateResponse = new CommandStationStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.commandStationState.getType());
            response = commandStationStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsPomRequest(BidibMessageInterface bidibMessage) {
        PomAddressData addressData;
        CommandStationPomMessage commandStationPomMessage;
        LOGGER.info("Process the CsPom request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            commandStationPomMessage = (CommandStationPomMessage)bidibMessage;
            addressData = commandStationPomMessage.getDecoderAddress();
            LOGGER.info("Received addressData: {}", (Object)addressData);
            CommandStationPomAcknowledgeResponse commandStationPomAckResponse = new CommandStationPomAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData, 1);
            response = commandStationPomAckResponse.getContent();
            LOGGER.info("Publish the running response: {}", (Object)commandStationPomAckResponse);
            this.publishResponse(response);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationPomAck response failed.", (Throwable)ex);
        }
        try {
            LOGGER.info("prepare the MSG_BM_CV that contains the real data.");
            commandStationPomMessage = (CommandStationPomMessage)bidibMessage;
            addressData = commandStationPomMessage.getDecoderAddress();
            int cvNumber = commandStationPomMessage.getCvNumber();
            LOGGER.info("Current CV number: {}", (Object)cvNumber);
            byte cvValue = 12;
            if (cvNumber == 29) {
                cvValue = 0;
            }
            CommandStationPom opCode = CommandStationPom.valueOf((byte)ByteUtils.getLowByte((int)commandStationPomMessage.getOpCode()));
            switch (opCode) {
                case WR_BYTE: {
                    cvValue = ByteUtils.getLowByte((int)commandStationPomMessage.getCvValue());
                    break;
                }
            }
            FeedbackCvResponse feedbackCvResponse = new FeedbackCvResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData.getAddress(), cvNumber - 1, cvValue);
            response = feedbackCvResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationPomAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsProgRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsProg request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationProgMessage commandStationProgMessage = (CommandStationProgMessage)bidibMessage;
            CommandStationPt opCode = commandStationProgMessage.getOpCode();
            int cvNumber = commandStationProgMessage.getCvNumber();
            int cvData = commandStationProgMessage.getCvData();
            LOGGER.info("Received opCode: {}, cvNumber: {}, cvData: {}", new Object[]{opCode, cvNumber, cvData});
            boolean sendTimeoutResponse = false;
            switch (opCode) {
                case BIDIB_CS_PROG_BREAK: {
                    break;
                }
                case BIDIB_CS_PROG_QUERY: {
                    break;
                }
                case BIDIB_CS_PROG_RDWR_BIT: {
                    byte byteValue;
                    Integer storedValue;
                    if ((cvData & 0x10) == 16) {
                        storedValue = this.mapLocoCV.get(cvNumber);
                        if (storedValue != null) {
                            byteValue = ByteUtils.getLowByte((int)storedValue);
                            byteValue = ByteUtils.setBit((byte)byteValue, ((cvData & 8) == 8 ? 1 : 0) != 0, (int)(cvData & 7));
                            LOGGER.info("Changed CV value: {}", (Object)ByteUtils.byteToHex((byte)byteValue));
                            this.mapLocoCV.put(cvNumber, Integer.valueOf(byteValue));
                            break;
                        }
                        byteValue = 0;
                        byteValue = ByteUtils.setBit((byte)byteValue, ((cvData & 8) == 8 ? 1 : 0) != 0, (int)(cvData & 7));
                        LOGGER.info("Changed CV value: {}", (Object)ByteUtils.byteToHex((byte)byteValue));
                        this.mapLocoCV.put(cvNumber, Integer.valueOf(byteValue));
                        break;
                    }
                    storedValue = this.mapLocoCV.get(cvNumber);
                    if (storedValue != null) {
                        byteValue = ByteUtils.getLowByte((int)storedValue);
                        boolean bitIsSetEqual = ByteUtils.isBitSetEqual((byte)byteValue, (int)ByteUtils.getBit((int)cvData, (int)3), (int)(cvData & 7));
                        LOGGER.info("Verify bitIsSetEqual: {}, byteValue: {}", (Object)bitIsSetEqual, (Object)byteValue);
                        if (bitIsSetEqual) break;
                        LOGGER.warn("Send timeout response!");
                        sendTimeoutResponse = true;
                        break;
                    }
                    LOGGER.warn("The requested CV value is not stored, cvNumber: {}", (Object)cvNumber);
                    sendTimeoutResponse = true;
                    break;
                }
                case BIDIB_CS_PROG_WR_BYTE: {
                    this.mapLocoCV.put(cvNumber, cvData);
                    break;
                }
                default: {
                    Integer storedValue = this.mapLocoCV.get(cvNumber);
                    if (storedValue != null) {
                        cvData = ByteUtils.getLowByte((int)storedValue);
                        break;
                    }
                    LOGGER.warn("The requested CV value is not stored, cvNumber: {}", (Object)cvNumber);
                    sendTimeoutResponse = true;
                }
            }
            CommandStationProgStateResponse commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_RUNNING, 1, cvNumber, cvData);
            response = commandStationProgStateResponse.getContent();
            LOGGER.info("Publish the running response: {}", (Object)commandStationProgStateResponse);
            this.publishResponse(response);
            LOGGER.info("Sleep a second.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Sleep thread was interrupted.", (Throwable)e);
            }
            if (!sendTimeoutResponse) {
                LOGGER.info("Prepare the OKAY state response.");
                commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_OKAY, 1, cvNumber, cvData);
            } else {
                LOGGER.info("Prepare the NO_ANSWER state response.");
                commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_NO_ANSWER, 1, cvNumber, 255);
            }
            response = commandStationProgStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationProgState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsDriveRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsDrive request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationDriveMessage commandStationDriveMessage = (CommandStationDriveMessage)bidibMessage;
            AddressData addressData = commandStationDriveMessage.getDecoderAddress();
            int messageNumber = commandStationDriveMessage.getNum();
            LOGGER.info("Received addressData: {}", (Object)addressData);
            CommandStationDriveAcknowledgeResponse commandStationDriveAckResponse = new CommandStationDriveAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData, 1, Integer.valueOf(messageNumber));
            response = commandStationDriveAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationDriveAck response failed.", (Throwable)ex);
        }
        return response;
    }

    private byte[] processCsBinStateRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsBinState request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationBinaryStateMessage commandStationBinStateMessage = (CommandStationBinaryStateMessage)bidibMessage;
            AddressData addressData = commandStationBinStateMessage.getDecoderAddress();
            int binStateNumber = commandStationBinStateMessage.getBinaryStateNumber();
            int binStateValue = commandStationBinStateMessage.getBinaryStateValue();
            int messageNumber = commandStationBinStateMessage.getNum();
            LOGGER.info("Received addressData: {}, binStateNumber: {}, binStateValue: {}", new Object[]{addressData, binStateNumber, binStateValue});
            CommandStationDriveAcknowledgeResponse commandStationDriveAckResponse = new CommandStationDriveAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData, 1, Integer.valueOf(messageNumber));
            response = commandStationDriveAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationDriveAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationQueryMessage commandStationQueryMessage = (CommandStationQueryMessage)bidibMessage;
            CsQueryTypeEnum csQueryType = commandStationQueryMessage.getCsQueryType();
            switch (csQueryType) {
                case LOCO_LIST: {
                    AddressData addressData = new AddressData(13, AddressTypeEnum.LOCOMOTIVE_FORWARD);
                    byte[] functions = new byte[]{-128, 0, 114, -123};
                    CommandStationDriveStateResponse driveStateResponse = new CommandStationDriveStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), 65, addressData, SpeedStepsEnum.DCC128, 39, functions);
                    response = driveStateResponse.getContent();
                    break;
                }
                default: {
                    LOGGER.warn("The CsQueryRequest is not implemented for type: {}", (Object)csQueryType);
                    break;
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationDriveAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsAccessoryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsAccessory request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationAccessoryMessage commandStationAccessoryMessage = (CommandStationAccessoryMessage)bidibMessage;
            AddressData addressData = commandStationAccessoryMessage.getDecoderAddress();
            LOGGER.info("Received addressData: {}", (Object)addressData);
            CommandStationAccessoryAcknowledgeResponse commandStationAccessoryAckResponse = new CommandStationAccessoryAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData, 1);
            response = commandStationAccessoryAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationAccessoryAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsDccAdvRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the DccAdv request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationDccAdvMessage commandStationDccAdvMessage = (CommandStationDccAdvMessage)bidibMessage;
            CommandStationDccAdvAcknowledgeResponse acknowledgeResponse = null;
            block1 : switch (commandStationDccAdvMessage.getOpCode()) {
                case BIDIB_DCCA_GET_TID: {
                    acknowledgeResponse = new CommandStationDccAdvAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.dccAdvTid);
                    break;
                }
                case BIDIB_DCCA_LOGON_ENABLE_ALL: {
                    LOGGER.info("Enable all was received.");
                    if (CollectionUtils.isEmpty(this.dccAdvDecoders)) {
                        LOGGER.info("Prepare the dccAdvDecoders.");
                        int mid = 13;
                        for (long index = 1L; index < 5L; ++index) {
                            long mun = 67305984L + index;
                            DccAdvDecoderInfo decoder = new DccAdvDecoderInfo(mun, mid, "BiDiB Loco Decoder ..: " + index, "Shrtna_" + index, new byte[]{0, 0, -5, 2, 0, 2, 0, 1}, "TamsFDR");
                            this.dccAdvDecoders.add(decoder);
                        }
                    }
                    for (DccAdvDecoderInfo decoder : this.dccAdvDecoders) {
                        DecoderIdAddressData addressData = new DecoderIdAddressData(Long.valueOf(decoder.did.getMun()), Integer.valueOf(decoder.did.getMid()));
                        LOGGER.info("Return demo decoder with addressData: {}", (Object)addressData);
                        int detectorAddress = 0;
                        FeedbackDccAResponse feedbackResponse = new FeedbackDccAResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorAddress, DccAOpCodeBm.BIDIB_DCCA_LOGON_NEW_DID, addressData);
                        this.publishResponse(feedbackResponse.getContent());
                    }
                    break;
                }
                case BIDIB_DCCA_LOGON_ASSIGN: {
                    LOGGER.info("Address is assigned: {}", (Object)commandStationDccAdvMessage.getAssignedAddress());
                    int detectorAddress = 0;
                    int hashValue = commandStationDccAdvMessage.getAssignedAddress();
                    DecoderUniqueIdData did = commandStationDccAdvMessage.getDid();
                    DccAdvDecoderInfo decoder = this.findDecoder(did);
                    ++decoder.logonAssignCounter;
                    if (decoder != null && decoder.logonAssignCounter < 3 && decoder.did.getMun() % 2L == 0L) {
                        LOGGER.warn("Ignore LogonAssign request, decoder: {}", (Object)decoder);
                        break;
                    }
                    LOGGER.info("Provide the hashValue: {}, did: {}", (Object)hashValue, (Object)did);
                    FeedbackDccAResponse feedbackResponse = new FeedbackDccAResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorAddress, DccAOpCodeBm.BIDIB_DCCA_LOGON_ASSIGN_ACK, did, hashValue);
                    this.publishResponse(feedbackResponse.getContent());
                    break;
                }
                case BIDIB_DCCA_SELECT_INFO: {
                    LOGGER.info("GetInfo is requested.");
                    DecoderUniqueIdData didGetInfo = commandStationDccAdvMessage.getDid();
                    DccAdvSelectInfoOpCode getInfoOpCode = commandStationDccAdvMessage.getInfoOpCode();
                    LOGGER.info("Provided did: {}, getInfoOpCode: {}", (Object)didGetInfo, (Object)getInfoOpCode);
                    DccAdvDecoderInfo decoder = this.findDecoder(didGetInfo);
                    LOGGER.info("Found registered decoder: {}", (Object)decoder);
                    boolean detectorAddress = false;
                    this.activeDccAdvDecoder = decoder;
                    this.activeDccAdvDecoder.setSelectedNamespace(ByteUtils.getInt((byte)getInfoOpCode.getType()));
                    switch (getInfoOpCode) {
                        case BIDIB_DCCA_SPACE_SHORTINFO: {
                            break block1;
                        }
                        case BIDIB_DCCA_SPACE_SHORTGUI: {
                            break block1;
                        }
                        case BIDIB_DCCA_SPACE_FIRMWARE_ID: {
                            this.activeDccAdvDecoder.setLastFullNameIndex(0);
                            break block1;
                        }
                        case BIDIB_DCCA_SPACE_PRODUCTNAME: {
                            this.activeDccAdvDecoder.setLastFullNameIndex(0);
                            break block1;
                        }
                        case BIDIB_DCCA_SPACE_SHORTNAME: {
                            this.activeDccAdvDecoder.setLastFullNameIndex(0);
                            break block1;
                        }
                        case BIDIB_DCCA_SPACE_FULLNAME: {
                            this.activeDccAdvDecoder.setLastFullNameIndex(0);
                            break block1;
                        }
                    }
                    LOGGER.warn("Unknown getInfoOpCode: {}", (Object)getInfoOpCode);
                    break;
                }
                case BIDIB_DCCA_GET_DATA: {
                    LOGGER.info("GetInfo_Cont is requested.");
                    int repetitions = commandStationDccAdvMessage.getRepetitions();
                    int detectorAddress = 0;
                    if (this.activeDccAdvDecoder == null) break;
                    FeedbackDccAResponse feedbackResponseInfo = null;
                    LOGGER.info("Get the data from the selected namespace: {}, repetitions: {}", (Object)this.activeDccAdvDecoder.getSelectedNamespace(), (Object)repetitions);
                    switch (this.activeDccAdvDecoder.getSelectedNamespace()) {
                        case 16: {
                            feedbackResponseInfo = new FeedbackDccAResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorAddress, DccAOpCodeBm.BIDIB_DCCA_INFO_SHORTINFO, this.activeDccAdvDecoder.did, 0, new byte[]{70, -91, 24, 0, 0});
                            this.publishResponse(feedbackResponseInfo.getContent());
                            break;
                        }
                        case 17: {
                            feedbackResponseInfo = new FeedbackDccAResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorAddress, DccAOpCodeBm.BIDIB_DCCA_INFO_SHORTGUI, this.activeDccAdvDecoder.did, 0, new byte[]{1, 0, 0, 0, 0});
                            this.publishResponse(feedbackResponseInfo.getContent());
                            break;
                        }
                        case 18: {
                            int lastFirmwareIdIndex = this.activeDccAdvDecoder.getLastFullNameIndex();
                            for (int idx = 0; idx < repetitions; ++idx) {
                                this.activeDccAdvDecoder.setLastFullNameIndex(lastFirmwareIdIndex);
                                int startIndex = lastFirmwareIdIndex * 4;
                                LOGGER.info("startIndex: {}", (Object)startIndex, (Object)ByteUtils.bytesToHex((byte[])this.activeDccAdvDecoder.firmwareId));
                                byte[] firmwareIdPart = ByteUtils.subArray((byte[])this.activeDccAdvDecoder.firmwareId, (int)startIndex, (int)4);
                                LOGGER.info("Provide the firmwareIdPart: {}, lastFullNameIndex: {}, startIndex: {}", new Object[]{ByteUtils.bytesToHex((byte[])firmwareIdPart), lastFirmwareIdIndex, startIndex});
                                if (idx == 0 && this.activeDccAdvDecoder.getRetryCounter() == 0) {
                                    LOGGER.warn("Skip send the part of the firmware id: {}", (Object)firmwareIdPart);
                                } else {
                                    feedbackResponseInfo = new FeedbackDccAResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorAddress, DccAOpCodeBm.BIDIB_DCCA_INFO_FIRMWAREID, this.activeDccAdvDecoder.did, lastFirmwareIdIndex, firmwareIdPart);
                                }
                                if (feedbackResponseInfo != null) {
                                    this.publishResponse(feedbackResponseInfo.getContent());
                                }
                                ++lastFirmwareIdIndex;
                                feedbackResponseInfo = null;
                            }
                            this.activeDccAdvDecoder.incRetryCounter();
                            break;
                        }
                        case 19: {
                            int lastProductNameIndex = this.activeDccAdvDecoder.getLastFullNameIndex();
                            for (int idx = 0; idx < repetitions; ++idx) {
                                this.activeDccAdvDecoder.setLastFullNameIndex(lastProductNameIndex);
                                int startIndex = lastProductNameIndex * 4;
                                String productNamePart = StringUtils.substring((String)this.activeDccAdvDecoder.productName, (int)startIndex, (int)(startIndex + 4));
                                LOGGER.info("Provide the productNamePart: {}, lastFullNameIndex: {}, startIndex: {}", new Object[]{productNamePart, lastProductNameIndex, startIndex});
                                if (idx == 0 && this.activeDccAdvDecoder.getRetryCounter() == 1) {
                                    LOGGER.warn("Skip send the part of the productName: {}", (Object)productNamePart);
                                } else {
                                    feedbackResponseInfo = new FeedbackDccAResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorAddress, DccAOpCodeBm.BIDIB_DCCA_INFO_PRODUCTNAME, this.activeDccAdvDecoder.did, lastProductNameIndex, productNamePart.getBytes(StandardCharsets.ISO_8859_1));
                                }
                                if (feedbackResponseInfo != null) {
                                    this.publishResponse(feedbackResponseInfo.getContent());
                                }
                                ++lastProductNameIndex;
                                feedbackResponseInfo = null;
                                this.activeDccAdvDecoder.incRetryCounter();
                            }
                            break;
                        }
                        case 20: {
                            int lastShortNameIndex = this.activeDccAdvDecoder.getLastFullNameIndex();
                            for (int idx = 0; idx < repetitions; ++idx) {
                                this.activeDccAdvDecoder.setLastFullNameIndex(lastShortNameIndex);
                                int startIndex = lastShortNameIndex * 4;
                                String shortNamePart = StringUtils.substring((String)this.activeDccAdvDecoder.shortName, (int)startIndex, (int)(startIndex + 4));
                                LOGGER.info("Provide the shortNamePart: {}, lastFullNameIndex: {}, startIndex: {}", new Object[]{shortNamePart, lastShortNameIndex, startIndex});
                                feedbackResponseInfo = new FeedbackDccAResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorAddress, DccAOpCodeBm.BIDIB_DCCA_INFO_SHORTNAME, this.activeDccAdvDecoder.did, lastShortNameIndex, shortNamePart.getBytes(StandardCharsets.ISO_8859_1));
                                if (feedbackResponseInfo != null) {
                                    this.publishResponse(feedbackResponseInfo.getContent());
                                }
                                ++lastShortNameIndex;
                            }
                            break;
                        }
                        case 21: {
                            int lastFullNameIndex = this.activeDccAdvDecoder.getLastFullNameIndex();
                            for (int idx = 0; idx < repetitions; ++idx) {
                                this.activeDccAdvDecoder.setLastFullNameIndex(lastFullNameIndex);
                                int startIndex = lastFullNameIndex * 4;
                                String fullNamePart = StringUtils.substring((String)this.activeDccAdvDecoder.fullName, (int)startIndex, (int)(startIndex + 4));
                                LOGGER.info("Provide the fullNamePart: {}, lastFullNameIndex: {}, startIndex: {}", new Object[]{fullNamePart, lastFullNameIndex, startIndex});
                                feedbackResponseInfo = new FeedbackDccAResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorAddress, DccAOpCodeBm.BIDIB_DCCA_INFO_FULLNAME, this.activeDccAdvDecoder.did, lastFullNameIndex, fullNamePart.getBytes(StandardCharsets.ISO_8859_1));
                                if (feedbackResponseInfo != null) {
                                    this.publishResponse(feedbackResponseInfo.getContent());
                                }
                                ++lastFullNameIndex;
                            }
                            break;
                        }
                    }
                    this.activeDccAdvDecoder = null;
                    break;
                }
                default: {
                    LOGGER.error("The DccAdv acknowledge is not yet implemented for OpCode: {}", (Object)commandStationDccAdvMessage.getOpCode());
                }
            }
            if (acknowledgeResponse != null) {
                response = acknowledgeResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationDccAdvAck response failed.", (Throwable)ex);
        }
        return response;
    }

    private DccAdvDecoderInfo findDecoder(final DecoderUniqueIdData did) {
        DccAdvDecoderInfo decoder = (DccAdvDecoderInfo)IterableUtils.find(this.dccAdvDecoders, (Predicate)new Predicate<DccAdvDecoderInfo>(){

            public boolean evaluate(DccAdvDecoderInfo decoder) {
                return Objects.equals(decoder.did, did);
            }
        });
        return decoder;
    }

    protected byte[] processCsRcPlusRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsRcPlus request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationRcPlusMessage commandStationRcPlusMessage = (CommandStationRcPlusMessage)bidibMessage;
            CommandStationRcPlusAcknowledgeResponse acknowledgeResponse = null;
            switch (commandStationRcPlusMessage.getOpCode()) {
                case RC_GET_TID: {
                    acknowledgeResponse = new CommandStationRcPlusAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.tid);
                    response = acknowledgeResponse.getContent();
                    break;
                }
                case RC_SET_TID: {
                    TidData newTid = commandStationRcPlusMessage.getTid();
                    LOGGER.info("Set the new TID: {}", (Object)newTid);
                    this.tid = newTid;
                    acknowledgeResponse = new CommandStationRcPlusAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.tid);
                    response = acknowledgeResponse.getContent();
                    break;
                }
                case RC_PING_ONCE_P0: {
                    acknowledgeResponse = new CommandStationRcPlusAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), RcPlusPhase.P0, 0);
                    response = acknowledgeResponse.getContent();
                    break;
                }
                case RC_PING_ONCE_P1: {
                    acknowledgeResponse = new CommandStationRcPlusAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), RcPlusPhase.P1, 0);
                    response = acknowledgeResponse.getContent();
                    break;
                }
                default: {
                    LOGGER.error("The RailCom+ acknowledge is not yet implemented for OpCode: {}", (Object)commandStationRcPlusMessage.getOpCode());
                    break;
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationRcPlusAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processResetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the reset request, bidibMessage: {}", (Object)bidibMessage);
        this.resetSendNum();
    }

    private static class DccAdvDecoderInfo {
        private DecoderUniqueIdData did;
        private String fullName;
        private String shortName;
        private byte[] firmwareId;
        private String productName;
        private int lastFullNameIndex;
        private int selectedNamespace;
        private int retryCounter;
        private int logonAssignCounter;

        public DccAdvDecoderInfo(long mun, int mid, String fullName, String shortName, byte[] firmwareId, String productName) {
            this.did = new DecoderUniqueIdData(mun, mid);
            this.fullName = fullName;
            this.shortName = shortName;
            this.firmwareId = firmwareId;
            this.productName = productName;
        }

        public int getLastFullNameIndex() {
            return this.lastFullNameIndex;
        }

        public void setLastFullNameIndex(int lastFullNameIndex) {
            this.lastFullNameIndex = lastFullNameIndex;
        }

        public void setSelectedNamespace(int selectedNamespace) {
            LOGGER.info("Set the selected namespace of the decoder: {}", (Object)selectedNamespace);
            this.selectedNamespace = selectedNamespace;
        }

        public int getSelectedNamespace() {
            return this.selectedNamespace;
        }

        public int getRetryCounter() {
            return this.retryCounter;
        }

        public void setRetryCounter(int retryCounter) {
            this.retryCounter = retryCounter;
        }

        public void incRetryCounter() {
            ++this.retryCounter;
        }
    }
}

