/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.enums.InputPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LightPortEnum;
import org.bidib.jbidibc.messages.enums.PortConfigStatus;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.FlatBacklightPortType;
import org.bidib.jbidibc.simulation.nodes.FlatInputPortType;
import org.bidib.jbidibc.simulation.nodes.FlatLightPortType;
import org.bidib.jbidibc.simulation.nodes.FlatPortType;
import org.bidib.jbidibc.simulation.nodes.FlatServoPortType;
import org.bidib.jbidibc.simulation.nodes.FlatSwitchPortType;
import org.bidib.jbidibc.simulation.nodes.InputPortParamsType;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.LightPortParamsType;
import org.bidib.jbidibc.simulation.nodes.LightPortType;
import org.bidib.jbidibc.simulation.nodes.PortParamsType;
import org.bidib.jbidibc.simulation.nodes.PortType;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.simulation.LightControlSimulator;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.LightPortStatusEvent;
import org.bidib.wizard.simulation.ports.GenericSimulationPort;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="126"), @BidibNodeSimulator(vid="13", pid="127"), @BidibNodeSimulator(vid="13", pid="108")})
public class LedIo24Simulator
extends LightControlSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(LedIo24Simulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.LedIo24Panel";
    private final Map<Integer, GenericSimulationPort> genericPorts = new HashMap<Integer, GenericSimulationPort>();
    protected final ScheduledExecutorService inputWorker = Executors.newScheduledThreadPool(1);
    protected final ScheduledExecutorService simulationWorker = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> futureTriggerInputMessage;

    public LedIo24Simulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    @Override
    public void postConstruct() {
        super.postConstruct();
        Feature feature = this.getFeature(70);
        if (feature != null && MapUtils.isEmpty(this.genericPorts)) {
            LOGGER.info("The current simulator has the flat model configured. Prepare the generic ports.");
            int numPorts = feature.getValue();
            LOGGER.info("Create generic ports, numPorts: {}", (Object)numPorts);
            for (int portNumber = 0; portNumber < numPorts; ++portNumber) {
                GenericSimulationPort port = new GenericSimulationPort(portNumber);
                port.setPortValue(250);
                port.setPortStatus(portNumber % 2 == 0 ? InputPortStatus.ON.getType().getType() : InputPortStatus.OFF.getType().getType());
                int mask = 32774;
                port.setCurrentPortType(LcOutputType.INPUTPORT, mask);
                this.genericPorts.put(portNumber, port);
            }
        } else {
            LOGGER.info("Skip init the ports because the ports are available already.");
            if (MapUtils.isNotEmpty(this.genericPorts)) {
                LOGGER.info("Set the feature FEATURE_CTRL_PORT_FLAT_MODEL to value: {}", (Object)this.genericPorts.size());
                this.features.add(new Feature(70, this.genericPorts.size()));
            }
        }
    }

    @Override
    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        this.features.remove(new Feature(42, 2));
        this.features.add(new Feature(42, 8));
    }

    @Override
    protected void prepareCVs() {
        super.prepareCVs();
        this.configurationVariables.put("String 8", "TEST result");
    }

    @Override
    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        super.start();
        if (!MapUtils.isEmpty(this.genericPorts)) {
            LinkedHashMap<Byte, Object> values;
            ReconfigPortConfigValue reconfigPortConfigValue;
            GenericSimulationPort genericPort;
            int portNum;
            int index = 0;
            for (portNum = 0; portNum < this.lightPortCount; ++portNum) {
                genericPort = this.genericPorts.get(portNum + index);
                reconfigPortConfigValue = (ReconfigPortConfigValue)genericPort.getPortConfigX().get((byte)-127);
                genericPort.setCurrentPortType(LcOutputType.LIGHTPORT, reconfigPortConfigValue.getPortMap());
                if (portNum == 0) {
                    genericPort.setInactive(true);
                }
                values = new LinkedHashMap<Byte, Object>();
                values.put((byte)-127, new ReconfigPortConfigValue(reconfigPortConfigValue.getValue()));
                LightPort lightPort = (LightPort)this.lightPorts.get(portNum);
                if (lightPort != null && lightPort.getConfigStatus() == PortConfigStatus.CONFIG_PASSED) {
                    LOGGER.info("Do not initialize the port because the configuration is set already: {}", (Object)genericPort);
                    values.put((byte)2, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMin()))));
                    values.put((byte)1, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMax()))));
                    values.put((byte)4, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMin()))));
                    values.put((byte)3, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMax()))));
                } else {
                    values.put((byte)2, new BytePortConfigValue(Byte.valueOf((byte)0)));
                    values.put((byte)1, new BytePortConfigValue(Byte.valueOf((byte)-1)));
                    values.put((byte)4, new BytePortConfigValue(Byte.valueOf((byte)15)));
                    values.put((byte)3, new BytePortConfigValue(Byte.valueOf((byte)63)));
                }
                values.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)20))));
                values.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)150))));
                values.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)4))));
                genericPort.setPortConfigX(values);
                lightPort = new LightPort((GenericPort)genericPort);
                this.lightPorts.put(portNum, lightPort);
            }
            index = this.lightPortCount;
            LOGGER.info("Set the port type for input ports, index: {}", (Object)index);
            for (portNum = 0; portNum < this.inputPortCount; ++portNum) {
                genericPort = this.genericPorts.get(portNum + index);
                reconfigPortConfigValue = (ReconfigPortConfigValue)genericPort.getPortConfigX().get((byte)-127);
                genericPort.setCurrentPortType(LcOutputType.INPUTPORT, reconfigPortConfigValue.getPortMap());
                values = new LinkedHashMap();
                values.put((byte)-127, new ReconfigPortConfigValue(reconfigPortConfigValue.getValue()));
                InputPort inputPort = (InputPort)this.inputPorts.get(portNum);
                if (inputPort != null && inputPort.getConfigStatus() == PortConfigStatus.CONFIG_PASSED) {
                    LOGGER.info("Do not initialize the port because the configuration is set already: {}", (Object)genericPort);
                    values.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, new BytePortConfigValue(Byte.valueOf(inputPort.getInputBehaviour().getType())));
                    values.put((byte)11, new BytePortConfigValue(ByteUtils.getLowByte((Integer)inputPort.getTicks())));
                } else {
                    values.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, new BytePortConfigValue(Byte.valueOf((byte)0)));
                    values.put((byte)11, new BytePortConfigValue(Byte.valueOf((byte)15)));
                }
                values.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)20))));
                values.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)150))));
                values.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)4))));
                genericPort.setPortConfigX(values);
                inputPort = new InputPort((GenericPort)genericPort);
                this.inputPorts.put(portNum, inputPort);
            }
        }
    }

    @Override
    public void stop() {
        LOGGER.info("Stop the LED-IO-24 simulator.");
        if (this.futureTriggerInputMessage != null) {
            LOGGER.info("Stop the input message trigger.");
            boolean success = this.futureTriggerInputMessage.cancel(false);
            LOGGER.info("Stopped the input message trigger, success: {}", (Object)success);
            this.futureTriggerInputMessage = null;
        }
        super.stop();
    }

    @Override
    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    protected void processSysEnableRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the sysEnable request: {}", (Object)bidibMessage);
        super.processSysEnableRequest(bidibMessage);
        if (this.futureTriggerInputMessage == null) {
            LOGGER.info("Schedule the input message trigger");
            int interval = 15;
            this.futureTriggerInputMessage = this.inputWorker.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Trigger input response");
                    LOGGER.info("Trigger input response has finished.");
                }
            }, 15L, interval, TimeUnit.SECONDS);
        }
    }

    protected void processSysDisableRequest(BidibMessageInterface bidibMessage) {
        super.processSysDisableRequest(bidibMessage);
        if (this.futureTriggerInputMessage != null) {
            LOGGER.info("Stop the input message trigger.");
            boolean success = this.futureTriggerInputMessage.cancel(false);
            LOGGER.info("Stopped the input message trigger, success: {}", (Object)success);
            this.futureTriggerInputMessage = null;
        }
    }

    protected void triggerInputResponse() {
        int maxPortId = 1;
        Random generator = new Random();
        int portNum = generator.nextInt(maxPortId);
        LOGGER.info("Trigger change input status, current portNum: {}", (Object)(portNum += 24));
        try {
            this.changeInputPortStatus(portNum);
        }
        catch (Exception ex) {
            LOGGER.warn("Publish input status failed for portNum: {}", (Object)portNum, (Object)ex);
        }
    }

    @Override
    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response;
        block7: {
            LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
            response = null;
            if (this.getFlatPortModelPortCount() > 0) {
                try {
                    LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
                    int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
                    LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
                    GenericPort port = null;
                    port = this.genericPorts.get(outputNumber);
                    LOGGER.info("Set LcConfig for output number: {}, port: {}", (Object)outputNumber, (Object)port);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                    if (port != null) {
                        Integer supportedPortTypes;
                        LcConfigX lcConfigX = lcConfigXSetMessage.getLcConfigX(this.messageLogger);
                        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)lcConfigX.getPortConfig().get((byte)-127);
                        if (reconfig != null && (supportedPortTypes = port.getSupportedPortTypes()) != null) {
                            ReconfigPortConfigValue newReconfig = new ReconfigPortConfigValue((int)reconfig.getCurrentOutputType().getType(), supportedPortTypes.intValue());
                            LOGGER.info("Prepared BIDIB_PCFG_RECONFIG to replace: {}", (Object)newReconfig);
                            lcConfigX.getPortConfig().put((byte)-127, newReconfig);
                        }
                        port.setPortConfigX(lcConfigX.getPortConfig());
                        Map updatedValues = port.getPortConfigX();
                        LOGGER.info("Return config of port: {}", (Object)port);
                        lcConfigX = new LcConfigX(bidibPort, updatedValues);
                        byte[] content = LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel());
                        if (outputNumber == 5) {
                            content = new byte[]{0, 5, 0, 12};
                        }
                        LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), content);
                        response = lcConfigXResponse.getContent();
                        break block7;
                    }
                    LOGGER.warn("No port assigned!");
                    LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = magicResponse.getContent();
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
                }
            } else {
                response = super.processLcConfigXSetRequest(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response;
        block6: {
            LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
            response = null;
            if (this.getFlatPortModelPortCount() > 0) {
                try {
                    LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
                    int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
                    LcOutputType outputType = lcConfigXGetMessage.getPortType(this.getPortModel());
                    GenericPort port = null;
                    port = this.genericPorts.get(outputNumber);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                    if (port != null) {
                        Map values = port.getPortConfigX();
                        if (outputNumber == 2) {
                            values.put((byte)0, new BytePortConfigValue(Byte.valueOf((byte)12)));
                        }
                        LOGGER.info("Return config of port: {}", (Object)port);
                        LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                        LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                        response = lcConfigXResponse.getContent();
                        break block6;
                    }
                    LOGGER.warn("No port available with port number: {}", (Object)outputNumber);
                    LcNotAvailableResponse notAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = notAvailableResponse.getContent();
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
                }
            } else {
                response = super.processLcConfigXGetRequest(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
        if (this.getFlatPortModelPortCount() > 0) {
            LcOutputType outputType = LcOutputType.SWITCHPORT;
            LinkedHashMap values = new LinkedHashMap();
            try {
                for (GenericPort genericPort : this.genericPorts.values()) {
                    int portNumber = genericPort.getPortNumber();
                    LOGGER.info("Prepare lcConfigXResponse for port number: {}", (Object)portNumber);
                    values.clear();
                    values.putAll(genericPort.getPortConfigX());
                    LOGGER.info("Return config of port: {}", (Object)genericPort);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
                    LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                    LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    byte[] response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcConfigXResponse response failed.", (Throwable)ex);
            }
        } else {
            super.processLcConfigXGetAllRequest(bidibMessage);
        }
    }

    @Override
    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutputQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        if (this.getFlatPortModelPortCount() > 0) {
            byte portState = 0;
            try {
                LcPortQueryMessage lcOutputQueryMessage = (LcPortQueryMessage)bidibMessage;
                LcOutputType outputType = lcOutputQueryMessage.getPortType(this.getPortModel());
                int outputNumber = lcOutputQueryMessage.getPortNumber(this.getPortModel());
                GenericPort port = this.genericPorts.get(outputNumber);
                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                if (port != null) {
                    portState = ByteUtils.getLowByte((int)255);
                } else {
                    LOGGER.warn("No port available with portNumber: {}", (Object)outputNumber);
                }
                LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
                response = lcStatResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
        } else {
            response = super.processLcPortQueryRequest(bidibMessage);
        }
        return response;
    }

    @Override
    protected byte[] processLcPortQueryAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the PortQueryAll request: {}", (Object)bidibMessage);
        if (this.getFlatPortModelPortCount() > 0) {
            byte[] response = null;
            try {
                LcPortQueryAllMessage portQueryAllMessage = (LcPortQueryAllMessage)bidibMessage;
                int portRangeFrom = portQueryAllMessage.getPortRangeFrom(this.getPortModel());
                int portRangeTo = portQueryAllMessage.getPortRangeTo(this.getPortModel());
                int portTypeMask = portQueryAllMessage.getPortTypeMask();
                LOGGER.info("Query all port states, portRangeFrom: {}, portRangeTo: {}, portModel: {}, portTypeMask: {}", new Object[]{portRangeFrom, portRangeTo, this.getPortModel(), portTypeMask});
                for (GenericPort genericPort : this.genericPorts.values()) {
                    LcOutputType currentPortType = genericPort.getCurrentPortType();
                    if (PortConfigUtils.isSupportsPortType((LcOutputType)currentPortType, (int)portTypeMask) && genericPort.getPortNumber() >= portRangeFrom && genericPort.getPortNumber() < portRangeTo) {
                        try {
                            byte portStatus = genericPort.getPortStatus();
                            this.publishPortState(bidibMessage.getAddr(), currentPortType, genericPort.getPortNumber(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)genericPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip current port that is out of port range or wrong port type: {}", (Object)genericPort);
                }
                LOGGER.info("Send the terminating LC_NA message.");
                this.publishLcNaResponse(bidibMessage.getAddr());
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
            return response;
        }
        LOGGER.info("The LedIo24Simulator is configured as type-oriented port model! Delegate evaluation to LightControlSimulator.");
        return super.processLcPortQueryAllRequest(bidibMessage);
    }

    @Override
    protected byte[] processLcKeyQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcKeyQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        if (this.getFlatPortModelPortCount() > 0) {
            byte keyState = 0;
            GenericSimulationPort port = null;
            try {
                LcKeyMessage lcKeyMessage = (LcKeyMessage)bidibMessage;
                int portNumber = lcKeyMessage.getBidibPort().getPortNumber(PortModelEnum.type);
                port = this.genericPorts.get(portNumber);
                if (port != null) {
                    keyState = port.getPortStatus();
                } else {
                    LOGGER.warn("No port available with portNumber: {}", (Object)portNumber);
                }
                LcKeyResponse lcKeyResponse = new LcKeyResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)portNumber), keyState);
                response = lcKeyResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcKey response failed.", (Throwable)ex);
            }
            if (port != null) {
                this.publishInputPortChange(port);
            }
        } else {
            response = super.processLcKeyQueryRequest(bidibMessage);
        }
        return response;
    }

    @Override
    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        if (this.getFlatPortModelPortCount() > 0) {
            GenericSimulationPort port = null;
            try {
                LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
                LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
                int portNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
                byte outputStatus = lcOutputMessage.getOutputStatus();
                port = this.genericPorts.get(portNumber);
                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
                if (port != null) {
                    port.setPortStatus(outputStatus);
                    LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, lcOutputMessage.getOutputStatus());
                    response = lcStatResponse.getContent();
                } else {
                    LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = lcNotAvailableResponse.getContent();
                }
                if (port != null) {
                    switch (port.getCurrentPortType()) {
                        case LIGHTPORT: {
                            this.publishLightPortChange(port);
                            break;
                        }
                    }
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
        }
        return response;
    }

    private void publishLightPortChange(GenericSimulationPort port) {
        LightPortStatus status = LightPortStatus.valueOf((LightPortEnum)LightPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The lightport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new LightPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    @Override
    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{0, 0, 0};
            if (accessoryNumber == 1 && aspect == 1) {
                LOGGER.warn("Adding simulated error to accessory state response");
                value = new byte[]{2, 1, 20};
                AccessoryResponseHandler callable = new AccessoryResponseHandler(bidibMessage.getAddr(), accessoryNumber, aspect);
                ScheduledFuture<?> future = this.simulationWorker.scheduleWithFixedDelay(callable, 1500L, 1500L, TimeUnit.MILLISECONDS);
                callable.setFuture(future);
            }
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)aspect), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            if (paraNumber == 254) {
                LOGGER.info("The param BIDIB_ACCESSORY_SWITCH_TIME is known for accessory 0 and 1!");
                byte[] value = null;
                switch (accessoryNumber) {
                    case 0: {
                        value = new byte[]{ByteUtils.getLowByte((int)135)};
                        break;
                    }
                    case 1: {
                        value = new byte[]{ByteUtils.getLowByte((int)119)};
                        break;
                    }
                    default: {
                        value = new byte[]{ByteUtils.getLowByte((int)paraNumber)};
                        paraNumber = 255;
                    }
                }
                AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
                response = accessoryParaResponse.getContent();
            } else {
                response = super.processAccessoryParaGetRequest(bidibMessage);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishInputPortChange(GenericSimulationPort port) {
        InputPortStatus status = InputPortStatus.valueOf((InputPortEnum)InputPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The inputport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new InputPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    @Override
    protected void changeInputPortStatus(int portNum) {
        GenericSimulationPort port = this.genericPorts.get(portNum);
        if (port != null) {
            InputPortStatus portStatus = InputPortStatus.valueOf((InputPortEnum)InputPortEnum.valueOf((byte)port.getPortStatus()));
            switch (portStatus) {
                case OFF: {
                    port.setPortStatus(InputPortStatus.ON.getType().getType());
                    break;
                }
                default: {
                    port.setPortStatus(InputPortStatus.OFF.getType().getType());
                }
            }
            try {
                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.INPUTPORT, (int)portNum);
                LcStatResponse lcStatResponse = new LcStatResponse(this.nodeAddress, this.getNextSendNum(), bidibPort, port.getPortStatus());
                byte[] response = lcStatResponse.getContent();
                this.sendSpontanousResponse(response);
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
            this.publishInputPortChange(port);
        } else {
            LOGGER.warn("The requested input port is not available: {}", (Object)portNum);
        }
    }

    @Override
    public void setPortsConfig(FlatPortType flatPortType) {
        if (flatPortType == null) {
            return;
        }
        LOGGER.info("Set the ports config: {}", (Object)flatPortType);
        if (CollectionUtils.isNotEmpty((Collection)flatPortType.getBACKLIGHTOrLIGHTOrINPUT())) {
            for (PortParamsType flatPortParamsType : flatPortType.getBACKLIGHTOrLIGHTOrINPUT()) {
                if (flatPortParamsType instanceof FlatInputPortType) {
                    this.prepareInutPortFromConfig((FlatInputPortType)flatPortParamsType);
                    continue;
                }
                if (flatPortParamsType instanceof FlatLightPortType) {
                    this.prepareLightPortFromConfig((FlatLightPortType)flatPortParamsType);
                    continue;
                }
                if (flatPortParamsType instanceof FlatBacklightPortType) {
                    this.prepareBacklightPortFromConfig((FlatBacklightPortType)flatPortParamsType);
                    continue;
                }
                if (flatPortParamsType instanceof FlatServoPortType) {
                    this.prepareServoPortFromConfig((FlatServoPortType)flatPortParamsType);
                    continue;
                }
                if (flatPortParamsType instanceof FlatSwitchPortType) {
                    this.prepareSwitchPortFromConfig((FlatSwitchPortType)flatPortParamsType);
                    continue;
                }
                LOGGER.warn("Unsupported flatPortParamsType detected: {}", (Object)flatPortParamsType);
            }
        }
    }

    @Override
    public void setPortsConfig(PortType portType) {
        if (portType == null) {
            return;
        }
        LOGGER.info("Set the ports config: {}", (Object)portType);
        if (portType instanceof LightPortType) {
            LightPortType lightPortType = (LightPortType)portType;
            this.lightPortCount = lightPortType.getCount();
            LOGGER.info("Total number of lightports: {}", (Object)this.lightPortCount);
            this.lightPorts.clear();
            for (int portId = 0; portId < this.lightPortCount; ++portId) {
                LightPort lightPort = new LightPort();
                lightPort.setId(portId);
                this.lightPorts.put(portId, lightPort);
            }
            this.prepareLightPortFromConfig(lightPortType);
        } else if (portType instanceof InputPortType) {
            InputPortType inputPortType = (InputPortType)portType;
            this.inputPortCount = inputPortType.getCount();
            this.inputPortOffset = inputPortType.getOffset() != null ? inputPortType.getOffset() : this.lightPortCount;
            LOGGER.info("Configured number of input ports: {}", (Object)this.inputPortCount);
            for (int portId = 0; portId < this.inputPortCount; ++portId) {
                InputPort inputPort = new InputPort();
                inputPort.setId(portId);
                this.inputPorts.put(portId, inputPort);
            }
            this.prepareInputPortFromConfig(inputPortType);
        }
    }

    protected void prepareLightPortFromConfig(LightPortType lightPortType) {
        if (CollectionUtils.isNotEmpty((Collection)lightPortType.getPort())) {
            for (LightPortParamsType portParams : lightPortType.getPort()) {
                LightPort lightPort = new LightPort();
                lightPort.setId(portParams.getPortId());
                lightPort.setDimMin(portParams.getDimSlopeDown());
                lightPort.setDimMax(portParams.getDimSlopeUp());
                lightPort.setPwmMax(portParams.getIntensityOn());
                lightPort.setPwmMin(portParams.getIntensityOff());
                if (portParams.getRgbValue() != null) {
                    try {
                        Integer rgbValue = Integer.parseInt(portParams.getRgbValue(), 16);
                        lightPort.setRgbValue(rgbValue);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Parse RGB value failed: {}", (Object)portParams.getRgbValue(), (Object)ex);
                        lightPort.setRgbValue(null);
                    }
                }
                if (portParams.getTransitionTime() != null) {
                    lightPort.setTransitionTime(portParams.getTransitionTime());
                }
                lightPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
                lightPort.setStatus((BidibStatus)LightPortStatus.OFF);
                LOGGER.info("Add configured port: {}", (Object)lightPort);
                this.lightPorts.put(lightPort.getId(), lightPort);
            }
            this.lightPortCount = this.lightPorts.size();
        }
    }

    protected void prepareBacklightPortFromConfig(FlatBacklightPortType lightPortType) {
        LOGGER.warn("prepareBacklightPortFromConfig is not implemented yet!");
    }

    protected void prepareServoPortFromConfig(FlatServoPortType servoPortType) {
        int portNumber = servoPortType.getPortId();
        GenericSimulationPort servoPort = new GenericSimulationPort(portNumber);
        int portTypeMap = LedIo24Simulator.getPortTypeMap((byte[])servoPortType.getPortTypeMap());
        servoPort.setCurrentPortType(LcOutputType.SERVOPORT, portTypeMap);
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPortType.getSpeed()))));
        portConfig.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPortType.getAdjustLow()))));
        portConfig.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPortType.getAdjustHigh()))));
        servoPort.setPortConfigX(portConfig);
        servoPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        servoPort.setPortValue(servoPortType.getValue());
        LOGGER.info("Add configured serbvo port: {}", (Object)servoPort);
        this.genericPorts.put(servoPort.getPortNumber(), servoPort);
    }

    protected void prepareSwitchPortFromConfig(FlatSwitchPortType switchPortType) {
        int portNumber = switchPortType.getPortId();
        GenericSimulationPort switchPort = new GenericSimulationPort(portNumber);
        int portTypeMap = LedIo24Simulator.getPortTypeMap((byte[])switchPortType.getPortTypeMap());
        switchPort.setCurrentPortType(LcOutputType.SWITCHPORT, portTypeMap);
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)11, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)switchPortType.getTicks()))));
        switchPort.setPortConfigX(portConfig);
        switchPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        switchPort.setPortStatus(SwitchPortStatus.ON.getType().getType());
        LOGGER.info("Add configured switch port: {}", (Object)switchPort);
        this.genericPorts.put(switchPort.getPortNumber(), switchPort);
    }

    protected void prepareLightPortFromConfig(FlatLightPortType lightPortType) {
        int portNumber = lightPortType.getPortId();
        GenericSimulationPort lightPort = new GenericSimulationPort(portNumber);
        int portTypeMap = LedIo24Simulator.getPortTypeMap((byte[])lightPortType.getPortTypeMap());
        lightPort.setCurrentPortType(LcOutputType.LIGHTPORT, portTypeMap);
        lightPort.setPortNumber(lightPortType.getPortId());
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)2, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPortType.getIntensityOff()))));
        portConfig.put((byte)1, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPortType.getIntensityOn()))));
        portConfig.put((byte)4, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPortType.getDimSlopeDown()))));
        portConfig.put((byte)3, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPortType.getDimSlopeUp()))));
        if (lightPortType.getTransitionTime() != null) {
            portConfig.put(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME, new BytePortConfigValue(ByteUtils.getLowByte((Integer)lightPortType.getTransitionTime())));
        }
        lightPort.setPortConfigX(portConfig);
        lightPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        lightPort.setPortStatus(LightPortStatus.OFF.getType().getType());
        LOGGER.info("Add configured light port: {}", (Object)lightPort);
        this.genericPorts.put(lightPort.getPortNumber(), lightPort);
    }

    protected void prepareInutPortFromConfig(FlatInputPortType inputPortType) {
        int portNumber = inputPortType.getPortId();
        GenericSimulationPort inputPort = new GenericSimulationPort(portNumber);
        int portTypeMap = LedIo24Simulator.getPortTypeMap((byte[])inputPortType.getPortTypeMap());
        inputPort.setCurrentPortType(LcOutputType.INPUTPORT, portTypeMap);
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)11, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)inputPortType.getTicks()))));
        inputPort.setPortConfigX(portConfig);
        inputPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        inputPort.setPortStatus(InputPortStatus.ON.getType().getType());
        LOGGER.info("Add configured input port: {}", (Object)inputPort);
        this.genericPorts.put(inputPort.getPortNumber(), inputPort);
    }

    protected void prepareInputPortFromConfig(InputPortType inputPortType) {
        if (CollectionUtils.isNotEmpty((Collection)inputPortType.getPort())) {
            for (InputPortParamsType portParams : inputPortType.getPort()) {
                InputPort inputPort = new InputPort();
                inputPort.setId(portParams.getPortId());
                inputPort.setSwitchOffTime(Integer.valueOf(portParams.getTicks()));
                inputPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
                LOGGER.info("Add configured port: {}", (Object)inputPort);
                this.inputPorts.put(inputPort.getId(), inputPort);
            }
            this.inputPortCount = this.inputPorts.size();
        }
    }

    private final class AccessoryResponseHandler
    implements Runnable {
        private List<String> accessoryResponseList = new ArrayList<String>();
        private final byte[] nodeAddress;
        private ScheduledFuture<?> future;

        public AccessoryResponseHandler(byte[] nodeAddress, int accessoryNumber, int aspect) {
            this.nodeAddress = nodeAddress;
            this.accessoryResponseList.add(accessoryNumber + "," + aspect + ",2,128,7");
            this.accessoryResponseList.add(accessoryNumber + ",255,2,129,7");
            this.accessoryResponseList.add(accessoryNumber + ",255,2,0,0");
        }

        public void setFuture(ScheduledFuture<?> future) {
            LOGGER.info("Set the future: {}", future);
            this.future = future;
        }

        @Override
        public void run() {
            String accessoryResponse;
            LOGGER.info("The AccessoryResponseHandler is executed.");
            if (!this.accessoryResponseList.isEmpty() && StringUtils.isNotBlank((CharSequence)(accessoryResponse = this.accessoryResponseList.remove(0)))) {
                LOGGER.info("Send response: {}", (Object)accessoryResponse);
                String[] parts = accessoryResponse.split(",");
                byte[] value = new byte[parts.length];
                int index = 0;
                for (String part : parts) {
                    int val = Integer.parseInt(part);
                    value[index] = ByteUtils.getLowByte((int)val);
                    ++index;
                }
                try {
                    AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(this.nodeAddress, 0, value[0], value[1], ByteUtils.subArray((byte[])value, (int)2));
                    byte[] response = accessoryStateResponse.getContent();
                    LOGGER.info("Prepared accessoryStateResponse: {}", (Object)accessoryStateResponse);
                    LedIo24Simulator.this.sendSpontanousResponse(response);
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
                }
            }
            if (this.accessoryResponseList.isEmpty()) {
                LOGGER.info("No more entries in accessoryResponseList. Cancel the future.");
                if (this.future != null) {
                    try {
                        this.future.cancel(false);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Cancel the future failed.", (Throwable)ex);
                    }
                }
            }
        }
    }
}

