/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.jbidibc.messages.enums.LcMacroOperationCode;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LightPortEnum;
import org.bidib.jbidibc.messages.enums.PortConfigStatus;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaSetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.FeedbackSpeedResponse;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcConfigSetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetAllMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcMacroGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroHandleMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaResponse;
import org.bidib.jbidibc.messages.message.LcMacroParaSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroResponse;
import org.bidib.jbidibc.messages.message.LcMacroSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroStateResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.port.RgbPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.MacroUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.FlatPortType;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.LightPortParamsType;
import org.bidib.jbidibc.simulation.nodes.LightPortType;
import org.bidib.jbidibc.simulation.nodes.PortType;
import org.bidib.jbidibc.simulation.nodes.ServoPortType;
import org.bidib.jbidibc.simulation.nodes.SwitchPortType;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.ServoPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bidib.wizard.simulation.events.InputPortSetStatusEvent;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.LightPortStatusEvent;
import org.bidib.wizard.simulation.events.ServoPortStatusEvent;
import org.bidib.wizard.simulation.events.SwitchPortStatusEvent;
import org.bidib.wizard.simulation.macro.MacroContainer;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="107"), @BidibNodeSimulator(vid="13", pid="204")})
public class LightControlSimulator
extends DefaultNodeSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightControlSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.LightControlPanel";
    protected static final int MAX_NUM_OF_FEEDBACK_PORTS = 8;
    protected final Map<Integer, InputPort> inputPorts = new HashMap<Integer, InputPort>();
    protected final Map<Integer, LightPort> lightPorts = new HashMap<Integer, LightPort>();
    protected final Map<Integer, SwitchPort> switchPorts = new HashMap<Integer, SwitchPort>();
    protected final Map<Integer, ServoPort> servoPorts = new HashMap<Integer, ServoPort>();
    protected final Map<Integer, MacroContainer> macros = new HashMap<Integer, MacroContainer>();
    protected int inputPortCount;
    protected int inputPortOffset;
    protected int lightPortCount;
    protected int servoPortCount;
    protected int switchPortCount;
    private final Map<Integer, FeedbackPort> feedbackPorts = new HashMap<Integer, FeedbackPort>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusValid = new AtomicBoolean();
    private final AtomicBoolean statusSignal = new AtomicBoolean();
    private boolean startFeedbackWorker = false;
    protected final ScheduledExecutorService feedbackAddrWorker;
    private int interval = 3000;
    private int currentLocoPosition = -1;
    private boolean fakePortStatus;
    private boolean simulateTestErrors;
    private int timestamp;

    public LightControlSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("feedbackAddrWorkers-thread-%d").build();
        this.feedbackAddrWorker = Executors.newScheduledThreadPool(1, namedThreadFactory);
    }

    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        this.features.add(new Feature(66, 1));
        this.features.add(new Feature(67, 1));
        this.features.add(new Feature(51, 1));
        this.features.add(new Feature(62, 40));
        this.features.add(new Feature(63, 38));
        this.features.add(new Feature(61, 40));
        this.features.add(new Feature(60, 2));
        this.features.add(new Feature(40, 20));
        this.features.add(new Feature(41, 0));
        this.features.add(new Feature(42, 2));
    }

    public void postConstruct() {
        Integer switchPortCountVal;
        Integer servoPortCountVal;
        Integer lightPortCountVal;
        Integer inputPortCountVal;
        super.postConstruct();
        if (this.inputPortCount > 0) {
            this.features.add(new Feature(50, this.inputPortCount));
        } else if (Feature.findFeature((Collection)this.features, (int)50) != null && (inputPortCountVal = Feature.getIntegerFeatureValue((Collection)this.features, (FeatureEnum)FeatureEnum.FEATURE_CTRL_INPUT_COUNT)) != null) {
            this.inputPortCount = inputPortCountVal;
        }
        if (this.lightPortCount > 0) {
            this.features.add(new Feature(53, this.lightPortCount));
        } else if (Feature.findFeature((Collection)this.features, (int)53) != null && (lightPortCountVal = Feature.getIntegerFeatureValue((Collection)this.features, (FeatureEnum)FeatureEnum.FEATURE_CTRL_LIGHT_COUNT)) != null) {
            this.lightPortCount = lightPortCountVal;
        }
        if (this.servoPortCount > 0) {
            this.features.add(new Feature(54, this.servoPortCount));
        } else if (Feature.findFeature((Collection)this.features, (int)54) != null && (servoPortCountVal = Feature.getIntegerFeatureValue((Collection)this.features, (FeatureEnum)FeatureEnum.FEATURE_CTRL_SERVO_COUNT)) != null) {
            this.servoPortCount = servoPortCountVal;
        }
        if (this.switchPortCount > 0) {
            this.features.add(new Feature(52, this.switchPortCount));
        } else if (Feature.findFeature((Collection)this.features, (int)52) != null && (switchPortCountVal = Feature.getIntegerFeatureValue((Collection)this.features, (FeatureEnum)FeatureEnum.FEATURE_CTRL_SWITCH_COUNT)) != null) {
            this.switchPortCount = switchPortCountVal;
        }
    }

    protected void prepareCVs() {
        super.prepareCVs();
        this.configurationVariables.put("2", "0");
        this.configurationVariables.put("90", "191");
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.setupInputPorts();
        this.setupLightPorts();
        this.setupSwitchPorts();
        this.setupServoPorts();
        this.setupFeedbackPorts();
        super.start();
        Feature bmSize = NodeUtils.getFeature((FeatureEnum)FeatureEnum.FEATURE_BM_SIZE, (Iterable)this.features);
        Feature bmOn = NodeUtils.getFeature((FeatureEnum)FeatureEnum.FEATURE_BM_ON, (Iterable)this.features);
        if (bmSize != null && bmSize.getValue() > 0 && bmOn != null && bmOn.getValue() > 0) {
            this.startFeedbackWorker = true;
            LOGGER.info("Start the feedback worker.");
        }
        if (this.startFeedbackWorker) {
            this.feedbackAddrWorker.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        int portNum = LightControlSimulator.this.currentLocoPosition;
                        LOGGER.info("Trigger feedback address, portNum: {}", (Object)portNum);
                        FeedbackPortSetStatusEvent evtFree = null;
                        if (portNum > -1) {
                            portNum = LightControlSimulator.this.currentLocoPosition;
                            if (portNum < 0) {
                                portNum = 7;
                            }
                            evtFree = new FeedbackPortSetStatusEvent(LightControlSimulator.this.getAddress(), portNum, FeedbackPortStatus.FREE);
                        }
                        ++LightControlSimulator.this.currentLocoPosition;
                        if (LightControlSimulator.this.currentLocoPosition >= 8) {
                            LightControlSimulator.this.currentLocoPosition = 0;
                        }
                        FeedbackPortSetStatusEvent evtOcc = new FeedbackPortSetStatusEvent(LightControlSimulator.this.getAddress(), LightControlSimulator.this.currentLocoPosition, FeedbackPortStatus.OCCUPIED);
                        LightControlSimulator.this.setFeedbackPortStatus(evtOcc);
                        LightControlSimulator.this.triggerFeedbackAddressResponse(LightControlSimulator.this.currentLocoPosition);
                        Thread.sleep(500L);
                        if (evtFree != null) {
                            LightControlSimulator.this.setFeedbackPortStatus(evtFree);
                            LightControlSimulator.this.triggerFeedbackAddressResponse(evtFree.getPortNum());
                        }
                        int delayValue = ThreadLocalRandom.current().nextInt(300, 4000);
                        LOGGER.info("Wait for next execution, delayValue: {}", (Object)delayValue);
                        Thread.sleep(delayValue);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Trigger the feedback address failed.", (Throwable)ex);
                    }
                    LOGGER.info("Trigger feedback address has finished.");
                }
            }, 5000L, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        if (this.feedbackAddrWorker != null) {
            LOGGER.info("Stop the booster diag worker.");
            this.feedbackAddrWorker.shutdownNow();
        }
        super.stop();
    }

    private void setupFeedbackPorts() {
        for (int id = 0; id < 8; ++id) {
            FeedbackPort port = new FeedbackPort();
            port.setId(id);
            port.setStatus(FeedbackPortStatus.FREE);
            this.feedbackPorts.put(id, port);
        }
    }

    protected void setupInputPorts() {
        if (CollectionUtils.isNotEmpty(this.inputPorts.values())) {
            LOGGER.info("InputPorts are set externally already.");
            return;
        }
        for (int id = 0; id < this.inputPortCount; ++id) {
            InputPort port = new InputPort();
            port.setId(id);
            port.setStatus((BidibStatus)(id % 2 == 0 ? InputPortStatus.ON : InputPortStatus.OFF));
            this.inputPorts.put(id, port);
        }
    }

    protected void setupLightPorts() {
        if (CollectionUtils.isNotEmpty(this.lightPorts.values())) {
            LOGGER.info("LightPorts are set externally already.");
            return;
        }
        for (int id = 0; id < this.lightPortCount; ++id) {
            LightPort port = new LightPort();
            port.setId(id);
            port.setStatus((BidibStatus)(id % 3 == 0 ? LightPortStatus.ON : LightPortStatus.OFF));
            this.lightPorts.put(id, port);
        }
    }

    protected void setupSwitchPorts() {
        if (CollectionUtils.isNotEmpty(this.switchPorts.values())) {
            LOGGER.info("SwitchPorts are set externally already.");
            return;
        }
        for (int id = 0; id < this.switchPortCount; ++id) {
            SwitchPort port = new SwitchPort();
            port.setId(id);
            port.setStatus((BidibStatus)SwitchPortStatus.OFF);
            port.setOutputBehaviour(IoBehaviourSwitchEnum.HIGH);
            port.setSwitchOffTime(Integer.valueOf(15));
            this.switchPorts.put(id, port);
        }
    }

    protected void setupServoPorts() {
        if (CollectionUtils.isNotEmpty(this.servoPorts.values())) {
            LOGGER.info("ServoPorts are set externally already.");
            return;
        }
        boolean useConfigX = this.getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_5);
        LOGGER.info("Create servoPorts, count: {}, useConfigX: {}", (Object)this.servoPortCount, (Object)useConfigX);
        for (int id = 0; id < this.servoPortCount; ++id) {
            ServoPort port = new ServoPort();
            port.setId(id);
            port.setRelativeValue(id % 4 * 25);
            if (useConfigX) {
                this.configureServoPort(port);
            } else {
                byte[] portConfig = new byte[]{48, 123, 8};
                port.setPortConfig(portConfig);
            }
            this.servoPorts.put(id, port);
        }
    }

    protected void configureServoPort(ServoPort port) {
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)20))));
        portConfig.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)150))));
        portConfig.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)4))));
        port.setPortConfigX(portConfig);
    }

    @EventSubscriber(eventClass=InputPortSetStatusEvent.class)
    public void inputPortSetStatus(InputPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the input port was requested.");
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        this.changeInputPortStatus(portNum);
    }

    protected void changeInputPortStatus(int portNum) {
        InputPort port = this.inputPorts.get(portNum);
        if (port != null) {
            switch ((InputPortStatus)port.getStatus()) {
                case OFF: {
                    port.setStatus((BidibStatus)InputPortStatus.ON);
                    break;
                }
                default: {
                    port.setStatus((BidibStatus)InputPortStatus.OFF);
                }
            }
            LcKeyMessage lcKeyMessage = new LcKeyMessage(portNum){

                public byte[] getAddr() {
                    return LightControlSimulator.this.getNodeAddress();
                }
            };
            this.processRequest((BidibMessageInterface)lcKeyMessage);
        } else {
            LOGGER.warn("The requested light port is not available: {}", (Object)portNum);
        }
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 64: {
                response = this.processLcOutputRequest(bidibMessage);
                break;
            }
            case 66: {
                response = this.processLcConfigGetRequest(bidibMessage);
                break;
            }
            case 65: {
                response = this.processLcConfigSetRequest(bidibMessage);
                break;
            }
            case 67: {
                response = this.processLcKeyQueryRequest(bidibMessage);
                break;
            }
            case 68: {
                response = this.processLcPortQueryRequest(bidibMessage);
                break;
            }
            case 70: {
                response = this.processLcConfigXSetRequest(bidibMessage);
                break;
            }
            case 71: {
                response = this.processLcConfigXGetRequest(bidibMessage);
                break;
            }
            case 69: {
                this.processLcConfigXGetAllRequest(bidibMessage);
                break;
            }
            case 63: {
                this.processLcPortQueryAllRequest(bidibMessage);
                break;
            }
            case 72: {
                response = this.processLcMacroHandleRequest(bidibMessage);
                break;
            }
            case 76: {
                response = this.processLcMacroParaGetRequest(bidibMessage);
                break;
            }
            case 75: {
                response = this.processLcMacroParaSetRequest(bidibMessage);
                break;
            }
            case 74: {
                response = this.processLcMacroGetRequest(bidibMessage);
                break;
            }
            case 73: {
                response = this.processLcMacroSetRequest(bidibMessage);
                break;
            }
            case 56: {
                response = this.processAccessorySetRequest(bidibMessage);
                break;
            }
            case 57: {
                response = this.processAccessoryGetRequest(bidibMessage);
                break;
            }
            case 60: {
                response = this.processAccessoryGetAllRequest(bidibMessage);
                break;
            }
            case 58: {
                response = this.processAccessoryParaSetRequest(bidibMessage);
                break;
            }
            case 59: {
                response = this.processAccessoryParaGetRequest(bidibMessage);
                break;
            }
            case 32: {
                response = this.processBmGetRangeRequest(bidibMessage);
                break;
            }
            case 33: {
                this.processBmMirrorMultipleRequest(bidibMessage);
                break;
            }
            case 34: {
                this.processBmMirrorOccupiedRequest(bidibMessage);
                break;
            }
            case 35: {
                this.processBmMirrorFreeRequest(bidibMessage);
                break;
            }
            case 37: {
                response = this.processBmGetConfidenceRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
            LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
            int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
            byte outputStatus = lcOutputMessage.getOutputStatus();
            ServoPort port = null;
            switch (outputType) {
                case LIGHTPORT: {
                    LightPort lightPort = this.lightPorts.get(outputNumber);
                    lightPort.setStatus((BidibStatus)LightPortStatus.valueOf((LightPortEnum)LightPortEnum.valueOf((byte)outputStatus)));
                    port = lightPort;
                    if (outputNumber != 2) break;
                    if (!this.fakePortStatus) {
                        LOGGER.warn("Fake LC_NA");
                        port = null;
                        this.fakePortStatus = true;
                        break;
                    }
                    this.fakePortStatus = false;
                    break;
                }
                case SWITCHPORT: {
                    SwitchPort switchPort = this.switchPorts.get(outputNumber);
                    switchPort.setStatus((BidibStatus)SwitchPortStatus.valueOf((SwitchPortEnum)SwitchPortEnum.valueOf((byte)outputStatus)));
                    port = switchPort;
                    if (outputNumber != 2) break;
                    if (!this.fakePortStatus) {
                        LOGGER.warn("Fake LC_NA");
                        port = null;
                        this.fakePortStatus = true;
                        break;
                    }
                    this.fakePortStatus = false;
                    break;
                }
                case SERVOPORT: {
                    ServoPort servoPort = this.servoPorts.get(outputNumber);
                    servoPort.setValue(ByteUtils.getInteger((byte)outputStatus));
                    port = servoPort;
                    break;
                }
                default: {
                    LOGGER.warn("LcOutput request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, lcOutputMessage.getOutputStatus());
                response = lcStatResponse.getContent();
                this.sendSpontanousResponse(response);
                response = null;
            } else {
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
            if (port != null) {
                switch (outputType) {
                    case LIGHTPORT: {
                        this.publishLightPortChange((Port<?>)port);
                        break;
                    }
                    case SWITCHPORT: {
                        this.publishSwitchPortChange((Port<?>)port);
                        break;
                    }
                    case SERVOPORT: {
                        this.publishServoPortChange((Port<?>)port);
                        break;
                    }
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishLightPortChange(Port<?> port) {
        LightPort lightPort = (LightPort)port;
        LightPortStatus status = (LightPortStatus)lightPort.getStatus();
        LOGGER.info("The lightport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new LightPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), lightPort.getId(), status));
    }

    private void publishSwitchPortChange(Port<?> port) {
        SwitchPort switchPort = (SwitchPort)port;
        SwitchPortStatus status = (SwitchPortStatus)switchPort.getStatus();
        LOGGER.info("The switchport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new SwitchPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), switchPort.getId(), status));
    }

    private void publishServoPortChange(Port<?> port) {
        ServoPort servoPort = (ServoPort)port;
        Integer value = servoPort.getValue();
        LOGGER.info("The servoport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new ServoPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), servoPort.getId(), value));
    }

    protected byte[] processLcConfigGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigGetMessage lcConfigGetMessage = (LcConfigGetMessage)bidibMessage;
            LcOutputType outputType = lcConfigGetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigGetMessage.getPortNumber(this.getPortModel());
            Port port = null;
            switch (outputType) {
                case LIGHTPORT: {
                    port = (Port)this.lightPorts.get(outputNumber);
                    break;
                }
                case SWITCHPORT: {
                    port = (Port)this.switchPorts.get(outputNumber);
                    break;
                }
                case SERVOPORT: {
                    port = (Port)this.servoPorts.get(outputNumber);
                    break;
                }
                case INPUTPORT: {
                    port = (Port)this.inputPorts.get(outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigResponse lcConfigResponse = new LcConfigResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, port.getPortConfig());
                response = lcConfigResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfig response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigSetMessage lcConfigSetMessage = (LcConfigSetMessage)bidibMessage;
            LcOutputType outputType = lcConfigSetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigSetMessage.getPortNumber(this.getPortModel());
            InputPort port = null;
            switch (outputType) {
                case LIGHTPORT: {
                    LightPort lightPort = this.lightPorts.get(outputNumber);
                    if (lightPort != null) {
                        lightPort.setPortConfig(lcConfigSetMessage.getPortConfig());
                        port = lightPort;
                        break;
                    }
                    LOGGER.warn("Lightport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case SWITCHPORT: {
                    SwitchPort switchPort = this.switchPorts.get(outputNumber);
                    if (switchPort != null) {
                        switchPort.setPortConfig(lcConfigSetMessage.getPortConfig());
                        port = switchPort;
                        break;
                    }
                    LOGGER.warn("Switchport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case SERVOPORT: {
                    ServoPort servoPort = this.servoPorts.get(outputNumber);
                    if (servoPort != null) {
                        servoPort.setPortConfig(lcConfigSetMessage.getPortConfig());
                        port = servoPort;
                        break;
                    }
                    LOGGER.warn("Servoport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case INPUTPORT: {
                    InputPort inputPort = this.inputPorts.get(outputNumber);
                    if (inputPort != null) {
                        LOGGER.warn("The input port has no config to set.");
                        port = inputPort;
                        break;
                    }
                    LOGGER.warn("Inputport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigResponse lcConfigResponse = new LcConfigResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, port.getPortConfig());
                response = lcConfigResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
            LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
            InputPort port = null;
            switch (outputType) {
                case INPUTPORT: {
                    InputPort inputPort = this.inputPorts.get(outputNumber);
                    if (inputPort != null) {
                        inputPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = inputPort;
                        break;
                    }
                    LOGGER.warn("Inputport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case LIGHTPORT: {
                    LightPort lightPort = this.lightPorts.get(outputNumber);
                    if (lightPort != null) {
                        lightPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = lightPort;
                        break;
                    }
                    LOGGER.warn("Lightport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case SWITCHPORT: {
                    SwitchPort switchPort = this.switchPorts.get(outputNumber);
                    if (switchPort != null) {
                        switchPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = switchPort;
                        break;
                    }
                    LOGGER.warn("Switchport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case SERVOPORT: {
                    ServoPort servoPort = this.servoPorts.get(outputNumber);
                    if (servoPort != null) {
                        servoPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = servoPort;
                        break;
                    }
                    LOGGER.warn("Servoport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigX lcConfigX = new LcConfigX(bidibPort, lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                response = lcConfigXResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
            int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
            LcOutputType lcOutputType = lcConfigXGetMessage.getPortType(this.getPortModel());
            Port port = null;
            LinkedHashMap<Byte, Object> values = new LinkedHashMap<Byte, Object>();
            switch (lcOutputType) {
                case LIGHTPORT: {
                    port = (Port)this.lightPorts.get(outputNumber);
                    LightPort lightPort = (LightPort)port;
                    values.put((byte)1, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMax()))));
                    values.put((byte)2, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMin()))));
                    values.put((byte)3, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMax()))));
                    values.put((byte)4, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMin()))));
                    if (lightPort.getRgbValue() != null) {
                        values.put((byte)-128, new RgbPortConfigValue(lightPort.getRgbValue()));
                    }
                    if (lightPort.getTransitionTime() != null) {
                        values.put(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME, new Int16PortConfigValue(lightPort.getTransitionTime()));
                    }
                    if (!this.simulateTestErrors || outputNumber != 2) break;
                    values.put((byte)0, new BytePortConfigValue(Byte.valueOf((byte)12)));
                    break;
                }
                case SWITCHPORT: {
                    port = (Port)this.switchPorts.get(outputNumber);
                    SwitchPort switchPort = (SwitchPort)port;
                    values.put(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)switchPort.getOutputBehaviour().getType()))));
                    values.put((byte)11, new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchPort.getSwitchOffTime())));
                    break;
                }
                case SERVOPORT: {
                    port = (Port)this.servoPorts.get(outputNumber);
                    ServoPort servoPort = (ServoPort)port;
                    values.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getSpeed()))));
                    values.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getTrimDown()))));
                    values.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getTrimUp()))));
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)lcOutputType);
                }
            }
            LOGGER.info("Return config of port: {}", (Object)port);
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)outputNumber);
            LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
            LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
            response = lcConfigXResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        block24: {
            LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
            byte[] response = null;
            try {
                LcConfigXResponse lcConfigXResponse;
                LcConfigX lcConfigX;
                BidibPort bidibPort;
                LcConfigXGetAllMessage lcConfigXGetAllMessage = (LcConfigXGetAllMessage)bidibMessage;
                LcOutputType outputType = lcConfigXGetAllMessage.getPortTypeFrom(this.getPortModel());
                Map<Byte, BytePortConfigValue> values = new LinkedHashMap<Byte, BytePortConfigValue>();
                if (outputType != null) {
                    LOGGER.info("Get all ports for output type: {}", (Object)outputType);
                    switch (outputType) {
                        case SERVOPORT: {
                            for (ServoPort servoPort : this.servoPorts.values()) {
                                values.clear();
                                values.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getSpeed()))));
                                values.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getTrimDown()))));
                                values.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getTrimUp()))));
                                LOGGER.info("Return config of servo port: {}", (Object)servoPort);
                                BidibPort bidibPort2 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)servoPort.getId());
                                LcConfigX lcConfigX2 = new LcConfigX(bidibPort2, values);
                                LcConfigXResponse lcConfigXResponse2 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX2, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse2.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block24;
                        }
                        case SWITCHPORT: {
                            for (SwitchPort switchPort : this.switchPorts.values()) {
                                values.clear();
                                values.put(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)switchPort.getOutputBehaviour().getType()))));
                                values.put((byte)11, new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchPort.getSwitchOffTime())));
                                LOGGER.info("Return config of switch port: {}", (Object)switchPort);
                                BidibPort bidibPort3 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)switchPort.getId());
                                LcConfigX lcConfigX3 = new LcConfigX(bidibPort3, values);
                                LcConfigXResponse lcConfigXResponse3 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX3, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse3.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block24;
                        }
                        case LIGHTPORT: {
                            if (!this.lightPorts.isEmpty()) {
                                for (LightPort lightPort : this.lightPorts.values()) {
                                    values.clear();
                                    values.put((byte)1, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMax()))));
                                    if (this.simulateTestErrors && lightPort.getId() == 3) {
                                        LOGGER.warn("No BIDIB_PCFG_LEVEL_PORT_OFF for light port 3!");
                                    } else {
                                        values.put((byte)2, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMin()))));
                                    }
                                    values.put((byte)3, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMax()))));
                                    if (this.simulateTestErrors && lightPort.getId() == 3) {
                                        LOGGER.warn("No BIDIB_PCFG_DIMM_DOWN for light port 3!");
                                    } else {
                                        values.put((byte)4, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMin()))));
                                    }
                                    if (lightPort.getRgbValue() != null) {
                                        values.put((byte)-128, (BytePortConfigValue)new RgbPortConfigValue(lightPort.getRgbValue()));
                                    }
                                    if (lightPort.getTransitionTime() != null) {
                                        values.put(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME, (BytePortConfigValue)new Int16PortConfigValue(lightPort.getTransitionTime()));
                                    }
                                    LOGGER.info("Return config of light port: {}", (Object)lightPort);
                                    BidibPort bidibPort4 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)lightPort.getId());
                                    LcConfigX lcConfigX4 = new LcConfigX(bidibPort4, values);
                                    LcConfigXResponse lcConfigXResponse4 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX4, (PortModelEnum)this.getPortModel()));
                                    response = lcConfigXResponse4.getContent();
                                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                    this.sendSpontanousResponse(response);
                                    response = null;
                                }
                                break block24;
                            }
                            LOGGER.warn("No lightPorts configured.");
                            break;
                        }
                        case INPUTPORT: {
                            for (InputPort inputPort : this.inputPorts.values()) {
                                values.clear();
                                LOGGER.info("Return config of input port: {}", (Object)inputPort);
                                BidibPort bidibPort5 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)inputPort.getId());
                                LcConfigX lcConfigX5 = new LcConfigX(bidibPort5, values);
                                LcConfigXResponse lcConfigXResponse5 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX5, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse5.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block24;
                        }
                        default: {
                            LOGGER.warn("Unsupported port type requested: {}", (Object)outputType);
                            break;
                        }
                    }
                    break block24;
                }
                for (ServoPort servoPort : this.servoPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of servo port: {}", (Object)servoPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.SERVOPORT, (int)servoPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (SwitchPort switchPort : this.switchPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of switch port: {}", (Object)switchPort);
                    values = switchPort.getPortConfigX();
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.SWITCHPORT, (int)switchPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (InputPort inputPort : this.inputPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of input port: {}", (Object)inputPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.INPUTPORT, (int)inputPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (LightPort lightPort : this.lightPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of light port: {}", (Object)lightPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.LIGHTPORT, (int)lightPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create lcConfigXResponse response failed.", (Throwable)ex);
            }
        }
    }

    protected byte[] processLcKeyQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcKeyQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte keyState = 0;
        Port port = null;
        try {
            LcKeyMessage lcKeyMessage = (LcKeyMessage)bidibMessage;
            int portNumber = lcKeyMessage.getBidibPort().getPortNumber(PortModelEnum.type);
            port = (Port)this.inputPorts.get(portNumber);
            keyState = port.getStatus().getType().getType();
            LcKeyResponse lcKeyResponse = new LcKeyResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)portNumber), keyState);
            response = lcKeyResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcKey response failed.", (Throwable)ex);
        }
        if (port != null) {
            this.publishInputPortChange(port);
        }
        return response;
    }

    private void publishInputPortChange(Port<?> port) {
        InputPort inputPort = (InputPort)port;
        InputPortStatus status = (InputPortStatus)inputPort.getStatus();
        LOGGER.info("The inputport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new InputPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), inputPort.getId(), status));
    }

    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutputQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte portState = 0;
        try {
            LcPortQueryMessage lcPortQueryMessage = (LcPortQueryMessage)bidibMessage;
            LcOutputType outputType = lcPortQueryMessage.getPortType(this.getPortModel());
            int portNumber = lcPortQueryMessage.getPortNumber(this.getPortModel());
            switch (outputType) {
                case INPUTPORT: {
                    portState = ((InputPortStatus)this.inputPorts.get(portNumber).getStatus()).getType().getType();
                    break;
                }
                case LIGHTPORT: {
                    portState = ((LightPortStatus)this.lightPorts.get(portNumber).getStatus()).getType().getType();
                    break;
                }
                case SWITCHPORT: {
                    portState = ((SwitchPortStatus)this.switchPorts.get(portNumber).getStatus()).getType().getType();
                    break;
                }
                case SERVOPORT: {
                    portState = ByteUtils.getLowByte((Integer)this.servoPorts.get(portNumber).getValue());
                    break;
                }
                default: {
                    LOGGER.warn("LcOutputQuery for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
            LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
            response = lcStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcPortQueryAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the PortQueryAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            byte portStatus;
            LcPortQueryAllMessage portQueryAllMessage = (LcPortQueryAllMessage)bidibMessage;
            int portRangeFrom = portQueryAllMessage.getPortRangeFrom(this.getPortModel());
            int portRangeTo = portQueryAllMessage.getPortRangeTo(this.getPortModel());
            int portTypeMask = portQueryAllMessage.getPortTypeMask();
            LOGGER.info("Query all port states, portRangeFrom: {}, portRangeTo: {}, portModel: {}, portTypeMask: {}", new Object[]{portRangeFrom, portRangeTo, this.getPortModel(), portTypeMask});
            if (PortConfigUtils.isSupportsInputPort((int)portTypeMask) && MapUtils.isNotEmpty(this.inputPorts)) {
                for (InputPort inputPort : this.inputPorts.values()) {
                    if (inputPort.getId() >= portRangeFrom && inputPort.getId() < portRangeTo) {
                        try {
                            InputPortStatus inputPortStatus = (InputPortStatus)inputPort.getStatus();
                            if (inputPortStatus == null) {
                                inputPort.setStatus((BidibStatus)InputPortStatus.OFF);
                                inputPortStatus = (InputPortStatus)inputPort.getStatus();
                            }
                            portStatus = inputPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.INPUTPORT, inputPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)inputPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip input port that is out of port range: {}", (Object)inputPort);
                }
            }
            if (PortConfigUtils.isSupportsLightPort((int)portTypeMask) && MapUtils.isNotEmpty(this.lightPorts)) {
                for (LightPort lightPort : this.lightPorts.values()) {
                    if (lightPort.getId() >= portRangeFrom && lightPort.getId() < portRangeTo) {
                        try {
                            LightPortStatus lightPortStatus = (LightPortStatus)lightPort.getStatus();
                            if (lightPortStatus == null) {
                                lightPort.setStatus((BidibStatus)LightPortStatus.OFF);
                                lightPortStatus = (LightPortStatus)lightPort.getStatus();
                            }
                            portStatus = lightPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.LIGHTPORT, lightPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)lightPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip light port that is out of port range: {}", (Object)lightPort);
                }
            }
            if (PortConfigUtils.isSupportsSwitchPort((int)portTypeMask) && MapUtils.isNotEmpty(this.switchPorts)) {
                for (SwitchPort switchPort : this.switchPorts.values()) {
                    if (switchPort.getId() >= portRangeFrom && switchPort.getId() < portRangeTo) {
                        try {
                            SwitchPortStatus switchPortStatus = (SwitchPortStatus)switchPort.getStatus();
                            if (switchPortStatus == null) {
                                switchPort.setStatus((BidibStatus)SwitchPortStatus.OFF);
                                switchPortStatus = (SwitchPortStatus)switchPort.getStatus();
                            }
                            portStatus = switchPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.SWITCHPORT, switchPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)switchPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip switch port that is out of port range: {}", (Object)switchPort);
                }
            }
            if (PortConfigUtils.isSupportsServoPort((int)portTypeMask) && MapUtils.isNotEmpty(this.servoPorts)) {
                for (ServoPort servoPort : this.servoPorts.values()) {
                    if (servoPort.getId() >= portRangeFrom && servoPort.getId() < portRangeTo) {
                        try {
                            ServoPortStatus servoPortStatus = (ServoPortStatus)servoPort.getStatus();
                            if (servoPortStatus == null) {
                                servoPort.setStatus((BidibStatus)ServoPortStatus.START);
                                servoPortStatus = (ServoPortStatus)servoPort.getStatus();
                            }
                            portStatus = servoPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.SERVOPORT, servoPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)servoPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip servo port that is out of port range: {}", (Object)servoPort);
                }
            }
            LOGGER.info("Send the terminating LC_NA message.");
            this.publishLcNaResponse(bidibMessage.getAddr());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void publishPortState(byte[] address, LcOutputType outputType, int outputNumber, byte portStatus) throws ProtocolException {
        BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
        LcStatResponse lcStatResponse = new LcStatResponse(address, this.getNextSendNum(), bidibPort, portStatus);
        LOGGER.info("Prepared LcStatResponse: {}", (Object)lcStatResponse);
        byte[] response = lcStatResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected void publishLcNaResponse(byte[] address) throws ProtocolException {
        BidibPort bidibPort = new BidibPort(new byte[]{ByteUtils.getLowByte((int)255), ByteUtils.getLowByte((int)255)});
        LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(address, this.getNextSendNum(), bidibPort);
        LOGGER.info("Prepared LcNotAvailableResponse: {}", (Object)lcNotAvailableResponse);
        byte[] response = lcNotAvailableResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected byte[] processLcMacroParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroParaGetMessage lcMacroParaGetMessage = (LcMacroParaGetMessage)bidibMessage;
            int macroNumber = lcMacroParaGetMessage.getMacroNumber();
            int paramId = lcMacroParaGetMessage.getParameterIndex();
            LOGGER.info("Process macroNumber: {}, paramId: {}", (Object)macroNumber, (Object)paramId);
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                LOGGER.info("Create new MacroContainer for macro number: {}", (Object)macroNumber);
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            byte[] parameter = container.getMacroParameter(paramId);
            LcMacroParaResponse lcMacroParaResponse = new LcMacroParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)macroNumber, (byte)paramId, parameter);
            response = lcMacroParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroParaSetMessage lcMacroParaSetMessage = (LcMacroParaSetMessage)bidibMessage;
            int macroNumber = lcMacroParaSetMessage.getMacroNumber();
            int paramId = lcMacroParaSetMessage.getParameterIndex();
            byte[] parameter = lcMacroParaSetMessage.getValue();
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            container.setMacroParameter(paramId, parameter);
            LcMacroParaResponse lcMacroParaResponse = new LcMacroParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)macroNumber, (byte)paramId, parameter);
            response = lcMacroParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroHandleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroHandle request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroHandleMessage lcMacroHandleMessage = (LcMacroHandleMessage)bidibMessage;
            Integer macroNumber = lcMacroHandleMessage.getMacroNumber();
            LcMacroOperationCode lcMacroOperationCode = lcMacroHandleMessage.getMacroOperationCode();
            LOGGER.info("Handle macro request, macroNumber: {}, lcMacroOperationCode: {}", (Object)macroNumber, (Object)lcMacroOperationCode);
            LcMacroState macroState = null;
            switch (lcMacroOperationCode) {
                case START: {
                    macroState = LcMacroState.RUNNING;
                    break;
                }
                case DELETE: {
                    macroState = LcMacroState.DELETE;
                    LOGGER.info("Remove macro with number: {}", (Object)macroNumber);
                    this.macros.remove(macroNumber);
                    break;
                }
                case OFF: {
                    macroState = LcMacroState.OFF;
                    break;
                }
                case RESTORE: {
                    macroState = LcMacroState.RESTORE;
                    break;
                }
                case SAVE: {
                    macroState = LcMacroState.SAVE;
                    break;
                }
                default: {
                    macroState = LcMacroState.NOTEXIST;
                }
            }
            LcMacroStateResponse lcMacroStateResponse = new LcMacroStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((Integer)macroNumber).byteValue(), macroState);
            response = lcMacroStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacro macroStep;
            LcMacroGetMessage lcMacroGetMessage = (LcMacroGetMessage)bidibMessage;
            Integer macroNumber = lcMacroGetMessage.getMacroNumber();
            int stepNumber = lcMacroGetMessage.getStep();
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            LcMacro value = macroStep = container.getMacroStep(stepNumber);
            LcMacroResponse lcMacroResponse = new LcMacroResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((Integer)macroNumber).byteValue(), ByteUtils.getLowByte((int)stepNumber), value);
            response = lcMacroResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacro response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroSetMessage lcMacroSetMessage = (LcMacroSetMessage)bidibMessage;
            int macroNumber = lcMacroSetMessage.getMacroNumber();
            int stepNumber = lcMacroSetMessage.getStep();
            LcMacro macroStep = MacroUtils.getMacro((byte[])lcMacroSetMessage.getData());
            LOGGER.info("Current macroNumber: {}, stepNumber: {}, macroStep: {}", new Object[]{macroNumber, stepNumber, macroStep});
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            container.setMacroStep(stepNumber, macroStep);
            try {
                LcMacroResponse lcMacroResponse = new LcMacroResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)macroNumber), ByteUtils.getLowByte((int)stepNumber), macroStep);
                response = lcMacroResponse.getContent();
            }
            catch (NullPointerException npe) {
                LOGGER.warn("create response failed.", (Throwable)npe);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacro response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{0, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryGetMessage accessoryGetMessage = (AccessoryGetMessage)bidibMessage;
            int accessoryNumber = accessoryGetMessage.getAccessoryNumber();
            int aspect = 0;
            byte[] value = new byte[]{3, 0, 0};
            Feature featureAccessoryMacroMapped = Feature.findFeature((Collection)this.features, (int)42);
            if (featureAccessoryMacroMapped != null && featureAccessoryMacroMapped.getValue() > 0) {
                value[0] = 0;
                if (accessoryNumber == 2) {
                    value[0] = 8;
                    aspect = 2;
                }
            }
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGetAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            Feature featureAccessoryCount = Feature.findFeature((Collection)this.features, (int)40);
            int accessoryCount = featureAccessoryCount.getValue();
            int aspect = 0;
            for (int accessoryNumber = 0; accessoryNumber < accessoryCount; ++accessoryNumber) {
                byte[] value = new byte[]{3, 0, 0};
                Feature featureAccessoryMacroMapped = Feature.findFeature((Collection)this.features, (int)42);
                if (featureAccessoryMacroMapped != null && featureAccessoryMacroMapped.getValue() > 0) {
                    value[0] = 0;
                    if (accessoryNumber == 2) {
                        value[0] = 8;
                        aspect = 2;
                    }
                }
                LOGGER.info("Return data for accessory: {}, data: {}", (Object)accessoryNumber, (Object)ByteUtils.bytesToHex((byte[])value));
                AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
                response = accessoryStateResponse.getContent();
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return null;
    }

    protected byte[] processAccessoryParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaSetMessage accessoryParaSetMessage = (AccessoryParaSetMessage)bidibMessage;
            int accessoryNumber = accessoryParaSetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaSetMessage.getParaNumber();
            byte[] value = accessoryParaSetMessage.getValue();
            if (accessoryNumber == 3 && paraNumber == 253) {
                LOGGER.info("Do not allow change PARA_MACROMAP for accessory number 3!");
                value = new byte[]{0, 1, 2, 3};
            }
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            byte[] value = new byte[]{0, 0, 0, 0};
            if (paraNumber == 254) {
                LOGGER.info("The param is not known currently!");
                value = new byte[]{ByteUtils.getLowByte((int)paraNumber)};
                paraNumber = 255;
            } else if (paraNumber == 253) {
                value = new byte[]{0, 1, 2, 3};
            }
            if (accessoryNumber == 2 && paraNumber == 253) {
                LOGGER.info("Do not signal PARA_MACROMAP for accessory number 2!");
                value = new byte[]{ByteUtils.getLowByte((int)paraNumber)};
                paraNumber = 255;
            }
            if (accessoryNumber == 2 && paraNumber == 252) {
                LOGGER.info("PARA_STARTUP == 2 for accessory number 2!");
                value = new byte[]{ByteUtils.getLowByte((int)2)};
            }
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processBmGetRangeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackGetRangeMessage: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            FeedbackGetRangeMessage feedbackGetRangeMessage = (FeedbackGetRangeMessage)bidibMessage;
            int baseAddress = feedbackGetRangeMessage.getBeginRange();
            int end = feedbackGetRangeMessage.getEndRange();
            int feedbackSize = feedbackGetRangeMessage.getEndRange() - feedbackGetRangeMessage.getBeginRange();
            int value = 0;
            int index = 0;
            int feedbackByteSize = feedbackSize / 8 + (feedbackSize % 8 > 0 ? 1 : 0);
            byte[] feedbackMultiple = new byte[feedbackByteSize];
            int position = feedbackMultiple.length;
            for (int portNum = end; portNum > baseAddress; --portNum) {
                value = (byte)((value & 0xFF) << 1);
                FeedbackPort fbp = this.feedbackPorts.get(portNum - 1);
                int status = 0;
                if (fbp != null) {
                    status = ByteUtils.getLowByte((int)((FeedbackPortStatus)fbp.getStatus()).getType().getType(), (int)1);
                }
                feedbackMultiple[position - 1] = value = (int)((byte)(value | status));
                if (++index <= 7) continue;
                value = 0;
                index = 0;
                --position;
            }
            LOGGER.info("Prepared feedback multiple: {}", (Object)ByteUtils.bytesToHex((byte[])feedbackMultiple));
            FeedbackMultipleResponse feedbackMultipleResponse = new FeedbackMultipleResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)baseAddress), ByteUtils.getLowByte((int)feedbackSize), feedbackMultiple);
            response = feedbackMultipleResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackMultiple response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processBmMirrorMultipleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackMirrorMultipleMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorOccupiedRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorOccupiedRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorFreeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorFreeRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    public void queryStatus(Class<?> portClass) {
        if (InputPort.class.equals(portClass)) {
            for (InputPort inputPort : this.inputPorts.values()) {
                this.publishInputPortChange((Port<?>)inputPort);
            }
        } else if (LightPort.class.equals(portClass)) {
            for (LightPort lightPort : this.lightPorts.values()) {
                this.publishLightPortChange((Port<?>)lightPort);
            }
        } else if (SwitchPort.class.equals(portClass)) {
            for (SwitchPort switchPort : this.switchPorts.values()) {
                this.publishSwitchPortChange((Port<?>)switchPort);
            }
        } else if (ServoPort.class.equals(portClass)) {
            for (ServoPort servoPort : this.servoPorts.values()) {
                this.publishServoPortChange((Port<?>)servoPort);
            }
        } else if (FeedbackPort.class.equals(portClass)) {
            for (FeedbackPort feedbackPort : this.feedbackPorts.values()) {
                this.publishFeedbackPortChange((Port<?>)feedbackPort);
            }
            this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
        }
    }

    public void setPortsConfig(FlatPortType portType) {
    }

    public void setPortsConfig(PortType portType) {
        if (portType == null) {
            return;
        }
        LOGGER.debug("Set the ports config: {}", (Object)portType);
        if (portType instanceof LightPortType) {
            LightPortType lightPortType = (LightPortType)portType;
            this.lightPortCount = lightPortType.getCount();
            LOGGER.info("Total number of lightports: {}", (Object)this.lightPortCount);
            this.lightPorts.clear();
            for (int portId = 0; portId < this.lightPortCount; ++portId) {
                LightPort lightPort = new LightPort();
                lightPort.setId(portId);
                this.lightPorts.put(portId, lightPort);
            }
            this.prepareLightPortCvValuesFromConfig(lightPortType);
        } else if (portType instanceof SwitchPortType) {
            this.switchPortCount = portType.getCount();
            LOGGER.info("Configured number of switch ports: {}", (Object)this.switchPortCount);
        } else if (portType instanceof InputPortType) {
            this.inputPortCount = portType.getCount();
            this.inputPortOffset = portType.getOffset() != null ? portType.getOffset() : 0;
            LOGGER.info("Configured number of input ports: {}", (Object)this.inputPortCount);
        } else if (portType instanceof ServoPortType) {
            this.servoPortCount = portType.getCount();
        }
    }

    protected void prepareLightPortCvValuesFromConfig(LightPortType lightPortType) {
        if (CollectionUtils.isNotEmpty((Collection)lightPortType.getPort())) {
            int cvBaseOffset = 215;
            for (LightPortParamsType portParams : lightPortType.getPort()) {
                LightPort lightPort = new LightPort();
                lightPort.setId(portParams.getPortId());
                lightPort.setDimMin(portParams.getDimSlopeDown());
                lightPort.setDimMax(portParams.getDimSlopeUp());
                lightPort.setPwmMax(portParams.getIntensityOn());
                lightPort.setPwmMin(portParams.getIntensityOff());
                if (portParams.getRgbValue() != null) {
                    try {
                        Integer rgbValue = Integer.parseInt(portParams.getRgbValue(), 16);
                        lightPort.setRgbValue(rgbValue);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Parse RGB value failed: {}", (Object)portParams.getRgbValue(), (Object)ex);
                        lightPort.setRgbValue(null);
                    }
                }
                if (portParams.getTransitionTime() != null) {
                    lightPort.setTransitionTime(portParams.getTransitionTime());
                }
                lightPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
                lightPort.setStatus((BidibStatus)LightPortStatus.OFF);
                LOGGER.info("Add configured port: {}", (Object)lightPort);
                this.lightPorts.put(lightPort.getId(), lightPort);
                int cvOffset = 215 + portParams.getPortId() * 7;
                this.configurationVariables.put(String.valueOf(cvOffset), String.valueOf(-1));
                this.configurationVariables.put(String.valueOf(cvOffset + 1), String.valueOf(lightPort.getPwmMin()));
                this.configurationVariables.put(String.valueOf(cvOffset + 2), String.valueOf(lightPort.getPwmMax()));
                this.configurationVariables.put(String.valueOf(cvOffset + 3), String.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMin())));
                this.configurationVariables.put(String.valueOf(cvOffset + 4), String.valueOf(ByteUtils.getHighByte((int)lightPort.getDimMin())));
                this.configurationVariables.put(String.valueOf(cvOffset + 5), String.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMax())));
                this.configurationVariables.put(String.valueOf(cvOffset + 6), String.valueOf(ByteUtils.getHighByte((int)lightPort.getDimMax())));
            }
            this.lightPortCount = this.lightPorts.size();
        }
    }

    public int getInputPortOffset() {
        return this.inputPortOffset;
    }

    protected void setFeedbackPortStatus(FeedbackPortSetStatusEvent statusEvent) throws ProtocolException {
        int portNum = statusEvent.getPortNum();
        FeedbackPort port = this.feedbackPorts.get(portNum);
        if (port != null) {
            FeedbackFreeResponse response = null;
            switch (statusEvent.getStatus()) {
                case OCCUPIED: {
                    port.setStatus(FeedbackPortStatus.OCCUPIED);
                    if (this.hasTimestampFeature()) {
                        response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum, this.getTimestamp());
                        break;
                    }
                    response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                    break;
                }
                default: {
                    port.setStatus(FeedbackPortStatus.FREE);
                    response = new FeedbackFreeResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                }
            }
            LOGGER.info("Prepared the FeedbackFreeResponse: {}", (Object)response);
            this.sendSpontanousResponse(response.getContent());
            this.publishFeedbackPortChange((Port<?>)port);
        } else {
            LOGGER.warn("The requested feedback port is not available: {}", (Object)portNum);
        }
    }

    private void publishFeedbackPortChange(Port<?> port) {
        FeedbackPort feedbackPort = (FeedbackPort)port;
        FeedbackPortStatus status = (FeedbackPortStatus)feedbackPort.getStatus();
        LOGGER.info("The feedbackport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getId(), status));
    }

    private int getTimestamp() {
        this.timestamp += 10;
        if (this.timestamp > 65000) {
            this.timestamp = 0;
        }
        return this.timestamp;
    }

    private boolean hasTimestampFeature() {
        Feature feature = Feature.findFeature((Collection)this.features, (int)30);
        return feature != null && feature.getValue() > 0;
    }

    protected byte[] processBmGetConfidenceRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            byte valid = (byte)(this.statusValid.get() ? 1 : 0);
            byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
            byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(bidibMessage.getAddr(), this.getNextSendNum(), valid, freeze, signal);
            response = feedbackConfidenceResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackConfidence response failed.", (Throwable)ex);
        }
        return response;
    }

    private void triggerFeedbackAddressResponse(int portNum) {
        LOGGER.info("Trigger the feedback address repsonse, portNum: {}", (Object)portNum);
        byte[] response = null;
        LinkedList<FeedbackAddressData> addresses = new LinkedList<FeedbackAddressData>();
        byte lowByte = 3;
        byte highByte = ByteUtils.getLowByte((int)128);
        int address = ByteUtils.getWord((byte)lowByte, (byte)((byte)(highByte & 0x3F)));
        AddressData addressDataIn = new AddressData(address, AddressTypeEnum.valueOf((byte)((byte)((highByte & 0xC0) >> 6))));
        addresses.add(new FeedbackAddressData(addressDataIn.getAddress(), EnrailmentDirectionEnum.LOCOMOTIVE_RIGHT));
        try {
            FeedbackPort feedbackPort = this.feedbackPorts.get(portNum);
            int detectorNumber = feedbackPort.getId();
            ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
            if (FeedbackPortStatus.OCCUPIED == feedbackPort.getStatus() && CollectionUtils.isNotEmpty(addresses)) {
                for (FeedbackAddressData addressData : addresses) {
                    EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                    AddressTypeEnum addressType = null;
                    switch (enrailmentDirection) {
                        case LOCOMOTIVE_LEFT: 
                        case LOCOMOTIVE_RIGHT: {
                            addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                            break;
                        }
                        case BASIC_ACCESSORY: {
                            addressType = AddressTypeEnum.ACCESSORY;
                            break;
                        }
                        case EXTENDED_ACCESSORY: {
                            addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                            break;
                        }
                    }
                    AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                    bidibAddresses.add(bidibAddress);
                }
            }
            FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(this.nodeAddress, this.getNextSendNum(), detectorNumber, bidibAddresses);
            response = feedbackAddressResponse.getContent();
            this.sendSpontanousResponse(response);
            if (FeedbackPortStatus.OCCUPIED == feedbackPort.getStatus()) {
                int speedValue = ThreadLocalRandom.current().nextInt(2, 100);
                FeedbackSpeedResponse feedbackSpeedResponse = new FeedbackSpeedResponse(this.nodeAddress, this.getNextSendNum(), address, speedValue);
                this.sendSpontanousResponse(feedbackSpeedResponse.getContent());
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create FeedbackAddressResponse failed.", (Throwable)ex);
        }
    }

    @EventSubscriber(eventClass=FeedbackConfidenceSetEvent.class)
    public void feedbackConfidenceSetEvent(FeedbackConfidenceSetEvent feedbackConfidenceEvent) {
        String nodeAddress = feedbackConfidenceEvent.getNodeAddr();
        LOGGER.info("The change of the feedback confidence was requested, nodeAddress: {}", (Object)nodeAddress);
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        this.statusValid.set(feedbackConfidenceEvent.getValid());
        this.statusFreeze.set(feedbackConfidenceEvent.getFreeze());
        this.statusSignal.set(feedbackConfidenceEvent.getSignal());
        byte valid = (byte)(this.statusValid.get() ? 1 : 0);
        byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
        byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
        try {
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(this.nodeAddress, this.getNextSendNum(), valid, freeze, signal);
            LOGGER.info("Prepared feedbackConfidenceResponse: {}", (Object)feedbackConfidenceResponse);
            this.sendSpontanousResponse(feedbackConfidenceResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send feedbackConfidenceResponse failed.", (Throwable)ex);
        }
        this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
    }

    private void publishFeedbackConfidenceStatusEvent(boolean valid, boolean freeze, boolean signal) {
        LOGGER.info("The feedbackport confidence status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackConfidenceStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), valid, freeze, signal));
    }
}

