/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.StringGetMessage;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.message.StringSetMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulator(vid="13", pid="149")
public class MotFuncSimulator
extends DefaultNodeSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotFuncSimulator.class);
    private String[] stringValue = new String[]{"", "MotFunc_Sim"};
    private static final String PATTERN_WRITE_COMMAND_WITH_ADDRESS = "^W([0-9a-z]+)=(.*)";
    private static final String PATTERN_WRITE_COMMAND = "^W=(.*)";
    private static final String PATTERN_WRITE_COMMAND_FINISH = "^S=(.*)";
    private static final String PATTERN_READ_COMMAND_WITH_ADDRESS = "^R([0-9a-z]+)=";
    private Pattern pWriteCommandWithAddress;
    private Pattern pWriteCommand;
    private Pattern pWriteCommandFinish;
    private Pattern pReadCommandWithAddress;
    private final StringBuilder decoderConfig = new StringBuilder();
    private final StringBuilder motFuncConfig = new StringBuilder();
    private StorageTargetIndex storageTarget;
    private static final String CMD_RESULT_OK = "RES=OK";
    private static final String CMD_RESULT_NOK = "RES=NOK";
    private static final String CMD_END_OF_TRANSMISSION = "S=";

    public MotFuncSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        this.features.add(new Feature(250, 8));
    }

    public void postConstruct() {
        super.postConstruct();
        this.pWriteCommandWithAddress = Pattern.compile(PATTERN_WRITE_COMMAND_WITH_ADDRESS);
        this.pWriteCommand = Pattern.compile(PATTERN_WRITE_COMMAND);
        this.pWriteCommandFinish = Pattern.compile(PATTERN_WRITE_COMMAND_FINISH);
        this.pReadCommandWithAddress = Pattern.compile(PATTERN_READ_COMMAND_WITH_ADDRESS);
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    protected byte[] processStringSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the stringSet request.");
        byte[] response = null;
        try {
            StringSetMessage stringSetMessage = (StringSetMessage)bidibMessage;
            int namespace = stringSetMessage.getNamespace();
            if (namespace == 0) {
                response = super.processStringSetRequest(bidibMessage);
            } else if (namespace == 3) {
                int stringId = stringSetMessage.getStringId();
                String stringValue = stringSetMessage.getString();
                this.storageTarget = stringId == 0 ? StorageTargetIndex.target_decoder : StorageTargetIndex.target_motfuc;
                String returnValue = null;
                Matcher matcherWriteCommandWithAddress = this.pWriteCommandWithAddress.matcher(stringValue);
                if (matcherWriteCommandWithAddress.find()) {
                    String addressString = matcherWriteCommandWithAddress.group(1);
                    String writeData = matcherWriteCommandWithAddress.group(2);
                    LOGGER.info("Found write with address command, address: {}, data: {}", (Object)addressString, (Object)writeData);
                    if (stringId >= 0 && stringId < 2) {
                        returnValue = CMD_RESULT_OK;
                        if (this.storageTarget == StorageTargetIndex.target_decoder) {
                            this.decoderConfig.setLength(0);
                            this.decoderConfig.append(writeData);
                        } else {
                            this.motFuncConfig.setLength(0);
                            this.motFuncConfig.append(writeData);
                        }
                    } else {
                        returnValue = CMD_RESULT_NOK;
                    }
                    StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringSetMessage.getNamespace()), ByteUtils.getLowByte((int)stringSetMessage.getStringId()), returnValue);
                    LOGGER.info("Prepared the stringResponse: {}", (Object)stringResponse);
                    return stringResponse.getContent();
                }
                Matcher matcherWriteCommand = this.pWriteCommand.matcher(stringValue);
                if (matcherWriteCommand.find()) {
                    String writeData = matcherWriteCommand.group(1);
                    LOGGER.info("Found write command, data: {}", (Object)writeData);
                    if (this.storageTarget == StorageTargetIndex.target_decoder) {
                        this.decoderConfig.append(writeData);
                    } else {
                        this.motFuncConfig.append(writeData);
                    }
                    return null;
                }
                Matcher matcherWriteCommandFinish = this.pWriteCommandFinish.matcher(stringValue);
                if (matcherWriteCommandFinish.find()) {
                    String writeData = matcherWriteCommandFinish.group(1);
                    LOGGER.info("Found write command finish, data: {}", (Object)writeData);
                    returnValue = CMD_RESULT_OK;
                    StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringSetMessage.getNamespace()), ByteUtils.getLowByte((int)stringSetMessage.getStringId()), returnValue);
                    LOGGER.info("Prepared the stringResponse: {}", (Object)stringResponse);
                    return stringResponse.getContent();
                }
                Matcher matcherReadCommandWithAddress = this.pReadCommandWithAddress.matcher(stringValue);
                if (matcherReadCommandWithAddress.find()) {
                    String addressString = matcherReadCommandWithAddress.group(1);
                    LOGGER.info("Found read with address command, address: {}", (Object)addressString);
                    if (stringId < 0 || stringId >= 2) {
                        returnValue = CMD_RESULT_NOK;
                        StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringSetMessage.getNamespace()), ByteUtils.getLowByte((int)stringSetMessage.getStringId()), returnValue);
                        LOGGER.info("Prepared the stringResponse: {}", (Object)stringResponse);
                        this.publishResponse(stringResponse.getContent());
                        return null;
                    }
                    returnValue = CMD_RESULT_OK;
                    StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringSetMessage.getNamespace()), ByteUtils.getLowByte((int)stringSetMessage.getStringId()), returnValue);
                    LOGGER.info("Prepared the stringResponse: {}", (Object)stringResponse);
                    this.publishResponse(stringResponse.getContent());
                    StringBuilder configSource = this.storageTarget == StorageTargetIndex.target_decoder ? this.decoderConfig : this.motFuncConfig;
                    if (configSource.length() > 0) {
                        DccTestPacketizer packetizer = new DccTestPacketizer();
                        packetizer.setDataToTransfer(configSource.toString());
                        while (packetizer.hasNext()) {
                            returnValue = packetizer.getNextReadChunk();
                            stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringSetMessage.getNamespace()), ByteUtils.getLowByte((int)stringSetMessage.getStringId()), returnValue);
                            LOGGER.info("Prepared the stringResponse: {}", (Object)stringResponse);
                            this.publishResponse(stringResponse.getContent());
                        }
                    }
                    returnValue = CMD_END_OF_TRANSMISSION;
                    stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringSetMessage.getNamespace()), ByteUtils.getLowByte((int)stringSetMessage.getStringId()), returnValue);
                    LOGGER.info("Prepared the stringResponse: {}", (Object)stringResponse);
                    this.publishResponse(stringResponse.getContent());
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create string response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processStringGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the stringGet request.");
        byte[] response = null;
        try {
            StringGetMessage stringGetMessage = (StringGetMessage)bidibMessage;
            int stringId = stringGetMessage.getStringId();
            LOGGER.info("Get STRING[{}]: {}", (Object)stringId, (Object)this.stringValue[stringId]);
            StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringGetMessage.getNamespace()), ByteUtils.getLowByte((int)stringGetMessage.getStringId()), this.stringValue[stringId]);
            response = stringResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create string response failed.", (Throwable)ex);
        }
        return response;
    }

    private static enum StorageTargetIndex {
        target_decoder,
        target_motfuc;

    }

    private static class DccTestPacketizer {
        public static final int DEFAULT_CHUNK_SIZE = 37;
        private String dataToTransfer;
        private int addressPointer;
        public static final String CMD_READ_CONTINUE = "H=";

        private DccTestPacketizer() {
        }

        public void reset() {
            this.addressPointer = 0;
        }

        public void setDataToTransfer(String dataToTransfer) {
            this.reset();
            this.dataToTransfer = dataToTransfer;
        }

        public boolean hasNext() {
            return this.dataToTransfer.length() > this.addressPointer;
        }

        public String getNextReadChunk() {
            return this.getNextDataChunk(CMD_READ_CONTINUE, 37);
        }

        private String getNextDataChunk(String prefix, int chunkSize) {
            StringBuilder sb = new StringBuilder(prefix);
            sb.append(this.getNextChunk(chunkSize));
            return sb.toString();
        }

        protected String getNextChunk(int chunkSize) {
            int oldAddressPointer = this.addressPointer;
            if (this.dataToTransfer.length() < oldAddressPointer + chunkSize) {
                chunkSize = this.dataToTransfer.length() - oldAddressPointer;
                LOGGER.info("Reduced chunksize to: {}", (Object)chunkSize);
            }
            String chunk = this.dataToTransfer.substring(oldAddressPointer, oldAddressPointer + chunkSize);
            LOGGER.info("Return chunk: {}", (Object)chunk);
            this.addressPointer += chunkSize;
            return chunk;
        }
    }
}

