/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaSetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigSetMessage;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="62", pid="152"), @BidibNodeSimulator(vid="62", pid="151")})
public class MultiDecoderSimulator
extends DefaultNodeSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiDecoderSimulator.class);
    private byte totalAspects = (byte)2;

    public MultiDecoderSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        this.features.add(new Feature(62, 0));
        this.features.add(new Feature(60, 0));
        this.features.add(new Feature(40, 8));
        this.features.add(new Feature(42, 0));
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 64: {
                response = this.processLcOutputRequest(bidibMessage);
                break;
            }
            case 66: {
                response = this.processLcConfigGetRequest(bidibMessage);
                break;
            }
            case 65: {
                response = this.processLcConfigSetRequest(bidibMessage);
                break;
            }
            case 56: {
                response = this.processAccessorySetRequest(bidibMessage);
                break;
            }
            case 57: {
                response = this.processAccessoryGetRequest(bidibMessage);
                break;
            }
            case 58: {
                response = this.processAccessoryParaSetRequest(bidibMessage);
                break;
            }
            case 59: {
                response = this.processAccessoryParaGetRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
            LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
            int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
            response = lcNotAvailableResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigGetMessage lcConfigGetMessage = (LcConfigGetMessage)bidibMessage;
            LcOutputType outputType = lcConfigGetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigGetMessage.getPortNumber(this.getPortModel());
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
            response = lcNotAvailableResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfig response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigSetMessage lcConfigSetMessage = (LcConfigSetMessage)bidibMessage;
            LcOutputType outputType = lcConfigSetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigSetMessage.getPortNumber(this.getPortModel());
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LOGGER.warn("No port assigned!");
            LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
            response = magicResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{this.totalAspects, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryGetMessage accessoryGetMessage = (AccessoryGetMessage)bidibMessage;
            int accessoryNumber = accessoryGetMessage.getAccessoryNumber();
            boolean aspect = true;
            byte[] value = new byte[]{this.totalAspects, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)(aspect ? 1 : 0), value);
            response = accessoryStateResponse.getContent();
            LOGGER.info("Return accessoryStateResponse: {}", (Object)accessoryStateResponse.toExtendedString());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaSetMessage accessoryParaSetMessage = (AccessoryParaSetMessage)bidibMessage;
            int accessoryNumber = accessoryParaSetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaSetMessage.getParaNumber();
            byte[] value = accessoryParaSetMessage.getValue();
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            if (paraNumber == 254) {
                LOGGER.info("The param BIDIB_ACCESSORY_SWITCH_TIME is known for accessory 0 and 1!");
                byte[] value = null;
                switch (accessoryNumber) {
                    case 0: {
                        value = new byte[]{ByteUtils.getLowByte((int)135)};
                        break;
                    }
                    case 1: {
                        value = new byte[]{ByteUtils.getLowByte((int)119)};
                        break;
                    }
                    default: {
                        value = new byte[]{ByteUtils.getLowByte((int)paraNumber)};
                        paraNumber = 255;
                    }
                }
                AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
                response = accessoryParaResponse.getContent();
            } else {
                byte[] value = new byte[]{0, 0, 0, 0};
                AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
                response = accessoryParaResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }
}

