/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Timer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.jbidibc.messages.enums.InputPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LightPortEnum;
import org.bidib.jbidibc.messages.enums.PortConfigStatus;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.FlatInputPortType;
import org.bidib.jbidibc.simulation.nodes.FlatPortType;
import org.bidib.jbidibc.simulation.nodes.FlatServoPortType;
import org.bidib.jbidibc.simulation.nodes.FlatSwitchPortType;
import org.bidib.jbidibc.simulation.nodes.PortParamsType;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.simulation.LightControlSimulator;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.LightPortStatusEvent;
import org.bidib.wizard.simulation.events.ServoPortStatusEvent;
import org.bidib.wizard.simulation.events.SwitchPortStatusEvent;
import org.bidib.wizard.simulation.ports.GenericSimulationPort;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="117"), @BidibNodeSimulator(vid="13", pid="140"), @BidibNodeSimulator(vid="13", pid="141"), @BidibNodeSimulator(vid="13", pid="142"), @BidibNodeSimulator(vid="13", pid="122"), @BidibNodeSimulator(vid="13", pid="143"), @BidibNodeSimulator(vid="13", pid="144"), @BidibNodeSimulator(vid="13", pid="145")})
public class OneControlSimulator
extends LightControlSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneControlSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.OneControlPanel";
    protected static final int NUM_OF_FEEDBACK_PORTS = 20;
    private final Map<Integer, GenericSimulationPort> genericPorts = new HashMap<Integer, GenericSimulationPort>();
    private final Map<Integer, FeedbackPort> feedbackPorts = new HashMap<Integer, FeedbackPort>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusValid = new AtomicBoolean();
    private final AtomicBoolean statusSignal = new AtomicBoolean();
    private Timer simulationTimer;
    private List<String> accessoryResponseList = new ArrayList<String>();
    private int timestamp;

    public OneControlSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    @Override
    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        this.features.remove(new Feature(42, 2));
        this.features.add(new Feature(42, 8));
        if (MapUtils.isNotEmpty(this.feedbackPorts)) {
            this.features.add(new Feature(2, 1));
            this.features.add(new Feature(3, 0));
            this.features.add(new Feature(1, 1));
        }
    }

    @Override
    public void postConstruct() {
        super.postConstruct();
        this.features.add(new Feature(0, this.feedbackPorts.size()));
        Feature feature = this.getFeature(70);
        if (feature != null && MapUtils.isEmpty(this.genericPorts)) {
            LOGGER.info("The current simulator has the flat model configured. Prepare the generic ports.");
            int numPorts = feature.getValue();
            LOGGER.info("Create generic ports, numPorts: {}", (Object)numPorts);
            for (int portNumber = 0; portNumber < numPorts; ++portNumber) {
                GenericSimulationPort port = new GenericSimulationPort(portNumber);
                port.setPortValue(250);
                port.setPortStatus(portNumber % 2 == 0 ? InputPortStatus.ON.getType().getType() : InputPortStatus.OFF.getType().getType());
                this.genericPorts.put(portNumber, port);
            }
        } else {
            LOGGER.info("Skip init the ports because the ports are available already.");
            if (MapUtils.isNotEmpty(this.genericPorts)) {
                LOGGER.info("Set the feature FEATURE_CTRL_PORT_FLAT_MODEL to value: {}", (Object)this.genericPorts.size());
                this.features.add(new Feature(70, this.genericPorts.size()));
            }
        }
    }

    @Override
    protected void prepareCVs() {
        super.prepareCVs();
    }

    @Override
    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    @Override
    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        this.setupFeedbackPorts();
        super.start();
        if (!MapUtils.isEmpty(this.genericPorts)) {
            Map portConfig;
            GenericSimulationPort genericPort;
            int portNum;
            int index = 0;
            for (portNum = 0; portNum < this.servoPortCount; ++portNum) {
                genericPort = this.genericPorts.get(portNum + index);
                genericPort.setCurrentPortType(LcOutputType.SERVOPORT, 4);
                LinkedHashMap<Byte, BytePortConfigValue> portConfig2 = new LinkedHashMap<Byte, BytePortConfigValue>();
                portConfig2.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)20))));
                portConfig2.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)150))));
                portConfig2.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)4))));
                genericPort.setPortConfigX(portConfig2);
                genericPort.setPortValue(ServoPort.getAbsoluteValue((int)(portNum % 4 * 25)));
            }
            index += this.servoPortCount;
            for (portNum = 0; portNum < this.switchPortCount; ++portNum) {
                genericPort = this.genericPorts.get(portNum + index);
                int mask = 129;
                if ((portNum & 1) == 1) {
                    mask = 1;
                    genericPort.setCurrentPortType(LcOutputType.SWITCHPORT, mask);
                } else {
                    genericPort.setCurrentPortType(LcOutputType.SWITCHPAIRPORT, mask);
                }
                portConfig = genericPort.getPortConfigX();
                portConfig.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, new BytePortConfigValue(Byte.valueOf((byte)0)));
                portConfig.put((byte)11, new BytePortConfigValue(Byte.valueOf((byte)48)));
                genericPort.setPortConfigX(portConfig);
            }
            index = this.inputPortOffset;
            LOGGER.info("Set the port type for input ports, index: {}", (Object)index);
            for (portNum = 0; portNum < this.inputPortCount; ++portNum) {
                genericPort = this.genericPorts.get(portNum + index);
                int mask = 32897;
                genericPort.setCurrentPortType(LcOutputType.INPUTPORT, mask);
                LOGGER.info("The current port is configured as INPUT port: {}", (Object)genericPort);
                portConfig = genericPort.getPortConfigX();
                portConfig.remove((byte)-127);
                portConfig.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, new BytePortConfigValue(Byte.valueOf((byte)0)));
                portConfig.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, new BytePortConfigValue(Byte.valueOf((byte)0)));
                genericPort.setPortConfigX(portConfig);
            }
            GenericSimulationPort simPort = null;
            LOGGER.info("Prepare CV for OneControl.");
            for (Map.Entry cv : this.configurationVariables.entrySet()) {
                switch ((String)cv.getKey()) {
                    case "437": {
                        simPort = this.genericPorts.get(this.inputPortOffset);
                        break;
                    }
                    case "440": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 1);
                        break;
                    }
                    case "443": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 2);
                        break;
                    }
                    case "446": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 3);
                        break;
                    }
                    case "449": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 4);
                        break;
                    }
                    case "452": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 5);
                        break;
                    }
                    case "455": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 6);
                        break;
                    }
                    case "458": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 7);
                        break;
                    }
                    case "461": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 8);
                        break;
                    }
                    case "464": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 9);
                        break;
                    }
                    case "467": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 10);
                        break;
                    }
                    case "470": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 11);
                        break;
                    }
                    case "473": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 12);
                        break;
                    }
                    case "476": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 13);
                        break;
                    }
                    case "479": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 14);
                        break;
                    }
                    case "482": {
                        simPort = this.genericPorts.get(this.inputPortOffset + 15);
                        break;
                    }
                }
                simPort = null;
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    private void setupFeedbackPorts() {
        for (int id = 0; id < 20; ++id) {
            FeedbackPort port = new FeedbackPort();
            port.setId(id);
            port.setStatus(FeedbackPortStatus.FREE);
            this.feedbackPorts.put(id, port);
        }
        this.uniqueId = NodeUtils.setHasFeedbackFunctions((long)this.uniqueId);
        LOGGER.info("Set the feeback ports flag in the class. New uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((long)this.uniqueId));
    }

    @Override
    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 32: {
                response = this.processBmGetRangeRequest(bidibMessage);
                break;
            }
            case 33: {
                this.processBmMirrorMultipleRequest(bidibMessage);
                break;
            }
            case 34: {
                this.processBmMirrorOccupiedRequest(bidibMessage);
                break;
            }
            case 35: {
                this.processBmMirrorFreeRequest(bidibMessage);
                break;
            }
            case 36: {
                this.processBmAddrGetRangeRequest(bidibMessage);
                break;
            }
            case 37: {
                response = this.processBmGetConfidenceRequest(bidibMessage);
                break;
            }
            case 64: {
                response = this.processLcOutputRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected byte[] processBmGetRangeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackGetRangeMessage: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            FeedbackGetRangeMessage feedbackGetRangeMessage = (FeedbackGetRangeMessage)bidibMessage;
            int baseAddress = feedbackGetRangeMessage.getBeginRange();
            int end = feedbackGetRangeMessage.getEndRange();
            int feedbackSize = feedbackGetRangeMessage.getEndRange() - feedbackGetRangeMessage.getBeginRange();
            int value = 0;
            int index = 0;
            byte[] feedbackMultiple = new byte[feedbackSize / 8];
            int position = feedbackMultiple.length;
            for (int portNum = end; portNum > baseAddress; --portNum) {
                value = (byte)((value & 0xFF) << 1);
                FeedbackPort fbp = this.feedbackPorts.get(portNum - 1);
                int status = 0;
                if (fbp != null) {
                    status = ByteUtils.getLowByte((int)((FeedbackPortStatus)fbp.getStatus()).getType().getType(), (int)1);
                }
                value = (byte)(value | status);
                if (++index <= 7) continue;
                feedbackMultiple[position - 1] = value;
                value = 0;
                index = 0;
                --position;
            }
            LOGGER.info("Prepared feedback multiple: {}", (Object)ByteUtils.bytesToHex((byte[])feedbackMultiple));
            FeedbackMultipleResponse feedbackMultipleResponse = new FeedbackMultipleResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)baseAddress), ByteUtils.getLowByte((int)feedbackSize), feedbackMultiple);
            response = feedbackMultipleResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackMultiple response failed.", (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.warn("Create feedbackMultiple response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected void processBmMirrorMultipleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackMirrorMultipleMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    @Override
    protected void processBmMirrorOccupiedRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorOccupiedRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    @Override
    protected void processBmMirrorFreeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorFreeRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmAddrGetRangeRequest(BidibMessageInterface bidibMessage) {
        try {
            for (FeedbackPort port : this.feedbackPorts.values()) {
                int detectorNumber = port.getId();
                ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
                List addresses = port.getAddresses();
                for (FeedbackAddressData addressData : addresses) {
                    EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                    AddressTypeEnum addressType = null;
                    switch (enrailmentDirection) {
                        case LOCOMOTIVE_LEFT: 
                        case LOCOMOTIVE_RIGHT: {
                            addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                            break;
                        }
                        case BASIC_ACCESSORY: {
                            addressType = AddressTypeEnum.ACCESSORY;
                            break;
                        }
                        case EXTENDED_ACCESSORY: {
                            addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                            break;
                        }
                    }
                    AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                    bidibAddresses.add(bidibAddress);
                }
                FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorNumber, bidibAddresses);
                byte[] response = feedbackAddressResponse.getContent();
                LOGGER.info("Prepare feedbackAddressResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackAddress response failed.", (Throwable)ex);
        }
    }

    @Override
    protected byte[] processBmGetConfidenceRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            byte valid = (byte)(this.statusValid.get() ? 1 : 0);
            byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
            byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(bidibMessage.getAddr(), this.getNextSendNum(), valid, freeze, signal);
            response = feedbackConfidenceResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackConfidence response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response;
        block9: {
            LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
            response = null;
            if (this.getFlatPortModelPortCount() > 0) {
                try {
                    LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
                    int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
                    LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
                    GenericPort port = null;
                    port = this.genericPorts.get(outputNumber);
                    LOGGER.info("Set LcConfig for output number: {}, port: {}", (Object)outputNumber, (Object)port);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                    if (port != null) {
                        Object supportedPortTypes;
                        Map currentPortConfig = port.getPortConfigX();
                        LcConfigX lcConfigX = lcConfigXSetMessage.getLcConfigX(this.messageLogger);
                        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)lcConfigX.getPortConfig().get((byte)-127);
                        if (reconfig != null && (supportedPortTypes = port.getSupportedPortTypes()) != null) {
                            ReconfigPortConfigValue reconfigPortConfigValue = new ReconfigPortConfigValue((int)reconfig.getCurrentOutputType().getType(), ((Integer)supportedPortTypes).intValue());
                            LOGGER.info("Prepared BIDIB_PCFG_RECONFIG to replace: {}", (Object)reconfigPortConfigValue);
                            lcConfigX.getPortConfig().put((byte)-127, reconfigPortConfigValue);
                        }
                        for (Map.Entry entry : lcConfigX.getPortConfig().entrySet()) {
                            Byte key = (Byte)entry.getKey();
                            if (currentPortConfig.containsKey(key)) {
                                currentPortConfig.remove(key);
                            }
                            currentPortConfig.put(key, (PortConfigValue)entry.getValue());
                        }
                        port.setPortConfigX(currentPortConfig);
                        lcConfigX.getPortConfig().clear();
                        lcConfigX.getPortConfig().putAll(currentPortConfig);
                        if (outputNumber == 5) {
                            LOGGER.warn("Change the content to signal an error ...");
                            lcConfigX.getPortConfig().put((byte)0, new BytePortConfigValue(Byte.valueOf((byte)12)));
                        }
                        byte[] content = LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel());
                        LOGGER.info("Prepared content: {}", (Object)ByteUtils.bytesToHex((byte[])content));
                        LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), content);
                        response = lcConfigXResponse.getContent();
                        break block9;
                    }
                    LOGGER.warn("No port assigned!");
                    LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = magicResponse.getContent();
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
                }
            } else {
                response = super.processLcConfigXSetRequest(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response;
        block9: {
            LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
            response = null;
            if (this.getFlatPortModelPortCount() > 0) {
                try {
                    LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
                    int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
                    LcOutputType outputType = lcConfigXGetMessage.getPortType(this.getPortModel());
                    GenericPort port = null;
                    LinkedHashMap<Byte, Object> values = new LinkedHashMap<Byte, Object>();
                    port = this.genericPorts.get(outputNumber);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                    if (port != null) {
                        if (outputNumber >= 0 && outputNumber < this.servoPortCount) {
                            values.put((byte)-127, new ReconfigPortConfigValue(Integer.valueOf(1026)));
                        } else if (outputNumber >= 4 && outputNumber < this.servoPortCount + 16) {
                            values.putAll(port.getPortConfigX());
                        } else {
                            values.put((byte)-127, new ReconfigPortConfigValue(Integer.valueOf(8388879)));
                            values.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, new BytePortConfigValue(Byte.valueOf((byte)0)));
                            values.put((byte)11, new BytePortConfigValue(Byte.valueOf((byte)32)));
                        }
                        LOGGER.info("Return config of port: {}", (Object)port);
                        LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                        LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                        response = lcConfigXResponse.getContent();
                        break block9;
                    }
                    LOGGER.warn("No port available with port number: {}", (Object)outputNumber);
                    LcNotAvailableResponse notAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = notAvailableResponse.getContent();
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
                }
            } else {
                response = super.processLcConfigXGetRequest(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
        if (this.isPortFlatModelAvailable()) {
            LcOutputType outputType = LcOutputType.SWITCHPORT;
            LinkedHashMap<Byte, BytePortConfigValue> values = new LinkedHashMap<Byte, BytePortConfigValue>();
            try {
                for (GenericPort genericPort : this.genericPorts.values()) {
                    int portNumber = genericPort.getPortNumber();
                    LOGGER.info("Prepare lcConfigXResponse for port number: {}", (Object)portNumber);
                    values.clear();
                    values.putAll(genericPort.getPortConfigX());
                    if (portNumber == 6) {
                        values.put((byte)0, new BytePortConfigValue(Byte.valueOf((byte)12)));
                    }
                    LOGGER.info("Return config of port: {}", (Object)genericPort);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
                    LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                    LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    byte[] response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcConfigXResponse response failed.", (Throwable)ex);
            }
        } else {
            super.processLcConfigXGetAllRequest(bidibMessage);
        }
    }

    @Override
    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        if (this.getFlatPortModelPortCount() > 0) {
            try {
                LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
                LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
                int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
                byte outputStatus = lcOutputMessage.getOutputStatus();
                GenericPort port = this.genericPorts.get(outputNumber);
                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                if (port != null) {
                    LcStatResponse lcStatResponse = null;
                    if (port.isMatchingPortType(LcOutputType.SERVOPORT) || port.isMatchingPortType(LcOutputType.BACKLIGHTPORT)) {
                        port.setPortValue(Integer.valueOf(ByteUtils.getInt((byte)outputStatus)));
                    } else {
                        port.setPortStatus(outputStatus);
                    }
                    lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, lcOutputMessage.getOutputStatus());
                    response = lcStatResponse.getContent();
                } else {
                    LOGGER.warn("No port available with portNumber: {}", (Object)outputNumber);
                    LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = lcNotAvailableResponse.getContent();
                }
                if (port != null) {
                    switch (outputType) {
                        case LIGHTPORT: {
                            this.publishLightPortChange(port);
                            break;
                        }
                        case SWITCHPORT: {
                            this.publishSwitchPortChange(port);
                            break;
                        }
                        case SERVOPORT: {
                            this.publishServoPortChange(port);
                            break;
                        }
                    }
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
        } else {
            response = super.processLcOutputRequest(bidibMessage);
        }
        return response;
    }

    @Override
    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutputQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        if (this.isPortFlatModelAvailable()) {
            try {
                LcPortQueryMessage lcOutputQueryMessage = (LcPortQueryMessage)bidibMessage;
                LcOutputType outputType = lcOutputQueryMessage.getPortType(this.getPortModel());
                int outputNumber = lcOutputQueryMessage.getPortNumber(this.getPortModel());
                GenericPort port = this.genericPorts.get(outputNumber);
                byte portState = 0;
                if (port != null) {
                    portState = port.isMatchingPortType(LcOutputType.SERVOPORT) || port.isMatchingPortType(LcOutputType.BACKLIGHTPORT) ? ByteUtils.getLowByte((Integer)port.getPortValue()).byteValue() : port.getPortStatus();
                } else {
                    LOGGER.warn("No port available with portNumber: {}", (Object)outputNumber);
                }
                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
                response = lcStatResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
        } else {
            response = super.processLcPortQueryRequest(bidibMessage);
        }
        return response;
    }

    @Override
    protected byte[] processLcPortQueryAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the PortQueryAll request: {}", (Object)bidibMessage);
        if (this.getFlatPortModelPortCount() > 0) {
            byte[] response = null;
            try {
                LcPortQueryAllMessage portQueryAllMessage = (LcPortQueryAllMessage)bidibMessage;
                int portRangeFrom = portQueryAllMessage.getPortRangeFrom(this.getPortModel());
                int portRangeTo = portQueryAllMessage.getPortRangeTo(this.getPortModel());
                int portTypeMask = portQueryAllMessage.getPortTypeMask();
                LOGGER.info("Query all port states, portRangeFrom: {}, portRangeTo: {}, portModel: {}, portTypeMask: {}", new Object[]{portRangeFrom, portRangeTo, this.getPortModel(), portTypeMask});
                for (GenericPort genericPort : this.genericPorts.values()) {
                    LcOutputType currentPortType = genericPort.getCurrentPortType();
                    if (PortConfigUtils.isSupportsPortType((LcOutputType)currentPortType, (int)portTypeMask) && genericPort.getPortNumber() >= portRangeFrom && genericPort.getPortNumber() < portRangeTo) {
                        try {
                            byte portStatus = 0;
                            portStatus = genericPort.isMatchingPortType(LcOutputType.SERVOPORT) || genericPort.isMatchingPortType(LcOutputType.BACKLIGHTPORT) ? ByteUtils.getLowByte((Integer)genericPort.getPortValue()).byteValue() : genericPort.getPortStatus();
                            this.publishPortState(bidibMessage.getAddr(), currentPortType, genericPort.getPortNumber(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)genericPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip current port that is out of port range or wrong port type: {}", (Object)genericPort);
                }
                LOGGER.info("Send the terminating LC_NA message.");
                this.publishLcNaResponse(bidibMessage.getAddr());
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
            return response;
        }
        LOGGER.info("The OneControlSimulator is configured as type-oriented port model! Delegate evaluation to LightControlSimulator.");
        return super.processLcPortQueryAllRequest(bidibMessage);
    }

    @Override
    protected byte[] processLcKeyQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcKeyQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        if (this.isPortFlatModelAvailable()) {
            byte keyState = 0;
            GenericSimulationPort port = null;
            try {
                LcKeyMessage lcKeyMessage = (LcKeyMessage)bidibMessage;
                int portNumber = lcKeyMessage.getBidibPort().getPortNumber(PortModelEnum.type);
                port = this.genericPorts.get(portNumber);
                if (port != null) {
                    keyState = port.getPortStatus();
                } else {
                    LOGGER.warn("No port available with portNumber: {}", (Object)portNumber);
                }
                LcKeyResponse lcKeyResponse = new LcKeyResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)portNumber), keyState);
                response = lcKeyResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcKey response failed.", (Throwable)ex);
            }
            if (port != null) {
                this.publishInputPortChange(port);
            }
        } else {
            response = super.processLcKeyQueryRequest(bidibMessage);
        }
        return response;
    }

    @Override
    protected byte[] processAccessorySetRequest(final BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{0, 0, 0};
            if (accessoryNumber == 1 && aspect == 1) {
                LOGGER.warn("Adding simulated error to accessory state response");
                value = new byte[]{2, 1, 20};
                this.accessoryResponseList.add(accessoryNumber + "," + aspect + ",2,128,7");
                this.accessoryResponseList.add(accessoryNumber + ",255,2,129,7");
                this.accessoryResponseList.add(accessoryNumber + ",255,2,0,0");
                this.simulationTimer = new Timer(1500, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String accessoryResponse;
                        if (!OneControlSimulator.this.accessoryResponseList.isEmpty() && StringUtils.isNotBlank((CharSequence)(accessoryResponse = OneControlSimulator.this.accessoryResponseList.remove(0)))) {
                            LOGGER.info("Send response: {}", (Object)accessoryResponse);
                            String[] parts = accessoryResponse.split(",");
                            byte[] value = new byte[parts.length];
                            int index = 0;
                            for (String part : parts) {
                                int val = Integer.parseInt(part);
                                value[index] = ByteUtils.getLowByte((int)val);
                                ++index;
                            }
                            try {
                                AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), OneControlSimulator.this.getNextSendNum(), value[0], value[1], ByteUtils.subArray((byte[])value, (int)2));
                                byte[] response = accessoryStateResponse.getContent();
                                LOGGER.info("Prepared accessoryStateResponse: {}", (Object)accessoryStateResponse);
                                OneControlSimulator.this.sendSpontanousResponse(response);
                            }
                            catch (ProtocolException ex) {
                                LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
                            }
                        }
                        if (OneControlSimulator.this.accessoryResponseList.isEmpty()) {
                            LOGGER.info("No more entries in accessoryResponseList. Stop and release timer.");
                            OneControlSimulator.this.simulationTimer.stop();
                            OneControlSimulator.this.simulationTimer = null;
                        }
                    }
                });
                this.simulationTimer.start();
            }
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)aspect), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishLightPortChange(GenericPort port) {
        LightPortStatus status = LightPortStatus.valueOf((LightPortEnum)LightPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The lightport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new LightPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    private void publishSwitchPortChange(GenericPort port) {
        SwitchPortStatus status = SwitchPortStatus.valueOf((SwitchPortEnum)SwitchPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The switchport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new SwitchPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    private void publishServoPortChange(GenericPort port) {
        int value = port.getPortValue();
        LOGGER.info("The servoport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new ServoPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), value));
    }

    private void publishInputPortChange(GenericSimulationPort port) {
        InputPortStatus status = InputPortStatus.valueOf((InputPortEnum)InputPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The inputport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new InputPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    @Override
    protected void changeInputPortStatus(int portNum) {
        LOGGER.info("Change the port status of input port with portNum: {}", (Object)portNum);
        GenericSimulationPort port = null;
        if (this.isPortFlatModelAvailable()) {
            try {
                port = this.genericPorts.get(portNum);
            }
            catch (Exception ex) {
                LOGGER.warn("Get input port failed.", (Throwable)ex);
            }
            if (port != null) {
                InputPortStatus portStatus = InputPortStatus.valueOf((InputPortEnum)InputPortEnum.valueOf((byte)port.getPortStatus()));
                switch (portStatus) {
                    case OFF: {
                        port.setPortStatus(InputPortStatus.ON.getType().getType());
                        break;
                    }
                    default: {
                        port.setPortStatus(InputPortStatus.OFF.getType().getType());
                    }
                }
                LcKeyMessage lcKeyMessage = new LcKeyMessage(portNum){

                    public byte[] getAddr() {
                        return OneControlSimulator.this.getNodeAddress();
                    }
                };
                this.processRequest((BidibMessageInterface)lcKeyMessage);
            } else {
                LOGGER.warn("The requested input port is not available: {}", (Object)portNum);
            }
        } else {
            super.changeInputPortStatus(portNum);
        }
    }

    private void publishFeedbackPortChange(Port<?> port) {
        FeedbackPort feedbackPort = (FeedbackPort)port;
        FeedbackPortStatus status = (FeedbackPortStatus)feedbackPort.getStatus();
        LOGGER.info("The feedbackport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getId(), status));
    }

    @Override
    public void queryStatus(Class<?> portClass) {
        if (FeedbackPort.class.equals(portClass)) {
            for (FeedbackPort feedbackPort : this.feedbackPorts.values()) {
                this.publishFeedbackPortChange((Port<?>)feedbackPort);
            }
            this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
        } else if (this.isPortFlatModelAvailable()) {
            for (GenericSimulationPort port : this.genericPorts.values()) {
                if (portClass == InputPort.class && port.isMatchingPortType(LcOutputType.INPUTPORT)) {
                    this.publishInputPortChange(port);
                    continue;
                }
                if (portClass == SwitchPort.class && port.isMatchingPortType(LcOutputType.SWITCHPORT)) {
                    this.publishSwitchPortChange(port);
                    continue;
                }
                if (portClass == LightPort.class && port.isMatchingPortType(LcOutputType.LIGHTPORT)) {
                    this.publishLightPortChange(port);
                    continue;
                }
                LOGGER.warn("Query port status for unsupported port class: {}", portClass);
            }
        } else {
            super.queryStatus(portClass);
        }
    }

    @Override
    @EventSubscriber(eventClass=FeedbackConfidenceSetEvent.class)
    public void feedbackConfidenceSetEvent(FeedbackConfidenceSetEvent feedbackConfidenceEvent) {
        String nodeAddress = feedbackConfidenceEvent.getNodeAddr();
        LOGGER.info("The change of the feedback confidence was requested, nodeAddress: {}", (Object)nodeAddress);
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        this.statusValid.set(feedbackConfidenceEvent.getValid());
        this.statusFreeze.set(feedbackConfidenceEvent.getFreeze());
        this.statusSignal.set(feedbackConfidenceEvent.getSignal());
        byte valid = (byte)(this.statusValid.get() ? 1 : 0);
        byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
        byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
        try {
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(this.nodeAddress, this.getNextSendNum(), valid, freeze, signal);
            LOGGER.info("Prepared feedbackConfidenceResponse: {}", (Object)feedbackConfidenceResponse);
            this.sendSpontanousResponse(feedbackConfidenceResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send feedbackConfidenceResponse failed.", (Throwable)ex);
        }
        this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
    }

    private void publishFeedbackConfidenceStatusEvent(boolean valid, boolean freeze, boolean signal) {
        LOGGER.info("The feedbackport confidence status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackConfidenceStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), valid, freeze, signal));
    }

    @EventSubscriber(eventClass=FeedbackPortSetStatusEvent.class)
    public void feedbackPortSetStatus(FeedbackPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the feedback port was requested, setStatusEvent: {}", (Object)setStatusEvent);
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        try {
            this.changeFeedbackPortStatus(portNum);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Publish feedback status failed.", (Throwable)ex);
        }
    }

    private int getTimestamp() {
        this.timestamp += 10;
        if (this.timestamp > 65000) {
            this.timestamp = 0;
        }
        return this.timestamp;
    }

    private boolean hasTimestampFeature() {
        Feature feature = Feature.findFeature((Collection)this.features, (int)30);
        return feature != null && feature.getValue() > 0;
    }

    protected void changeFeedbackPortStatus(int portNum) throws ProtocolException {
        FeedbackPort port = this.feedbackPorts.get(portNum);
        if (port != null) {
            FeedbackFreeResponse response = null;
            LOGGER.info("Publish status report for port: {}", (Object)port);
            switch ((FeedbackPortStatus)port.getStatus()) {
                case FREE: {
                    port.setStatus(FeedbackPortStatus.OCCUPIED);
                    if (this.hasTimestampFeature()) {
                        response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum, this.getTimestamp());
                        break;
                    }
                    response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                    break;
                }
                default: {
                    port.setStatus(FeedbackPortStatus.FREE);
                    response = new FeedbackFreeResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                }
            }
            this.sendSpontanousResponse(response.getContent());
            this.publishFeedbackPortChange((Port<?>)port);
        } else {
            LOGGER.warn("The requested feedback port is not available: {}", (Object)portNum);
        }
    }

    @Override
    public void setPortsConfig(FlatPortType flatPortType) {
        if (flatPortType == null) {
            return;
        }
        LOGGER.debug("Set the ports config: {}", (Object)flatPortType);
        if (CollectionUtils.isNotEmpty((Collection)flatPortType.getBACKLIGHTOrLIGHTOrINPUT())) {
            for (PortParamsType flatPortParamsType : flatPortType.getBACKLIGHTOrLIGHTOrINPUT()) {
                if (flatPortParamsType instanceof FlatInputPortType) {
                    this.prepareInutPortFromConfig((FlatInputPortType)flatPortParamsType);
                    continue;
                }
                if (flatPortParamsType instanceof FlatServoPortType) {
                    this.prepareServoPortFromConfig((FlatServoPortType)flatPortParamsType);
                    continue;
                }
                if (flatPortParamsType instanceof FlatSwitchPortType) {
                    this.prepareSwitchPortFromConfig((FlatSwitchPortType)flatPortParamsType);
                    continue;
                }
                LOGGER.warn("Unsupported flatPortParamsType detected: {}", (Object)flatPortParamsType);
            }
        }
    }

    protected void prepareServoPortFromConfig(FlatServoPortType servoPortType) {
        int portNumber = servoPortType.getPortId();
        GenericSimulationPort servoPort = new GenericSimulationPort(portNumber);
        int portTypeMap = OneControlSimulator.getPortTypeMap((byte[])servoPortType.getPortTypeMap());
        servoPort.setCurrentPortType(LcOutputType.SERVOPORT, portTypeMap);
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPortType.getSpeed()))));
        portConfig.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPortType.getAdjustLow()))));
        portConfig.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPortType.getAdjustHigh()))));
        servoPort.setPortConfigX(portConfig);
        servoPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        servoPort.setPortValue(servoPortType.getValue());
        LOGGER.info("Add configured servo port: {}", (Object)servoPort);
        this.genericPorts.put(servoPort.getPortNumber(), servoPort);
    }

    protected void prepareSwitchPortFromConfig(FlatSwitchPortType switchPortType) {
        int portNumber = switchPortType.getPortId();
        GenericSimulationPort switchPort = new GenericSimulationPort(portNumber);
        LcOutputType lcOutputType = LcOutputType.SWITCHPORT;
        int portTypeMap = OneControlSimulator.getPortTypeMap((byte[])switchPortType.getPortTypeMap());
        if (portNumber % 2 == 1) {
            portTypeMap &= 0xFF7F;
        } else if (portNumber < 24) {
            lcOutputType = LcOutputType.SWITCHPAIRPORT;
        }
        switchPort.setCurrentPortType(lcOutputType, portTypeMap);
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)11, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)switchPortType.getTicks()))));
        portConfig.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)switchPortType.getLoadType()))));
        switchPort.setPortConfigX(portConfig);
        switchPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        switchPort.setPortStatus(SwitchPortStatus.ON.getType().getType());
        LOGGER.info("Add configured switch port: {}", (Object)switchPort);
        this.genericPorts.put(switchPort.getPortNumber(), switchPort);
    }

    protected void prepareInutPortFromConfig(FlatInputPortType inputPortType) {
        int portNumber = inputPortType.getPortId();
        GenericSimulationPort inputPort = new GenericSimulationPort(portNumber);
        int portTypeMap = OneControlSimulator.getPortTypeMap((byte[])inputPortType.getPortTypeMap());
        inputPort.setCurrentPortType(LcOutputType.INPUTPORT, portTypeMap);
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)11, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)inputPortType.getTicks()))));
        portConfig.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)inputPortType.getInputCtrl()))));
        inputPort.setPortConfigX(portConfig);
        inputPort.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        inputPort.setPortStatus(InputPortStatus.ON.getType().getType());
        LOGGER.info("Add configured input port: {}", (Object)inputPort);
        this.genericPorts.put(inputPort.getPortNumber(), inputPort);
    }
}

