/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.enums.LcMacroOperationCode;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LightPortEnum;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaSetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcConfigSetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetAllMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcMacroGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroHandleMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaResponse;
import org.bidib.jbidibc.messages.message.LcMacroParaSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroResponse;
import org.bidib.jbidibc.messages.message.LcMacroSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroStateResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.MacroUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.DmxNode;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.BacklightPortParamsType;
import org.bidib.jbidibc.simulation.nodes.BacklightPortType;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.DmxChannelParamsType;
import org.bidib.jbidibc.simulation.nodes.DmxChannelsType;
import org.bidib.jbidibc.simulation.nodes.FlatPortType;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.LightPortParamsType;
import org.bidib.jbidibc.simulation.nodes.LightPortType;
import org.bidib.jbidibc.simulation.nodes.PortType;
import org.bidib.wizard.model.dmx.DmxChannel;
import org.bidib.wizard.model.dmx.DmxChannelWrapper;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.DmxLightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.simulation.events.BacklightPortStatusEvent;
import org.bidib.wizard.simulation.events.InputPortSetStatusEvent;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.LightPortStatusEvent;
import org.bidib.wizard.simulation.macro.MacroContainer;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="115"), @BidibNodeSimulator(vid="251", pid="112")})
public class OneDMXSimulator
extends DefaultNodeSimulator
implements SwitchingFunctionsNode,
DmxNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneDMXSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.OneDMXPanel";
    protected final Map<Integer, InputPort> inputPorts = new HashMap<Integer, InputPort>();
    private final Map<Integer, DmxLightPort> lightPorts = new HashMap<Integer, DmxLightPort>();
    private final Map<Integer, BacklightPort> backlightPorts = new HashMap<Integer, BacklightPort>();
    private final Map<Integer, MacroContainer> macros = new HashMap<Integer, MacroContainer>();
    private final Map<Integer, DmxChannel> dmxChannels = new HashMap<Integer, DmxChannel>();
    protected int inputPortCount;
    protected int inputPortOffset;
    private int lightPortCount;
    private int backlightPortCount;

    public OneDMXSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        this.features.add(new Feature(66, 1));
        this.features.add(new Feature(58, 100));
        this.features.add(new Feature(51, 1));
        this.features.add(new Feature(62, 32));
        this.features.add(new Feature(63, 30));
        this.features.add(new Feature(61, 32));
        this.features.add(new Feature(60, 2));
        this.features.add(new Feature(40, 8));
        this.features.add(new Feature(41, 0));
        this.features.add(new Feature(42, 2));
    }

    public void postConstruct() {
        super.postConstruct();
        if (this.inputPortCount > 0) {
            this.features.add(new Feature(50, this.inputPortCount));
        }
        this.features.add(new Feature(53, this.lightPortCount));
        this.features.add(new Feature(59, this.backlightPortCount));
    }

    protected void setupInputPorts() {
        if (CollectionUtils.isNotEmpty(this.inputPorts.values())) {
            LOGGER.info("InputPorts are set externally already.");
            return;
        }
        for (int id = 0; id < this.inputPortCount; ++id) {
            InputPort port = new InputPort();
            port.setId(id);
            port.setStatus((BidibStatus)(id % 2 == 0 ? InputPortStatus.ON : InputPortStatus.OFF));
            this.inputPorts.put(id, port);
        }
    }

    protected void prepareCVs() {
        super.prepareCVs();
        this.configurationVariables.put(String.valueOf(31), String.valueOf(0));
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.setupInputPorts();
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    @EventSubscriber(eventClass=InputPortSetStatusEvent.class)
    public void inputPortSetStatus(InputPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the input port was requested.");
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        this.changeInputPortStatus(portNum);
    }

    protected void changeInputPortStatus(int portNum) {
        InputPort port = this.inputPorts.get(portNum);
        if (port != null) {
            switch ((InputPortStatus)port.getStatus()) {
                case OFF: {
                    port.setStatus((BidibStatus)InputPortStatus.ON);
                    break;
                }
                default: {
                    port.setStatus((BidibStatus)InputPortStatus.OFF);
                }
            }
            LcKeyMessage lcKeyMessage = new LcKeyMessage(portNum){

                public byte[] getAddr() {
                    return OneDMXSimulator.this.getNodeAddress();
                }
            };
            this.processRequest((BidibMessageInterface)lcKeyMessage);
        } else {
            LOGGER.warn("The requested light port is not available: {}", (Object)portNum);
        }
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 64: {
                response = this.processLcOutputRequest(bidibMessage);
                break;
            }
            case 66: {
                response = this.processLcConfigGetRequest(bidibMessage);
                break;
            }
            case 65: {
                response = this.processLcConfigSetRequest(bidibMessage);
                break;
            }
            case 67: {
                response = this.processLcKeyQueryRequest(bidibMessage);
                break;
            }
            case 68: {
                response = this.processLcPortQueryRequest(bidibMessage);
                break;
            }
            case 70: {
                response = this.processLcConfigXSetRequest(bidibMessage);
                break;
            }
            case 71: {
                response = this.processLcConfigXGetRequest(bidibMessage);
                break;
            }
            case 69: {
                this.processLcConfigXGetAllRequest(bidibMessage);
                break;
            }
            case 63: {
                this.processLcPortQueryAllRequest(bidibMessage);
                break;
            }
            case 72: {
                response = this.processLcMacroHandleRequest(bidibMessage);
                break;
            }
            case 76: {
                response = this.processLcMacroParaGetRequest(bidibMessage);
                break;
            }
            case 75: {
                response = this.processLcMacroParaSetRequest(bidibMessage);
                break;
            }
            case 74: {
                response = this.processLcMacroGetRequest(bidibMessage);
                break;
            }
            case 73: {
                response = this.processLcMacroSetRequest(bidibMessage);
                break;
            }
            case 56: {
                response = this.processAccessorySetRequest(bidibMessage);
                break;
            }
            case 57: {
                response = this.processAccessoryGetRequest(bidibMessage);
                break;
            }
            case 60: {
                response = this.processAccessoryGetAllRequest(bidibMessage);
                break;
            }
            case 58: {
                response = this.processAccessoryParaSetRequest(bidibMessage);
                break;
            }
            case 59: {
                response = this.processAccessoryParaGetRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
            LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
            int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
            byte outputStatus = lcOutputMessage.getOutputStatus();
            BacklightPort port = null;
            switch (outputType) {
                case LIGHTPORT: {
                    DmxLightPort dmxLightPort = this.lightPorts.get(outputNumber);
                    dmxLightPort.getLightPort().setStatus((BidibStatus)LightPortStatus.valueOf((LightPortEnum)LightPortEnum.valueOf((byte)outputStatus)));
                    port = dmxLightPort.getLightPort();
                    break;
                }
                case BACKLIGHTPORT: {
                    BacklightPort backlightPort = this.backlightPorts.get(outputNumber);
                    backlightPort.setValue(Integer.valueOf(ByteUtils.getInt((byte)outputStatus)), true);
                    port = backlightPort;
                    break;
                }
                default: {
                    LOGGER.warn("LcOutput request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, lcOutputMessage.getOutputStatus());
            response = lcStatResponse.getContent();
            if (port != null) {
                switch (outputType) {
                    case LIGHTPORT: {
                        this.publishLightPortChange((Port<?>)port);
                        break;
                    }
                    case BACKLIGHTPORT: {
                        this.publishBacklightPortChange((Port<?>)port);
                        break;
                    }
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishLightPortChange(Port<?> port) {
        LightPort lightPort = (LightPort)port;
        LightPortStatus status = (LightPortStatus)lightPort.getStatus();
        LOGGER.info("The lightport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new LightPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), lightPort.getId(), status));
    }

    private void publishBacklightPortChange(Port<?> port) {
        BacklightPort backlightPort = (BacklightPort)port;
        BacklightPortStatus status = (BacklightPortStatus)backlightPort.getStatus();
        LOGGER.info("The backlightport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new BacklightPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getId(), status));
    }

    protected byte[] processLcConfigGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigGetMessage lcConfigGetMessage = (LcConfigGetMessage)bidibMessage;
            LcOutputType outputType = lcConfigGetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigGetMessage.getPortNumber(this.getPortModel());
            Port port = null;
            switch (outputType) {
                case LIGHTPORT: {
                    port = (Port)this.lightPorts.get(outputNumber);
                    break;
                }
                case BACKLIGHTPORT: {
                    port = (Port)this.backlightPorts.get(outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            LOGGER.info("Return config of port: {}", (Object)port);
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcConfigResponse lcConfigResponse = new LcConfigResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, port.getPortConfig());
            response = lcConfigResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfig response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigResponse magicResponse;
            LcConfigSetMessage lcConfigSetMessage = (LcConfigSetMessage)bidibMessage;
            LcOutputType outputType = lcConfigSetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigSetMessage.getPortNumber(this.getPortModel());
            BacklightPort port = null;
            switch (outputType) {
                case LIGHTPORT: {
                    DmxLightPort dmxLightPort = this.lightPorts.get(outputNumber);
                    if (dmxLightPort != null) {
                        dmxLightPort.getLightPort().setPortConfig(lcConfigSetMessage.getPortConfig());
                        port = dmxLightPort;
                        break;
                    }
                    LOGGER.warn("Lightport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case BACKLIGHTPORT: {
                    BacklightPort backlightPort = this.backlightPorts.get(outputNumber);
                    if (backlightPort != null) {
                        backlightPort.setPortConfig(lcConfigSetMessage.getPortConfig());
                        port = backlightPort;
                        break;
                    }
                    LOGGER.warn("Backlightport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port == null) {
                LOGGER.warn("No port assigned!");
                magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            } else {
                magicResponse = new LcConfigResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, port.getPortConfig());
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigResponse response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
            int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
            LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
            BacklightPort port = null;
            switch (outputType) {
                case LIGHTPORT: {
                    DmxLightPort dmxLightPort = this.lightPorts.get(outputNumber);
                    if (dmxLightPort != null) {
                        dmxLightPort.getLightPort().setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = dmxLightPort;
                        break;
                    }
                    LOGGER.warn("Lightport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case BACKLIGHTPORT: {
                    BacklightPort backlightPort = this.backlightPorts.get(outputNumber);
                    if (backlightPort != null) {
                        backlightPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = backlightPort;
                        break;
                    }
                    LOGGER.warn("Backlightport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigX lcConfigX = new LcConfigX(bidibPort, lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                response = lcConfigXResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
            int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
            LcOutputType lcOutputType = lcConfigXGetMessage.getPortType(this.getPortModel());
            Port port = null;
            LinkedHashMap<Byte, Object> values = new LinkedHashMap<Byte, Object>();
            switch (lcOutputType) {
                case LIGHTPORT: {
                    port = (Port)this.lightPorts.get(outputNumber);
                    LightPort lightPort = ((DmxLightPort)port).getLightPort();
                    values.put((byte)1, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMax()))));
                    values.put((byte)2, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMin()))));
                    values.put((byte)67, new Int16PortConfigValue(Integer.valueOf(lightPort.getDimMax())));
                    values.put((byte)68, new Int16PortConfigValue(Integer.valueOf(lightPort.getDimMin())));
                    if (lightPort.getDmxMapping() == null) break;
                    values.put((byte)6, new BytePortConfigValue(ByteUtils.getLowByte((Integer)lightPort.getDmxMapping())));
                    break;
                }
                case BACKLIGHTPORT: {
                    port = (Port)this.backlightPorts.get(outputNumber);
                    BacklightPort backlightPort = (BacklightPort)port;
                    values.put((byte)67, new Int16PortConfigValue(Integer.valueOf(backlightPort.getDimSlopeUp())));
                    values.put((byte)68, new Int16PortConfigValue(Integer.valueOf(backlightPort.getDimSlopeDown())));
                    values.put((byte)6, new BytePortConfigValue(ByteUtils.getLowByte((Integer)backlightPort.getDmxMapping())));
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)lcOutputType);
                }
            }
            LOGGER.info("Return config of port: {}", (Object)port);
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)outputNumber);
            LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
            LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
            response = lcConfigXResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        block14: {
            LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
            byte[] response = null;
            try {
                LcConfigXResponse lcConfigXResponse;
                LcConfigX lcConfigX;
                BidibPort bidibPort;
                LcConfigXGetAllMessage lcConfigXGetAllMessage = (LcConfigXGetAllMessage)bidibMessage;
                LcOutputType lcOutputType = lcConfigXGetAllMessage.getPortTypeFrom(this.getPortModel());
                LinkedHashMap values = new LinkedHashMap();
                if (lcOutputType != null) {
                    LOGGER.info("Get all ports for output type: {}", (Object)lcOutputType);
                    switch (lcOutputType) {
                        case LIGHTPORT: {
                            for (DmxLightPort lightPort : this.lightPorts.values()) {
                                values.clear();
                                values.putAll(lightPort.getLightPort().getPortConfigX());
                                LOGGER.info("Return config of light port: {}", (Object)lightPort);
                                BidibPort bidibPort2 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)lightPort.getId());
                                LcConfigX lcConfigX2 = new LcConfigX(bidibPort2, values);
                                LcConfigXResponse lcConfigXResponse2 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX2, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse2.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block14;
                        }
                        case BACKLIGHTPORT: {
                            for (BacklightPort backlightPort : this.backlightPorts.values()) {
                                values.clear();
                                values.putAll(backlightPort.getPortConfigX());
                                LOGGER.info("Return config of backlight port: {}", (Object)backlightPort);
                                BidibPort bidibPort3 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)backlightPort.getId());
                                LcConfigX lcConfigX3 = new LcConfigX(bidibPort3, values);
                                LcConfigXResponse lcConfigXResponse3 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX3, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse3.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block14;
                        }
                        case INPUTPORT: {
                            for (InputPort inputPort : this.inputPorts.values()) {
                                values.clear();
                                LOGGER.info("Return config of input port: {}", (Object)inputPort);
                                BidibPort bidibPort4 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)inputPort.getId());
                                LcConfigX lcConfigX4 = new LcConfigX(bidibPort4, values);
                                LcConfigXResponse lcConfigXResponse4 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX4, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse4.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block14;
                        }
                        default: {
                            LOGGER.warn("Unsupported port type requested: {}", (Object)lcOutputType);
                            break;
                        }
                    }
                    break block14;
                }
                for (DmxLightPort lightPort : this.lightPorts.values()) {
                    values.clear();
                    values.putAll(lightPort.getLightPort().getPortConfigX());
                    LOGGER.info("Return config of light port: {}", (Object)lightPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)lightPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (BacklightPort backlightPort : this.backlightPorts.values()) {
                    values.clear();
                    values.putAll(backlightPort.getPortConfigX());
                    LOGGER.info("Return config of backlight port: {}", (Object)backlightPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)backlightPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (InputPort inputPort : this.inputPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of input port: {}", (Object)inputPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.INPUTPORT, (int)inputPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create lcConfigXResponse response failed.", (Throwable)ex);
            }
        }
    }

    protected byte[] processLcKeyQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcKeyQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte keyState = 0;
        Port port = null;
        try {
            LcKeyMessage lcKeyMessage = (LcKeyMessage)bidibMessage;
            int portNumber = lcKeyMessage.getBidibPort().getPortNumber(PortModelEnum.type);
            port = (Port)this.inputPorts.get(portNumber);
            keyState = port.getStatus().getType().getType();
            LcKeyResponse lcKeyResponse = new LcKeyResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)portNumber), keyState);
            response = lcKeyResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcKey response failed.", (Throwable)ex);
        }
        if (port != null) {
            this.publishInputPortChange(port);
        }
        return response;
    }

    private void publishInputPortChange(Port<?> port) {
        InputPort inputPort = (InputPort)port;
        InputPortStatus status = (InputPortStatus)inputPort.getStatus();
        LOGGER.info("The inputport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new InputPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), inputPort.getId(), status));
    }

    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutputQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte portState = 0;
        try {
            LcPortQueryMessage lcPortQueryMessage = (LcPortQueryMessage)bidibMessage;
            LcOutputType outputType = lcPortQueryMessage.getPortType(this.getPortModel());
            int outputNumber = lcPortQueryMessage.getPortNumber(this.getPortModel());
            LOGGER.info("Get port with portNumber: {}", (Object)outputNumber);
            switch (outputType) {
                case INPUTPORT: {
                    portState = ((InputPortStatus)this.inputPorts.get(outputNumber).getStatus()).getType().getType();
                    break;
                }
                case LIGHTPORT: {
                    portState = this.lightPorts.get(outputNumber).getStatus().getType().getType();
                    break;
                }
                case BACKLIGHTPORT: {
                    portState = ((BacklightPortStatus)this.backlightPorts.get(outputNumber).getStatus()).getType().getType();
                    break;
                }
                default: {
                    LOGGER.warn("LcOutputQuery for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
            response = lcStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcPortQueryAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the PortQueryAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            byte portStatus;
            LcPortQueryAllMessage portQueryAllMessage = (LcPortQueryAllMessage)bidibMessage;
            int portRangeFrom = portQueryAllMessage.getPortRangeFrom(this.getPortModel());
            int portRangeTo = portQueryAllMessage.getPortRangeTo(this.getPortModel());
            int portTypeMask = portQueryAllMessage.getPortTypeMask();
            LOGGER.info("Query all port states, portRangeFrom: {}, portRangeTo: {}, portModel: {}, portTypeMask: {}", new Object[]{portRangeFrom, portRangeTo, this.getPortModel(), portTypeMask});
            if (PortConfigUtils.isSupportsInputPort((int)portTypeMask) && MapUtils.isNotEmpty(this.inputPorts)) {
                for (InputPort inputPort : this.inputPorts.values()) {
                    if (inputPort.getId() >= portRangeFrom && inputPort.getId() < portRangeTo) {
                        try {
                            InputPortStatus inputPortStatus = (InputPortStatus)inputPort.getStatus();
                            portStatus = inputPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.INPUTPORT, inputPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)inputPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip input port that is out of port range: {}", (Object)inputPort);
                }
            }
            if (PortConfigUtils.isSupportsLightPort((int)portTypeMask) && MapUtils.isNotEmpty(this.lightPorts)) {
                for (DmxLightPort lightPort : this.lightPorts.values()) {
                    if (lightPort.getId() >= portRangeFrom && lightPort.getId() < portRangeTo) {
                        try {
                            LightPortStatus lightPortStatus = lightPort.getStatus();
                            portStatus = lightPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.LIGHTPORT, lightPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)lightPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip light port that is out of port range: {}", (Object)lightPort);
                }
            }
            if (PortConfigUtils.isSupportsBacklightPort((int)portTypeMask) && MapUtils.isNotEmpty(this.backlightPorts)) {
                for (BacklightPort backlightPort : this.backlightPorts.values()) {
                    if (backlightPort.getId() >= portRangeFrom && backlightPort.getId() < portRangeTo) {
                        try {
                            BacklightPortStatus backlightPortStatus = (BacklightPortStatus)backlightPort.getStatus();
                            portStatus = backlightPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.BACKLIGHTPORT, backlightPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)backlightPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip backlight port that is out of port range: {}", (Object)backlightPort);
                }
            }
            LOGGER.info("Send the terminating LC_NA message.");
            this.publishLcNaResponse(bidibMessage.getAddr());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void publishPortState(byte[] address, LcOutputType outputType, int outputNumber, byte portStatus) throws ProtocolException {
        BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
        LcStatResponse lcStatResponse = new LcStatResponse(address, this.getNextSendNum(), bidibPort, portStatus);
        LOGGER.info("Prepared LcStatResponse: {}", (Object)lcStatResponse);
        byte[] response = lcStatResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected void publishLcNaResponse(byte[] address) throws ProtocolException {
        BidibPort bidibPort = new BidibPort(new byte[]{ByteUtils.getLowByte((int)255), ByteUtils.getLowByte((int)255)});
        LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(address, this.getNextSendNum(), bidibPort);
        LOGGER.info("Prepared LcNotAvailableResponse: {}", (Object)lcNotAvailableResponse);
        byte[] response = lcNotAvailableResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected byte[] processLcMacroParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroParaGetMessage lcMacroParaGetMessage = (LcMacroParaGetMessage)bidibMessage;
            int macroNumber = lcMacroParaGetMessage.getMacroNumber();
            int paramId = lcMacroParaGetMessage.getParameterIndex();
            LOGGER.info("Process macroNumber: {}, paramId: {}", (Object)macroNumber, (Object)paramId);
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                LOGGER.info("Create new MacroContainer for macro number: {}", (Object)macroNumber);
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            byte[] parameter = container.getMacroParameter(paramId);
            LcMacroParaResponse lcMacroParaResponse = new LcMacroParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)macroNumber, (byte)paramId, parameter);
            response = lcMacroParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroParaSetMessage lcMacroParaSetMessage = (LcMacroParaSetMessage)bidibMessage;
            int macroNumber = lcMacroParaSetMessage.getMacroNumber();
            int paramId = lcMacroParaSetMessage.getParameterIndex();
            byte[] parameter = lcMacroParaSetMessage.getValue();
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            container.setMacroParameter(paramId, parameter);
            LcMacroParaResponse lcMacroParaResponse = new LcMacroParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)macroNumber, (byte)paramId, parameter);
            response = lcMacroParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroHandleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroHandle request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroHandleMessage lcMacroHandleMessage = (LcMacroHandleMessage)bidibMessage;
            Integer macroNumber = lcMacroHandleMessage.getMacroNumber();
            LcMacroOperationCode lcMacroOperationCode = lcMacroHandleMessage.getMacroOperationCode();
            LOGGER.info("Handle macro request, macroNumber: {}, lcMacroOperationCode: {}", (Object)macroNumber, (Object)lcMacroOperationCode);
            LcMacroState macroState = null;
            switch (lcMacroOperationCode) {
                case START: {
                    macroState = LcMacroState.RUNNING;
                    break;
                }
                case DELETE: {
                    macroState = LcMacroState.DELETE;
                    LOGGER.info("Remove macro with number: {}", (Object)macroNumber);
                    this.macros.remove(macroNumber);
                    break;
                }
                case OFF: {
                    macroState = LcMacroState.OFF;
                    break;
                }
                case RESTORE: {
                    macroState = LcMacroState.RESTORE;
                    break;
                }
                case SAVE: {
                    macroState = LcMacroState.SAVE;
                    break;
                }
                default: {
                    macroState = LcMacroState.NOTEXIST;
                }
            }
            LcMacroStateResponse lcMacroStateResponse = new LcMacroStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((Integer)macroNumber).byteValue(), macroState);
            response = lcMacroStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacro macroStep;
            LcMacroGetMessage lcMacroGetMessage = (LcMacroGetMessage)bidibMessage;
            Integer macroNumber = lcMacroGetMessage.getMacroNumber();
            int stepNumber = lcMacroGetMessage.getStep();
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            LcMacro value = macroStep = container.getMacroStep(stepNumber);
            LcMacroResponse lcMacroResponse = new LcMacroResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((Integer)macroNumber).byteValue(), ByteUtils.getLowByte((int)stepNumber), value);
            response = lcMacroResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacro response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroSetMessage lcMacroSetMessage = (LcMacroSetMessage)bidibMessage;
            int macroNumber = lcMacroSetMessage.getMacroNumber();
            int stepNumber = lcMacroSetMessage.getStep();
            LcMacro macroStep = MacroUtils.getMacro((byte[])lcMacroSetMessage.getData());
            LOGGER.info("Current macroNumber: {}, stepNumber: {}, macroStep: {}", new Object[]{macroNumber, stepNumber, macroStep});
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            container.setMacroStep(stepNumber, macroStep);
            try {
                LcMacroResponse lcMacroResponse = new LcMacroResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)macroNumber), ByteUtils.getLowByte((int)stepNumber), macroStep);
                response = lcMacroResponse.getContent();
            }
            catch (NullPointerException npe) {
                LOGGER.warn("create response failed.", (Throwable)npe);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacro response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{0, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryGetMessage accessoryGetMessage = (AccessoryGetMessage)bidibMessage;
            int accessoryNumber = accessoryGetMessage.getAccessoryNumber();
            boolean aspect = false;
            byte[] value = new byte[]{0, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)(aspect ? 1 : 0), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGetAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            Feature featureAccessoryCount = Feature.findFeature((Collection)this.features, (int)40);
            int accessoryCount = featureAccessoryCount.getValue();
            int aspect = 0;
            for (int accessoryNumber = 0; accessoryNumber < accessoryCount; ++accessoryNumber) {
                byte[] value = new byte[]{3, 0, 0};
                Feature featureAccessoryMacroMapped = Feature.findFeature((Collection)this.features, (int)42);
                if (featureAccessoryMacroMapped != null && featureAccessoryMacroMapped.getValue() > 0) {
                    value[0] = 0;
                    if (accessoryNumber == 2) {
                        value[0] = 8;
                        aspect = 2;
                    }
                }
                LOGGER.info("Return data for accessory: {}, data: {}", (Object)accessoryNumber, (Object)ByteUtils.bytesToHex((byte[])value));
                AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
                response = accessoryStateResponse.getContent();
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return null;
    }

    protected byte[] processAccessoryParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaSetMessage accessoryParaSetMessage = (AccessoryParaSetMessage)bidibMessage;
            int accessoryNumber = accessoryParaSetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaSetMessage.getParaNumber();
            byte[] value = accessoryParaSetMessage.getValue();
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            byte[] value = new byte[]{0, 0, 0, 0};
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    public void queryStatus(Class<?> portClass) {
        block4: {
            block5: {
                block3: {
                    if (!InputPort.class.equals(portClass)) break block3;
                    for (InputPort inputPort : this.inputPorts.values()) {
                        this.publishInputPortChange((Port<?>)inputPort);
                    }
                    break block4;
                }
                if (!LightPort.class.equals(portClass)) break block5;
                for (DmxLightPort lightPort : this.lightPorts.values()) {
                    this.publishLightPortChange((Port<?>)lightPort.getLightPort());
                }
                break block4;
            }
            if (!BacklightPort.class.equals(portClass)) break block4;
            for (BacklightPort backlightPort : this.backlightPorts.values()) {
                this.publishBacklightPortChange((Port<?>)backlightPort);
            }
        }
    }

    public void setPortsConfig(FlatPortType portType) {
    }

    public void setPortsConfig(PortType portType) {
        if (portType == null) {
            return;
        }
        if (portType instanceof LightPortType) {
            LightPortType lightPortType = (LightPortType)portType;
            this.lightPortCount = lightPortType.getCount();
            LOGGER.info("Total number of lightports: {}", (Object)this.lightPortCount);
            for (int portId = 0; portId < this.lightPortCount; ++portId) {
                LightPort lightPort = new LightPort();
                lightPort.setId(portId);
                lightPort.setStatus((BidibStatus)(portId % 3 == 0 ? LightPortStatus.ON : LightPortStatus.OFF));
                HashMap<Byte, Object> portConfig = new HashMap<Byte, Object>();
                portConfig.put((byte)67, new Int16PortConfigValue(Integer.valueOf(65535)));
                portConfig.put((byte)68, new Int16PortConfigValue(Integer.valueOf(0)));
                portConfig.put((byte)2, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)0))));
                portConfig.put((byte)1, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)255))));
                lightPort.setKnownPortConfigKeys(portConfig.keySet());
                lightPort.setPortConfigX(portConfig);
                DmxLightPort dmxLightPort = new DmxLightPort(lightPort);
                this.lightPorts.put(dmxLightPort.getId(), dmxLightPort);
            }
            if (CollectionUtils.isNotEmpty((Collection)lightPortType.getPort())) {
                int cvBaseOffset = 215;
                for (LightPortParamsType portParams : lightPortType.getPort()) {
                    LightPort lightPort = new LightPort();
                    lightPort.setId(portParams.getPortId());
                    lightPort.setDimMin8_8(portParams.getDimSlopeDown());
                    lightPort.setDimMax8_8(portParams.getDimSlopeUp());
                    lightPort.setPwmMax(portParams.getIntensityOn());
                    lightPort.setPwmMin(portParams.getIntensityOff());
                    lightPort.setDmxMapping(Integer.valueOf(portParams.getDmxMapping()));
                    lightPort.setStatus((BidibStatus)LightPortStatus.OFF);
                    HashSet<Byte> knownPortConfigKeys = new HashSet<Byte>();
                    knownPortConfigKeys.add((byte)67);
                    knownPortConfigKeys.add((byte)68);
                    knownPortConfigKeys.add((byte)1);
                    knownPortConfigKeys.add((byte)2);
                    knownPortConfigKeys.add((byte)6);
                    lightPort.setKnownPortConfigKeys(knownPortConfigKeys);
                    DmxLightPort dmxLightPort = new DmxLightPort(lightPort);
                    DmxChannel dmxChannel = this.dmxChannels.get(portParams.getDmxMapping());
                    dmxLightPort.setDmxTargetChannel(dmxChannel);
                    LOGGER.info("Add configured port: {}", (Object)lightPort);
                    this.lightPorts.put(dmxLightPort.getId(), dmxLightPort);
                    int cvOffset = 215 + portParams.getPortId() * 7;
                    if (dmxLightPort.getDmxTargetChannel() != null) {
                        this.configurationVariables.put(String.valueOf(cvOffset), String.valueOf(portParams.getDmxMapping()));
                    } else {
                        this.configurationVariables.put(String.valueOf(cvOffset), String.valueOf(-1));
                    }
                    this.configurationVariables.put(String.valueOf(cvOffset + 1), String.valueOf(lightPort.getPwmMin()));
                    this.configurationVariables.put(String.valueOf(cvOffset + 2), String.valueOf(lightPort.getPwmMax()));
                    this.configurationVariables.put(String.valueOf(cvOffset + 3), String.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMin())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 4), String.valueOf(ByteUtils.getHighByte((int)lightPort.getDimMin())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 5), String.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMax())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 6), String.valueOf(ByteUtils.getHighByte((int)lightPort.getDimMax())));
                }
                this.lightPortCount = this.lightPorts.size();
            }
        } else if (portType instanceof BacklightPortType) {
            BacklightPortType backlightPortType = (BacklightPortType)portType;
            this.backlightPortCount = portType.getCount();
            LOGGER.info("Total number of backlight ports: {}", (Object)this.backlightPortCount);
            for (int portId = 0; portId < this.backlightPortCount; ++portId) {
                BacklightPort backlightPort = new BacklightPort();
                backlightPort.setId(portId);
                this.backlightPorts.put(backlightPort.getId(), backlightPort);
            }
            if (CollectionUtils.isNotEmpty((Collection)backlightPortType.getPort())) {
                int cvBaseOffset = 1111;
                for (BacklightPortParamsType portParams : backlightPortType.getPort()) {
                    BacklightPort backlightPort = new BacklightPort();
                    backlightPort.setId(portParams.getPortId());
                    backlightPort.setDmxMapping(Integer.valueOf(portParams.getDmxMapping()));
                    backlightPort.setDimSlopeDown(portParams.getDimSlopeDown());
                    backlightPort.setDimSlopeUp(portParams.getDimSlopeUp());
                    backlightPort.setStatus((BidibStatus)BacklightPortStatus.START);
                    HashSet<Byte> knownPortConfigKeys = new HashSet<Byte>();
                    knownPortConfigKeys.add((byte)67);
                    knownPortConfigKeys.add((byte)68);
                    knownPortConfigKeys.add((byte)1);
                    knownPortConfigKeys.add((byte)2);
                    knownPortConfigKeys.add((byte)6);
                    backlightPort.setKnownPortConfigKeys(knownPortConfigKeys);
                    LOGGER.info("Add configured port: {}", (Object)backlightPort);
                    this.backlightPorts.put(backlightPort.getId(), backlightPort);
                    int cvOffset = 1111 + portParams.getPortId() * 5;
                    this.configurationVariables.put(String.valueOf(cvOffset), String.valueOf(backlightPort.getDmxMapping()));
                    this.configurationVariables.put(String.valueOf(cvOffset + 1), String.valueOf(ByteUtils.getLowByte((int)backlightPort.getDimSlopeDown())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 2), String.valueOf(ByteUtils.getHighByte((int)backlightPort.getDimSlopeDown())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 3), String.valueOf(ByteUtils.getLowByte((int)backlightPort.getDimSlopeUp())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 4), String.valueOf(ByteUtils.getHighByte((int)backlightPort.getDimSlopeUp())));
                }
                this.backlightPortCount = this.backlightPorts.size();
            }
        } else if (portType instanceof InputPortType) {
            this.inputPortCount = portType.getCount();
            this.inputPortOffset = portType.getOffset() != null ? portType.getOffset() : 0;
            LOGGER.info("Configured number of input ports: {}", (Object)this.inputPortCount);
        }
    }

    public int getInputPortOffset() {
        return this.inputPortOffset;
    }

    public void setDmxConfig(DmxChannelsType dmxChannelType) {
        int cvOffset;
        LOGGER.info("Prepare the DMX channels.");
        if (dmxChannelType == null) {
            LOGGER.warn("No DMX channels provided.");
            return;
        }
        if (dmxChannelType.getCount() != null) {
            cvOffset = 71;
            for (int channelId = 0; channelId < dmxChannelType.getCount(); ++channelId) {
                this.configurationVariables.put(String.valueOf(cvOffset + channelId), String.valueOf(1));
                int realDmxChannelId = channelId + 1;
                DmxChannel dmxChannel = new DmxChannel(null, DmxChannelWrapper.searchKey((Integer)realDmxChannelId));
                dmxChannel.setInitialState(0);
                this.dmxChannels.put(realDmxChannelId, dmxChannel);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dmxChannelType.getChannel())) {
            cvOffset = 71;
            for (DmxChannelParamsType dmxChannelParams : dmxChannelType.getChannel()) {
                int dmxChannelId = dmxChannelParams.getChannelId();
                if (dmxChannelId > 0 && dmxChannelId < 65) {
                    DmxChannel dmxChannel = new DmxChannel(null, DmxChannelWrapper.searchKey((Integer)dmxChannelId));
                    dmxChannel.setInitialState(dmxChannelParams.getInitialState());
                    this.dmxChannels.put(dmxChannelId, dmxChannel);
                    this.configurationVariables.put(String.valueOf(cvOffset + dmxChannelId - 1), String.valueOf(dmxChannelParams.getInitialState()));
                    continue;
                }
                LOGGER.warn("Current DMX channelId is out of range: {}", (Object)dmxChannelId);
            }
        }
    }
}

