/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcConfigSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.FlatPortType;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.PortType;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="114"), @BidibNodeSimulator(vid="251", pid="107")})
public class OneHubSimulator
extends DefaultNodeSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneHubSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.LightControlPanel";
    private final Map<Integer, InputPort> inputPorts = new HashMap<Integer, InputPort>();
    private int inputPortCount;

    public OneHubSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
        if (!NodeUtils.hasSubNodesFunctions((long)uniqueId)) {
            LOGGER.warn("The configured Hub has no subnode functions defined in the uniqueId!");
        }
    }

    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        this.features.add(new Feature(51, 1));
    }

    public void postConstruct() {
        super.postConstruct();
        this.features.add(new Feature(50, this.inputPortCount));
    }

    protected void prepareCVs() {
        super.prepareCVs();
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.setupInputPorts();
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    private void setupInputPorts() {
        for (int id = 0; id < this.inputPortCount; ++id) {
            InputPort port = new InputPort();
            port.setId(id);
            port.setStatus((BidibStatus)(id % 2 == 0 ? InputPortStatus.ON : InputPortStatus.OFF));
            this.inputPorts.put(id, port);
        }
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 66: {
                response = this.processLcConfigGetRequest(bidibMessage);
                break;
            }
            case 65: {
                response = this.processLcConfigSetRequest(bidibMessage);
                break;
            }
            case 67: {
                response = this.processLcKeyQueryRequest(bidibMessage);
                break;
            }
            case 68: {
                response = this.processLcPortQueryRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processLcKeyQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcKeyQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte keyState = 0;
        Port port = null;
        try {
            LcKeyMessage lcKeyMessage = (LcKeyMessage)bidibMessage;
            int portNumber = lcKeyMessage.getBidibPort().getPortNumber(PortModelEnum.type);
            port = (Port)this.inputPorts.get(portNumber);
            keyState = port.getStatus().getType().getType();
            LcKeyResponse lcKeyResponse = new LcKeyResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)portNumber), keyState);
            response = lcKeyResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcKey response failed.", (Throwable)ex);
        }
        if (port != null) {
            this.publishInputPortChange(port);
        }
        return response;
    }

    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutputQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte portState = 0;
        try {
            LcPortQueryMessage lcPortQueryMessage = (LcPortQueryMessage)bidibMessage;
            LcOutputType outputType = lcPortQueryMessage.getPortType(this.getPortModel());
            int portNumber = lcPortQueryMessage.getPortNumber(this.getPortModel());
            switch (outputType) {
                case INPUTPORT: {
                    portState = ((InputPortStatus)this.inputPorts.get(portNumber).getStatus()).getType().getType();
                    break;
                }
                default: {
                    LOGGER.warn("LcOutputQuery for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
            LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
            response = lcStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcPortQueryAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the PortQueryAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcPortQueryAllMessage portQueryAllMessage = (LcPortQueryAllMessage)bidibMessage;
            int portRangeFrom = portQueryAllMessage.getPortRangeFrom(this.getPortModel());
            int portRangeTo = portQueryAllMessage.getPortRangeTo(this.getPortModel());
            int portTypeMask = portQueryAllMessage.getPortTypeMask();
            LOGGER.info("Query all port states, portRangeFrom: {}, portRangeTo: {}, portModel: {}, portTypeMask: {}", new Object[]{portRangeFrom, portRangeTo, this.getPortModel(), portTypeMask});
            if (PortConfigUtils.isSupportsInputPort((int)portTypeMask) && MapUtils.isNotEmpty(this.inputPorts)) {
                for (InputPort inputPort : this.inputPorts.values()) {
                    if (inputPort.getId() >= portRangeFrom && inputPort.getId() < portRangeTo) {
                        try {
                            InputPortStatus inputPortStatus = (InputPortStatus)inputPort.getStatus();
                            if (inputPortStatus == null) {
                                inputPort.setStatus((BidibStatus)InputPortStatus.OFF);
                                inputPortStatus = (InputPortStatus)inputPort.getStatus();
                            }
                            byte portStatus = inputPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.INPUTPORT, inputPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)inputPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip input port that is out of port range: {}", (Object)inputPort);
                }
            }
            LOGGER.info("Send the terminating LC_NA message.");
            this.publishLcNaResponse(bidibMessage.getAddr());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void publishPortState(byte[] address, LcOutputType outputType, int outputNumber, byte portStatus) throws ProtocolException {
        BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
        LcStatResponse lcStatResponse = new LcStatResponse(address, this.getNextSendNum(), bidibPort, portStatus);
        LOGGER.info("Prepared LcStatResponse: {}", (Object)lcStatResponse);
        byte[] response = lcStatResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected void publishLcNaResponse(byte[] address) throws ProtocolException {
        BidibPort bidibPort = new BidibPort(new byte[]{ByteUtils.getLowByte((int)255), ByteUtils.getLowByte((int)255)});
        LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(address, this.getNextSendNum(), bidibPort);
        LOGGER.info("Prepared LcNotAvailableResponse: {}", (Object)lcNotAvailableResponse);
        byte[] response = lcNotAvailableResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected byte[] processLcConfigGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigGetMessage lcConfigGetMessage = (LcConfigGetMessage)bidibMessage;
            LcOutputType outputType = lcConfigGetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigGetMessage.getPortNumber(this.getPortModel());
            Port port = null;
            switch (outputType) {
                case INPUTPORT: {
                    port = (Port)this.inputPorts.get(outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigResponse lcConfigResponse = new LcConfigResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, port.getPortConfig());
                response = lcConfigResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfig response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigSetMessage lcConfigSetMessage = (LcConfigSetMessage)bidibMessage;
            LcOutputType outputType = lcConfigSetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigSetMessage.getPortNumber(this.getPortModel());
            InputPort port = null;
            switch (outputType) {
                case INPUTPORT: {
                    InputPort inputPort = this.inputPorts.get(outputNumber);
                    if (inputPort != null) {
                        LOGGER.warn("The input port has no config to set.");
                        port = inputPort;
                        break;
                    }
                    LOGGER.warn("Inputport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigResponse lcConfigResponse = new LcConfigResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, port.getPortConfig());
                response = lcConfigResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishInputPortChange(Port<?> port) {
        InputPort inputPort = (InputPort)port;
        InputPortStatus status = (InputPortStatus)inputPort.getStatus();
        LOGGER.info("The inputport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new InputPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), inputPort.getId(), status));
    }

    public void queryStatus(Class<?> portClass) {
        if (InputPort.class.equals(portClass)) {
            for (InputPort inputPort : this.inputPorts.values()) {
                this.publishInputPortChange((Port<?>)inputPort);
            }
        }
    }

    public void setPortsConfig(FlatPortType portType) {
    }

    public void setPortsConfig(PortType portType) {
        if (portType == null) {
            return;
        }
        if (portType instanceof InputPortType) {
            this.inputPortCount = portType.getCount();
        }
    }
}

