/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.jbidibc.messages.enums.LcMacroOperationCode;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaSetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcConfigSetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetAllMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcMacroGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroHandleMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaResponse;
import org.bidib.jbidibc.messages.message.LcMacroParaSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroResponse;
import org.bidib.jbidibc.messages.message.LcMacroSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroStateResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.message.VendorGetMessage;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.MacroUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.PortType;
import org.bidib.jbidibc.simulation.nodes.ServoPortType;
import org.bidib.jbidibc.simulation.nodes.SwitchPortType;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.simulation.LightControlSimulator;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.ServoPortStatusEvent;
import org.bidib.wizard.simulation.events.SwitchPortStatusEvent;
import org.bidib.wizard.simulation.macro.MacroContainer;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="121"), @BidibNodeSimulator(vid="13", pid="130"), @BidibNodeSimulator(vid="251", pid="222")})
public class OneSTSimulator
extends LightControlSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneSTSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.LightControlPanel";
    private final Map<Integer, FeedbackPort> feedbackPorts = new HashMap<Integer, FeedbackPort>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusValid = new AtomicBoolean();
    private final AtomicBoolean statusSignal = new AtomicBoolean();

    public OneSTSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    @Override
    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    private void setupFeedbackPorts() {
        for (int id = 0; id < 16; ++id) {
            FeedbackPort port = new FeedbackPort();
            port.setId(id);
            port.setStatus(FeedbackPortStatus.FREE);
            this.feedbackPorts.put(id, port);
        }
    }

    @Override
    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.setupInputPorts();
        this.setupSwitchPorts();
        this.setupServoPorts();
        this.setupFeedbackPorts();
        super.start();
    }

    @Override
    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    @Override
    protected void configureServoPort(ServoPort port) {
        LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
        portConfig.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)20))));
        portConfig.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)150))));
        portConfig.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)4))));
        portConfig.put((byte)10, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)0))));
        portConfig.put((byte)16, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)18))));
        port.setPortConfigX(portConfig);
    }

    @Override
    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 64: {
                response = this.processLcOutputRequest(bidibMessage);
                break;
            }
            case 66: {
                response = this.processLcConfigGetRequest(bidibMessage);
                break;
            }
            case 65: {
                response = this.processLcConfigSetRequest(bidibMessage);
                break;
            }
            case 67: {
                response = this.processLcKeyQueryRequest(bidibMessage);
                break;
            }
            case 68: {
                response = this.processLcPortQueryRequest(bidibMessage);
                break;
            }
            case 70: {
                response = this.processLcConfigXSetRequest(bidibMessage);
                break;
            }
            case 71: {
                response = this.processLcConfigXGetRequest(bidibMessage);
                break;
            }
            case 69: {
                this.processLcConfigXGetAllRequest(bidibMessage);
                break;
            }
            case 72: {
                response = this.processLcMacroHandleRequest(bidibMessage);
                break;
            }
            case 76: {
                response = this.processLcMacroParaGetRequest(bidibMessage);
                break;
            }
            case 75: {
                response = this.processLcMacroParaSetRequest(bidibMessage);
                break;
            }
            case 74: {
                response = this.processLcMacroGetRequest(bidibMessage);
                break;
            }
            case 73: {
                response = this.processLcMacroSetRequest(bidibMessage);
                break;
            }
            case 56: {
                response = this.processAccessorySetRequest(bidibMessage);
                break;
            }
            case 57: {
                response = this.processAccessoryGetRequest(bidibMessage);
                break;
            }
            case 58: {
                response = this.processAccessoryParaSetRequest(bidibMessage);
                break;
            }
            case 59: {
                response = this.processAccessoryParaGetRequest(bidibMessage);
                break;
            }
            case 32: {
                response = this.processBmGetRangeRequest(bidibMessage);
                break;
            }
            case 33: {
                this.processBmMirrorMultipleRequest(bidibMessage);
                break;
            }
            case 36: {
                this.processBmAddrGetRangeRequest(bidibMessage);
                break;
            }
            case 37: {
                response = this.processBmGetConfidenceRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected byte[] processBmGetRangeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackGetRangeMessage: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            FeedbackGetRangeMessage feedbackGetRangeMessage = (FeedbackGetRangeMessage)bidibMessage;
            int baseAddress = feedbackGetRangeMessage.getBeginRange();
            int end = feedbackGetRangeMessage.getEndRange();
            byte feedbackSize = ByteUtils.getLowByte((int)(feedbackGetRangeMessage.getEndRange() - feedbackGetRangeMessage.getBeginRange()));
            int value = 0;
            int index = 0;
            byte[] feedbackMultiple = new byte[feedbackSize / 8];
            int position = feedbackMultiple.length;
            for (int portNum = end; portNum > baseAddress; --portNum) {
                value = (byte)((value & 0xFF) << 1);
                FeedbackPort fbp = this.feedbackPorts.get(portNum - 1);
                int status = 0;
                if (fbp != null) {
                    status = ByteUtils.getLowByte((int)((FeedbackPortStatus)fbp.getStatus()).getType().getType(), (int)1);
                }
                value = (byte)(value | status);
                if (++index <= 7) continue;
                feedbackMultiple[position - 1] = value;
                value = 0;
                index = 0;
                --position;
            }
            LOGGER.info("Prepared feedback multiple: {}", (Object)ByteUtils.bytesToHex((byte[])feedbackMultiple));
            FeedbackMultipleResponse feedbackMultipleResponse = new FeedbackMultipleResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)baseAddress), ByteUtils.getLowByte((int)feedbackSize), feedbackMultiple);
            response = feedbackMultipleResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackMultiple response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected void processBmMirrorMultipleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackMirrorMultipleMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmAddrGetRangeRequest(BidibMessageInterface bidibMessage) {
        try {
            for (FeedbackPort port : this.feedbackPorts.values()) {
                int detectorNumber = port.getId();
                ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
                List addresses = port.getAddresses();
                for (FeedbackAddressData addressData : addresses) {
                    EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                    AddressTypeEnum addressType = null;
                    switch (enrailmentDirection) {
                        case LOCOMOTIVE_LEFT: 
                        case LOCOMOTIVE_RIGHT: {
                            addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                            break;
                        }
                        case BASIC_ACCESSORY: {
                            addressType = AddressTypeEnum.ACCESSORY;
                            break;
                        }
                        case EXTENDED_ACCESSORY: {
                            addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                            break;
                        }
                    }
                    AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                    bidibAddresses.add(bidibAddress);
                }
                FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorNumber, bidibAddresses);
                byte[] response = feedbackAddressResponse.getContent();
                LOGGER.info("Prepare feedbackAddressResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackAddress response failed.", (Throwable)ex);
        }
    }

    @Override
    protected byte[] processBmGetConfidenceRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            byte valid = (byte)(this.statusValid.get() ? 1 : 0);
            byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
            byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(bidibMessage.getAddr(), this.getNextSendNum(), valid, freeze, signal);
            response = feedbackConfidenceResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackConfidence response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
            LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
            int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
            byte outputStatus = lcOutputMessage.getOutputStatus();
            ServoPort port = null;
            switch (outputType) {
                case SWITCHPORT: {
                    SwitchPort switchPort = (SwitchPort)this.switchPorts.get(outputNumber);
                    switchPort.setStatus((BidibStatus)SwitchPortStatus.valueOf((SwitchPortEnum)SwitchPortEnum.valueOf((byte)outputStatus)));
                    port = switchPort;
                    break;
                }
                case SERVOPORT: {
                    ServoPort servoPort = (ServoPort)this.servoPorts.get(outputNumber);
                    servoPort.setValue(ByteUtils.getInteger((byte)outputStatus));
                    port = servoPort;
                    break;
                }
                default: {
                    LOGGER.warn("LcOutput request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, lcOutputMessage.getOutputStatus());
                response = lcStatResponse.getContent();
            } else {
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
            if (port != null) {
                switch (outputType) {
                    case SWITCHPORT: {
                        this.publishSwitchPortChange((Port<?>)port);
                        break;
                    }
                    case SERVOPORT: {
                        this.publishServoPortChange((Port<?>)port);
                        break;
                    }
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishSwitchPortChange(Port<?> port) {
        SwitchPort switchPort = (SwitchPort)port;
        SwitchPortStatus status = (SwitchPortStatus)switchPort.getStatus();
        LOGGER.info("The switchport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new SwitchPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), switchPort.getId(), status));
    }

    private void publishServoPortChange(Port<?> port) {
        ServoPort servoPort = (ServoPort)port;
        Integer value = servoPort.getValue();
        LOGGER.info("The servoport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new ServoPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), servoPort.getId(), value));
    }

    @Override
    protected byte[] processLcConfigGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigGetMessage lcConfigGetMessage = (LcConfigGetMessage)bidibMessage;
            LcOutputType outputType = lcConfigGetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigGetMessage.getPortNumber(this.getPortModel());
            Port port = null;
            switch (outputType) {
                case SWITCHPORT: {
                    port = (Port)this.switchPorts.get(outputNumber);
                    break;
                }
                case SERVOPORT: {
                    if (outputNumber == 1) break;
                    port = (Port)this.servoPorts.get(outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigResponse lcConfigResponse = new LcConfigResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, port.getPortConfig());
                response = lcConfigResponse.getContent();
            } else {
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfig response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcConfigSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigResponse magicResponse;
            LcConfigSetMessage lcConfigSetMessage = (LcConfigSetMessage)bidibMessage;
            LcOutputType outputType = lcConfigSetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigSetMessage.getPortNumber(this.getPortModel());
            SwitchPort port = null;
            switch (outputType) {
                case SWITCHPORT: {
                    SwitchPort switchPort = (SwitchPort)this.switchPorts.get(outputNumber);
                    if (switchPort != null) {
                        switchPort.setPortConfig(lcConfigSetMessage.getPortConfig());
                        port = switchPort;
                        break;
                    }
                    LOGGER.warn("Switchport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case SERVOPORT: {
                    ServoPort servoPort = (ServoPort)this.servoPorts.get(outputNumber);
                    if (servoPort != null && outputNumber != 1) {
                        servoPort.setPortConfig(lcConfigSetMessage.getPortConfig());
                        port = servoPort;
                        break;
                    }
                    LOGGER.warn("Servoport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                magicResponse = new LcConfigResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, port.getPortConfig());
                response = magicResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
            int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
            LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
            ServoPort port = null;
            switch (outputType) {
                case SWITCHPORT: {
                    LOGGER.info("Set the switch port config, outputNumber: {}", (Object)outputNumber);
                    SwitchPort switchPort = (SwitchPort)this.switchPorts.get(outputNumber);
                    if (switchPort != null) {
                        switchPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = switchPort;
                        break;
                    }
                    LOGGER.warn("Switchport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case SERVOPORT: {
                    ServoPort servoPort = (ServoPort)this.servoPorts.get(outputNumber);
                    if (servoPort != null) {
                        servoPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = servoPort;
                        break;
                    }
                    LOGGER.warn("Servoport not available, outputNumber: {}", (Object)servoPort);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigX lcConfigX = new LcConfigX(bidibPort, lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                response = lcConfigXResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
            int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
            LcOutputType outputType = lcConfigXGetMessage.getPortType(this.getPortModel());
            Port port = null;
            LinkedHashMap<Byte, BytePortConfigValue> values = new LinkedHashMap<Byte, BytePortConfigValue>();
            switch (outputType) {
                case SWITCHPORT: {
                    port = (Port)this.switchPorts.get(outputNumber);
                    SwitchPort switchPort = (SwitchPort)port;
                    values.put((byte)11, new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchPort.getSwitchOffTime())));
                    values.put(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, new BytePortConfigValue(Byte.valueOf(switchPort.getOutputBehaviour().getType())));
                    break;
                }
                case SERVOPORT: {
                    port = (Port)this.servoPorts.get(outputNumber);
                    ServoPort servoPort = (ServoPort)port;
                    values.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getSpeed()))));
                    values.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getTrimDown()))));
                    values.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.getTrimUp()))));
                    if (servoPort.getServoExtra() != null) {
                        values.put((byte)10, new BytePortConfigValue(ByteUtils.getLowByte((Integer)servoPort.getServoExtra())));
                    }
                    if (!servoPort.isPortConfigKeySupported(Byte.valueOf((byte)16))) break;
                    values.put((byte)16, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)servoPort.prepareMoveType()))));
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            LOGGER.info("Return config of port: {}", (Object)port);
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
            LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
            response = lcConfigXResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        block14: {
            LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
            byte[] response = null;
            try {
                LcConfigXResponse lcConfigXResponse;
                LcConfigX lcConfigX;
                BidibPort bidibPort;
                LcConfigXGetAllMessage lcConfigXGetAllMessage = (LcConfigXGetAllMessage)bidibMessage;
                LcOutputType outputType = lcConfigXGetAllMessage.getPortTypeFrom(this.getPortModel());
                LinkedHashMap values = new LinkedHashMap();
                if (outputType != null) {
                    LOGGER.info("Get all ports for output type: {}", (Object)outputType);
                    switch (outputType) {
                        case SERVOPORT: {
                            for (ServoPort servoPort : this.servoPorts.values()) {
                                values.clear();
                                values.putAll(servoPort.getPortConfigX());
                                LOGGER.info("Return config of servo port: {}", (Object)servoPort);
                                BidibPort bidibPort2 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)servoPort.getId());
                                LcConfigX lcConfigX2 = new LcConfigX(bidibPort2, values);
                                LcConfigXResponse lcConfigXResponse2 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX2, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse2.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block14;
                        }
                        case SWITCHPORT: {
                            for (SwitchPort switchPort : this.switchPorts.values()) {
                                values.clear();
                                values.putAll(switchPort.getPortConfigX());
                                LOGGER.info("Return config of switch port: {}", (Object)switchPort);
                                BidibPort bidibPort3 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)switchPort.getId());
                                LcConfigX lcConfigX3 = new LcConfigX(bidibPort3, values);
                                LcConfigXResponse lcConfigXResponse3 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX3, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse3.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block14;
                        }
                        case INPUTPORT: {
                            for (InputPort inputPort : this.inputPorts.values()) {
                                values.clear();
                                values.putAll(inputPort.getPortConfigX());
                                LOGGER.info("Return config of input port: {}", (Object)inputPort);
                                BidibPort bidibPort4 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)inputPort.getId());
                                LcConfigX lcConfigX4 = new LcConfigX(bidibPort4, values);
                                LcConfigXResponse lcConfigXResponse4 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX4, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse4.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block14;
                        }
                        default: {
                            LOGGER.warn("Unsupported port type requested: {}", (Object)outputType);
                            break;
                        }
                    }
                    break block14;
                }
                for (ServoPort servoPort : this.servoPorts.values()) {
                    values.clear();
                    values.putAll(servoPort.getPortConfigX());
                    LOGGER.info("Return config of servo port: {}", (Object)servoPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.SERVOPORT, (int)servoPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (SwitchPort switchPort : this.switchPorts.values()) {
                    values.clear();
                    values.putAll(switchPort.getPortConfigX());
                    LOGGER.info("Return config of switch port: {}", (Object)switchPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.SWITCHPORT, (int)switchPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (InputPort inputPort : this.inputPorts.values()) {
                    values.clear();
                    values.putAll(inputPort.getPortConfigX());
                    LOGGER.info("Return config of input port: {}", (Object)inputPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.INPUTPORT, (int)inputPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create lcConfigXResponse response failed.", (Throwable)ex);
            }
        }
    }

    @Override
    protected byte[] processLcKeyQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcKeyQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte keyState = 0;
        Port port = null;
        try {
            LcKeyMessage lcKeyMessage = (LcKeyMessage)bidibMessage;
            int portNumber = lcKeyMessage.getBidibPort().getPortNumber(PortModelEnum.type);
            port = (Port)this.inputPorts.get(portNumber);
            keyState = port.getStatus().getType().getType();
            LcKeyResponse lcKeyResponse = new LcKeyResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)portNumber), keyState);
            response = lcKeyResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcKey response failed.", (Throwable)ex);
        }
        if (port != null) {
            this.publishInputPortChange(port);
        }
        return response;
    }

    private void publishInputPortChange(Port<?> port) {
        InputPort inputPort = (InputPort)port;
        InputPortStatus status = (InputPortStatus)inputPort.getStatus();
        LOGGER.info("The inputport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new InputPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), inputPort.getId(), status));
    }

    @Override
    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcPortQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte portState = 0;
        try {
            LcPortQueryMessage lcPortQueryMessage = (LcPortQueryMessage)bidibMessage;
            LcOutputType outputType = lcPortQueryMessage.getPortType(this.getPortModel());
            int portNumber = lcPortQueryMessage.getPortNumber(this.getPortModel());
            switch (outputType) {
                case INPUTPORT: {
                    portState = ((InputPortStatus)((InputPort)this.inputPorts.get(portNumber)).getStatus()).getType().getType();
                    break;
                }
                case SWITCHPORT: {
                    portState = ((SwitchPortStatus)((SwitchPort)this.switchPorts.get(portNumber)).getStatus()).getType().getType();
                    break;
                }
                case SERVOPORT: {
                    portState = ByteUtils.getLowByte((Integer)((ServoPort)this.servoPorts.get(portNumber)).getValue());
                    break;
                }
                default: {
                    LOGGER.warn("LcOutputQuery for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
            LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
            response = lcStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcMacroParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroParaGetMessage lcMacroParaGetMessage = (LcMacroParaGetMessage)bidibMessage;
            int macroNumber = lcMacroParaGetMessage.getMacroNumber();
            int paramId = lcMacroParaGetMessage.getParameterIndex();
            LOGGER.info("Process macroNumber: {}, paramId: {}", (Object)macroNumber, (Object)paramId);
            MacroContainer container = (MacroContainer)this.macros.get(macroNumber);
            if (container == null) {
                LOGGER.info("Create new MacroContainer for macro number: {}", (Object)macroNumber);
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            byte[] parameter = container.getMacroParameter(paramId);
            LcMacroParaResponse lcMacroParaResponse = new LcMacroParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)macroNumber, (byte)paramId, parameter);
            response = lcMacroParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroPara response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcMacroParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroParaSetMessage lcMacroParaSetMessage = (LcMacroParaSetMessage)bidibMessage;
            int macroNumber = lcMacroParaSetMessage.getMacroNumber();
            int paramId = lcMacroParaSetMessage.getParameterIndex();
            byte[] parameter = lcMacroParaSetMessage.getValue();
            MacroContainer container = (MacroContainer)this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            container.setMacroParameter(paramId, parameter);
            LcMacroParaResponse lcMacroParaResponse = new LcMacroParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)macroNumber, (byte)paramId, parameter);
            response = lcMacroParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroPara response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcMacroHandleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroHandle request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroHandleMessage lcMacroHandleMessage = (LcMacroHandleMessage)bidibMessage;
            Integer macroNumber = lcMacroHandleMessage.getMacroNumber();
            LcMacroOperationCode lcMacroOperationCode = lcMacroHandleMessage.getMacroOperationCode();
            LOGGER.info("Handle macro request, macroNumber: {}, lcMacroOperationCode: {}", (Object)macroNumber, (Object)lcMacroOperationCode);
            LcMacroState macroState = null;
            switch (lcMacroOperationCode) {
                case START: {
                    macroState = LcMacroState.RUNNING;
                    break;
                }
                case DELETE: {
                    macroState = LcMacroState.DELETE;
                    LOGGER.info("Remove macro with number: {}", (Object)macroNumber);
                    this.macros.remove(macroNumber);
                    break;
                }
                case OFF: {
                    macroState = LcMacroState.OFF;
                    break;
                }
                case RESTORE: {
                    macroState = LcMacroState.RESTORE;
                    break;
                }
                case SAVE: {
                    macroState = LcMacroState.SAVE;
                    break;
                }
                default: {
                    macroState = LcMacroState.NOTEXIST;
                }
            }
            LcMacroStateResponse lcMacroStateResponse = new LcMacroStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((Integer)macroNumber).byteValue(), macroState);
            response = lcMacroStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroState response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcMacroGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacro macroStep;
            LcMacroGetMessage lcMacroGetMessage = (LcMacroGetMessage)bidibMessage;
            Integer macroNumber = lcMacroGetMessage.getMacroNumber();
            int stepNumber = lcMacroGetMessage.getStep();
            MacroContainer container = (MacroContainer)this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            LcMacro value = macroStep = container.getMacroStep(stepNumber);
            LcMacroResponse lcMacroResponse = new LcMacroResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((Integer)macroNumber).byteValue(), ByteUtils.getLowByte((int)stepNumber), value);
            response = lcMacroResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacro response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcMacroSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroSetMessage lcMacroSetMessage = (LcMacroSetMessage)bidibMessage;
            int macroNumber = lcMacroSetMessage.getMacroNumber();
            int stepNumber = lcMacroSetMessage.getStep();
            LcMacro macroStep = MacroUtils.getMacro((byte[])lcMacroSetMessage.getData());
            LOGGER.info("Current macroNumber: {}, stepNumber: {}, macroStep: {}", new Object[]{macroNumber, stepNumber, macroStep});
            MacroContainer container = (MacroContainer)this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            container.setMacroStep(stepNumber, macroStep);
            try {
                LcMacroResponse lcMacroResponse = new LcMacroResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)macroNumber), ByteUtils.getLowByte((int)stepNumber), macroStep);
                response = lcMacroResponse.getContent();
            }
            catch (NullPointerException npe) {
                LOGGER.warn("create response failed.", (Throwable)npe);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacro response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{0, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processAccessoryGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryGetMessage accessoryGetMessage = (AccessoryGetMessage)bidibMessage;
            int accessoryNumber = accessoryGetMessage.getAccessoryNumber();
            boolean aspect = false;
            byte[] value = new byte[]{0, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)(aspect ? 1 : 0), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processAccessoryParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaSetMessage accessoryParaSetMessage = (AccessoryParaSetMessage)bidibMessage;
            int accessoryNumber = accessoryParaSetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaSetMessage.getParaNumber();
            byte[] value = accessoryParaSetMessage.getValue();
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            byte[] value = new byte[]{0, 0, 0, 0};
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processVendorGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            Feature feature;
            VendorGetMessage vendorGetMessage = (VendorGetMessage)bidibMessage;
            String vendorDataName = vendorGetMessage.getVendorDataName();
            LOGGER.info("Get the vendor data with name: {}", (Object)vendorDataName);
            String vendorDataValue = (String)this.configurationVariables.get(vendorDataName);
            if (StringUtils.isBlank((CharSequence)vendorDataValue)) {
                vendorDataValue = "";
            }
            if ("10001".equals(vendorDataName) && ((feature = this.getFeature(0)) == null || feature.getValue() == 0)) {
                LOGGER.info("Skip return result for GBM16T.");
                return null;
            }
            VendorResponse vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
            response = vendorResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    public void queryStatus(Class<?> portClass) {
        block4: {
            block5: {
                block3: {
                    if (!InputPort.class.equals(portClass)) break block3;
                    for (InputPort inputPort : this.inputPorts.values()) {
                        this.publishInputPortChange((Port<?>)inputPort);
                    }
                    break block4;
                }
                if (!SwitchPort.class.equals(portClass)) break block5;
                for (SwitchPort switchPort : this.switchPorts.values()) {
                    this.publishSwitchPortChange((Port<?>)switchPort);
                }
                break block4;
            }
            if (!ServoPort.class.equals(portClass)) break block4;
            for (ServoPort servoPort : this.servoPorts.values()) {
                this.publishServoPortChange((Port<?>)servoPort);
            }
        }
    }

    @Override
    public void setPortsConfig(PortType portType) {
        if (portType == null) {
            return;
        }
        LOGGER.info("Set the port config: {}", (Object)portType);
        if (portType instanceof SwitchPortType) {
            this.switchPortCount = portType.getCount();
            LOGGER.info("Set the number of switchPorts: {}", (Object)this.switchPortCount);
        } else if (portType instanceof InputPortType) {
            this.inputPortCount = portType.getCount();
            this.inputPortOffset = portType.getOffset() != null ? portType.getOffset() : 0;
        } else if (portType instanceof ServoPortType) {
            this.servoPortCount = portType.getCount();
        }
    }
}

