/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.CvExchangeFactory;
import org.bidib.jbidibc.core.schema.cvexchange.CVSType;
import org.bidib.jbidibc.core.schema.cvexchange.SaveCV;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.jbidibc.messages.enums.LcMacroOperationCode;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SoundPortEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryNotifyResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaSetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.LcConfigXGetAllMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcMacroGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroHandleMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaResponse;
import org.bidib.jbidibc.messages.message.LcMacroParaSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroResponse;
import org.bidib.jbidibc.messages.message.LcMacroSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroStateResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.message.VendorGetMessage;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.port.RgbPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.MacroUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.FlatPortType;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.LightPortParamsType;
import org.bidib.jbidibc.simulation.nodes.LightPortType;
import org.bidib.jbidibc.simulation.nodes.MotorPortType;
import org.bidib.jbidibc.simulation.nodes.PortType;
import org.bidib.jbidibc.simulation.nodes.ServoPortType;
import org.bidib.jbidibc.simulation.nodes.SoundPortType;
import org.bidib.jbidibc.simulation.nodes.SwitchPortType;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.ServoPortStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.simulation.events.EmergencyStopSetEvent;
import org.bidib.wizard.simulation.events.EmergencyStopStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.MotorPortStatusEvent;
import org.bidib.wizard.simulation.events.ServoPortStatusEvent;
import org.bidib.wizard.simulation.events.SoundPortStatusEvent;
import org.bidib.wizard.simulation.events.SwitchPortStatusEvent;
import org.bidib.wizard.simulation.macro.MacroContainer;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="120"), @BidibNodeSimulator(vid="251", pid="202")})
public class OneStepControlSimulator
extends DefaultNodeSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneStepControlSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.OneStepControlSimulatorPanel";
    private static final String CV_STEPPOS = "STEPPOS";
    protected final Map<Integer, MacroContainer> macros = new HashMap<Integer, MacroContainer>();
    private final Map<Integer, FeedbackPort> feedbackPorts = new HashMap<Integer, FeedbackPort>();
    protected final Map<Integer, InputPort> inputPorts = new HashMap<Integer, InputPort>();
    protected final Map<Integer, LightPort> lightPorts = new HashMap<Integer, LightPort>();
    protected final Map<Integer, SwitchPort> switchPorts = new HashMap<Integer, SwitchPort>();
    protected final Map<Integer, SoundPort> soundPorts = new HashMap<Integer, SoundPort>();
    protected final Map<Integer, ServoPort> servoPorts = new HashMap<Integer, ServoPort>();
    protected final Map<Integer, MotorPort> motorPorts = new HashMap<Integer, MotorPort>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusValid = new AtomicBoolean();
    private final AtomicBoolean statusSignal = new AtomicBoolean();
    private final AtomicBoolean emergencyStop = new AtomicBoolean();
    protected int inputPortCount;
    protected int inputPortOffset;
    protected int lightPortCount;
    protected int servoPortCount;
    protected int switchPortCount;
    protected int motorPortCount;
    protected int soundPortCount;
    protected Map<Integer, Long> aspectMap = new HashMap<Integer, Long>();
    protected Long totalSteps = 0L;
    private TurnTableType tableType = TurnTableType.round;
    private String simulationConfigSearchRoot;
    private final ScheduledExecutorService accessoryStateWorkers = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("simAccessoryStateWorkers-thread-%d").build());
    boolean positionValueChanged;
    private int currentAspectAccessoryControlling;
    private int currentAspectAccessoryOperating = 1;
    private int currentAngle;
    private boolean backwardsDirection;
    private static final int STEP_WIDTH = 5;
    private ScheduledFuture<?> taskFuture;
    private long currentPositionValue;
    private final AtomicLong targetPositionValue = new AtomicLong();

    public OneStepControlSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    protected void prepareFeatures() {
        super.prepareFeatures();
        this.features.add(new Feature(66, 1));
        this.features.add(new Feature(51, 1));
        this.features.add(new Feature(0, 4));
        this.features.add(new Feature(1, 1));
        this.features.add(new Feature(42, 7));
    }

    public void init(Context context) {
        LOGGER.info("Provided context: {}", (Object)context);
        this.simulationConfigSearchRoot = (String)context.get("simulationConfigSearchRoot", String.class, null);
        super.init(context);
    }

    private Long getPositionValue(int currentCv) {
        int[] position = new int[]{Integer.parseInt((String)this.configurationVariables.get(Integer.toString(currentCv))), Integer.parseInt((String)this.configurationVariables.get(Integer.toString(currentCv + 1))), Integer.parseInt((String)this.configurationVariables.get(Integer.toString(currentCv + 2))), Integer.parseInt((String)this.configurationVariables.get(Integer.toString(currentCv + 3)))};
        long longValue = 0L;
        for (int byteIndex = 3; byteIndex > -1; --byteIndex) {
            longValue = longValue << 8 | (long)position[byteIndex];
        }
        Long positionValue = longValue & 0xFFFFFFFFL;
        return positionValue;
    }

    private void prepareAspectMap() {
        if (this.configurationVariables.get(CV_STEPPOS) == null) {
            this.configurationVariables.put(CV_STEPPOS, "0");
        }
        this.updateTableType();
        this.totalSteps = this.getPositionValue(116);
        this.aspectMap.clear();
        int currentCV = 169;
        for (int index = 0; index < 48; ++index) {
            Long positionValue = this.getPositionValue(currentCV + index * 5 + 1);
            if (positionValue.intValue() == -1) {
                LOGGER.info("Found end of positions marker, stop adding aspects to aspectMap. Current index: {}", (Object)index);
                break;
            }
            if (index == 0) {
                this.configurationVariables.put(CV_STEPPOS, positionValue.toString());
                this.currentPositionValue = positionValue;
            }
            Float angleValue = Float.valueOf(positionValue.floatValue() / this.totalSteps.floatValue());
            LOGGER.info("Current aspect: {}, positionValue: {}, angleValue: {}", new Object[]{index, positionValue, angleValue});
            this.aspectMap.put(index, positionValue);
        }
    }

    private void updateTableType() {
        String cvTableType = (String)this.configurationVariables.get(Integer.toString(114));
        if (cvTableType != null) {
            int valTableType = Integer.parseInt(cvTableType);
            this.tableType = TurnTableType.fromValue((byte)ByteUtils.getLowByte((int)valTableType));
            LOGGER.info("Current tableType: {}", (Object)this.tableType);
        }
    }

    public void postConstruct() {
        super.postConstruct();
        LOGGER.info("Add the features in postConstruct.");
        this.features.add(new Feature(50, this.inputPortCount));
        this.features.add(new Feature(53, this.lightPortCount));
        this.features.add(new Feature(54, this.servoPortCount));
        this.features.add(new Feature(52, this.switchPortCount));
        this.features.add(new Feature(55, this.soundPortCount));
        this.features.add(new Feature(56, this.motorPortCount));
        if (MapUtils.isNotEmpty((Map)this.configurationVariables)) {
            LOGGER.info("The configuration variables are set already. Prepare the aspectMap from the CV value in the simulation.xml.");
            this.prepareAspectMap();
            return;
        }
        String userHome = System.getProperty("user.home");
        File cvValuesFile = new File(userHome, ".bidib/data/simulation/stepcontrol-cv.xml");
        if (StringUtils.isNotBlank((CharSequence)this.simulationConfigSearchRoot) && new File(this.simulationConfigSearchRoot).isDirectory()) {
            LOGGER.info("Load the stepcontrol-cv.xml from folder based on simulationConfigSearchRoot: {}", (Object)this.simulationConfigSearchRoot);
            cvValuesFile = new File(this.simulationConfigSearchRoot, "data/simulation/stepcontrol-cv.xml");
        }
        LOGGER.info("Prepared location to load CV values from cvValuesFile: {}", (Object)cvValuesFile.getPath());
        boolean cvValuesFromFileLoaded = false;
        if (cvValuesFile.exists()) {
            try (FileInputStream cvValues = new FileInputStream(cvValuesFile);){
                SaveCV saveCV = new CvExchangeFactory().loadCV((InputStream)cvValues);
                LOGGER.info("Loaded saveCV from stream.");
                this.configurationVariables.clear();
                if (saveCV != null && saveCV.getCVs() != null && CollectionUtils.isNotEmpty((Collection)saveCV.getCVs().getCv())) {
                    for (CVSType cv : saveCV.getCVs().getCv()) {
                        this.configurationVariables.put(cv.getNumber(), cv.getValue());
                    }
                }
                this.prepareAspectMap();
                cvValuesFromFileLoaded = true;
            }
            catch (Exception ex) {
                LOGGER.warn("Load CV values from file failed.", (Throwable)ex);
            }
        }
        if (!cvValuesFromFileLoaded) {
            this.configurationVariables.put("1", "1");
            this.configurationVariables.put("2", "13");
            this.configurationVariables.put("3", "120");
            this.configurationVariables.put("4", "0");
            this.configurationVariables.put("5", "0");
            this.configurationVariables.put("6", "0");
            this.configurationVariables.put("7", "21");
            this.configurationVariables.put("80", "0");
            this.configurationVariables.put("113", "0");
            this.configurationVariables.put("114", "1");
            this.configurationVariables.put("115", "16");
            this.configurationVariables.put("116", "0");
            this.configurationVariables.put("117", "50");
            this.configurationVariables.put("118", "0");
            this.configurationVariables.put("119", "0");
            this.configurationVariables.put("120", "112");
            this.configurationVariables.put("121", "11");
            this.configurationVariables.put("122", "0");
            this.configurationVariables.put("123", "0");
            this.configurationVariables.put(CV_STEPPOS, "0");
            this.configurationVariables.put("124", "0");
            this.configurationVariables.put("125", "0");
            this.configurationVariables.put("126", "10");
            this.configurationVariables.put("127", "0");
            this.configurationVariables.put("128", "8");
            this.configurationVariables.put("129", "50");
            this.configurationVariables.put("130", "0");
            this.configurationVariables.put("131", "40");
            this.configurationVariables.put("132", "0");
            this.configurationVariables.put("133", "100");
            this.configurationVariables.put("134", "0");
            this.configurationVariables.put("137", "50");
            this.configurationVariables.put("153", "1");
            this.configurationVariables.put("154", "0");
            this.configurationVariables.put("156", "0");
            this.configurationVariables.put("161", "144");
            this.configurationVariables.put("162", "1");
            this.configurationVariables.put("163", "64");
            this.configurationVariables.put("164", "13");
            this.configurationVariables.put("165", "1");
            this.configurationVariables.put("166", "0");
            this.configurationVariables.put("167", "1");
            this.configurationVariables.put("168", "0");
            this.configurationVariables.put("169", "0");
            this.configurationVariables.put("170", "0");
            this.configurationVariables.put("171", "0");
            this.configurationVariables.put("172", "0");
            this.configurationVariables.put("173", "0");
            this.configurationVariables.put("174", "0");
            this.configurationVariables.put("175", "20");
            this.configurationVariables.put("176", "0");
            this.configurationVariables.put("177", "0");
            this.configurationVariables.put("178", "0");
            this.configurationVariables.put("179", "1");
            this.configurationVariables.put("180", "32");
            this.configurationVariables.put("181", "3");
            this.configurationVariables.put("182", "0");
            this.configurationVariables.put("183", "0");
            this.configurationVariables.put("184", "1");
            this.configurationVariables.put("185", "0");
            this.configurationVariables.put("186", "25");
            this.configurationVariables.put("187", "0");
            this.configurationVariables.put("188", "0");
            this.configurationVariables.put("189", "1");
            this.configurationVariables.put("190", "0");
            this.configurationVariables.put("191", "50");
            this.configurationVariables.put("192", "0");
            this.configurationVariables.put("193", "0");
            this.configurationVariables.put("194", "1");
            this.configurationVariables.put("195", "255");
            this.configurationVariables.put("196", "255");
            this.configurationVariables.put("197", "255");
            this.configurationVariables.put("198", "255");
            this.configurationVariables.put("199", "1");
            this.configurationVariables.put("200", "0");
            this.configurationVariables.put("201", "255");
            this.configurationVariables.put("202", "0");
            this.configurationVariables.put("203", "0");
            this.configurationVariables.put("204", "1");
            this.configurationVariables.put("205", "255");
            this.configurationVariables.put("206", "255");
            this.configurationVariables.put("207", "255");
            this.configurationVariables.put("208", "255");
            this.prepareAspectMap();
        }
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.setupFeedbackPorts();
        this.setupInputPorts();
        this.setupLightPorts();
        this.setupSwitchPorts();
        this.setupServoPorts();
        this.setupMotorPorts();
        this.setupSoundPorts();
        super.start();
    }

    public void stop() {
        this.cancelSchedulePublishCurrentAngle();
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    private void setupFeedbackPorts() {
        for (int id = 0; id < 4; ++id) {
            FeedbackPort port = new FeedbackPort();
            port.setId(id);
            port.setStatus(FeedbackPortStatus.FREE);
            this.feedbackPorts.put(id, port);
        }
    }

    protected void setupInputPorts() {
        if (CollectionUtils.isNotEmpty(this.inputPorts.values())) {
            return;
        }
        for (int id = 0; id < this.inputPortCount; ++id) {
            InputPort port = new InputPort();
            port.setId(id);
            port.setStatus((BidibStatus)(id % 2 == 0 ? InputPortStatus.ON : InputPortStatus.OFF));
            this.inputPorts.put(id, port);
        }
    }

    protected void setupLightPorts() {
        if (CollectionUtils.isNotEmpty(this.lightPorts.values())) {
            return;
        }
        for (int id = 0; id < this.lightPortCount; ++id) {
            LightPort port = new LightPort();
            port.setId(id);
            port.setStatus((BidibStatus)(id % 3 == 0 ? LightPortStatus.ON : LightPortStatus.OFF));
            this.lightPorts.put(id, port);
        }
    }

    protected void setupSwitchPorts() {
        if (CollectionUtils.isNotEmpty(this.switchPorts.values())) {
            return;
        }
        for (int id = 0; id < this.switchPortCount; ++id) {
            SwitchPort port = new SwitchPort();
            port.setId(id);
            port.setStatus((BidibStatus)SwitchPortStatus.OFF);
            port.setOutputBehaviour(IoBehaviourSwitchEnum.HIGH);
            port.setSwitchOffTime(Integer.valueOf(15));
            this.switchPorts.put(id, port);
        }
    }

    protected void setupSoundPorts() {
        if (CollectionUtils.isNotEmpty(this.soundPorts.values())) {
            return;
        }
        for (int id = 0; id < this.soundPortCount; ++id) {
            SoundPort port = new SoundPort();
            port.setId(id);
            port.setStatus((BidibStatus)SoundPortStatus.STOP);
            port.setPulseTime(16);
            this.soundPorts.put(id, port);
        }
    }

    protected void setupServoPorts() {
        if (CollectionUtils.isNotEmpty(this.servoPorts.values())) {
            LOGGER.warn("The servo ports are already setup!");
            return;
        }
        LOGGER.info("Create servoPorts, count: {}", (Object)this.servoPortCount);
        for (int id = 0; id < this.servoPortCount; ++id) {
            ServoPort port = new ServoPort();
            port.setId(id);
            port.setRelativeValue(id % 4 * 25);
            this.servoPorts.put(id, port);
        }
    }

    protected void setupMotorPorts() {
        if (CollectionUtils.isNotEmpty(this.motorPorts.values())) {
            LOGGER.warn("The motor ports are already setup!");
            return;
        }
        LOGGER.info("Create motorPorts, count: {}", (Object)this.motorPortCount);
        for (int id = 0; id < this.motorPortCount; ++id) {
            MotorPort port = new MotorPort();
            port.setId(id);
            port.setValue(Integer.valueOf(id % 4 * 25));
            this.motorPorts.put(id, port);
        }
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 64: {
                response = this.processLcOutputRequest(bidibMessage);
                break;
            }
            case 67: {
                response = this.processLcKeyQueryRequest(bidibMessage);
                break;
            }
            case 68: {
                response = this.processLcPortQueryRequest(bidibMessage);
                break;
            }
            case 70: {
                response = this.processLcConfigXSetRequest(bidibMessage);
                break;
            }
            case 71: {
                response = this.processLcConfigXGetRequest(bidibMessage);
                break;
            }
            case 69: {
                this.processLcConfigXGetAllRequest(bidibMessage);
                break;
            }
            case 63: {
                this.processLcPortQueryAllRequest(bidibMessage);
                break;
            }
            case 72: {
                response = this.processLcMacroHandleRequest(bidibMessage);
                break;
            }
            case 76: {
                response = this.processLcMacroParaGetRequest(bidibMessage);
                break;
            }
            case 75: {
                response = this.processLcMacroParaSetRequest(bidibMessage);
                break;
            }
            case 74: {
                response = this.processLcMacroGetRequest(bidibMessage);
                break;
            }
            case 73: {
                response = this.processLcMacroSetRequest(bidibMessage);
                break;
            }
            case 56: {
                response = this.processAccessorySetRequest(bidibMessage);
                break;
            }
            case 57: {
                response = this.processAccessoryGetRequest(bidibMessage);
                break;
            }
            case 60: {
                response = this.processAccessoryGetAllRequest(bidibMessage);
                break;
            }
            case 58: {
                response = this.processAccessoryParaSetRequest(bidibMessage);
                break;
            }
            case 59: {
                response = this.processAccessoryParaGetRequest(bidibMessage);
                break;
            }
            case 32: {
                response = this.processBmGetRangeRequest(bidibMessage);
                break;
            }
            case 33: {
                this.processBmMirrorMultipleRequest(bidibMessage);
                break;
            }
            case 34: {
                this.processBmMirrorOccupiedRequest(bidibMessage);
                break;
            }
            case 35: {
                this.processBmMirrorFreeRequest(bidibMessage);
                break;
            }
            case 36: {
                this.processBmAddrGetRangeRequest(bidibMessage);
                break;
            }
            case 37: {
                response = this.processBmGetConfidenceRequest(bidibMessage);
                break;
            }
            case 23: {
                response = this.processVendorGetRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
            LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
            LightPort port = null;
            switch (outputType) {
                case LIGHTPORT: {
                    LightPort lightPort = this.lightPorts.get(outputNumber);
                    if (lightPort != null) {
                        lightPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = lightPort;
                        break;
                    }
                    LOGGER.warn("Lightport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case SWITCHPORT: {
                    SwitchPort switchPort = this.switchPorts.get(outputNumber);
                    if (switchPort != null) {
                        switchPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = switchPort;
                        break;
                    }
                    LOGGER.warn("Switchport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                case SOUNDPORT: {
                    SoundPort soundPort = this.soundPorts.get(outputNumber);
                    if (soundPort != null) {
                        soundPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = soundPort;
                        break;
                    }
                    LOGGER.warn("Soundport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port == null) {
                LcConfigX lcConfigX = new LcConfigX(bidibPort, lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                response = lcConfigXResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
            int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
            LcOutputType lcOutputType = lcConfigXGetMessage.getPortType(this.getPortModel());
            Port port = null;
            LinkedHashMap<Byte, Object> values = new LinkedHashMap<Byte, Object>();
            switch (lcOutputType) {
                case LIGHTPORT: {
                    port = (Port)this.lightPorts.get(outputNumber);
                    LightPort lightPort = (LightPort)port;
                    values.put((byte)1, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMax()))));
                    values.put((byte)2, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)lightPort.getPwmMin()))));
                    values.put((byte)67, new Int16PortConfigValue(Integer.valueOf(lightPort.getDimMax())));
                    values.put((byte)68, new Int16PortConfigValue(Integer.valueOf(lightPort.getDimMin())));
                    if (lightPort.getRgbValue() != null) {
                        values.put((byte)-128, new RgbPortConfigValue(lightPort.getRgbValue()));
                    }
                    if (outputNumber != 2) break;
                    values.put((byte)0, new BytePortConfigValue(Byte.valueOf((byte)12)));
                    break;
                }
                case SERVOPORT: {
                    port = (Port)this.servoPorts.get(outputNumber);
                    ServoPort servoPort = (ServoPort)port;
                    values.put((byte)7, new BytePortConfigValue(Byte.valueOf((byte)20)));
                    values.put((byte)8, new BytePortConfigValue(Byte.valueOf((byte)-6)));
                    values.put((byte)9, new BytePortConfigValue(Byte.valueOf((byte)5)));
                    LOGGER.info("Return config of servo port: {}", (Object)servoPort);
                    break;
                }
                case SWITCHPORT: {
                    port = (Port)this.switchPorts.get(outputNumber);
                    SwitchPort switchPort = (SwitchPort)port;
                    values.put((byte)11, new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchPort.getSwitchOffTime())));
                    LOGGER.info("Return config of switch port: {}", (Object)switchPort);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)lcOutputType);
                }
            }
            LOGGER.info("Return config of port: {}", (Object)port);
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)outputNumber);
            LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
            LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
            response = lcConfigXResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        block22: {
            LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
            byte[] response = null;
            try {
                LcConfigXResponse lcConfigXResponse;
                LcConfigX lcConfigX;
                BidibPort bidibPort;
                LcConfigXGetAllMessage lcConfigXGetAllMessage = (LcConfigXGetAllMessage)bidibMessage;
                LcOutputType outputType = lcConfigXGetAllMessage.getPortTypeFrom(this.getPortModel());
                Map<Byte, BytePortConfigValue> values = new LinkedHashMap<Byte, BytePortConfigValue>();
                if (outputType != null) {
                    LOGGER.info("Get all ports for output type: {}", (Object)outputType);
                    switch (outputType) {
                        case SERVOPORT: {
                            for (ServoPort servoPort : this.servoPorts.values()) {
                                values.clear();
                                values.put((byte)7, new BytePortConfigValue(Byte.valueOf((byte)20)));
                                values.put((byte)8, new BytePortConfigValue(Byte.valueOf((byte)-6)));
                                values.put((byte)9, new BytePortConfigValue(Byte.valueOf((byte)5)));
                                LOGGER.info("Return config of servo port: {}", (Object)servoPort);
                                BidibPort bidibPort2 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)servoPort.getId());
                                LcConfigX lcConfigX2 = new LcConfigX(bidibPort2, values);
                                LcConfigXResponse lcConfigXResponse2 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX2, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse2.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block22;
                        }
                        case SWITCHPORT: {
                            for (SwitchPort switchPort : this.switchPorts.values()) {
                                values.clear();
                                values.put((byte)11, new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchPort.getSwitchOffTime())));
                                LOGGER.info("Return config of switch port: {}", (Object)switchPort);
                                BidibPort bidibPort3 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)switchPort.getId());
                                LcConfigX lcConfigX3 = new LcConfigX(bidibPort3, values);
                                LcConfigXResponse lcConfigXResponse3 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX3, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse3.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block22;
                        }
                        case LIGHTPORT: {
                            for (LightPort lightPort : this.lightPorts.values()) {
                                values.clear();
                                LOGGER.info("Return config of light port: {}", (Object)lightPort);
                                BidibPort bidibPort4 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)lightPort.getId());
                                LcConfigX lcConfigX4 = new LcConfigX(bidibPort4, values);
                                LcConfigXResponse lcConfigXResponse4 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX4, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse4.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block22;
                        }
                        case INPUTPORT: {
                            for (InputPort inputPort : this.inputPorts.values()) {
                                values.clear();
                                LOGGER.info("Return config of input port: {}", (Object)inputPort);
                                BidibPort bidibPort5 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)inputPort.getId());
                                LcConfigX lcConfigX5 = new LcConfigX(bidibPort5, values);
                                LcConfigXResponse lcConfigXResponse5 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX5, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse5.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block22;
                        }
                        case MOTORPORT: {
                            for (MotorPort motorPort : this.motorPorts.values()) {
                                values.clear();
                                LOGGER.info("Return config of motor port: {}", (Object)motorPort);
                                BidibPort bidibPort6 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)motorPort.getId());
                                LcConfigX lcConfigX6 = new LcConfigX(bidibPort6, values);
                                LcConfigXResponse lcConfigXResponse6 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX6, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse6.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block22;
                        }
                        case SOUNDPORT: {
                            for (SoundPort soundPort : this.soundPorts.values()) {
                                values.clear();
                                LOGGER.info("Return config of sound port: {}", (Object)soundPort);
                                BidibPort bidibPort7 = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)soundPort.getId());
                                LcConfigX lcConfigX7 = new LcConfigX(bidibPort7, values);
                                LcConfigXResponse lcConfigXResponse7 = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX7, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse7.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block22;
                        }
                        default: {
                            LOGGER.warn("Unsupported port type requested: {}", (Object)outputType);
                            break;
                        }
                    }
                    break block22;
                }
                for (ServoPort servoPort : this.servoPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of servo port: {}", (Object)servoPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.SERVOPORT, (int)servoPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (SwitchPort switchPort : this.switchPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of switch port: {}", (Object)switchPort);
                    values = switchPort.getPortConfigX();
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.SWITCHPORT, (int)switchPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (SoundPort soundPort : this.soundPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of switch port: {}", (Object)soundPort);
                    values = soundPort.getPortConfigX();
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.SOUNDPORT, (int)soundPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (InputPort inputPort : this.inputPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of input port: {}", (Object)inputPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.INPUTPORT, (int)inputPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
                for (LightPort lightPort : this.lightPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of light port: {}", (Object)lightPort);
                    bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.LIGHTPORT, (int)lightPort.getId());
                    lcConfigX = new LcConfigX(bidibPort, values);
                    lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create lcConfigXResponse response failed.", (Throwable)ex);
            }
        }
    }

    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
            LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
            int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
            byte outputStatus = lcOutputMessage.getOutputStatus();
            ServoPort port = null;
            switch (outputType) {
                case MOTORPORT: {
                    MotorPort motorPort = this.motorPorts.get(outputNumber);
                    Integer val = ByteUtils.getInt((byte)outputStatus, (int)127);
                    if ((outputStatus & 0x80) == 0) {
                        LOGGER.info("Negative speed: {}", (Object)val);
                    } else {
                        LOGGER.info("Positive speed: {}", (Object)val);
                    }
                    motorPort.setValue(ByteUtils.getInteger((byte)outputStatus));
                    port = motorPort;
                    break;
                }
                case SWITCHPORT: {
                    SwitchPort switchPort = this.switchPorts.get(outputNumber);
                    switchPort.setStatus((BidibStatus)SwitchPortStatus.valueOf((SwitchPortEnum)SwitchPortEnum.valueOf((byte)outputStatus)));
                    port = switchPort;
                    break;
                }
                case SOUNDPORT: {
                    SoundPort soundPort = this.soundPorts.get(outputNumber);
                    soundPort.setStatus((BidibStatus)SoundPortStatus.valueOf((SoundPortEnum)SoundPortEnum.valueOf((byte)outputStatus)));
                    port = soundPort;
                    break;
                }
                case SERVOPORT: {
                    ServoPort servoPort = this.servoPorts.get(outputNumber);
                    servoPort.setValue(ByteUtils.getInteger((byte)outputStatus));
                    port = servoPort;
                    break;
                }
                default: {
                    LOGGER.warn("LcOutput request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, outputStatus);
                response = lcStatResponse.getContent();
            } else {
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
            if (port != null) {
                switch (outputType) {
                    case MOTORPORT: {
                        this.publishMotorPortChange((Port<?>)port);
                        break;
                    }
                    case SWITCHPORT: {
                        this.publishSwitchPortChange((Port<?>)port);
                        break;
                    }
                    case SOUNDPORT: {
                        this.publishSoundPortChange((Port<?>)port);
                        break;
                    }
                    case SERVOPORT: {
                        this.publishServoPortChange((Port<?>)port);
                        break;
                    }
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcKeyQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcKeyQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte keyState = 0;
        Port port = null;
        try {
            LcKeyMessage lcKeyMessage = (LcKeyMessage)bidibMessage;
            int portNumber = lcKeyMessage.getBidibPort().getPortNumber(PortModelEnum.type);
            port = (Port)this.inputPorts.get(portNumber);
            keyState = port.getStatus().getType().getType();
            LcKeyResponse lcKeyResponse = new LcKeyResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)portNumber), keyState);
            response = lcKeyResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcKey response failed.", (Throwable)ex);
        }
        if (port != null) {
            this.publishInputPortChange(port);
        }
        return response;
    }

    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutputQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte portState = 0;
        try {
            LcPortQueryMessage lcPortQueryMessage = (LcPortQueryMessage)bidibMessage;
            LcOutputType outputType = lcPortQueryMessage.getPortType(this.getPortModel());
            int portNumber = lcPortQueryMessage.getPortNumber(this.getPortModel());
            switch (outputType) {
                case INPUTPORT: {
                    portState = ((InputPortStatus)this.inputPorts.get(portNumber).getStatus()).getType().getType();
                    break;
                }
                case LIGHTPORT: {
                    portState = ((LightPortStatus)this.lightPorts.get(portNumber).getStatus()).getType().getType();
                    break;
                }
                case MOTORPORT: {
                    portState = ByteUtils.getLowByte((Integer)this.motorPorts.get(portNumber).getValue());
                    break;
                }
                case SWITCHPORT: {
                    portState = ((SwitchPortStatus)this.switchPorts.get(portNumber).getStatus()).getType().getType();
                    break;
                }
                case SOUNDPORT: {
                    portState = ((SoundPortStatus)this.soundPorts.get(portNumber).getStatus()).getType().getType();
                    break;
                }
                case SERVOPORT: {
                    portState = ByteUtils.getLowByte((Integer)this.servoPorts.get(portNumber).getValue());
                    break;
                }
                default: {
                    LOGGER.warn("LcOutputQuery for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
            LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
            response = lcStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcPortQueryAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the PortQueryAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            byte portStatus;
            LcPortQueryAllMessage portQueryAllMessage = (LcPortQueryAllMessage)bidibMessage;
            int portRangeFrom = portQueryAllMessage.getPortRangeFrom(this.getPortModel());
            int portRangeTo = portQueryAllMessage.getPortRangeTo(this.getPortModel());
            int portTypeMask = portQueryAllMessage.getPortTypeMask();
            LOGGER.info("Query all port states, portRangeFrom: {}, portRangeTo: {}, portModel: {}, portTypeMask: {}", new Object[]{portRangeFrom, portRangeTo, this.getPortModel(), portTypeMask});
            if (PortConfigUtils.isSupportsInputPort((int)portTypeMask) && MapUtils.isNotEmpty(this.inputPorts)) {
                for (InputPort inputPort : this.inputPorts.values()) {
                    if (inputPort.getId() >= portRangeFrom && inputPort.getId() < portRangeTo) {
                        try {
                            InputPortStatus inputPortStatus = (InputPortStatus)inputPort.getStatus();
                            if (inputPortStatus == null) {
                                inputPort.setStatus((BidibStatus)InputPortStatus.OFF);
                                inputPortStatus = (InputPortStatus)inputPort.getStatus();
                            }
                            portStatus = inputPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.INPUTPORT, inputPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)inputPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip input port that is out of port range: {}", (Object)inputPort);
                }
            }
            if (PortConfigUtils.isSupportsLightPort((int)portTypeMask) && MapUtils.isNotEmpty(this.lightPorts)) {
                for (LightPort lightPort : this.lightPorts.values()) {
                    if (lightPort.getId() >= portRangeFrom && lightPort.getId() < portRangeTo) {
                        try {
                            LightPortStatus lightPortStatus = (LightPortStatus)lightPort.getStatus();
                            if (lightPortStatus == null) {
                                lightPort.setStatus((BidibStatus)LightPortStatus.OFF);
                                lightPortStatus = (LightPortStatus)lightPort.getStatus();
                            }
                            portStatus = lightPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.LIGHTPORT, lightPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)lightPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip light port that is out of port range: {}", (Object)lightPort);
                }
            }
            if (PortConfigUtils.isSupportsSwitchPort((int)portTypeMask) && MapUtils.isNotEmpty(this.switchPorts)) {
                for (SwitchPort switchPort : this.switchPorts.values()) {
                    if (switchPort.getId() >= portRangeFrom && switchPort.getId() < portRangeTo) {
                        try {
                            SwitchPortStatus switchPortStatus = (SwitchPortStatus)switchPort.getStatus();
                            if (switchPortStatus == null) {
                                switchPort.setStatus((BidibStatus)SwitchPortStatus.OFF);
                                switchPortStatus = (SwitchPortStatus)switchPort.getStatus();
                            }
                            portStatus = switchPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.SWITCHPORT, switchPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)switchPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip switch port that is out of port range: {}", (Object)switchPort);
                }
            }
            if (PortConfigUtils.isSupportsServoPort((int)portTypeMask) && MapUtils.isNotEmpty(this.servoPorts)) {
                for (ServoPort servoPort : this.servoPorts.values()) {
                    if (servoPort.getId() >= portRangeFrom && servoPort.getId() < portRangeTo) {
                        try {
                            ServoPortStatus servoPortStatus = (ServoPortStatus)servoPort.getStatus();
                            if (servoPortStatus == null) {
                                servoPort.setStatus((BidibStatus)ServoPortStatus.START);
                                servoPortStatus = (ServoPortStatus)servoPort.getStatus();
                            }
                            portStatus = servoPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.SERVOPORT, servoPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)servoPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip servo port that is out of port range: {}", (Object)servoPort);
                }
            }
            if (PortConfigUtils.isSupportsSoundPort((int)portTypeMask) && MapUtils.isNotEmpty(this.soundPorts)) {
                for (SoundPort soundPort : this.soundPorts.values()) {
                    if (soundPort.getId() >= portRangeFrom && soundPort.getId() < portRangeTo) {
                        try {
                            SoundPortStatus soundPortStatus = (SoundPortStatus)soundPort.getStatus();
                            if (soundPortStatus == null) {
                                soundPort.setStatus((BidibStatus)SoundPortStatus.STOP);
                                soundPortStatus = (SoundPortStatus)soundPort.getStatus();
                            }
                            portStatus = soundPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.SOUNDPORT, soundPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)soundPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip sound port that is out of port range: {}", (Object)soundPort);
                }
            }
            LOGGER.info("Send the terminating LC_NA message.");
            this.publishLcNaResponse(bidibMessage.getAddr());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void publishPortState(byte[] address, LcOutputType outputType, int outputNumber, byte portStatus) throws ProtocolException {
        BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
        LcStatResponse lcStatResponse = new LcStatResponse(address, this.getNextSendNum(), bidibPort, portStatus);
        LOGGER.info("Prepared LcStatResponse: {}", (Object)lcStatResponse);
        byte[] response = lcStatResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected void publishLcNaResponse(byte[] address) throws ProtocolException {
        BidibPort bidibPort = new BidibPort(new byte[]{ByteUtils.getLowByte((int)255), ByteUtils.getLowByte((int)255)});
        LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(address, this.getNextSendNum(), bidibPort);
        LOGGER.info("Prepared LcNotAvailableResponse: {}", (Object)lcNotAvailableResponse);
        byte[] response = lcNotAvailableResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected byte[] processVendorDisableRequest(BidibMessageInterface bidibMessage) {
        byte[] result = super.processVendorDisableRequest(bidibMessage);
        if (this.positionValueChanged) {
            this.positionValueChanged = false;
            this.prepareAspectMap();
        }
        return result;
    }

    protected byte[] processVendorSetRequest(BidibMessageInterface bidibMessage) {
        return super.processVendorSetRequest(bidibMessage, vd -> {
            this.configurationVariables.put(vd.getName(), vd.getValue());
            switch (vd.getName()) {
                case "114": {
                    this.updateTableType();
                    break;
                }
            }
            if (!this.positionValueChanged) {
                try {
                    int cvNum = Integer.valueOf(vd.getName());
                    if (cvNum >= 169 && cvNum <= 408) {
                        this.positionValueChanged = true;
                    }
                }
                catch (NumberFormatException ex) {
                    LOGGER.warn("Parse CV number failed, message: {}", (Object)ex.getMessage());
                }
            }
        });
    }

    protected byte[] processVendorGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            String vendorDataValue;
            VendorGetMessage vendorGetMessage = (VendorGetMessage)bidibMessage;
            String vendorDataName = vendorGetMessage.getVendorDataName();
            LOGGER.info("Get the vendor data with name: {}", (Object)vendorDataName);
            if ("124".equals(vendorDataName)) {
                byte accessoryNum = 1;
                byte aspect = 1;
                byte[] value = new byte[]{4, 0, 0};
                AccessoryNotifyResponse accessoryNotifyResponse = new AccessoryNotifyResponse(bidibMessage.getAddr(), this.getNextSendNum(), accessoryNum, aspect, value);
                LOGGER.info("Send the accessoryNotifyResponse fore testing purposes: {}", (Object)accessoryNotifyResponse);
                this.sendSpontanousResponse(accessoryNotifyResponse.getContent());
            }
            if (StringUtils.isBlank((CharSequence)(vendorDataValue = (String)this.configurationVariables.get(vendorDataName)))) {
                vendorDataValue = "";
            }
            VendorResponse vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
            response = vendorResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishSwitchPortChange(Port<?> port) {
        SwitchPort switchPort = (SwitchPort)port;
        SwitchPortStatus status = (SwitchPortStatus)switchPort.getStatus();
        LOGGER.info("The switchport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new SwitchPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), switchPort.getId(), status));
    }

    private void publishSoundPortChange(Port<?> port) {
        SoundPort soundPort = (SoundPort)port;
        SoundPortStatus status = (SoundPortStatus)soundPort.getStatus();
        LOGGER.info("The soundport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new SoundPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), soundPort, status));
    }

    private void publishMotorPortChange(Port<?> port) {
        MotorPort motorPort = (MotorPort)port;
        int value = motorPort.getValue();
        LOGGER.info("The motorport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new MotorPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), motorPort.getId(), value));
    }

    private void publishServoPortChange(Port<?> port) {
        ServoPort servoPort = (ServoPort)port;
        Integer value = servoPort.getValue();
        LOGGER.info("The servoport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new ServoPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), servoPort.getId(), value));
    }

    private void publishInputPortChange(Port<?> port) {
        InputPort inputPort = (InputPort)port;
        InputPortStatus status = (InputPortStatus)inputPort.getStatus();
        LOGGER.info("The inputport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new InputPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), inputPort.getId(), status));
    }

    protected byte[] processLcMacroHandleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroHandle request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroHandleMessage lcMacroHandleMessage = (LcMacroHandleMessage)bidibMessage;
            Integer macroNumber = lcMacroHandleMessage.getMacroNumber();
            LcMacroOperationCode lcMacroOperationCode = lcMacroHandleMessage.getMacroOperationCode();
            LOGGER.info("Handle macro request, macroNumber: {}, lcMacroOperationCode: {}", (Object)macroNumber, (Object)lcMacroOperationCode);
            LcMacroState macroState = null;
            switch (lcMacroOperationCode) {
                case START: {
                    macroState = LcMacroState.RUNNING;
                    break;
                }
                case DELETE: {
                    macroState = LcMacroState.DELETE;
                    LOGGER.info("Remove macro with number: {}", (Object)macroNumber);
                    this.macros.remove(macroNumber);
                    break;
                }
                case OFF: {
                    macroState = LcMacroState.OFF;
                    break;
                }
                case RESTORE: {
                    macroState = LcMacroState.RESTORE;
                    break;
                }
                case SAVE: {
                    macroState = LcMacroState.SAVE;
                    break;
                }
                default: {
                    macroState = LcMacroState.NOTEXIST;
                }
            }
            LcMacroStateResponse lcMacroStateResponse = new LcMacroStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((Integer)macroNumber).byteValue(), macroState);
            response = lcMacroStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroParaGetMessage lcMacroParaGetMessage = (LcMacroParaGetMessage)bidibMessage;
            int macroNumber = lcMacroParaGetMessage.getMacroNumber();
            int paramId = lcMacroParaGetMessage.getParameterIndex();
            LOGGER.info("Process macroNumber: {}, paramId: {}", (Object)macroNumber, (Object)paramId);
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                LOGGER.info("Create new MacroContainer for macro number: {}", (Object)macroNumber);
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            byte[] parameter = container.getMacroParameter(paramId);
            LcMacroParaResponse lcMacroParaResponse = new LcMacroParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)macroNumber, (byte)paramId, parameter);
            response = lcMacroParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroParaSetMessage lcMacroParaSetMessage = (LcMacroParaSetMessage)bidibMessage;
            int macroNumber = lcMacroParaSetMessage.getMacroNumber();
            int paramId = lcMacroParaSetMessage.getParameterIndex();
            byte[] parameter = lcMacroParaSetMessage.getValue();
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            container.setMacroParameter(paramId, parameter);
            LcMacroParaResponse lcMacroParaResponse = new LcMacroParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)macroNumber, (byte)paramId, parameter);
            response = lcMacroParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacroPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacro macroStep;
            LcMacroGetMessage lcMacroGetMessage = (LcMacroGetMessage)bidibMessage;
            Integer macroNumber = lcMacroGetMessage.getMacroNumber();
            int stepNumber = lcMacroGetMessage.getStep();
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            LcMacro value = macroStep = container.getMacroStep(stepNumber);
            LcMacroResponse lcMacroResponse = new LcMacroResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((Integer)macroNumber).byteValue(), ByteUtils.getLowByte((int)stepNumber), value);
            response = lcMacroResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacro response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcMacroSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcMacroSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcMacroSetMessage lcMacroSetMessage = (LcMacroSetMessage)bidibMessage;
            int macroNumber = lcMacroSetMessage.getMacroNumber();
            int stepNumber = lcMacroSetMessage.getStep();
            LcMacro macroStep = MacroUtils.getMacro((byte[])lcMacroSetMessage.getData());
            LOGGER.info("Current macroNumber: {}, stepNumber: {}, macroStep: {}", new Object[]{macroNumber, stepNumber, macroStep});
            MacroContainer container = this.macros.get(macroNumber);
            if (container == null) {
                container = new MacroContainer(macroNumber);
                this.macros.put(macroNumber, container);
            }
            container.setMacroStep(stepNumber, macroStep);
            try {
                LcMacroResponse lcMacroResponse = new LcMacroResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)macroNumber), ByteUtils.getLowByte((int)stepNumber), macroStep);
                response = lcMacroResponse.getContent();
            }
            catch (NullPointerException npe) {
                LOGGER.warn("create response failed.", (Throwable)npe);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcMacro response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{0, 0, 0};
            if (accessoryNumber == 0) {
                if (aspect < this.aspectMap.size()) {
                    int currentAngle = this.currentAngle;
                    Long positionValue = this.aspectMap.get(aspect);
                    this.targetPositionValue.set(positionValue);
                    Float angleValue = Float.valueOf(positionValue.floatValue() / this.totalSteps.floatValue());
                    int targetAngle = (int)(angleValue.floatValue() * 360.0f / 1.5f);
                    LOGGER.info("Current aspect: {}, targetPositionValue: {}, targetAngle: {}, currentAngle: {}", new Object[]{aspect, this.targetPositionValue.get(), targetAngle, currentAngle});
                    this.backwardsDirection = targetAngle < currentAngle;
                    boolean finished = targetAngle == currentAngle;
                    byte execute = (byte)(!finished ? 1 : 0);
                    byte wait = (byte)(finished ? 0 : 72);
                    value = new byte[]{48, execute, wait, 1, ByteUtils.getLowByte((int)currentAngle), 2, ByteUtils.getLowByte((int)targetAngle)};
                    this.currentAngle = currentAngle;
                    this.currentAspectAccessoryControlling = aspect;
                    int currentStepPos = (int)((float)currentAngle * 1.5f * this.totalSteps.floatValue() / 360.0f);
                    this.configurationVariables.put(CV_STEPPOS, Integer.toString(currentStepPos));
                    this.schedulePublishCurrentAngle();
                } else {
                    LOGGER.warn("Ignore aspect out of bounds: {}", (Object)aspect);
                }
            } else if (accessoryNumber == 1) {
                this.currentAspectAccessoryOperating = aspect;
            }
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, ByteUtils.getLowByte((int)aspect), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryGetMessage accessoryGetMessage = (AccessoryGetMessage)bidibMessage;
            int accessoryNumber = accessoryGetMessage.getAccessoryNumber();
            int aspect = 0;
            byte[] value = new byte[]{0, 0, 0};
            if (this.emergencyStop.get()) {
                LOGGER.info("Simulator is in emergency stop mode.");
                accessoryNumber = 0;
                aspect = ByteUtils.getLowByte((int)254);
                value = new byte[]{3, -127, 0};
            } else if (accessoryNumber == 0) {
                boolean finished = false;
                aspect = this.currentAspectAccessoryControlling;
                Long positionValue = this.aspectMap.get(aspect);
                Float angleValue = Float.valueOf(positionValue.floatValue() / this.totalSteps.floatValue());
                int targetAngle = (int)(angleValue.floatValue() * 360.0f / 1.5f);
                LOGGER.info("Current targetAngle: {}, currentAngle: {}, backwardsDirection: {}", new Object[]{targetAngle, this.currentAngle, this.backwardsDirection});
                if (!this.backwardsDirection) {
                    if (targetAngle > this.currentAngle) {
                        this.currentAngle += 5;
                    }
                    if (targetAngle <= this.currentAngle) {
                        this.currentAngle = targetAngle;
                        finished = true;
                    }
                } else {
                    if (targetAngle < this.currentAngle) {
                        this.currentAngle -= 5;
                    }
                    if (targetAngle >= this.currentAngle) {
                        this.currentAngle = targetAngle;
                        finished = true;
                    }
                }
                byte execute = (byte)(!finished ? 1 : 0);
                byte wait = (byte)(finished ? 0 : 72);
                LOGGER.info("finished: {}, execute: {}, wait: {}", new Object[]{finished, execute, wait});
                value = new byte[]{48, execute, wait, 1, ByteUtils.getLowByte((int)this.currentAngle), 2, ByteUtils.getLowByte((int)targetAngle)};
                int currentStepPos = (int)((float)this.currentAngle * 1.5f * this.totalSteps.floatValue() / 360.0f);
                this.configurationVariables.put(CV_STEPPOS, Integer.toString(currentStepPos));
            } else {
                value = new byte[]{4, 0, 0};
                switch (accessoryNumber) {
                    case 1: {
                        value[0] = 4;
                        aspect = this.currentAspectAccessoryOperating;
                        break;
                    }
                    case 2: {
                        value[0] = 3;
                        break;
                    }
                    default: {
                        value[0] = 7;
                    }
                }
                LOGGER.info("AccessoryGet, Return data for accessory: {}, aspect: {}, data: {}", new Object[]{accessoryNumber, aspect, ByteUtils.bytesToHex((byte[])value)});
            }
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, ByteUtils.getLowByte((int)aspect), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    private byte[] prepareMovingAspect(int accessoryNumber) {
        byte[] values = null;
        byte aspect = 0;
        if (this.emergencyStop.get()) {
            LOGGER.info("Simulator is in emergency stop mode.");
            accessoryNumber = 0;
            aspect = ByteUtils.getLowByte((int)254);
            values = new byte[]{3, -127, 0};
        } else if (accessoryNumber == 0) {
            boolean finished = false;
            Long positionValue = this.aspectMap.get(aspect);
            if (positionValue == null) {
                positionValue = 0L;
            }
            Float angleValue = Float.valueOf(positionValue.floatValue() / this.totalSteps.floatValue());
            int targetAngle = (int)(angleValue.floatValue() * 360.0f / 1.5f);
            LOGGER.info("Current targetAngle: {}, currentAngle: {}, backwardsDirection: {}", new Object[]{targetAngle, this.currentAngle, this.backwardsDirection});
            if (!this.backwardsDirection) {
                if (targetAngle > this.currentAngle) {
                    this.currentAngle += 5;
                }
                if (targetAngle <= this.currentAngle) {
                    this.currentAngle = targetAngle;
                    finished = true;
                }
            } else {
                if (targetAngle < this.currentAngle) {
                    this.currentAngle -= 5;
                }
                if (targetAngle >= this.currentAngle) {
                    this.currentAngle = targetAngle;
                    finished = true;
                }
            }
            byte execute = (byte)(!finished ? 1 : 0);
            byte wait = (byte)(finished ? 0 : 72);
            LOGGER.info("finished: {}, execute: {}, wait: {}", new Object[]{finished, execute, wait});
            values = new byte[]{48, execute, wait, 1, ByteUtils.getLowByte((int)this.currentAngle), 2, ByteUtils.getLowByte((int)targetAngle)};
            int currentStepPos = (int)((float)this.currentAngle * 1.5f * this.totalSteps.floatValue() / 360.0f);
            this.configurationVariables.put(CV_STEPPOS, Integer.toString(currentStepPos));
        }
        return values;
    }

    protected byte[] processAccessoryGetAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGetAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            Feature feature = this.getFeature(40);
            int totalAccessoryCount = feature.getValue();
            int aspect = 0;
            byte[] value = new byte[]{0, 0, 0};
            for (int accessoryNumber = 0; accessoryNumber < totalAccessoryCount; ++accessoryNumber) {
                value = new byte[]{4, 0, 0};
                switch (accessoryNumber) {
                    case 0: {
                        aspect = this.currentAspectAccessoryControlling;
                        value = this.prepareMovingAspect(accessoryNumber);
                        break;
                    }
                    case 1: {
                        value[0] = 4;
                        aspect = this.currentAspectAccessoryOperating;
                        break;
                    }
                    case 2: {
                        value[0] = 3;
                        break;
                    }
                    default: {
                        value[0] = 7;
                    }
                }
                LOGGER.info("AccessoryGetAll, Return data for accessory: {}, aspect: {}, data: {}", new Object[]{accessoryNumber, aspect, ByteUtils.bytesToHex((byte[])value)});
                AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, ByteUtils.getLowByte((int)aspect), value);
                response = accessoryStateResponse.getContent();
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return null;
    }

    protected byte[] processAccessoryParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaSetMessage accessoryParaSetMessage = (AccessoryParaSetMessage)bidibMessage;
            int accessoryNumber = accessoryParaSetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaSetMessage.getParaNumber();
            byte[] value = accessoryParaSetMessage.getValue();
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            byte[] value = new byte[]{0, 0, 0, 0};
            switch (accessoryNumber) {
                case 1: {
                    if (paraNumber != 253) break;
                    LOGGER.warn("Signal BIDIB_ACCESSORY_PARA_NOTEXIST for BIDIB_ACCESSORY_PARA_MACROMAP.");
                    value = new byte[]{ByteUtils.getLowByte((int)253)};
                    paraNumber = 255;
                    break;
                }
                case 2: {
                    value = new byte[]{0, 0, 0};
                    break;
                }
            }
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processBmGetRangeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackGetRangeMessage: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            FeedbackGetRangeMessage feedbackGetRangeMessage = (FeedbackGetRangeMessage)bidibMessage;
            int baseAddress = feedbackGetRangeMessage.getBeginRange();
            int end = feedbackGetRangeMessage.getEndRange();
            int feedbackSize = feedbackGetRangeMessage.getEndRange() - feedbackGetRangeMessage.getBeginRange();
            int value = 0;
            int index = 0;
            int feedbackByteSize = feedbackSize / 8 + (feedbackSize % 8 > 0 ? 1 : 0);
            byte[] feedbackMultiple = new byte[feedbackByteSize];
            int position = feedbackMultiple.length;
            for (int portNum = end; portNum > baseAddress; --portNum) {
                value = (byte)((value & 0xFF) << 1);
                FeedbackPort fbp = this.feedbackPorts.get(portNum - 1);
                int status = 0;
                if (fbp != null) {
                    status = ByteUtils.getLowByte((int)((FeedbackPortStatus)fbp.getStatus()).getType().getType(), (int)1);
                }
                feedbackMultiple[position - 1] = value = (int)((byte)(value | status));
                if (++index <= 7) continue;
                value = 0;
                index = 0;
                --position;
            }
            LOGGER.info("Prepared feedback multiple: {}", (Object)ByteUtils.bytesToHex((byte[])feedbackMultiple));
            FeedbackMultipleResponse feedbackMultipleResponse = new FeedbackMultipleResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)baseAddress), ByteUtils.getLowByte((int)feedbackSize), feedbackMultiple);
            response = feedbackMultipleResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackMultiple response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processBmMirrorMultipleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackMirrorMultipleMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorOccupiedRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorOccupiedRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorFreeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorFreeRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmAddrGetRangeRequest(BidibMessageInterface bidibMessage) {
        try {
            for (FeedbackPort port : this.feedbackPorts.values()) {
                int detectorNumber = port.getId();
                ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
                List addresses = port.getAddresses();
                if (CollectionUtils.isNotEmpty((Collection)addresses)) {
                    for (FeedbackAddressData addressData : addresses) {
                        EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                        AddressTypeEnum addressType = null;
                        switch (enrailmentDirection) {
                            case LOCOMOTIVE_LEFT: 
                            case LOCOMOTIVE_RIGHT: {
                                addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                                break;
                            }
                            case BASIC_ACCESSORY: {
                                addressType = AddressTypeEnum.ACCESSORY;
                                break;
                            }
                            case EXTENDED_ACCESSORY: {
                                addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                                break;
                            }
                        }
                        AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                        bidibAddresses.add(bidibAddress);
                    }
                }
                FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorNumber, bidibAddresses);
                byte[] response = feedbackAddressResponse.getContent();
                LOGGER.info("Prepare feedbackAddressResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackAddress response failed.", (Throwable)ex);
        }
    }

    protected byte[] processBmGetConfidenceRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            byte valid = (byte)(this.statusValid.get() ? 1 : 0);
            byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
            byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(bidibMessage.getAddr(), this.getNextSendNum(), valid, freeze, signal);
            response = feedbackConfidenceResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackConfidence response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishFeedbackPortChange(Port<?> port) {
        FeedbackPort feedbackPort = (FeedbackPort)port;
        FeedbackPortStatus status = (FeedbackPortStatus)feedbackPort.getStatus();
        LOGGER.info("The feedbackport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getId(), status));
    }

    public void queryStatus(Class<?> portClass) {
        if (FeedbackPort.class.equals(portClass)) {
            for (FeedbackPort feedbackPort : this.feedbackPorts.values()) {
                this.publishFeedbackPortChange((Port<?>)feedbackPort);
            }
            this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
        }
    }

    @EventSubscriber(eventClass=FeedbackConfidenceSetEvent.class)
    public void feedbackConfidenceSetEvent(FeedbackConfidenceSetEvent feedbackConfidenceEvent) {
        String nodeAddress = feedbackConfidenceEvent.getNodeAddr();
        LOGGER.info("The change of the feedback confidence was requested, nodeAddress: {}", (Object)nodeAddress);
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        this.statusValid.set(feedbackConfidenceEvent.getValid());
        this.statusFreeze.set(feedbackConfidenceEvent.getFreeze());
        this.statusSignal.set(feedbackConfidenceEvent.getSignal());
        byte valid = (byte)(this.statusValid.get() ? 1 : 0);
        byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
        byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
        try {
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(this.nodeAddress, this.getNextSendNum(), valid, freeze, signal);
            LOGGER.info("Prepared feedbackConfidenceResponse: {}", (Object)feedbackConfidenceResponse);
            this.sendSpontanousResponse(feedbackConfidenceResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send feedbackConfidenceResponse failed.", (Throwable)ex);
        }
        this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
    }

    private void publishFeedbackConfidenceStatusEvent(boolean valid, boolean freeze, boolean signal) {
        LOGGER.info("The feedbackport confidence status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackConfidenceStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), valid, freeze, signal));
    }

    @EventSubscriber(eventClass=FeedbackPortSetStatusEvent.class)
    public void feedbackPortSetStatus(FeedbackPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the feedback port was requested.");
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        try {
            this.changeFeedbackPortStatus(portNum);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Publish feedback status failed.", (Throwable)ex);
        }
    }

    protected void changeFeedbackPortStatus(int portNum) throws ProtocolException {
        FeedbackPort port = this.feedbackPorts.get(portNum);
        if (port != null) {
            FeedbackOccupiedResponse response = null;
            switch ((FeedbackPortStatus)port.getStatus()) {
                case FREE: {
                    port.setStatus(FeedbackPortStatus.OCCUPIED);
                    response = new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                    break;
                }
                default: {
                    port.setStatus(FeedbackPortStatus.FREE);
                    response = new FeedbackFreeResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                }
            }
            this.sendSpontanousResponse(response.getContent());
            this.publishFeedbackPortChange((Port<?>)port);
        } else {
            LOGGER.warn("The requested feedback port is not available: {}", (Object)portNum);
        }
    }

    @EventSubscriber(eventClass=EmergencyStopSetEvent.class)
    public void emergencyStopSetEvent(EmergencyStopSetEvent emergencyStopEvent) {
        byte[] byArray;
        String nodeAddress = emergencyStopEvent.getNodeAddr();
        LOGGER.info("The change of the emergency stop was requested, nodeAddress: {}", (Object)nodeAddress);
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        this.emergencyStop.set(emergencyStopEvent.getEmergencyStop());
        byte aspect = ByteUtils.getLowByte((int)(this.emergencyStop.get() ? 254 : 0));
        if (this.emergencyStop.get()) {
            byte[] byArray2 = new byte[3];
            byArray2[0] = 3;
            byArray2[1] = -127;
            byArray = byArray2;
            byArray2[2] = 0;
        } else {
            byte[] byArray3 = new byte[3];
            byArray3[0] = 3;
            byArray3[1] = 0;
            byArray = byArray3;
            byArray3[2] = 0;
        }
        byte[] value = byArray;
        try {
            AccessoryNotifyResponse accessoryNotifyResponse = new AccessoryNotifyResponse(this.nodeAddress, this.getNextSendNum(), 0, aspect, value);
            LOGGER.info("Prepared accessoryNotifyResponse: {}", (Object)accessoryNotifyResponse);
            this.sendSpontanousResponse(accessoryNotifyResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send accessoryNotifyResponse failed.", (Throwable)ex);
        }
        this.publishEmergencyStopStatusEvent(this.emergencyStop.get());
    }

    private void publishEmergencyStopStatusEvent(boolean emergencyStop) {
        LOGGER.info("The emergency Stop status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new EmergencyStopStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), emergencyStop));
    }

    public void setPortsConfig(FlatPortType portType) {
    }

    public void setPortsConfig(PortType portType) {
        if (portType == null) {
            return;
        }
        if (portType instanceof LightPortType) {
            LightPortType lightPortType = (LightPortType)portType;
            this.lightPortCount = lightPortType.getCount();
            LOGGER.info("Total number of lightports: {}", (Object)this.lightPortCount);
            this.lightPorts.clear();
            for (int portId = 0; portId < this.lightPortCount; ++portId) {
                LightPort lightPort = new LightPort();
                lightPort.setId(portId);
                this.lightPorts.put(portId, lightPort);
            }
            if (CollectionUtils.isNotEmpty((Collection)lightPortType.getPort())) {
                int cvBaseOffset = 215;
                for (LightPortParamsType portParams : lightPortType.getPort()) {
                    LightPort lightPort = new LightPort();
                    lightPort.setId(portParams.getPortId());
                    lightPort.setDimMin(portParams.getDimSlopeDown());
                    lightPort.setDimMax(portParams.getDimSlopeUp());
                    lightPort.setPwmMax(portParams.getIntensityOn());
                    lightPort.setPwmMin(portParams.getIntensityOff());
                    if (portParams.getRgbValue() != null) {
                        try {
                            Integer rgbValue = Integer.parseInt(portParams.getRgbValue(), 16);
                            lightPort.setRgbValue(rgbValue);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Parse RGB value failed: {}", (Object)portParams.getRgbValue(), (Object)ex);
                            lightPort.setRgbValue(null);
                        }
                    }
                    lightPort.setStatus((BidibStatus)LightPortStatus.OFF);
                    LOGGER.info("Add configured port: {}", (Object)lightPort);
                    this.lightPorts.put(lightPort.getId(), lightPort);
                    int cvOffset = 215 + portParams.getPortId() * 7;
                    this.configurationVariables.put(String.valueOf(cvOffset), String.valueOf(-1));
                    this.configurationVariables.put(String.valueOf(cvOffset + 1), String.valueOf(lightPort.getPwmMin()));
                    this.configurationVariables.put(String.valueOf(cvOffset + 2), String.valueOf(lightPort.getPwmMax()));
                    this.configurationVariables.put(String.valueOf(cvOffset + 3), String.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMin())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 4), String.valueOf(ByteUtils.getHighByte((int)lightPort.getDimMin())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 5), String.valueOf(ByteUtils.getLowByte((int)lightPort.getDimMax())));
                    this.configurationVariables.put(String.valueOf(cvOffset + 6), String.valueOf(ByteUtils.getHighByte((int)lightPort.getDimMax())));
                }
                this.lightPortCount = this.lightPorts.size();
            }
        } else if (portType instanceof SwitchPortType) {
            this.switchPortCount = portType.getCount();
        } else if (portType instanceof InputPortType) {
            this.inputPortCount = portType.getCount();
            this.inputPortOffset = portType.getOffset() != null ? portType.getOffset() : 0;
        } else if (portType instanceof ServoPortType) {
            this.servoPortCount = portType.getCount();
        } else if (portType instanceof SoundPortType) {
            this.soundPortCount = portType.getCount();
        } else if (portType instanceof MotorPortType) {
            this.motorPortCount = portType.getCount();
        }
    }

    private void schedulePublishCurrentAngle() {
        if (this.taskFuture != null) {
            LOGGER.warn("The task to publish the current angle is running already.");
            this.cancelSchedulePublishCurrentAngle();
        }
        this.taskFuture = this.accessoryStateWorkers.scheduleAtFixedRate(() -> {
            try {
                LOGGER.info("Publish the current angle.");
                if (!this.publishCurrentAngle()) {
                    this.cancelSchedulePublishCurrentAngle();
                    this.taskFuture = null;
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Publish the current angle failed.", (Throwable)ex);
            }
        }, 250L, 250L, TimeUnit.MILLISECONDS);
    }

    private void cancelSchedulePublishCurrentAngle() {
        LOGGER.info("Cancel the publish current angle task.");
        try {
            if (this.taskFuture != null) {
                this.taskFuture.cancel(true);
                this.taskFuture = null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Stop scheduled task failed.", (Throwable)ex);
        }
    }

    private boolean publishCurrentAngle() {
        long delta;
        long totalSteps = this.totalSteps;
        if (this.backwardsDirection) {
            if (this.currentPositionValue - this.targetPositionValue.get() > 0L) {
                this.currentPositionValue -= this.tableType == TurnTableType.round ? 100L : 500L;
                if (this.currentPositionValue < 0L) {
                    this.currentPositionValue = totalSteps;
                }
            } else {
                delta = this.currentPositionValue - this.targetPositionValue.get();
                this.currentPositionValue -= delta;
            }
        } else if (this.targetPositionValue.get() - this.currentPositionValue > 0L) {
            this.currentPositionValue += this.tableType == TurnTableType.round ? 100L : 500L;
            if (this.currentPositionValue > totalSteps) {
                this.currentPositionValue = 0L;
            }
        } else {
            delta = this.targetPositionValue.get() - this.currentPositionValue;
            this.currentPositionValue += delta;
        }
        boolean accessoryNumber = false;
        int aspect = this.currentAspectAccessoryControlling;
        Float currentAngleValue = Float.valueOf((float)this.currentPositionValue / this.totalSteps.floatValue());
        int currentAngle = (int)(currentAngleValue.floatValue() * 360.0f / 1.5f);
        Float angleValue = Float.valueOf(this.targetPositionValue.floatValue() / this.totalSteps.floatValue());
        int targetAngle = (int)(angleValue.floatValue() * 360.0f / 1.5f);
        LOGGER.info("Current aspect: {}, currentPositionValue: {}, targetPositionValue: {}, targetAngle: {}, currentAngle: {}", new Object[]{aspect, this.currentPositionValue, this.targetPositionValue, targetAngle, currentAngle});
        boolean finished = targetAngle == currentAngle;
        byte execute = (byte)(!finished ? 1 : 0);
        byte wait = (byte)(finished ? 0 : 72);
        byte[] value = new byte[]{48, execute, wait, 1, ByteUtils.getLowByte((int)currentAngle), 2, ByteUtils.getLowByte((int)targetAngle)};
        this.currentAngle = currentAngle;
        try {
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(this.getNodeAddress(), this.getNextSendNum(), (byte)(accessoryNumber ? 1 : 0), ByteUtils.getLowByte((int)aspect), value);
            byte[] response = accessoryStateResponse.getContent();
            this.publishResponse(response);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Publish the current angle failed.", (Throwable)ex);
        }
        if (finished) {
            LOGGER.info("Target position reached. Stop publish current angle.");
            return false;
        }
        return true;
    }
}

