/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.simulation.LightControlSimulator;
import org.bidib.wizard.simulation.events.SwitchPairPortStatusEvent;
import org.bidib.wizard.simulation.events.SwitchPortStatusEvent;
import org.bidib.wizard.simulation.ports.GenericSimulationPort;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="146"), @BidibNodeSimulator(vid="251", pid="227")})
public class OpenSwitchSimulator
extends LightControlSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSwitchSimulator.class);
    private final Map<Integer, GenericSimulationPort> genericPorts = new HashMap<Integer, GenericSimulationPort>();
    protected final ScheduledExecutorService simulationWorker = Executors.newScheduledThreadPool(1);
    private boolean simulateAccessoryStateError;

    public OpenSwitchSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    @Override
    public void postConstruct() {
        Feature feature = this.getFeature(70);
        LOGGER.info("The current simulator has the flat model configured. Prepare the generic ports.");
        int numPorts = feature.getValue();
        LOGGER.info("Create generic ports, numPorts: {}", (Object)numPorts);
        for (int portNumber = 0; portNumber < numPorts; ++portNumber) {
            GenericSimulationPort port = new GenericSimulationPort(portNumber);
            port.setPortValue(250);
            port.setPortStatus(SwitchPortStatus.OFF.getType().getType());
            port.setCurrentPortType(LcOutputType.SWITCHPAIRPORT, 129);
            this.genericPorts.put(portNumber, port);
        }
    }

    @Override
    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
    }

    @Override
    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        super.start();
        if (!MapUtils.isEmpty(this.genericPorts)) {
            this.switchPortCount = 8;
            int index = 0;
            for (int portNum = 0; portNum < this.switchPortCount; ++portNum) {
                GenericSimulationPort genericPort = this.genericPorts.get(portNum + index);
                int mask = 129;
                if ((portNum & 1) == 1) {
                    mask = 1;
                    genericPort.setCurrentPortType(LcOutputType.SWITCHPORT, mask);
                } else {
                    genericPort.setCurrentPortType(LcOutputType.SWITCHPAIRPORT, mask);
                }
                Map portConfig = genericPort.getPortConfigX();
                portConfig.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, new BytePortConfigValue(Byte.valueOf((byte)0)));
                portConfig.put((byte)11, new BytePortConfigValue(Byte.valueOf((byte)15)));
                genericPort.setPortConfigX(portConfig);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response;
        block8: {
            LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
            response = null;
            if (this.getFlatPortModelPortCount() > 0) {
                try {
                    LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
                    int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
                    LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
                    GenericPort port = null;
                    port = this.genericPorts.get(outputNumber);
                    LOGGER.info("Set LcConfig for output number: {}, port: {}", (Object)outputNumber, (Object)port);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                    if (port != null) {
                        Object supportedPortTypes;
                        Map currentPortConfig = port.getPortConfigX();
                        LcConfigX lcConfigX = lcConfigXSetMessage.getLcConfigX(this.messageLogger);
                        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)lcConfigX.getPortConfig().get((byte)-127);
                        if (reconfig != null && (supportedPortTypes = port.getSupportedPortTypes()) != null) {
                            ReconfigPortConfigValue reconfigPortConfigValue = new ReconfigPortConfigValue((int)reconfig.getCurrentOutputType().getType(), ((Integer)supportedPortTypes).intValue());
                            LOGGER.info("Prepared BIDIB_PCFG_RECONFIG to replace: {}", (Object)reconfigPortConfigValue);
                            lcConfigX.getPortConfig().put((byte)-127, reconfigPortConfigValue);
                        }
                        for (Map.Entry entry : lcConfigX.getPortConfig().entrySet()) {
                            Byte key = (Byte)entry.getKey();
                            if (currentPortConfig.containsKey(key)) {
                                currentPortConfig.remove(key);
                            }
                            currentPortConfig.put(key, (PortConfigValue)entry.getValue());
                        }
                        port.setPortConfigX(currentPortConfig);
                        lcConfigX.getPortConfig().clear();
                        lcConfigX.getPortConfig().putAll(currentPortConfig);
                        byte[] content = LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel());
                        LOGGER.info("Prepared content: {}", (Object)ByteUtils.bytesToHex((byte[])content));
                        LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), content);
                        response = lcConfigXResponse.getContent();
                        break block8;
                    }
                    LOGGER.warn("No port assigned!");
                    LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = magicResponse.getContent();
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
                }
            } else {
                response = super.processLcConfigXSetRequest(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response;
        block5: {
            LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
            response = null;
            if (this.getFlatPortModelPortCount() > 0) {
                try {
                    LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
                    int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
                    LcOutputType outputType = lcConfigXGetMessage.getPortType(this.getPortModel());
                    GenericPort port = null;
                    LinkedHashMap values = new LinkedHashMap();
                    port = this.genericPorts.get(outputNumber);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                    if (port != null) {
                        values.putAll(port.getPortConfigX());
                        LOGGER.info("Return config of port: {}", (Object)port);
                        LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                        LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                        response = lcConfigXResponse.getContent();
                        break block5;
                    }
                    LOGGER.warn("No port available with port number: {}", (Object)outputNumber);
                    LcNotAvailableResponse notAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = notAvailableResponse.getContent();
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
                }
            } else {
                response = super.processLcConfigXGetRequest(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
        if (this.isPortFlatModelAvailable()) {
            LcOutputType outputType = LcOutputType.SWITCHPORT;
            LinkedHashMap values = new LinkedHashMap();
            try {
                for (GenericPort genericPort : this.genericPorts.values()) {
                    int portNumber = genericPort.getPortNumber();
                    LOGGER.info("Prepare lcConfigXResponse for port number: {}", (Object)portNumber);
                    values.clear();
                    values.putAll(genericPort.getPortConfigX());
                    LOGGER.info("Return config of port: {}", (Object)genericPort);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
                    LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                    LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    byte[] response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcConfigXResponse response failed.", (Throwable)ex);
            }
        } else {
            super.processLcConfigXGetAllRequest(bidibMessage);
        }
    }

    @Override
    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        if (this.getFlatPortModelPortCount() > 0) {
            try {
                LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
                LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
                int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
                byte outputStatus = lcOutputMessage.getOutputStatus();
                GenericPort port = this.genericPorts.get(outputNumber);
                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                if (port != null) {
                    LcStatResponse lcStatResponse = null;
                    port.setPortStatus(outputStatus);
                    lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, lcOutputMessage.getOutputStatus());
                    response = lcStatResponse.getContent();
                } else {
                    LOGGER.warn("No port available with portNumber: {}", (Object)outputNumber);
                    LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                    response = lcNotAvailableResponse.getContent();
                }
                if (port != null) {
                    switch (outputType) {
                        case SWITCHPORT: {
                            this.publishSwitchPortChange(port);
                            break;
                        }
                        case SWITCHPAIRPORT: {
                            this.publishSwitchPairPortChange(port);
                            break;
                        }
                    }
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
        } else {
            response = super.processLcOutputRequest(bidibMessage);
        }
        return response;
    }

    @Override
    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutputQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        if (this.isPortFlatModelAvailable()) {
            byte portState = 0;
            try {
                LcPortQueryMessage lcOutputQueryMessage = (LcPortQueryMessage)bidibMessage;
                LcOutputType outputType = lcOutputQueryMessage.getPortType(this.getPortModel());
                int outputNumber = lcOutputQueryMessage.getPortNumber(this.getPortModel());
                GenericPort port = this.genericPorts.get(outputNumber);
                if (port != null) {
                    portState = port.getPortStatus();
                } else {
                    LOGGER.warn("No port available with portNumber: {}", (Object)outputNumber);
                }
                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
                LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
                response = lcStatResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
            }
        } else {
            response = super.processLcPortQueryRequest(bidibMessage);
        }
        return response;
    }

    private void publishSwitchPortChange(GenericPort port) {
        SwitchPortStatus status = SwitchPortStatus.valueOf((SwitchPortEnum)SwitchPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The switchport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new SwitchPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    private void publishSwitchPairPortChange(GenericPort port) {
        SwitchPortStatus status = SwitchPortStatus.valueOf((SwitchPortEnum)SwitchPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The switchPairPort status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new SwitchPairPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    @Override
    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{0, 0, 0};
            if (this.simulateAccessoryStateError && accessoryNumber == 1 && aspect == 1) {
                LOGGER.warn("Adding simulated error to accessory state response");
                value = new byte[]{2, 1, 20};
                AccessoryResponseHandler callable = new AccessoryResponseHandler(bidibMessage.getAddr(), accessoryNumber, aspect);
                ScheduledFuture<?> future = this.simulationWorker.scheduleWithFixedDelay(callable, 1500L, 1500L, TimeUnit.MILLISECONDS);
                callable.setFuture(future);
            }
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)aspect), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processAccessoryGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryGetMessage accessoryGetMessage = (AccessoryGetMessage)bidibMessage;
            int accessoryNumber = accessoryGetMessage.getAccessoryNumber();
            boolean aspect = false;
            int total = 4;
            if (accessoryNumber < 8) {
                total = 2;
            }
            byte[] value = new byte[]{ByteUtils.getLowByte((int)total), 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)(aspect ? 1 : 0), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processAccessoryGetAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGetAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            Feature featureAccessoryCount = Feature.findFeature((Collection)this.features, (int)40);
            int accessoryCount = featureAccessoryCount.getValue();
            boolean aspect = false;
            for (int accessoryNumber = 0; accessoryNumber < accessoryCount; ++accessoryNumber) {
                int total = 4;
                if (accessoryNumber < 8) {
                    total = 2;
                }
                byte[] value = new byte[]{ByteUtils.getLowByte((int)total), 0, 0};
                LOGGER.info("Return data for accessory: {}, data: {}", (Object)accessoryNumber, (Object)ByteUtils.bytesToHex((byte[])value));
                AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)(aspect ? 1 : 0), value);
                response = accessoryStateResponse.getContent();
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return null;
    }

    @Override
    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            if (paraNumber == 254) {
                byte[] value = new byte[]{ByteUtils.getLowByte((int)paraNumber)};
                paraNumber = 255;
                AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
                response = accessoryParaResponse.getContent();
            } else {
                response = super.processAccessoryParaGetRequest(bidibMessage);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    private final class AccessoryResponseHandler
    implements Runnable {
        private List<String> accessoryResponseList = new ArrayList<String>();
        private final byte[] nodeAddress;
        private ScheduledFuture<?> future;

        public AccessoryResponseHandler(byte[] nodeAddress, int accessoryNumber, int aspect) {
            this.nodeAddress = nodeAddress;
            this.accessoryResponseList.add(accessoryNumber + "," + aspect + ",2,128,7");
            this.accessoryResponseList.add(accessoryNumber + ",255,2,129,7");
            this.accessoryResponseList.add(accessoryNumber + ",255,2,0,0");
        }

        public void setFuture(ScheduledFuture<?> future) {
            LOGGER.info("Set the future: {}", future);
            this.future = future;
        }

        @Override
        public void run() {
            String accessoryResponse;
            LOGGER.info("The AccessoryResponseHandler is executed.");
            if (!this.accessoryResponseList.isEmpty() && StringUtils.isNotBlank((CharSequence)(accessoryResponse = this.accessoryResponseList.remove(0)))) {
                LOGGER.info("Send response: {}", (Object)accessoryResponse);
                String[] parts = accessoryResponse.split(",");
                byte[] value = new byte[parts.length];
                int index = 0;
                for (String part : parts) {
                    int val = Integer.parseInt(part);
                    value[index] = ByteUtils.getLowByte((int)val);
                    ++index;
                }
                try {
                    AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(this.nodeAddress, 0, value[0], value[1], ByteUtils.subArray((byte[])value, (int)2));
                    byte[] response = accessoryStateResponse.getContent();
                    LOGGER.info("Prepared accessoryStateResponse: {}", (Object)accessoryStateResponse);
                    OpenSwitchSimulator.this.sendSpontanousResponse(response);
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
                }
            }
            if (this.accessoryResponseList.isEmpty()) {
                LOGGER.info("No more entries in accessoryResponseList. Cancel the future.");
                if (this.future != null) {
                    try {
                        this.future.cancel(false);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Cancel the future failed.", (Throwable)ex);
                    }
                }
            }
        }
    }
}

