/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.enums.PositionLocationEnum;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryMessage;
import org.bidib.jbidibc.messages.message.CommandStationBinaryStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationQueryMessage;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationStateResponse;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackCvResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.FeedbackPositionResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="32770"), @BidibNodeSimulator(vid="251", pid="302")})
public class RFBasisNodeSimulator
extends DefaultNodeSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RFBasisNodeSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.GBMboostMasterPanel";
    private final Map<Integer, FeedbackPort> feedbackPorts = new HashMap<Integer, FeedbackPort>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusValid = new AtomicBoolean();
    private final AtomicBoolean statusSignal = new AtomicBoolean();
    private CommandStationState commandStationState = CommandStationState.OFF;
    private Map<Integer, Integer> mapLocoCV = new LinkedHashMap<Integer, Integer>();
    protected static final int NUM_OF_FEEDBACK_PORTS = 16;
    protected final ScheduledExecutorService positionWorker = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> futureTriggerPositionWorker;
    protected static final int MAX_NUM_OF_FEEDBACK_PORTS = 16;
    private int currentCarPosition = -1;
    private int carAddress = 3;
    private int timestamp;
    private int decoderAddress = 10;
    private int locationAddress = 120;

    public RFBasisNodeSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    protected void prepareFeatures() {
        super.prepareFeatures();
        this.features.add(new Feature(0, 16));
        this.features.add(new Feature(1, 1));
        this.features.add(new Feature(2, 1));
        this.features.add(new Feature(3, 100));
        this.features.add(new Feature(8, 1));
        this.features.add(new Feature(9, 1));
        this.features.add(new Feature(10, 1));
        this.features.add(new Feature(11, 1));
        this.features.add(new Feature(12, 5));
        this.features.add(new Feature(13, 1));
        this.features.add(new Feature(14, 1));
        this.features.add(new Feature(28, 100));
        this.features.add(new Feature(31, 1));
        this.features.add(new Feature(32, 30));
        this.features.add(new Feature(101, 20));
        this.features.add(new Feature(106, 3));
        this.features.add(new Feature(107, 1));
        this.features.add(new Feature(108, 1));
        this.features.add(new Feature(109, 1));
        this.features.add(new Feature(110, 1));
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.mapLocoCV.put(1, 3);
        this.mapLocoCV.put(29, 0);
        this.mapLocoCV.put(28, 3);
        this.setupFeedbackPorts();
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        if (this.positionWorker != null) {
            LOGGER.info("Stop the position worker.");
            this.positionWorker.shutdownNow();
        }
        super.stop();
    }

    private void setupFeedbackPorts() {
        for (int id = 0; id < 16; ++id) {
            FeedbackPort port = new FeedbackPort();
            port.setId(id);
            port.setStatus(FeedbackPortStatus.FREE);
            this.feedbackPorts.put(id, port);
        }
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 32: {
                response = this.processBmGetRangeRequest(bidibMessage);
                break;
            }
            case 33: {
                this.processBmMirrorMultipleRequest(bidibMessage);
                break;
            }
            case 34: {
                this.processBmMirrorOccupiedRequest(bidibMessage);
                break;
            }
            case 35: {
                this.processBmMirrorFreeRequest(bidibMessage);
                break;
            }
            case 38: {
                this.processBmMirrorPositionRequest(bidibMessage);
                break;
            }
            case 36: {
                this.processBmAddrGetRangeRequest(bidibMessage);
                break;
            }
            case 37: {
                response = this.processBmGetConfidenceRequest(bidibMessage);
                break;
            }
            case 98: {
                response = this.processCsSetStateRequest(bidibMessage);
                break;
            }
            case 103: {
                response = this.processCsPomRequest(bidibMessage);
                break;
            }
            case 111: {
                response = this.processCsProgRequest(bidibMessage);
                break;
            }
            case 100: {
                response = this.processCsDriveRequest(bidibMessage);
                break;
            }
            case 101: {
                response = this.processCsAccessoryRequest(bidibMessage);
                break;
            }
            case 106: {
                response = this.processCsQueryRequest(bidibMessage);
                break;
            }
            case 102: {
                response = this.processCsBinStateRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processCsSetStateRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsSetState request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationSetStateMessage commandStationSetStateMessage = (CommandStationSetStateMessage)bidibMessage;
            CommandStationState state = commandStationSetStateMessage.getState();
            LOGGER.info("The requested command station state is: {}", (Object)state);
            switch (state) {
                case OFF: {
                    this.commandStationState = CommandStationState.OFF;
                    break;
                }
                case STOP: 
                case SOFTSTOP: {
                    this.commandStationState = CommandStationState.STOP;
                    break;
                }
                case GO: 
                case GO_IGN_WD: {
                    this.commandStationState = CommandStationState.GO;
                    break;
                }
                case PROG: {
                    this.commandStationState = CommandStationState.PROG;
                    break;
                }
                case QUERY: {
                    LOGGER.warn("Query command station state requested");
                    break;
                }
                default: {
                    LOGGER.warn("Unprocessed command station state: {}", (Object)state);
                }
            }
            LOGGER.info("Return current command station state: {}", (Object)this.commandStationState);
            CommandStationStateResponse commandStationStateResponse = new CommandStationStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.commandStationState.getType());
            response = commandStationStateResponse.getContent();
            this.publishResponse(response);
            response = null;
            this.handleCsState(this.commandStationState);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationState response failed.", (Throwable)ex);
        }
        return response;
    }

    private void handleCsState(CommandStationState commandStationState) {
        switch (commandStationState) {
            case GO: 
            case GO_IGN_WD: {
                if (this.futureTriggerPositionWorker != null) break;
                LOGGER.info("Schedule the position trigger");
                int interval = 4000;
                this.futureTriggerPositionWorker = this.positionWorker.scheduleAtFixedRate(() -> {
                    LOGGER.info("Trigger position");
                    try {
                        this.triggerPositionResponse();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Trigger the position failed.", (Throwable)ex);
                    }
                    LOGGER.info("Trigger position has finished.");
                }, 500L, interval, TimeUnit.MILLISECONDS);
                break;
            }
            case OFF: 
            case STOP: 
            case SOFTSTOP: {
                if (this.futureTriggerPositionWorker == null) break;
                LOGGER.info("Stop the position trigger.");
                this.futureTriggerPositionWorker.cancel(false);
                this.futureTriggerPositionWorker = null;
                break;
            }
        }
    }

    protected void triggerPositionResponse() {
        try {
            int offset;
            int portNum = this.currentCarPosition;
            LOGGER.info("Trigger position address, portNum: {}", (Object)portNum);
            if (portNum > -1 && (portNum = this.currentCarPosition) < 0) {
                portNum = 15;
            }
            ++this.currentCarPosition;
            if (this.currentCarPosition >= 16) {
                this.currentCarPosition = 0;
            }
            if ((offset = this.getLocalAddr()) < 12) {
                offset = 12;
            }
            int locationType = ByteUtils.getInt((byte)PositionLocationEnum.LOCATOR_BADGE.getType());
            this.triggerPositionAddressResponse(this.currentCarPosition + (offset - 12) * 100, this.carAddress + offset * 2, locationType, this.currentCarPosition);
            int delayValue = ThreadLocalRandom.current().nextInt(300, 800);
            LOGGER.info("Wait for next execution, delayValue: {}", (Object)delayValue);
            Thread.sleep(delayValue);
            this.triggerPositionAddressResponse(this.currentCarPosition + (offset - 12) * 100, this.carAddress + 1 + offset * 2, locationType, this.currentCarPosition);
        }
        catch (Exception ex) {
            LOGGER.warn("Trigger the feedback address failed.", (Throwable)ex);
        }
        LOGGER.info("Trigger feedback address has finished.");
    }

    private void triggerPositionAddressResponse(int portNum, int carAddress, int locationType, int carPosition) {
        LOGGER.info("Trigger the feedback address repsonse, portNum: {}", (Object)portNum);
        byte[] response = null;
        try {
            FeedbackPositionResponse feedbackPositionEvent = new FeedbackPositionResponse(this.nodeAddress, this.getNextSendNum(), carAddress, locationType, carPosition);
            response = feedbackPositionEvent.getContent();
            this.sendSpontanousResponse(response);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create FeedbackPositionResponse failed.", (Throwable)ex);
        }
    }

    protected byte[] processCsPomRequest(BidibMessageInterface bidibMessage) {
        PomAddressData addressData;
        CommandStationPomMessage commandStationPomMessage;
        LOGGER.info("Process the CsPom request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            commandStationPomMessage = (CommandStationPomMessage)bidibMessage;
            addressData = commandStationPomMessage.getDecoderAddress();
            LOGGER.info("Received addressData: {}", (Object)addressData);
            CommandStationPomAcknowledgeResponse commandStationPomAckResponse = new CommandStationPomAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData, 1);
            response = commandStationPomAckResponse.getContent();
            LOGGER.info("Publish the running response: {}", (Object)commandStationPomAckResponse);
            this.publishResponse(response);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationPomAck response failed.", (Throwable)ex);
        }
        try {
            LOGGER.info("prepare the MSG_BM_CV that contains the real data.");
            commandStationPomMessage = (CommandStationPomMessage)bidibMessage;
            addressData = commandStationPomMessage.getDecoderAddress();
            int cvNumber = commandStationPomMessage.getCvNumber();
            LOGGER.info("Current CV number: {}", (Object)cvNumber);
            byte cvValue = 12;
            if (cvNumber == 29) {
                cvValue = 0;
            }
            CommandStationPom opCode = CommandStationPom.valueOf((byte)ByteUtils.getLowByte((int)commandStationPomMessage.getOpCode()));
            switch (opCode) {
                case WR_BYTE: {
                    cvValue = ByteUtils.getLowByte((int)commandStationPomMessage.getCvValue());
                    break;
                }
            }
            FeedbackCvResponse feedbackCvResponse = new FeedbackCvResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData.getAddress(), cvNumber - 1, cvValue);
            response = feedbackCvResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationPomAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsProgRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsProg request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationProgMessage commandStationProgMessage = (CommandStationProgMessage)bidibMessage;
            CommandStationPt opCode = commandStationProgMessage.getOpCode();
            int cvNumber = commandStationProgMessage.getCvNumber();
            int cvData = commandStationProgMessage.getCvData();
            LOGGER.info("Received opCode: {}, cvNumber: {}, cvData: {}", new Object[]{opCode, cvNumber, cvData});
            boolean sendTimeoutResponse = false;
            switch (opCode) {
                case BIDIB_CS_PROG_BREAK: {
                    break;
                }
                case BIDIB_CS_PROG_QUERY: {
                    break;
                }
                case BIDIB_CS_PROG_RDWR_BIT: {
                    byte byteValue;
                    Integer storedValue;
                    if ((cvData & 0x10) == 16) {
                        storedValue = this.mapLocoCV.get(cvNumber);
                        if (storedValue != null) {
                            byteValue = ByteUtils.getLowByte((int)storedValue);
                            byteValue = ByteUtils.setBit((byte)byteValue, ((cvData & 8) == 8 ? 1 : 0) != 0, (int)(cvData & 7));
                            LOGGER.info("Changed CV value: {}", (Object)ByteUtils.byteToHex((byte)byteValue));
                            this.mapLocoCV.put(cvNumber, Integer.valueOf(byteValue));
                            break;
                        }
                        byteValue = 0;
                        byteValue = ByteUtils.setBit((byte)byteValue, ((cvData & 8) == 8 ? 1 : 0) != 0, (int)(cvData & 7));
                        LOGGER.info("Changed CV value: {}", (Object)ByteUtils.byteToHex((byte)byteValue));
                        this.mapLocoCV.put(cvNumber, Integer.valueOf(byteValue));
                        break;
                    }
                    storedValue = this.mapLocoCV.get(cvNumber);
                    if (storedValue != null) {
                        byteValue = ByteUtils.getLowByte((int)storedValue);
                        boolean bitIsSetEqual = ByteUtils.isBitSetEqual((byte)byteValue, (int)ByteUtils.getBit((int)cvData, (int)3), (int)(cvData & 7));
                        LOGGER.info("Verify bitIsSetEqual: {}, byteValue: {}", (Object)bitIsSetEqual, (Object)byteValue);
                        if (bitIsSetEqual) break;
                        LOGGER.warn("Send timeout response!");
                        sendTimeoutResponse = true;
                        break;
                    }
                    LOGGER.warn("The requested CV value is not stored, cvNumber: {}", (Object)cvNumber);
                    sendTimeoutResponse = true;
                    break;
                }
                case BIDIB_CS_PROG_WR_BYTE: {
                    this.mapLocoCV.put(cvNumber, cvData);
                    break;
                }
                default: {
                    Integer storedValue = this.mapLocoCV.get(cvNumber);
                    if (storedValue != null) {
                        cvData = ByteUtils.getLowByte((int)storedValue);
                        break;
                    }
                    LOGGER.warn("The requested CV value is not stored, cvNumber: {}", (Object)cvNumber);
                    sendTimeoutResponse = true;
                }
            }
            CommandStationProgStateResponse commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_RUNNING, 1, cvNumber, cvData);
            response = commandStationProgStateResponse.getContent();
            LOGGER.info("Publish the running response: {}", (Object)commandStationProgStateResponse);
            this.publishResponse(response);
            LOGGER.info("Sleep a second.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Sleep thread was interrupted.", (Throwable)e);
            }
            if (!sendTimeoutResponse) {
                LOGGER.info("Prepare the OKAY state response.");
                commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_OKAY, 1, cvNumber, cvData);
            } else {
                LOGGER.info("Prepare the NO_ANSWER state response.");
                commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_NO_ANSWER, 1, cvNumber, 255);
            }
            response = commandStationProgStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationProgState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsDriveRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsDrive request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationDriveMessage commandStationDriveMessage = (CommandStationDriveMessage)bidibMessage;
            AddressData addressData = commandStationDriveMessage.getDecoderAddress();
            int messageNumber = commandStationDriveMessage.getNum();
            LOGGER.info("Received addressData: {}", (Object)addressData);
            CommandStationDriveAcknowledgeResponse commandStationDriveAckResponse = new CommandStationDriveAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData, 1, Integer.valueOf(messageNumber));
            response = commandStationDriveAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationDriveAck response failed.", (Throwable)ex);
        }
        return response;
    }

    private byte[] processCsBinStateRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsBinState request: {}", (Object)bidibMessage);
        Integer requestedCellNumber = null;
        Integer carAddress = null;
        byte[] response = null;
        try {
            CommandStationBinaryStateMessage commandStationBinStateMessage = (CommandStationBinaryStateMessage)bidibMessage;
            AddressData addressData = commandStationBinStateMessage.getDecoderAddress();
            int binStateNumber = commandStationBinStateMessage.getBinaryStateNumber();
            int binStateValue = commandStationBinStateMessage.getBinaryStateValue();
            int messageNumber = commandStationBinStateMessage.getNum();
            LOGGER.info("Received addressData: {}, binStateNumber: {}, binStateValue: {}", new Object[]{addressData, binStateNumber, binStateValue});
            CommandStationDriveAcknowledgeResponse commandStationDriveAckResponse = new CommandStationDriveAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData, 1, Integer.valueOf(messageNumber));
            response = commandStationDriveAckResponse.getContent();
            this.sendSpontanousResponse(response);
            if (binStateValue > 0 && binStateNumber >= 512 && binStateNumber <= 519) {
                requestedCellNumber = binStateNumber - 511;
                carAddress = addressData.getAddress();
                LOGGER.info("The requested cell number: {}, carAddress: {}", (Object)requestedCellNumber, (Object)carAddress);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationDriveAck response failed.", (Throwable)ex);
        }
        response = null;
        Feature featureCellNumber = this.getFeature(FeatureEnum.FEATURE_CELL_NUMBER.getNumber());
        if (featureCellNumber != null && requestedCellNumber != null && featureCellNumber.getValue() == requestedCellNumber.intValue()) {
            int offset = this.getLocalAddr();
            if (offset < 12) {
                offset = 12;
            }
            LOGGER.info("The cell number has changed, requested cellnumber: {}", (Object)requestedCellNumber);
            this.triggerPositionAddressResponse(this.currentCarPosition + (offset - 12) * 100, carAddress, 1, requestedCellNumber);
        }
        return response;
    }

    protected byte[] processCsQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationQueryMessage commandStationQueryMessage = (CommandStationQueryMessage)bidibMessage;
            CsQueryTypeEnum csQueryType = commandStationQueryMessage.getCsQueryType();
            switch (csQueryType) {
                case LOCO_LIST: {
                    AddressData addressData = new AddressData(13, AddressTypeEnum.LOCOMOTIVE_FORWARD);
                    byte[] functions = new byte[]{-128, 0, 114, -123};
                    CommandStationDriveStateResponse driveStateResponse = new CommandStationDriveStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), 65, addressData, SpeedStepsEnum.DCC128, 39, functions);
                    response = driveStateResponse.getContent();
                    break;
                }
                default: {
                    LOGGER.warn("The CsQueryRequest is not implemented for type: {}", (Object)csQueryType);
                    break;
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationDriveAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsAccessoryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsAccessory request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationAccessoryMessage commandStationAccessoryMessage = (CommandStationAccessoryMessage)bidibMessage;
            AddressData addressData = commandStationAccessoryMessage.getDecoderAddress();
            LOGGER.info("Received addressData: {}", (Object)addressData);
            CommandStationAccessoryAcknowledgeResponse commandStationAccessoryAckResponse = new CommandStationAccessoryAcknowledgeResponse(bidibMessage.getAddr(), this.getNextSendNum(), addressData, 1);
            response = commandStationAccessoryAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationAccessoryAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processBmGetRangeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackGetRangeMessage: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            FeedbackGetRangeMessage feedbackGetRangeMessage = (FeedbackGetRangeMessage)bidibMessage;
            int baseAddress = feedbackGetRangeMessage.getBeginRange();
            int end = feedbackGetRangeMessage.getEndRange();
            int feedbackSize = feedbackGetRangeMessage.getEndRange() - feedbackGetRangeMessage.getBeginRange();
            int value = 0;
            int index = 0;
            int feedbackByteSize = feedbackSize / 8 + (feedbackSize % 8 > 0 ? 1 : 0);
            byte[] feedbackMultiple = new byte[feedbackByteSize];
            int position = feedbackMultiple.length;
            for (int portNum = end; portNum > baseAddress; --portNum) {
                value = (byte)((value & 0xFF) << 1);
                FeedbackPort fbp = this.feedbackPorts.get(portNum - 1);
                int status = 0;
                if (fbp != null) {
                    status = ByteUtils.getLowByte((int)((FeedbackPortStatus)fbp.getStatus()).getType().getType(), (int)1);
                }
                feedbackMultiple[position - 1] = value = (int)((byte)(value | status));
                if (++index <= 7) continue;
                value = 0;
                index = 0;
                --position;
            }
            LOGGER.info("Prepared feedback multiple: {}", (Object)ByteUtils.bytesToHex((byte[])feedbackMultiple));
            FeedbackMultipleResponse feedbackMultipleResponse = new FeedbackMultipleResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)baseAddress), ByteUtils.getLowByte((int)feedbackSize), feedbackMultiple);
            response = feedbackMultipleResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackMultiple response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processBmMirrorMultipleRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the FeedbackMirrorMultipleMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorOccupiedRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorOccupiedRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorFreeRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorFreeRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmMirrorPositionRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the processBmMirrorPositionRequest: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processBmAddrGetRangeRequest(BidibMessageInterface bidibMessage) {
        try {
            for (FeedbackPort port : this.feedbackPorts.values()) {
                int detectorNumber = port.getId();
                ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
                List addresses = port.getAddresses();
                if (CollectionUtils.isNotEmpty((Collection)addresses)) {
                    for (FeedbackAddressData addressData : addresses) {
                        EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                        AddressTypeEnum addressType = null;
                        switch (enrailmentDirection) {
                            case LOCOMOTIVE_LEFT: 
                            case LOCOMOTIVE_RIGHT: {
                                addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                                break;
                            }
                            case BASIC_ACCESSORY: {
                                addressType = AddressTypeEnum.ACCESSORY;
                                break;
                            }
                            case EXTENDED_ACCESSORY: {
                                addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                                break;
                            }
                        }
                        AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                        bidibAddresses.add(bidibAddress);
                    }
                }
                FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(bidibMessage.getAddr(), this.getNextSendNum(), detectorNumber, bidibAddresses);
                byte[] response = feedbackAddressResponse.getContent();
                LOGGER.info("Prepare feedbackAddressResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackAddress response failed.", (Throwable)ex);
        }
    }

    protected byte[] processBmGetConfidenceRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            byte valid = (byte)(this.statusValid.get() ? 1 : 0);
            byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
            byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(bidibMessage.getAddr(), this.getNextSendNum(), valid, freeze, signal);
            response = feedbackConfidenceResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feedbackConfidence response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishFeedbackPortChange(Port<?> port) {
        FeedbackPort feedbackPort = (FeedbackPort)port;
        FeedbackPortStatus status = (FeedbackPortStatus)feedbackPort.getStatus();
        LOGGER.info("The feedbackport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), feedbackPort.getId(), status));
    }

    public void queryStatus(Class<?> portClass) {
        if (FeedbackPort.class.equals(portClass)) {
            for (FeedbackPort feedbackPort : this.feedbackPorts.values()) {
                this.publishFeedbackPortChange((Port<?>)feedbackPort);
            }
            this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
        }
    }

    @EventSubscriber(eventClass=FeedbackConfidenceSetEvent.class)
    public void feedbackConfidenceSetEvent(FeedbackConfidenceSetEvent feedbackConfidenceEvent) {
        String nodeAddress = feedbackConfidenceEvent.getNodeAddr();
        LOGGER.info("The change of the feedback confidence was requested, nodeAddress: {}", (Object)nodeAddress);
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        this.statusValid.set(feedbackConfidenceEvent.getValid());
        this.statusFreeze.set(feedbackConfidenceEvent.getFreeze());
        this.statusSignal.set(feedbackConfidenceEvent.getSignal());
        byte valid = (byte)(this.statusValid.get() ? 1 : 0);
        byte freeze = (byte)(this.statusFreeze.get() ? 1 : 0);
        byte signal = (byte)(this.statusSignal.get() ? 1 : 0);
        try {
            FeedbackConfidenceResponse feedbackConfidenceResponse = new FeedbackConfidenceResponse(this.nodeAddress, this.getNextSendNum(), valid, freeze, signal);
            LOGGER.info("Prepared feedbackConfidenceResponse: {}", (Object)feedbackConfidenceResponse);
            this.sendSpontanousResponse(feedbackConfidenceResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send feedbackConfidenceResponse failed.", (Throwable)ex);
        }
        this.publishFeedbackConfidenceStatusEvent(this.statusValid.get(), this.statusFreeze.get(), this.statusSignal.get());
    }

    private void publishFeedbackConfidenceStatusEvent(boolean valid, boolean freeze, boolean signal) {
        LOGGER.info("The feedbackport confidence status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new FeedbackConfidenceStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), valid, freeze, signal));
    }

    @EventSubscriber(eventClass=FeedbackPortSetStatusEvent.class)
    public void feedbackPortSetStatus(FeedbackPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the feedback port was requested.");
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        try {
            this.changeFeedbackPortStatus(portNum);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Publish feedback status failed.", (Throwable)ex);
        }
    }

    private int getTimestamp() {
        this.timestamp += 10;
        if (this.timestamp > 65000) {
            this.timestamp = 0;
        }
        return this.timestamp;
    }

    private boolean hasTimestampFeature() {
        Feature feature = Feature.findFeature((Collection)this.features, (int)30);
        return feature != null && feature.getValue() > 0;
    }

    private int getDecoderAddress() {
        ++this.decoderAddress;
        if (this.decoderAddress > 15) {
            this.decoderAddress = 10;
        }
        return this.decoderAddress;
    }

    private int getLocationAddress() {
        ++this.locationAddress;
        if (this.locationAddress > 150) {
            this.locationAddress = 120;
        }
        return this.locationAddress;
    }

    protected void changeFeedbackPortStatus(int portNum) throws ProtocolException {
        FeedbackPort port = this.feedbackPorts.get(portNum);
        if (port != null) {
            FeedbackFreeResponse response = null;
            FeedbackPositionResponse responsePosition = null;
            switch ((FeedbackPortStatus)port.getStatus()) {
                case FREE: {
                    port.setStatus(FeedbackPortStatus.OCCUPIED);
                    response = this.hasTimestampFeature() ? new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum, this.getTimestamp()) : new FeedbackOccupiedResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                    int locationType = ByteUtils.getInt((byte)PositionLocationEnum.LOCATOR_BADGE.getType());
                    responsePosition = new FeedbackPositionResponse(this.getNodeAddress(), this.getNextSendNum(), this.getDecoderAddress(), locationType, this.getLocationAddress());
                    break;
                }
                default: {
                    port.setStatus(FeedbackPortStatus.FREE);
                    response = new FeedbackFreeResponse(this.getNodeAddress(), this.getNextSendNum(), portNum);
                }
            }
            this.sendSpontanousResponse(response.getContent());
            if (responsePosition != null) {
                this.sendSpontanousResponse(responsePosition.getContent());
            }
            this.publishFeedbackPortChange((Port<?>)port);
        } else {
            LOGGER.warn("The requested feedback port is not available: {}", (Object)portNum);
        }
    }
}

