/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaSetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BoostDiagnosticResponse;
import org.bidib.jbidibc.messages.message.BoostOffMessage;
import org.bidib.jbidibc.messages.message.BoostOnMessage;
import org.bidib.jbidibc.messages.message.BoostStatResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationProgMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationQueryMessage;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationStateResponse;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackSpeedResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="251", pid="117"), @BidibNodeSimulator(vid="251", pid="118"), @BidibNodeSimulator(vid="251", pid="119")})
public class ReadyBoostSimulator
extends DefaultNodeSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadyBoostSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.LightControlPanel";
    private BoosterState boosterState = BoosterState.OFF;
    private CommandStationState commandStationState = CommandStationState.OFF;
    private Map<Integer, Integer> mapLocoCV = new LinkedHashMap<Integer, Integer>();
    protected final ScheduledExecutorService boosterDiagWorker = Executors.newScheduledThreadPool(1);
    protected static final int MAX_NUM_OF_LOCO_DECODERS = 16;
    protected final ScheduledExecutorService feedbackLocoDecoderWorker = Executors.newScheduledThreadPool(1);
    private BoosterControl boosterControl = BoosterControl.CONNECT;
    private ScheduledFuture<?> futureTriggerBoostDiagnostic;
    private ScheduledFuture<?> futureTriggerGlobalDetector;
    private int interval = 3000;
    private static final int LOCO_DECODER_ADDRESS_BASE = 3;
    private final List<LocoListItem> locoList = new LinkedList<LocoListItem>();

    public ReadyBoostSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        this.features.add(new Feature(40, 1));
        this.features.add(new Feature(41, 0));
        this.features.add(new Feature(19, 8));
        this.features.add(new Feature(23, 200));
        this.features.add(new Feature(22, 186));
        this.features.add(new Feature(21, 1));
        this.features.add(new Feature(26, 0));
        this.features.add(new Feature(18, 1));
        this.features.add(new Feature(17, 1));
        this.features.add(new Feature(27, 0));
        this.features.add(new Feature(19, 30));
        this.features.add(new Feature(101, 20));
        this.features.add(new Feature(13, 2));
        this.features.add(new Feature(14, 2));
        this.features.add(new Feature(8, 2));
        this.features.add(new Feature(9, 2));
    }

    public void postConstruct() {
        super.postConstruct();
    }

    protected void prepareCVs() {
        super.prepareCVs();
        this.configurationVariables.put("81", "253");
        this.configurationVariables.put("82", "2");
        this.configurationVariables.put("83", "0");
        this.configurationVariables.put("84", "3");
        this.configurationVariables.put("86", "0");
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.mapLocoCV.put(1, 3);
        this.mapLocoCV.put(29, 0);
        this.mapLocoCV.put(28, 3);
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 56: {
                response = this.processAccessorySetRequest(bidibMessage);
                break;
            }
            case 57: {
                response = this.processAccessoryGetRequest(bidibMessage);
                break;
            }
            case 58: {
                response = this.processAccessoryParaSetRequest(bidibMessage);
                break;
            }
            case 59: {
                response = this.processAccessoryParaGetRequest(bidibMessage);
                break;
            }
            case 50: {
                response = this.processBoostQueryRequest(bidibMessage);
                break;
            }
            case 49: {
                response = this.processBoostOnRequest(bidibMessage);
                break;
            }
            case 48: {
                response = this.processBoostOffRequest(bidibMessage);
                break;
            }
            case 98: {
                response = this.processCsSetStateRequest(bidibMessage);
                break;
            }
            case 111: {
                response = this.processCsProgRequest(bidibMessage);
                break;
            }
            case 106: {
                response = this.processCsQueryRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            if (accessoryNumber == 0) {
                this.boosterControl = aspect == 1 ? BoosterControl.LOCAL : BoosterControl.CONNECT;
                LOGGER.info("Current boosterControl: {}", (Object)this.boosterControl);
                byte boosterStateValue = ByteUtils.getLowByte((int)(this.boosterState.getType() | (this.boosterControl == BoosterControl.LOCAL ? 64 : 0)));
                BoostStatResponse boostStatResponse = new BoostStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), boosterStateValue);
                LOGGER.info("Publish the booster state response: {}", (Object)boostStatResponse);
                this.sendSpontanousResponse(boostStatResponse.getContent());
            }
            byte[] value = new byte[]{0, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryGetMessage accessoryGetMessage = (AccessoryGetMessage)bidibMessage;
            int accessoryNumber = accessoryGetMessage.getAccessoryNumber();
            boolean aspect = false;
            byte[] value = new byte[]{2, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)(aspect ? 1 : 0), value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaSetMessage accessoryParaSetMessage = (AccessoryParaSetMessage)bidibMessage;
            int accessoryNumber = accessoryParaSetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaSetMessage.getParaNumber();
            byte[] value = accessoryParaSetMessage.getValue();
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            byte[] value = new byte[]{0, 0, 0, 0};
            if (paraNumber == 254 || paraNumber == 252) {
                LOGGER.info("The param is not known currently!");
                value = new byte[]{ByteUtils.getLowByte((int)paraNumber)};
                paraNumber = 255;
            }
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processBoostQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the BoostQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            BoostStatResponse boostStatResponse = new BoostStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.boosterState);
            response = boostStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create BoostStatResponse response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processBoostOnRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the BoostOn request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            BoostOnMessage boostOnMessage = (BoostOnMessage)bidibMessage;
            byte broadcast = boostOnMessage.getBroadcast();
            LOGGER.info("BoostOn with broadcast: {}", (Object)broadcast);
            if (broadcast == 0) {
                // empty if block
            }
            this.boosterState = BoosterState.ON;
            byte boosterStateValue = ByteUtils.getLowByte((int)(this.boosterState.getType() | (this.boosterControl == BoosterControl.LOCAL ? 64 : 0)));
            BoostStatResponse boostStatResponse = new BoostStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), boosterStateValue);
            response = boostStatResponse.getContent();
            this.sendSpontanousResponse(response);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create BoostStatResponse response failed.", (Throwable)ex);
        }
        if (this.futureTriggerBoostDiagnostic == null) {
            Feature curMeasInterval = this.features.stream().filter(f -> f.getFeatureEnum().equals((Object)FeatureEnum.FEATURE_BST_CURMEAS_INTERVAL)).findFirst().orElse(null);
            LOGGER.info("Schedule the boost diagnostic trigger, curMeasInterval: {}", (Object)curMeasInterval);
            int interval = (curMeasInterval != null ? curMeasInterval.getValue() : 200) * 10;
            this.futureTriggerBoostDiagnostic = this.boosterDiagWorker.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Trigger boost diag");
                    try {
                        ReadyBoostSimulator.this.triggerBoostDiagnosticResponse();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Trigger the boost diagnostic failed.", (Throwable)ex);
                    }
                    LOGGER.info("Trigger boost has finished.");
                }
            }, 500L, interval, TimeUnit.MILLISECONDS);
        }
        if (this.futureTriggerGlobalDetector == null) {
            LOGGER.info("Start the global detector feedback worker.");
            this.locoList.clear();
            for (int address = 3; address < 19; ++address) {
                this.locoList.add(new LocoListItem(address, 0));
            }
            this.futureTriggerGlobalDetector = this.feedbackLocoDecoderWorker.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOGGER.info("Trigger addresses for loco decoder: {}", ReadyBoostSimulator.this.locoList);
                        ReadyBoostSimulator.this.triggerFeedbackAddressResponse(255, ReadyBoostSimulator.this.locoList.stream().mapToInt(i -> i.address).toArray());
                        Thread.sleep(500L);
                        int delayValue = ThreadLocalRandom.current().nextInt(300, 4000);
                        LOGGER.info("Wait for next execution, delayValue: {}", (Object)delayValue);
                        Thread.sleep(delayValue);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Trigger the feedback address failed.", (Throwable)ex);
                    }
                    LOGGER.info("Trigger feedback address has finished.");
                }
            }, 5000L, this.interval, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    protected byte[] processBoostOffRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the BoostOff request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            BoostOffMessage boostOffMessage = (BoostOffMessage)bidibMessage;
            byte broadcast = boostOffMessage.getBroadcast();
            LOGGER.info("BoostOn with broadcast: {}", (Object)broadcast);
            if (broadcast == 0) {
                // empty if block
            }
            this.boosterState = BoosterState.OFF;
            BoostStatResponse boostStatResponse = new BoostStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.boosterState);
            response = boostStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create BoostStatResponse response failed.", (Throwable)ex);
        }
        if (this.futureTriggerGlobalDetector != null) {
            LOGGER.info("Stop the global detector trigger.");
            this.futureTriggerGlobalDetector.cancel(false);
            this.futureTriggerGlobalDetector = null;
        }
        if (this.futureTriggerBoostDiagnostic != null) {
            LOGGER.info("Stop the boost diagnostic trigger.");
            this.futureTriggerBoostDiagnostic.cancel(false);
            this.futureTriggerBoostDiagnostic = null;
        }
        return response;
    }

    protected void triggerBoostDiagnosticResponse() {
        LOGGER.info("Trigger the boostDiagnostic repsonse.");
        byte[] response = null;
        try {
            int currentValue = ThreadLocalRandom.current().nextInt(10, 181);
            int tempValue = ThreadLocalRandom.current().nextInt(25, 70);
            BoostDiagnosticResponse boostDiagnosticResponse = new BoostDiagnosticResponse(this.nodeAddress, this.getNextSendNum(), currentValue, 169, tempValue);
            response = boostDiagnosticResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create boostDiagnostic response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }

    protected byte[] processCsSetStateRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsSetState request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationSetStateMessage commandStationSetStateMessage = (CommandStationSetStateMessage)bidibMessage;
            CommandStationState state = commandStationSetStateMessage.getState();
            LOGGER.info("The requested command station state is: {}", (Object)state);
            switch (state) {
                case OFF: {
                    this.commandStationState = CommandStationState.OFF;
                    break;
                }
                case STOP: 
                case SOFTSTOP: {
                    this.commandStationState = CommandStationState.STOP;
                    break;
                }
                case GO: 
                case GO_IGN_WD: {
                    this.commandStationState = CommandStationState.GO;
                    break;
                }
                case PROG: {
                    this.commandStationState = CommandStationState.PROG;
                    break;
                }
                case QUERY: {
                    LOGGER.warn("Query command station state requested");
                    break;
                }
                default: {
                    LOGGER.warn("Unprocessed command station state: {}", (Object)state);
                }
            }
            LOGGER.info("Return current command station state: {}", (Object)this.commandStationState);
            CommandStationStateResponse commandStationStateResponse = new CommandStationStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.commandStationState.getType());
            response = commandStationStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationQueryMessage commandStationQueryMessage = (CommandStationQueryMessage)bidibMessage;
            CsQueryTypeEnum csQueryType = commandStationQueryMessage.getCsQueryType();
            switch (csQueryType) {
                case LOCO_LIST: {
                    AddressData addressData = new AddressData(13, AddressTypeEnum.LOCOMOTIVE_FORWARD);
                    byte[] functions = new byte[]{-128, 0, 114, -123};
                    CommandStationDriveStateResponse driveStateResponse = new CommandStationDriveStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), 65, addressData, SpeedStepsEnum.DCC128, 39, functions);
                    response = driveStateResponse.getContent();
                    break;
                }
                default: {
                    LOGGER.warn("The CsQueryRequest is not implemented for type: {}", (Object)csQueryType);
                    break;
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationDriveAck response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processCsProgRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the CsProg request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            CommandStationProgMessage commandStationProgMessage = (CommandStationProgMessage)bidibMessage;
            CommandStationPt opCode = commandStationProgMessage.getOpCode();
            int cvNumber = commandStationProgMessage.getCvNumber();
            int cvData = commandStationProgMessage.getCvData();
            LOGGER.info("Received opCode: {}, cvNumber: {}, cvData: {}", new Object[]{opCode, cvNumber, cvData});
            boolean sendTimeoutResponse = false;
            switch (opCode) {
                case BIDIB_CS_PROG_BREAK: {
                    break;
                }
                case BIDIB_CS_PROG_QUERY: {
                    break;
                }
                case BIDIB_CS_PROG_RDWR_BIT: {
                    byte byteValue;
                    Integer storedValue;
                    if ((cvData & 0x10) == 16) {
                        storedValue = this.mapLocoCV.get(cvNumber);
                        if (storedValue != null) {
                            byteValue = ByteUtils.getLowByte((int)storedValue);
                            byteValue = ByteUtils.setBit((byte)byteValue, ((cvData & 8) == 8 ? 1 : 0) != 0, (int)(cvData & 7));
                            LOGGER.info("Changed CV value: {}", (Object)ByteUtils.byteToHex((byte)byteValue));
                            this.mapLocoCV.put(cvNumber, Integer.valueOf(byteValue));
                            break;
                        }
                        byteValue = 0;
                        byteValue = ByteUtils.setBit((byte)byteValue, ((cvData & 8) == 8 ? 1 : 0) != 0, (int)(cvData & 7));
                        LOGGER.info("Changed CV value: {}", (Object)ByteUtils.byteToHex((byte)byteValue));
                        this.mapLocoCV.put(cvNumber, Integer.valueOf(byteValue));
                        break;
                    }
                    storedValue = this.mapLocoCV.get(cvNumber);
                    if (storedValue != null) {
                        byteValue = ByteUtils.getLowByte((int)storedValue);
                        boolean bitIsSetEqual = ByteUtils.isBitSetEqual((byte)byteValue, (int)ByteUtils.getBit((int)cvData, (int)3), (int)(cvData & 7));
                        LOGGER.info("Verify bitIsSetEqual: {}, byteValue: {}", (Object)bitIsSetEqual, (Object)byteValue);
                        if (bitIsSetEqual) break;
                        LOGGER.warn("Send timeout response!");
                        sendTimeoutResponse = true;
                        break;
                    }
                    LOGGER.warn("The requested CV value is not stored, cvNumber: {}", (Object)cvNumber);
                    sendTimeoutResponse = true;
                    break;
                }
                case BIDIB_CS_PROG_WR_BYTE: {
                    this.mapLocoCV.put(cvNumber, cvData);
                    break;
                }
                default: {
                    Integer storedValue = this.mapLocoCV.get(cvNumber);
                    if (storedValue != null) {
                        cvData = ByteUtils.getLowByte((int)storedValue);
                        break;
                    }
                    LOGGER.warn("The requested CV value is not stored, cvNumber: {}", (Object)cvNumber);
                    sendTimeoutResponse = true;
                }
            }
            CommandStationProgStateResponse commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_RUNNING, 1, cvNumber, cvData);
            response = commandStationProgStateResponse.getContent();
            LOGGER.info("Publish the running response: {}", (Object)commandStationProgStateResponse);
            this.publishResponse(response);
            LOGGER.info("Sleep a second.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Sleep thread was interrupted.", (Throwable)e);
            }
            if (!sendTimeoutResponse) {
                LOGGER.info("Prepare the OKAY state response.");
                commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_OKAY, 1, cvNumber, cvData);
            } else {
                LOGGER.info("Prepare the NO_ANSWER state response.");
                commandStationProgStateResponse = new CommandStationProgStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), CommandStationProgState.PROG_NO_ANSWER, 1, cvNumber, 255);
            }
            response = commandStationProgStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create CommandStationProgState response failed.", (Throwable)ex);
        }
        return response;
    }

    private void triggerFeedbackAddressResponse(int portNum, int ... locoAddresses) {
        LOGGER.info("Trigger the feedback address repsonse, portNum: {}", (Object)portNum);
        byte[] response = null;
        LinkedList<FeedbackAddressData> addresses = new LinkedList<FeedbackAddressData>();
        for (int addressData : locoAddresses) {
            byte lowByte = ByteUtils.getLowByte((int)addressData);
            byte highByte = ByteUtils.getLowByte((int)128);
            int address = ByteUtils.getWord((byte)lowByte, (byte)((byte)(highByte & 0x3F)));
            AddressData addressDataIn = new AddressData(address, AddressTypeEnum.valueOf((byte)((byte)((highByte & 0xC0) >> 6))));
            addresses.add(new FeedbackAddressData(addressDataIn.getAddress(), EnrailmentDirectionEnum.LOCOMOTIVE_RIGHT));
        }
        try {
            int detectorNumber = portNum;
            ArrayList<AddressData> bidibAddresses = new ArrayList<AddressData>();
            if (CollectionUtils.isNotEmpty(addresses)) {
                for (FeedbackAddressData addressData : addresses) {
                    EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                    AddressTypeEnum addressType = null;
                    switch (enrailmentDirection) {
                        case LOCOMOTIVE_LEFT: 
                        case LOCOMOTIVE_RIGHT: {
                            addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                            break;
                        }
                        case BASIC_ACCESSORY: {
                            addressType = AddressTypeEnum.ACCESSORY;
                            break;
                        }
                        case EXTENDED_ACCESSORY: {
                            addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                            break;
                        }
                    }
                    AddressData bidibAddress = new AddressData(addressData.getAddress(), addressType);
                    bidibAddresses.add(bidibAddress);
                }
            }
            if (CollectionUtils.isNotEmpty(bidibAddresses)) {
                FeedbackAddressResponse feedbackAddressResponse = new FeedbackAddressResponse(this.nodeAddress, this.getNextSendNum(), detectorNumber, bidibAddresses);
                LOGGER.info("Prepared feedbackAddressResponse: {}", (Object)feedbackAddressResponse);
                response = feedbackAddressResponse.getContent();
                this.sendSpontanousResponse(response);
            }
            if (CollectionUtils.isNotEmpty(bidibAddresses)) {
                for (AddressData addressData : bidibAddresses) {
                    int address = addressData.getAddress();
                    int speedValue = ThreadLocalRandom.current().nextInt(2, 100);
                    FeedbackSpeedResponse feedbackSpeedResponse = new FeedbackSpeedResponse(this.nodeAddress, this.getNextSendNum(), address, speedValue);
                    this.sendSpontanousResponse(feedbackSpeedResponse.getContent());
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create FeedbackAddressResponse failed.", (Throwable)ex);
        }
    }

    private static final class LocoListItem {
        protected int address;
        protected int speed;

        public LocoListItem(int address, int speed) {
            this.address = address;
            this.speed = speed;
        }
    }
}

