/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaSetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigSetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetAllMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.FlatPortType;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.PortType;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.simulation.events.InputPortSetStatusEvent;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="13", pid="118"), @BidibNodeSimulator(vid="251", pid="113"), @BidibNodeSimulator(vid="251", pid="114")})
public class ReadyDmxLineSimulator
extends DefaultNodeSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadyDmxLineSimulator.class);
    protected final Map<Integer, InputPort> inputPorts = new HashMap<Integer, InputPort>();
    protected int inputPortCount;
    private byte totalAspects = (byte)26;

    public ReadyDmxLineSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
        if (this.inputPortCount > 0) {
            this.features.add(new Feature(50, this.inputPortCount));
        }
        this.features.add(new Feature(40, 8));
        this.features.add(new Feature(41, 0));
        this.features.add(new Feature(254, 1));
    }

    protected void setupInputPorts() {
        if (CollectionUtils.isNotEmpty(this.inputPorts.values())) {
            LOGGER.info("InputPorts are set externally already.");
            return;
        }
        for (int id = 0; id < this.inputPortCount; ++id) {
            InputPort port = new InputPort();
            port.setId(id);
            port.setStatus((BidibStatus)(id % 2 == 0 ? InputPortStatus.ON : InputPortStatus.OFF));
            this.inputPorts.put(id, port);
        }
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        this.setupInputPorts();
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    @EventSubscriber(eventClass=InputPortSetStatusEvent.class)
    public void inputPortSetStatus(InputPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the input port was requested.");
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        this.changeInputPortStatus(portNum);
    }

    protected void changeInputPortStatus(int portNum) {
        InputPort port = this.inputPorts.get(portNum);
        if (port != null) {
            switch ((InputPortStatus)port.getStatus()) {
                case OFF: {
                    port.setStatus((BidibStatus)InputPortStatus.ON);
                    break;
                }
                default: {
                    port.setStatus((BidibStatus)InputPortStatus.OFF);
                }
            }
            LcKeyMessage lcKeyMessage = new LcKeyMessage(portNum){

                public byte[] getAddr() {
                    return ReadyDmxLineSimulator.this.getNodeAddress();
                }
            };
            this.processRequest((BidibMessageInterface)lcKeyMessage);
        } else {
            LOGGER.warn("The requested light port is not available: {}", (Object)portNum);
        }
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 64: {
                response = this.processLcOutputRequest(bidibMessage);
                break;
            }
            case 66: {
                response = this.processLcConfigGetRequest(bidibMessage);
                break;
            }
            case 65: {
                response = this.processLcConfigSetRequest(bidibMessage);
                break;
            }
            case 68: {
                response = this.processLcPortQueryRequest(bidibMessage);
                break;
            }
            case 63: {
                this.processLcPortQueryAllRequest(bidibMessage);
                break;
            }
            case 70: {
                response = this.processLcConfigXSetRequest(bidibMessage);
                break;
            }
            case 71: {
                response = this.processLcConfigXGetRequest(bidibMessage);
                break;
            }
            case 69: {
                this.processLcConfigXGetAllRequest(bidibMessage);
                break;
            }
            case 56: {
                response = this.processAccessorySetRequest(bidibMessage);
                break;
            }
            case 57: {
                response = this.processAccessoryGetRequest(bidibMessage);
                break;
            }
            case 60: {
                response = this.processAccessoryGetAllRequest(bidibMessage);
                break;
            }
            case 58: {
                response = this.processAccessoryParaSetRequest(bidibMessage);
                break;
            }
            case 59: {
                response = this.processAccessoryParaGetRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
            LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
            int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
            response = lcNotAvailableResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigGetMessage lcConfigGetMessage = (LcConfigGetMessage)bidibMessage;
            LcOutputType outputType = lcConfigGetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigGetMessage.getPortNumber(this.getPortModel());
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
            response = lcNotAvailableResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfig response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigSetMessage lcConfigSetMessage = (LcConfigSetMessage)bidibMessage;
            LcOutputType outputType = lcConfigSetMessage.getPortType(this.getPortModel());
            int outputNumber = lcConfigSetMessage.getPortNumber(this.getPortModel());
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LOGGER.warn("No port assigned!");
            LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
            response = magicResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
            int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
            LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
            InputPort port = null;
            switch (outputType) {
                case INPUTPORT: {
                    InputPort inputPort = this.inputPorts.get(outputNumber);
                    if (inputPort != null) {
                        inputPort.setPortConfigX(lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                        port = inputPort;
                        break;
                    }
                    LOGGER.warn("Inputport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigSet request for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcConfigX lcConfigX = new LcConfigX(bidibPort, lcConfigXSetMessage.getLcConfigX(this.messageLogger).getPortConfig());
                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                response = lcConfigXResponse.getContent();
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
            int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
            LcOutputType lcOutputType = lcConfigXGetMessage.getPortType(this.getPortModel());
            Object port = null;
            LinkedHashMap values = new LinkedHashMap();
            switch (lcOutputType) {
                case INPUTPORT: {
                    InputPort inputPort = this.inputPorts.get(outputNumber);
                    if (inputPort != null) {
                        LOGGER.info("Return config of input port: {}", (Object)inputPort);
                        BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)inputPort.getId());
                        LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                        LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                        response = lcConfigXResponse.getContent();
                        LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                        break;
                    }
                    LOGGER.warn("Inputport not available, outputNumber: {}", (Object)outputNumber);
                    break;
                }
                default: {
                    LOGGER.warn("LcConfigGet request for unsupported port type detected: {}", (Object)lcOutputType);
                }
            }
            LOGGER.info("Return config of port: {}", port);
            if (response == null) {
                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)outputNumber);
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        block8: {
            LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
            byte[] response = null;
            try {
                LcConfigXGetAllMessage lcConfigXGetAllMessage = (LcConfigXGetAllMessage)bidibMessage;
                LcOutputType lcOutputType = lcConfigXGetAllMessage.getPortTypeFrom(this.getPortModel());
                LinkedHashMap values = new LinkedHashMap();
                if (lcOutputType != null) {
                    LOGGER.info("Get all ports for output type: {}", (Object)lcOutputType);
                    switch (lcOutputType) {
                        case INPUTPORT: {
                            for (InputPort inputPort : this.inputPorts.values()) {
                                values.clear();
                                LOGGER.info("Return config of input port: {}", (Object)inputPort);
                                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)lcOutputType, (int)inputPort.getId());
                                LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block8;
                        }
                        default: {
                            LOGGER.warn("Unsupported port type requested: {}", (Object)lcOutputType);
                            break;
                        }
                    }
                    break block8;
                }
                for (InputPort inputPort : this.inputPorts.values()) {
                    values.clear();
                    LOGGER.info("Return config of input port: {}", (Object)inputPort);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)LcOutputType.INPUTPORT, (int)inputPort.getId());
                    LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                    LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                    response = null;
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create lcConfigXResponse response failed.", (Throwable)ex);
            }
        }
    }

    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutputQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        byte portState = 0;
        try {
            LcPortQueryMessage lcPortQueryMessage = (LcPortQueryMessage)bidibMessage;
            LcOutputType outputType = lcPortQueryMessage.getPortType(this.getPortModel());
            int outputNumber = lcPortQueryMessage.getPortNumber(this.getPortModel());
            LOGGER.info("Get port with portNumber: {}", (Object)outputNumber);
            switch (outputType) {
                case INPUTPORT: {
                    portState = ((InputPortStatus)this.inputPorts.get(outputNumber).getStatus()).getType().getType();
                    break;
                }
                default: {
                    LOGGER.warn("LcOutputQuery for unsupported port type detected: {}", (Object)outputType);
                }
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
            response = lcStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processLcPortQueryAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the PortQueryAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcPortQueryAllMessage portQueryAllMessage = (LcPortQueryAllMessage)bidibMessage;
            int portRangeFrom = portQueryAllMessage.getPortRangeFrom(this.getPortModel());
            int portRangeTo = portQueryAllMessage.getPortRangeTo(this.getPortModel());
            int portTypeMask = portQueryAllMessage.getPortTypeMask();
            LOGGER.info("Query all port states, portRangeFrom: {}, portRangeTo: {}, portModel: {}, portTypeMask: {}", new Object[]{portRangeFrom, portRangeTo, this.getPortModel(), portTypeMask});
            if (PortConfigUtils.isSupportsInputPort((int)portTypeMask) && MapUtils.isNotEmpty(this.inputPorts)) {
                for (InputPort inputPort : this.inputPorts.values()) {
                    if (inputPort.getId() >= portRangeFrom && inputPort.getId() < portRangeTo) {
                        try {
                            InputPortStatus inputPortStatus = (InputPortStatus)inputPort.getStatus();
                            byte portStatus = inputPortStatus.getType().getType();
                            this.publishPortState(bidibMessage.getAddr(), LcOutputType.INPUTPORT, inputPort.getId(), portStatus);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Publish port state failed for port: {}", (Object)inputPort, (Object)ex);
                        }
                        continue;
                    }
                    LOGGER.info("Skip input port that is out of port range: {}", (Object)inputPort);
                }
            }
            LOGGER.info("Send the terminating LC_NA message.");
            this.publishLcNaResponse(bidibMessage.getAddr());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void publishPortState(byte[] address, LcOutputType outputType, int outputNumber, byte portStatus) throws ProtocolException {
        BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
        LcStatResponse lcStatResponse = new LcStatResponse(address, this.getNextSendNum(), bidibPort, portStatus);
        LOGGER.info("Prepared LcStatResponse: {}", (Object)lcStatResponse);
        byte[] response = lcStatResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected void publishLcNaResponse(byte[] address) throws ProtocolException {
        BidibPort bidibPort = new BidibPort(new byte[]{ByteUtils.getLowByte((int)255), ByteUtils.getLowByte((int)255)});
        LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(address, this.getNextSendNum(), bidibPort);
        LOGGER.info("Prepared LcNotAvailableResponse: {}", (Object)lcNotAvailableResponse);
        byte[] response = lcNotAvailableResponse.getContent();
        this.sendSpontanousResponse(response);
    }

    protected byte[] processAccessorySetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessorySet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessorySetMessage accessorySetMessage = (AccessorySetMessage)bidibMessage;
            int accessoryNumber = accessorySetMessage.getAccessoryNumber();
            int aspect = accessorySetMessage.getAspect();
            byte[] value = new byte[]{this.totalAspects, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)aspect, value);
            response = accessoryStateResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryGetMessage accessoryGetMessage = (AccessoryGetMessage)bidibMessage;
            int accessoryNumber = accessoryGetMessage.getAccessoryNumber();
            boolean aspect = true;
            byte[] value = new byte[]{this.totalAspects, 0, 0};
            AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)(aspect ? 1 : 0), value);
            response = accessoryStateResponse.getContent();
            LOGGER.info("Return accessoryStateResponse: {}", (Object)accessoryStateResponse.toExtendedString());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryGetAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryGetAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            Feature featureAccessoryCount = Feature.findFeature((Collection)this.features, (int)40);
            int accessoryCount = featureAccessoryCount.getValue();
            boolean aspect = false;
            for (int accessoryNumber = 0; accessoryNumber < accessoryCount; ++accessoryNumber) {
                byte[] value = new byte[]{3, 0, 0};
                Feature featureAccessoryMacroMapped = Feature.findFeature((Collection)this.features, (int)42);
                if (featureAccessoryMacroMapped != null && featureAccessoryMacroMapped.getValue() > 0) {
                    value[0] = 0;
                    switch (accessoryNumber) {
                        case 0: {
                            value[0] = 2;
                            aspect = false;
                            break;
                        }
                        case 1: {
                            value[0] = 5;
                            aspect = false;
                            break;
                        }
                        case 2: {
                            value[0] = 7;
                            aspect = false;
                            break;
                        }
                        case 3: {
                            value[0] = 4;
                            aspect = false;
                            break;
                        }
                    }
                }
                LOGGER.info("Return data for accessory: {}, data: {}", (Object)accessoryNumber, (Object)ByteUtils.bytesToHex((byte[])value));
                AccessoryStateResponse accessoryStateResponse = new AccessoryStateResponse(bidibMessage.getAddr(), this.getNextSendNum(), (byte)accessoryNumber, (byte)(aspect ? 1 : 0), value);
                response = accessoryStateResponse.getContent();
                this.sendSpontanousResponse(response);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryState response failed.", (Throwable)ex);
        }
        return null;
    }

    protected byte[] processAccessoryParaSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaSetMessage accessoryParaSetMessage = (AccessoryParaSetMessage)bidibMessage;
            int accessoryNumber = accessoryParaSetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaSetMessage.getParaNumber();
            byte[] value = accessoryParaSetMessage.getValue();
            AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
            response = accessoryParaResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processAccessoryParaGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the AccessoryParaGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            AccessoryParaGetMessage accessoryParaGetMessage = (AccessoryParaGetMessage)bidibMessage;
            int accessoryNumber = accessoryParaGetMessage.getAccessoryNumber();
            int paraNumber = accessoryParaGetMessage.getParaNumber();
            if (paraNumber == 254) {
                LOGGER.info("The param BIDIB_ACCESSORY_SWITCH_TIME is known for accessory 0 and 1!");
                byte[] value = null;
                switch (accessoryNumber) {
                    case 0: {
                        value = new byte[]{ByteUtils.getLowByte((int)135)};
                        break;
                    }
                    case 1: {
                        value = new byte[]{ByteUtils.getLowByte((int)119)};
                        break;
                    }
                    default: {
                        value = new byte[]{ByteUtils.getLowByte((int)paraNumber)};
                        paraNumber = 255;
                    }
                }
                AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
                response = accessoryParaResponse.getContent();
            } else {
                byte[] value = new byte[]{0, 0, 0, 0};
                AccessoryParaResponse accessoryParaResponse = new AccessoryParaResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)accessoryNumber), ByteUtils.getLowByte((int)paraNumber), value);
                response = accessoryParaResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create AccessoryPara response failed.", (Throwable)ex);
        }
        return response;
    }

    public void setPortsConfig(FlatPortType portType) {
    }

    public void setPortsConfig(PortType portType) {
        if (portType == null) {
            return;
        }
        if (portType instanceof InputPortType) {
            this.inputPortCount = portType.getCount();
            LOGGER.info("Configured number of input ports: {}", (Object)this.inputPortCount);
        }
    }
}

