/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.enums.InputPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LcConfigXGetAllMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulators;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.PortType;
import org.bidib.jbidibc.simulation.nodes.ServoPortType;
import org.bidib.jbidibc.simulation.nodes.SwitchPortType;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.simulation.LightControlSimulator;
import org.bidib.wizard.simulation.events.InputPortSetStatusEvent;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.PortConfigEvent;
import org.bidib.wizard.simulation.events.ServoPortStatusEvent;
import org.bidib.wizard.simulation.events.SwitchPortStatusEvent;
import org.bidib.wizard.simulation.ports.GenericSimulationPort;
import org.bidib.wizard.simulation.ports.PortListUtils;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulators(value={@BidibNodeSimulator(vid="251", pid="232")})
public class ReadyServo8Simulator
extends LightControlSimulator
implements SwitchingFunctionsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadyServo8Simulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.ReadyServo8Panel";
    private final Map<Integer, GenericSimulationPort> genericPorts = new HashMap<Integer, GenericSimulationPort>();

    public ReadyServo8Simulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
    }

    @Override
    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    @Override
    public void postConstruct() {
        super.postConstruct();
        Feature feature = this.getFeature(70);
        if (feature != null && MapUtils.isEmpty(this.genericPorts)) {
            LOGGER.info("The current simulator has the flat model configured. Prepare the generic ports.");
            int numPorts = feature.getValue();
            LOGGER.info("Create generic ports, numPorts: {}", (Object)numPorts);
            this.servoPortCount = 8;
            this.inputPortOffset = this.switchPortCount = 8;
            for (int portNumber = 0; portNumber < numPorts; ++portNumber) {
                GenericSimulationPort port = new GenericSimulationPort(portNumber);
                int mask = 0;
                if (portNumber >= 0 && portNumber < 8) {
                    port.setPortValue(120);
                    mask = 4;
                    port.setCurrentPortType(LcOutputType.SERVOPORT, mask);
                } else {
                    port.setPortStatus(portNumber % 2 == 0 ? InputPortStatus.ON.getType().getType() : InputPortStatus.OFF.getType().getType());
                    mask = 32769;
                    port.setCurrentPortType(LcOutputType.INPUTPORT, mask);
                }
                LOGGER.info("Register genericPort, portNumber: {}, port: {}", (Object)portNumber, (Object)port);
                this.genericPorts.put(portNumber, port);
            }
        } else {
            LOGGER.info("Skip init the ports because the ports are available already.");
            if (MapUtils.isNotEmpty(this.genericPorts)) {
                LOGGER.info("Set the feature FEATURE_CTRL_PORT_FLAT_MODEL to value: {}", (Object)this.genericPorts.size());
                this.features.add(new Feature(70, this.genericPorts.size()));
            }
        }
    }

    @Override
    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
    }

    @Override
    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        super.start();
        if (!MapUtils.isEmpty(this.genericPorts)) {
            GenericSimulationPort genericPort;
            int portNum;
            int index = 0;
            for (portNum = 0; portNum < this.servoPortCount; ++portNum) {
                genericPort = this.genericPorts.get(portNum + index);
                genericPort.setCurrentPortType(LcOutputType.SERVOPORT, 4);
                LinkedHashMap<Byte, BytePortConfigValue> portConfig = new LinkedHashMap<Byte, BytePortConfigValue>();
                portConfig.put((byte)7, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)20))));
                portConfig.put((byte)8, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)200))));
                portConfig.put((byte)9, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)4))));
                portConfig.put((byte)10, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)0))));
                portConfig.put((byte)16, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)0))));
                genericPort.setPortConfigX(portConfig);
                genericPort.setPortValue(ServoPort.getAbsoluteValue((int)(portNum % 4 * 25)));
            }
            LOGGER.info("Set the port type for GPIO ports, index: {}, switchPortCount: {}", (Object)(index += this.servoPortCount), (Object)this.switchPortCount);
            for (portNum = 0; portNum < this.switchPortCount; ++portNum) {
                genericPort = this.genericPorts.get(portNum + index);
                int mask = 32769;
                genericPort.setCurrentPortType(LcOutputType.SWITCHPORT, mask);
                LOGGER.info("The current port is configured as INPUT port: {}", (Object)genericPort);
                Map portConfig = genericPort.getPortConfigX();
                portConfig.remove((byte)-127);
                portConfig.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, new BytePortConfigValue(Byte.valueOf((byte)0)));
                portConfig.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, new BytePortConfigValue(Byte.valueOf((byte)2)));
                portConfig.put((byte)11, new BytePortConfigValue(Byte.valueOf((byte)30)));
                genericPort.setPortConfigX(portConfig);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 64: {
                response = this.processLcOutputRequest(bidibMessage);
                break;
            }
            case 66: {
                response = this.processLcConfigGetRequest(bidibMessage);
                break;
            }
            case 65: {
                response = this.processLcConfigSetRequest(bidibMessage);
                break;
            }
            case 67: {
                response = this.processLcKeyQueryRequest(bidibMessage);
                break;
            }
            case 68: {
                response = this.processLcPortQueryRequest(bidibMessage);
                break;
            }
            case 70: {
                response = this.processLcConfigXSetRequest(bidibMessage);
                break;
            }
            case 71: {
                response = this.processLcConfigXGetRequest(bidibMessage);
                break;
            }
            case 69: {
                this.processLcConfigXGetAllRequest(bidibMessage);
                break;
            }
            case 72: {
                response = this.processLcMacroHandleRequest(bidibMessage);
                break;
            }
            case 76: {
                response = this.processLcMacroParaGetRequest(bidibMessage);
                break;
            }
            case 75: {
                response = this.processLcMacroParaSetRequest(bidibMessage);
                break;
            }
            case 74: {
                response = this.processLcMacroGetRequest(bidibMessage);
                break;
            }
            case 73: {
                response = this.processLcMacroSetRequest(bidibMessage);
                break;
            }
            case 56: {
                response = this.processAccessorySetRequest(bidibMessage);
                break;
            }
            case 57: {
                response = this.processAccessoryGetRequest(bidibMessage);
                break;
            }
            case 58: {
                response = this.processAccessoryParaSetRequest(bidibMessage);
                break;
            }
            case 59: {
                response = this.processAccessoryParaGetRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    @Override
    protected byte[] processLcOutputRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcOutput request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcOutputMessage lcOutputMessage = (LcOutputMessage)bidibMessage;
            LcOutputType outputType = lcOutputMessage.getOutputType(this.getPortModel());
            int outputNumber = lcOutputMessage.getOutputNumber(this.getPortModel());
            byte outputStatus = lcOutputMessage.getOutputStatus();
            GenericPort port = this.genericPorts.get(outputNumber);
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                LcStatResponse lcStatResponse = null;
                if (port.isMatchingPortType(LcOutputType.SERVOPORT) || port.isMatchingPortType(LcOutputType.BACKLIGHTPORT)) {
                    port.setPortValue(Integer.valueOf(ByteUtils.getInt((byte)outputStatus)));
                } else {
                    port.setPortStatus(outputStatus);
                }
                lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, lcOutputMessage.getOutputStatus());
                response = lcStatResponse.getContent();
            } else {
                LOGGER.warn("No port available with portNumber: {}", (Object)outputNumber);
                LcNotAvailableResponse lcNotAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = lcNotAvailableResponse.getContent();
            }
            if (port != null) {
                switch (outputType) {
                    case INPUTPORT: {
                        this.publishInputPortChange(port);
                        break;
                    }
                    case SWITCHPORT: {
                        this.publishSwitchPortChange(port);
                        break;
                    }
                    case SERVOPORT: {
                        this.publishServoPortChange(port);
                        break;
                    }
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    private void publishSwitchPortChange(GenericPort port) {
        SwitchPortStatus status = SwitchPortStatus.valueOf((SwitchPortEnum)SwitchPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The switchport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new SwitchPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    private void publishServoPortChange(GenericPort port) {
        Integer value = port.getPortValue();
        LOGGER.info("The servoport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new ServoPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), value));
    }

    @Override
    protected byte[] processLcConfigXSetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXSet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXSetMessage lcConfigXSetMessage = (LcConfigXSetMessage)bidibMessage;
            int outputNumber = lcConfigXSetMessage.getPortNumber(this.getPortModel());
            LcOutputType outputType = lcConfigXSetMessage.getPortType(this.getPortModel());
            GenericPort port = null;
            port = this.genericPorts.get(outputNumber);
            LOGGER.info("Set LcConfig for output number: {}, port: {}", (Object)outputNumber, (Object)port);
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            boolean publishConfigChangeEvent = false;
            if (port != null) {
                Object supportedPortTypes;
                Map currentPortConfig = port.getPortConfigX();
                LcConfigX lcConfigX = lcConfigXSetMessage.getLcConfigX(this.messageLogger);
                ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)lcConfigX.getPortConfig().get((byte)-127);
                if (reconfig != null && (supportedPortTypes = port.getSupportedPortTypes()) != null) {
                    ReconfigPortConfigValue reconfigPortConfigValue = new ReconfigPortConfigValue((int)reconfig.getCurrentOutputType().getType(), ((Integer)supportedPortTypes).intValue());
                    LOGGER.info("Prepared BIDIB_PCFG_RECONFIG to replace: {}", (Object)reconfigPortConfigValue);
                    lcConfigX.getPortConfig().put((byte)-127, reconfigPortConfigValue);
                    publishConfigChangeEvent = true;
                }
                for (Map.Entry entry : lcConfigX.getPortConfig().entrySet()) {
                    Byte key = (Byte)entry.getKey();
                    if (currentPortConfig.containsKey(key)) {
                        currentPortConfig.remove(key);
                    }
                    currentPortConfig.put(key, (PortConfigValue)entry.getValue());
                }
                port.setPortConfigX(currentPortConfig);
                lcConfigX.getPortConfig().clear();
                switch (port.getCurrentPortType()) {
                    case INPUTPORT: {
                        lcConfigX.getPortConfig().put((byte)-127, (PortConfigValue)currentPortConfig.get((byte)-127));
                        lcConfigX.getPortConfig().put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, (PortConfigValue)currentPortConfig.get(BidibLibrary.BIDIB_PCFG_INPUT_CTRL));
                        break;
                    }
                    case SWITCHPORT: {
                        lcConfigX.getPortConfig().putAll(currentPortConfig);
                        lcConfigX.getPortConfig().remove(BidibLibrary.BIDIB_PCFG_INPUT_CTRL);
                        break;
                    }
                    default: {
                        lcConfigX.getPortConfig().putAll(currentPortConfig);
                    }
                }
                byte[] content = LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel());
                LOGGER.info("Prepared content: {}", (Object)ByteUtils.bytesToHex((byte[])content));
                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), content);
                response = lcConfigXResponse.getContent();
                if (publishConfigChangeEvent) {
                    LOGGER.info("Publish the change of port type for port: {}", (Object)port);
                    this.publishPortConfigChange(port, port.getCurrentPortType());
                }
            } else {
                LOGGER.warn("No port assigned!");
                LcNotAvailableResponse magicResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = magicResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcConfigXGetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcConfigXGet request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcConfigXGetMessage lcConfigXGetMessage = (LcConfigXGetMessage)bidibMessage;
            int outputNumber = lcConfigXGetMessage.getPortNumber(this.getPortModel());
            LcOutputType outputType = lcConfigXGetMessage.getPortType(this.getPortModel());
            GenericPort port = null;
            LinkedHashMap<Byte, Object> values = new LinkedHashMap<Byte, Object>();
            port = this.genericPorts.get(outputNumber);
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            if (port != null) {
                if (outputNumber >= 0 && outputNumber < this.servoPortCount) {
                    values.put((byte)-127, new ReconfigPortConfigValue(Integer.valueOf(1026)));
                } else if (outputNumber >= 4 && outputNumber < this.servoPortCount + 16) {
                    values.putAll(port.getPortConfigX());
                } else {
                    values.put((byte)-127, new ReconfigPortConfigValue(Integer.valueOf(8388879)));
                    values.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, new BytePortConfigValue(Byte.valueOf((byte)0)));
                    values.put((byte)11, new BytePortConfigValue(Byte.valueOf((byte)32)));
                }
                LOGGER.info("Return config of port: {}", (Object)port);
                LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                response = lcConfigXResponse.getContent();
            } else {
                LOGGER.warn("No port available with port number: {}", (Object)outputNumber);
                LcNotAvailableResponse notAvailableResponse = new LcNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort);
                response = notAvailableResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcConfigX response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected void processLcConfigXGetAllRequest(BidibMessageInterface bidibMessage) {
        block16: {
            LOGGER.info("Process the LcConfigXGetAll request: {}", (Object)bidibMessage);
            try {
                LcConfigXGetAllMessage lcConfigXGetAllMessage = (LcConfigXGetAllMessage)bidibMessage;
                LcOutputType outputType = lcConfigXGetAllMessage.getPortTypeFrom(this.getPortModel());
                HashMap<Byte, PortConfigValue> values = new HashMap<Byte, PortConfigValue>();
                if (outputType != null) {
                    LOGGER.info("Get all ports for output type: {}", (Object)outputType);
                    byte[] response = null;
                    switch (outputType) {
                        case SERVOPORT: {
                            for (GenericSimulationPort servoPort : PortListUtils.findPortsByType(this.genericPorts.values(), LcOutputType.SERVOPORT)) {
                                values.clear();
                                values.putAll(servoPort.getPortConfigX());
                                LOGGER.info("Return config of servo port: {}", (Object)servoPort);
                                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)servoPort.getPortNumber());
                                LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block16;
                        }
                        case SWITCHPORT: {
                            for (GenericSimulationPort switchPort : PortListUtils.findPortsByType(this.genericPorts.values(), LcOutputType.SWITCHPORT)) {
                                values.clear();
                                values.putAll(switchPort.getPortConfigX());
                                values.remove(BidibLibrary.BIDIB_PCFG_INPUT_CTRL);
                                LOGGER.info("Return config of switch port: {}", (Object)switchPort);
                                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)switchPort.getPortNumber());
                                LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block16;
                        }
                        case INPUTPORT: {
                            for (GenericSimulationPort inputPort : PortListUtils.findPortsByType(this.genericPorts.values(), LcOutputType.INPUTPORT)) {
                                values.clear();
                                values.put((byte)-127, (PortConfigValue)inputPort.getPortConfigX().get((byte)-127));
                                values.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, (PortConfigValue)inputPort.getPortConfigX().get(BidibLibrary.BIDIB_PCFG_INPUT_CTRL));
                                LOGGER.info("Return config of input port: {}", (Object)inputPort);
                                BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)inputPort.getPortNumber());
                                LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                                LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                                response = lcConfigXResponse.getContent();
                                LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                                this.sendSpontanousResponse(response);
                                response = null;
                            }
                            break block16;
                        }
                        default: {
                            LOGGER.warn("Unsupported port type requested: {}", (Object)outputType);
                        }
                    }
                    break block16;
                }
                for (GenericPort genericPort : this.genericPorts.values()) {
                    int portNumber = genericPort.getPortNumber();
                    LOGGER.info("Prepare lcConfigXResponse for port number: {}", (Object)portNumber);
                    values.clear();
                    values.putAll(genericPort.getPortConfigX());
                    switch (genericPort.getCurrentPortType()) {
                        case INPUTPORT: {
                            values.remove((byte)11);
                            values.remove(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL);
                            break;
                        }
                        case SWITCHPORT: {
                            values.remove(BidibLibrary.BIDIB_PCFG_INPUT_CTRL);
                            break;
                        }
                    }
                    LOGGER.info("Return config of port: {}", (Object)genericPort);
                    BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)portNumber);
                    LcConfigX lcConfigX = new LcConfigX(bidibPort, values);
                    LcConfigXResponse lcConfigXResponse = new LcConfigXResponse(bidibMessage.getAddr(), this.getNextSendNum(), LcConfigX.getCodedPortConfig(null, (LcConfigX)lcConfigX, (PortModelEnum)this.getPortModel()));
                    byte[] response = lcConfigXResponse.getContent();
                    LOGGER.info("Prepared lcConfigXResponse: {}", (Object)ByteUtils.bytesToHex((byte[])response));
                    this.sendSpontanousResponse(response);
                }
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create lcConfigXResponse response failed.", (Throwable)ex);
            }
        }
    }

    private void publishInputPortChange(GenericPort port) {
        InputPortStatus status = InputPortStatus.valueOf((InputPortEnum)InputPortEnum.valueOf((byte)port.getPortStatus()));
        LOGGER.info("The inputport status has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        EventBus.publish((Object)new InputPortStatusEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), status));
    }

    private void publishPortConfigChange(GenericPort port, LcOutputType signalledPortType) {
        LOGGER.info("The port config has changed, notify the listeners, nodeAddress: {}", (Object)this.nodeAddress);
        PortConfigEvent portConfigEvent = new PortConfigEvent(NodeUtils.formatAddress((byte[])this.nodeAddress), port.getPortNumber(), signalledPortType, port);
        portConfigEvent.setEnabled(port.isMatchingPortType(signalledPortType));
        EventBus.publish((Object)portConfigEvent);
    }

    @Override
    protected byte[] processLcPortQueryRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LcPortQuery request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcPortQueryMessage lcOutputQueryMessage = (LcPortQueryMessage)bidibMessage;
            LcOutputType outputType = lcOutputQueryMessage.getPortType(this.getPortModel());
            int outputNumber = lcOutputQueryMessage.getPortNumber(this.getPortModel());
            GenericPort port = this.genericPorts.get(outputNumber);
            byte portState = 0;
            if (port != null) {
                portState = port.isMatchingPortType(LcOutputType.SERVOPORT) || port.isMatchingPortType(LcOutputType.BACKLIGHTPORT) ? ByteUtils.getLowByte((Integer)port.getPortValue()).byteValue() : port.getPortStatus();
            } else {
                LOGGER.warn("No port available with portNumber: {}", (Object)outputNumber);
            }
            BidibPort bidibPort = BidibPort.prepareBidibPort((PortModelEnum)this.getPortModel(), (LcOutputType)outputType, (int)outputNumber);
            LcStatResponse lcStatResponse = new LcStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), bidibPort, portState);
            response = lcStatResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    protected byte[] processLcPortQueryAllRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the PortQueryAll request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LcPortQueryAllMessage portQueryAllMessage = (LcPortQueryAllMessage)bidibMessage;
            int portRangeFrom = portQueryAllMessage.getPortRangeFrom(this.getPortModel());
            int portRangeTo = portQueryAllMessage.getPortRangeTo(this.getPortModel());
            int portTypeMask = portQueryAllMessage.getPortTypeMask();
            LOGGER.info("Query all port states, portRangeFrom: {}, portRangeTo: {}, portModel: {}, portTypeMask: {}", new Object[]{portRangeFrom, portRangeTo, this.getPortModel(), portTypeMask});
            for (GenericPort genericPort : this.genericPorts.values()) {
                LcOutputType currentPortType = genericPort.getCurrentPortType();
                if (PortConfigUtils.isSupportsPortType((LcOutputType)currentPortType, (int)portTypeMask) && genericPort.getPortNumber() >= portRangeFrom && genericPort.getPortNumber() < portRangeTo) {
                    try {
                        byte portStatus = 0;
                        portStatus = genericPort.isMatchingPortType(LcOutputType.SERVOPORT) || genericPort.isMatchingPortType(LcOutputType.BACKLIGHTPORT) ? ByteUtils.getLowByte((Integer)genericPort.getPortValue()).byteValue() : genericPort.getPortStatus();
                        this.publishPortState(bidibMessage.getAddr(), currentPortType, genericPort.getPortNumber(), portStatus);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Publish port state failed for port: {}", (Object)genericPort, (Object)ex);
                    }
                    continue;
                }
                LOGGER.info("Skip current port that is out of port range or wrong port type: {}", (Object)genericPort);
            }
            LOGGER.info("Send the terminating LC_NA message.");
            this.publishLcNaResponse(bidibMessage.getAddr());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create LcStat response failed.", (Throwable)ex);
        }
        return response;
    }

    @Override
    public void queryStatus(Class<?> portClass) {
        for (GenericSimulationPort port : this.genericPorts.values()) {
            if (portClass == InputPort.class) {
                if (port.isMatchingPortType(LcOutputType.INPUTPORT)) {
                    this.publishInputPortChange(port);
                }
                if (!port.isSupportsInputPort()) continue;
                this.publishPortConfigChange(port, LcOutputType.INPUTPORT);
                continue;
            }
            if (portClass == SwitchPort.class) {
                if (port.isMatchingPortType(LcOutputType.SWITCHPORT)) {
                    this.publishSwitchPortChange(port);
                }
                if (!port.isSupportsSwitchPort()) continue;
                this.publishPortConfigChange(port, LcOutputType.SWITCHPORT);
                continue;
            }
            if (portClass == ServoPort.class) {
                if (port.isMatchingPortType(LcOutputType.SERVOPORT)) {
                    this.publishServoPortChange(port);
                }
                if (!port.isSupportsServoPort()) continue;
                this.publishPortConfigChange(port, LcOutputType.SERVOPORT);
                continue;
            }
            LOGGER.warn("Query port status for unsupported port class: {}", portClass);
        }
    }

    @Override
    public void setPortsConfig(PortType portType) {
        if (portType == null) {
            return;
        }
        LOGGER.info("Set the port config: {}", (Object)portType);
        if (portType instanceof SwitchPortType) {
            this.switchPortCount = portType.getCount();
            LOGGER.info("Set the number of switchPorts: {}", (Object)this.switchPortCount);
        } else if (portType instanceof InputPortType) {
            this.inputPortCount = portType.getCount();
            this.inputPortOffset = portType.getOffset() != null ? portType.getOffset() : 0;
        } else if (portType instanceof ServoPortType) {
            this.servoPortCount = portType.getCount();
        }
    }

    @Override
    @EventSubscriber(eventClass=InputPortSetStatusEvent.class)
    public void inputPortSetStatus(InputPortSetStatusEvent setStatusEvent) {
        LOGGER.info("The change of the input port was requested.");
        String nodeAddress = setStatusEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        int portNum = setStatusEvent.getPortNum();
        this.changeInputPortStatus(portNum);
    }

    @Override
    protected void changeInputPortStatus(int portNum) {
        GenericSimulationPort port = PortListUtils.findPortsByTypeAndPortNumber(this.genericPorts.values(), LcOutputType.INPUTPORT, portNum);
        if (port != null) {
            switch (InputPortStatus.valueOf((InputPortEnum)InputPortEnum.valueOf((byte)port.getPortStatus()))) {
                case OFF: {
                    port.setPortStatus(InputPortStatus.ON.getType().getType());
                    break;
                }
                default: {
                    port.setPortStatus(InputPortStatus.OFF.getType().getType());
                }
            }
            LcPortQueryMessage lcPortQueryMessage = this.getBidibRequestFactory().createLcPortQuery(this.getPortModel(), LcOutputType.INPUTPORT, portNum);
            lcPortQueryMessage.setAddr(this.getNodeAddress());
            this.processRequest((BidibMessageInterface)lcPortQueryMessage);
            this.publishInputPortChange(port);
        } else {
            LOGGER.warn("The requested input port is not available: {}", (Object)portNum);
        }
    }
}

