/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.VendorData;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.MessageClassEnum;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.message.GuestRequestSendMessage;
import org.bidib.jbidibc.messages.message.GuestRequestSubscribeMessage;
import org.bidib.jbidibc.messages.message.NodeTabGetAllMessage;
import org.bidib.jbidibc.messages.message.SysGetMagicMessage;
import org.bidib.jbidibc.messages.message.VendorGetMessage;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.message.VendorSetMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.annotation.BidibNodeSimulator;
import org.bidib.jbidibc.simulation.events.GuestRequestSendAccessoryAspectEvent;
import org.bidib.jbidibc.simulation.events.GuestRequestSendBoosterSetStateEvent;
import org.bidib.jbidibc.simulation.events.GuestRequestSendCsSetStateEvent;
import org.bidib.jbidibc.simulation.events.GuestRequestSendNodeTabGetAllEvent;
import org.bidib.jbidibc.simulation.events.GuestRequestSendNodeTabGetNextEvent;
import org.bidib.jbidibc.simulation.events.GuestRequestSendSysGetMagicEvent;
import org.bidib.jbidibc.simulation.events.GuestSubscribeEvent;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BidibNodeSimulator(vid="251", pid="305")
public class ReadyXPSimulator
extends DefaultNodeSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadyXPSimulator.class);
    private static final String SIMULATION_PANEL_CLASS = "org.bidib.wizard.simulation.client.view.panel.ReadyXPPanel";
    protected final ScheduledExecutorService simulationWorker = Executors.newScheduledThreadPool(1);

    public ReadyXPSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        super(nodeAddress, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
        this.setNodeMagic(49374);
    }

    public String getSimulationPanelClass() {
        return SIMULATION_PANEL_CLASS;
    }

    protected void prepareFeatures() {
        LOGGER.info("Prepare the features.");
        super.prepareFeatures();
    }

    public void start() {
        LOGGER.info("Start the simulator for address: {}", (Object)this.getAddress());
        AnnotationProcessor.process((Object)((Object)this));
        super.start();
    }

    public void stop() {
        AnnotationProcessor.unprocess((Object)((Object)this));
        super.stop();
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 82: {
                response = this.processGuestRespSentRequest(bidibMessage);
                break;
            }
            case 83: {
                response = this.processGuestRespNotifyRequest(bidibMessage);
                break;
            }
            default: {
                response = super.prepareResponse(bidibMessage);
            }
        }
        return response;
    }

    protected byte[] processGuestRespSentRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Received GuestRespSent message: {}", (Object)bidibMessage);
        return null;
    }

    protected byte[] processGuestRespNotifyRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Received GuestRespNotify message: {}", (Object)bidibMessage);
        return null;
    }

    protected byte[] processVendorSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            VendorSetMessage vendorSetMessage = (VendorSetMessage)bidibMessage;
            VendorData vendorData = vendorSetMessage.getVendorData();
            LOGGER.info("Set the vendor data: {}", (Object)vendorData);
            String vendorDataName = vendorData.getName();
            String vendorDataValue = vendorData.getValue();
            if (vendorDataName.toLowerCase().startsWith("ame ")) {
                LOGGER.info("Handle the aspect mapping, name: {}, value: {}", (Object)vendorDataName, (Object)vendorDataValue);
                String result = vendorData.getValue();
                if ("".equals(result) && "AME 0d7f002200 18 2 12 1".equals(vendorDataName)) {
                    LOGGER.warn("Force test invalid result for delete of cv name: {}", (Object)vendorDataName);
                    result = "1";
                } else if ("1".equals(result) && "AME 0d7f002200 17 2 12 1".equals(vendorDataName)) {
                    LOGGER.warn("Force test invalid result for write of cv name: {}", (Object)vendorDataName);
                    result = "";
                }
                VendorResponse vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorData.getName(), result);
                response = vendorResponse.getContent();
            } else {
                this.configurationVariables.put(vendorData.getName(), vendorData.getValue());
                VendorResponse vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorData.getName(), vendorData.getValue());
                response = vendorResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processVendorGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            VendorGetMessage vendorGetMessage = (VendorGetMessage)bidibMessage;
            String vendorDataName = vendorGetMessage.getVendorDataName();
            LOGGER.info("Get the vendor data with name: {}", (Object)vendorDataName);
            if (vendorDataName.toLowerCase().equals("amr *")) {
                LOGGER.info("Handle the aspect mapping.");
                String vendorDataValue = "4";
                VendorResponse vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
                response = vendorResponse.getContent();
                this.sendSpontanousResponse(response);
                vendorDataName = "AME 0D7F002200 18 1 12 0";
                vendorDataValue = "1";
                vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
                response = vendorResponse.getContent();
                this.sendSpontanousResponse(response);
                vendorDataName = "AME 0D7F002200 18 2 12 1";
                vendorDataValue = "1";
                vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
                response = vendorResponse.getContent();
                this.sendSpontanousResponse(response);
                vendorDataName = "AME 0D7F002200 17 1 11 1";
                vendorDataValue = "1";
                vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
                response = vendorResponse.getContent();
                this.sendSpontanousResponse(response);
                vendorDataName = "AME 0D7F002200 17 2 11 0";
                vendorDataValue = "1";
                vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
                response = vendorResponse.getContent();
                this.sendSpontanousResponse(response);
                response = null;
            } else {
                String vendorDataValue = (String)this.configurationVariables.get(vendorDataName);
                if (StringUtils.isBlank((CharSequence)vendorDataValue)) {
                    vendorDataValue = "";
                }
                VendorResponse vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
                response = vendorResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor response failed.", (Throwable)ex);
        }
        return response;
    }

    @EventSubscriber(eventClass=GuestSubscribeEvent.class)
    public void guestSubscribeEvent(GuestSubscribeEvent guestSubscribeEvent) {
        LOGGER.info("Received the guestSubscribeEvent: {}", (Object)guestSubscribeEvent);
        byte[] response = null;
        try {
            int classValue = MessageClassEnum.classValue((MessageClassEnum)guestSubscribeEvent.getMessageClass());
            int subscription = ByteUtils.getInt((byte)ByteUtils.getLowByte((int)classValue), (byte)ByteUtils.getLowByte((int)classValue));
            TargetModeEnum targetMode = TargetModeEnum.BIDIB_TARGET_MODE_TOP;
            switch (guestSubscribeEvent.getMessageClass()) {
                case BIDIB_MESSAGE_CLASS_COMMANDSTATION: {
                    targetMode = TargetModeEnum.BIDIB_TARGET_MODE_DCCGEN;
                    break;
                }
                case BIDIB_MESSAGE_CLASS_ACCESSORY: {
                    targetMode = TargetModeEnum.BIDIB_TARGET_MODE_ACCESSORY;
                    break;
                }
                case BIDIB_MESSAGE_CLASS_BOOSTER: {
                    targetMode = TargetModeEnum.BIDIB_TARGET_MODE_BOOSTER;
                    break;
                }
            }
            GuestRequestSubscribeMessage subscribeMessage = new GuestRequestSubscribeMessage(targetMode, subscription);
            subscribeMessage.setAddr(this.nodeAddress);
            response = subscribeMessage.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create GuestRequestSubscribeMessage response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }

    @EventSubscriber(eventClass=GuestRequestSendCsSetStateEvent.class)
    public void guestSendEvent(GuestRequestSendCsSetStateEvent guestRequestSendEvent) {
        LOGGER.info("Received the guestRequestSendEvent: {}", (Object)guestRequestSendEvent);
        byte[] response = null;
        try {
            CommandStationState csState = guestRequestSendEvent.getState();
            BidibRequestFactory requestFactory = new BidibRequestFactory();
            CommandStationSetStateMessage csDriveMessage = requestFactory.createCommandStationSetState(csState);
            GuestRequestSendMessage guestRequestSendMessage = new GuestRequestSendMessage(TargetModeEnum.BIDIB_TARGET_MODE_DCCGEN, csDriveMessage.getMessageContent());
            guestRequestSendMessage.setAddr(this.nodeAddress);
            response = guestRequestSendMessage.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create GuestRequestSendMessage response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }

    @EventSubscriber(eventClass=GuestRequestSendBoosterSetStateEvent.class)
    public void guestSendEvent(GuestRequestSendBoosterSetStateEvent guestRequestSendEvent) {
        LOGGER.info("Received the guestRequestSendEvent: {}", (Object)guestRequestSendEvent);
        byte[] response = null;
        try {
            BoosterState csState = guestRequestSendEvent.getState();
            BidibRequestFactory requestFactory = new BidibRequestFactory();
            BidibCommand csDriveMessage = requestFactory.createBoosterSetState(csState, false);
            GuestRequestSendMessage guestRequestSendMessage = new GuestRequestSendMessage(TargetModeEnum.BIDIB_TARGET_MODE_BOOSTER, csDriveMessage.getMessageContent());
            guestRequestSendMessage.setAddr(this.nodeAddress);
            response = guestRequestSendMessage.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create GuestRequestSendMessage response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }

    @EventSubscriber(eventClass=GuestRequestSendAccessoryAspectEvent.class)
    public void guestSendEvent(GuestRequestSendAccessoryAspectEvent guestRequestSendEvent) {
        LOGGER.info("Received the guestRequestSendEvent: {}", (Object)guestRequestSendEvent);
        byte[] response = null;
        try {
            int accessoryNumber = guestRequestSendEvent.getAccessoryNumber();
            int aspectNumber = guestRequestSendEvent.getAspectNumber();
            BidibRequestFactory requestFactory = new BidibRequestFactory();
            AccessorySetMessage accessorySetMessage = requestFactory.createAccessorySet(accessoryNumber, aspectNumber);
            GuestRequestSendMessage guestRequestSendMessage = new GuestRequestSendMessage(TargetModeEnum.BIDIB_TARGET_MODE_ACCESSORY, accessorySetMessage.getMessageContent());
            guestRequestSendMessage.setAddr(this.nodeAddress);
            response = guestRequestSendMessage.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create GuestRequestSendMessage response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }

    @EventSubscriber(eventClass=GuestRequestSendSysGetMagicEvent.class)
    public void guestSendEvent(GuestRequestSendSysGetMagicEvent guestRequestSendEvent) {
        LOGGER.info("Received the guestRequestSendEvent: {}", (Object)guestRequestSendEvent);
        byte[] response = null;
        try {
            byte[] targetNodeAddress = guestRequestSendEvent.getTargetNodeAddr();
            BidibRequestFactory requestFactory = new BidibRequestFactory();
            SysGetMagicMessage sysGetMagicMessage = requestFactory.createSysGetMagic();
            GuestRequestSendMessage guestRequestSendMessage = new GuestRequestSendMessage(TargetModeEnum.BIDIB_TARGET_MODE_TOP, sysGetMagicMessage.getMessageContent());
            guestRequestSendMessage.setAddr(this.nodeAddress);
            response = guestRequestSendMessage.getContent();
            LOGGER.info("Prepared response content: {}", (Object)ByteUtils.bytesToHex((byte[])response));
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create GuestRequestSendMessage response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }

    @EventSubscriber(eventClass=GuestRequestSendNodeTabGetAllEvent.class)
    public void guestSendEvent(GuestRequestSendNodeTabGetAllEvent guestRequestSendEvent) {
        LOGGER.info("Received the guestRequestSendEvent: {}", (Object)guestRequestSendEvent);
        byte[] response = null;
        try {
            BidibRequestFactory requestFactory = new BidibRequestFactory();
            NodeTabGetAllMessage nodeTabGetAllMessage = requestFactory.createNodeTabGetAll();
            GuestRequestSendMessage guestRequestSendMessage = new GuestRequestSendMessage(TargetModeEnum.BIDIB_TARGET_MODE_TOP, nodeTabGetAllMessage.getMessageContent());
            guestRequestSendMessage.setAddr(this.nodeAddress);
            response = guestRequestSendMessage.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create GuestRequestSendMessage response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }

    @EventSubscriber(eventClass=GuestRequestSendNodeTabGetNextEvent.class)
    public void guestSendEvent(GuestRequestSendNodeTabGetNextEvent guestRequestSendEvent) {
        LOGGER.info("Received the guestRequestSendEvent: {}", (Object)guestRequestSendEvent);
        byte[] response = null;
        try {
            BidibRequestFactory requestFactory = new BidibRequestFactory();
            BidibCommand nodeTabGetAllMessage = requestFactory.createNodeTabGetNext();
            GuestRequestSendMessage guestRequestSendMessage = new GuestRequestSendMessage(TargetModeEnum.BIDIB_TARGET_MODE_TOP, nodeTabGetAllMessage.getMessageContent());
            guestRequestSendMessage.setAddr(this.nodeAddress);
            response = guestRequestSendMessage.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create GuestRequestSendMessage response failed.", (Throwable)ex);
        }
        this.sendSpontanousResponse(response);
    }
}

