/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.macro;

import java.util.HashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroContainer.class);
    private int macroNumber;
    private Map<Integer, LcMacro> macroSteps = new HashMap<Integer, LcMacro>();
    private Map<Integer, byte[]> macroParameters = new HashMap<Integer, byte[]>();

    public MacroContainer(int macroNumber) {
        this.setMacroNumber(macroNumber);
        LOGGER.info("Create new MacroContainer for macroNumber: {}", (Object)macroNumber);
        byte stepNumber = 0;
        LcMacro lcMacro = new LcMacro(ByteUtils.getLowByte((int)macroNumber), stepNumber, ByteUtils.getLowByte((int)255), LcOutputType.END_OF_MACRO.getType(), 0, 0);
        this.macroSteps.put(0, lcMacro);
        this.macroParameters.put(3, LcMacro.MACRO_START_OFF);
        this.macroParameters.put(1, new byte[]{1});
        this.macroParameters.put(2, new byte[]{1});
    }

    public int getMacroNumber() {
        return this.macroNumber;
    }

    public void setMacroNumber(int macroNumber) {
        this.macroNumber = macroNumber;
    }

    public Map<Integer, LcMacro> getMacroSteps() {
        return this.macroSteps;
    }

    public void setMacroSteps(Map<Integer, LcMacro> macroSteps) {
        this.macroSteps = macroSteps;
    }

    public LcMacro getMacroStep(Integer stepNumber) {
        return this.macroSteps.get(stepNumber);
    }

    public void setMacroStep(Integer stepNumber, LcMacro macroStep) {
        this.macroSteps.put(stepNumber, macroStep);
    }

    public Map<Integer, byte[]> getMacroParameters() {
        return this.macroParameters;
    }

    public void setMacroParameters(Map<Integer, byte[]> macroParameters) {
        this.macroParameters = macroParameters;
    }

    public byte[] getMacroParameter(Integer paramId) {
        byte[] parameter = this.macroParameters.get(paramId);
        LOGGER.info("Get the macro parameterId: {}, params: {}", (Object)paramId, (Object)ByteUtils.bytesToHex((byte[])parameter));
        return parameter;
    }

    public void setMacroParameter(Integer paramId, byte[] parameter) {
        LOGGER.info("Set the macro parameterId: {}, params: {}", (Object)paramId, (Object)ByteUtils.bytesToHex((byte[])parameter));
        this.macroParameters.put(paramId, parameter);
    }
}

