/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.ports;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.simulation.ports.GenericSimulationPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortListUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortListUtils.class);

    public static List<GenericSimulationPort> findPortsByType(Collection<GenericSimulationPort> ports, LcOutputType lcOutputType) {
        List<GenericSimulationPort> filteredPorts = ports.stream().filter(p -> PortListUtils.isSupportsPortType(p, lcOutputType)).collect(Collectors.toList());
        return filteredPorts;
    }

    public static boolean isSupportsPortType(GenericPort genericPort, LcOutputType portType) {
        LcOutputType currentPortType = genericPort.getCurrentPortType();
        return PortConfigUtils.isSupportsPortType((LcOutputType)currentPortType, (int)PortConfigUtils.toPortTypeMask((LcOutputType)portType));
    }

    public static GenericSimulationPort findPortsByTypeAndPortNumber(Collection<GenericSimulationPort> ports, LcOutputType lcOutputType, int portNum) {
        GenericSimulationPort port = ports.stream().filter(p -> PortListUtils.isSupportsPortType(p, lcOutputType)).filter(p -> p.getPortNumber() == portNum).findFirst().orElse(null);
        return port;
    }

    public static GenericSimulationPort findPortByPortNumber(Collection<GenericSimulationPort> ports, int portNum) {
        LOGGER.debug("Find port with portNum: {} in ports: {}", (Object)portNum, ports);
        if (CollectionUtils.isEmpty(ports)) {
            LOGGER.warn("No ports provided to search port number: {}", (Object)portNum);
        }
        GenericSimulationPort port = ports.stream().filter(p -> p.getPortNumber() == portNum).findFirst().orElse(null);
        LOGGER.debug("Return found port: {}", (Object)port);
        return port;
    }
}

