/*
 * Decompiled with CFR 0.152.
 */
package xAPlib;

import xAPlib.xAPMessageObject;
import xAPlib.xAPNameValuePair;

public class xAPMessage
extends xAPMessageObject {
    public xAPMessage() {
    }

    public xAPMessage(String aClass) {
        this.setClassName(aClass);
        this.setHop("1");
        this.setUID("FFFFFFFF");
        this.setVersion("12");
    }

    public xAPMessage(String aClass, String aSource) {
        this.setClassName(aClass);
        this.setSource(aSource);
        this.setHop("1");
        this.setUID("FFFFFFFF");
        this.setVersion("12");
    }

    public xAPMessage(String aClass, String aSource, String aTarget) {
        this.setClassName(aClass);
        this.setSource(aSource);
        this.setTarget(aTarget);
        this.setHop("1");
        this.setUID("FFFFFFFF");
        this.setVersion("12");
    }

    public void setClassName(String aClass) {
        this.addOrUpdateNameValuePair("xap-header", "class", aClass);
    }

    public void setSource(String aSource) {
        this.addOrUpdateNameValuePair("xap-header", "source", aSource);
    }

    public void setTarget(String aTarget) {
        this.addOrUpdateNameValuePair("xap-header", "target", aTarget);
    }

    public void setUID(String aUID) {
        this.addOrUpdateNameValuePair("xap-header", "uid", aUID);
    }

    public void setHop(String aHop) {
        this.addOrUpdateNameValuePair("xap-header", "hop", aHop);
    }

    public void setVersion(String aVersion) {
        this.addOrUpdateNameValuePair("xap-header", "v", aVersion);
    }

    public String getVersion() {
        xAPNameValuePair iNVPair = this.getNameValuePair("xap-header", "v");
        if (iNVPair != null) {
            return iNVPair.getValue();
        }
        return null;
    }

    public String getSource() {
        xAPNameValuePair iNVPair = this.getNameValuePair("xap-header", "source");
        if (iNVPair != null) {
            return iNVPair.getValue();
        }
        return null;
    }

    public String getTarget() {
        xAPNameValuePair iNVPair = this.getNameValuePair("xap-header", "target");
        if (iNVPair != null) {
            return iNVPair.getValue();
        }
        return null;
    }

    public String getUID() {
        xAPNameValuePair iNVPair = this.getNameValuePair("xap-header", "uid");
        if (iNVPair != null) {
            return iNVPair.getValue();
        }
        return null;
    }

    public String getHop() {
        xAPNameValuePair iNVPair = this.getNameValuePair("xap-header", "hop");
        if (iNVPair != null) {
            return iNVPair.getValue();
        }
        return null;
    }

    public String getClassName() {
        xAPNameValuePair iNVPair = this.getNameValuePair("xap-header", "class");
        if (iNVPair != null) {
            return iNVPair.getValue();
        }
        return null;
    }

    public String getHeaderAsString() {
        StringBuffer iHeader = new StringBuffer();
        xAPNameValuePair iNVrecord = this.getFirstNameValuePairInBlock("xap-header");
        if (iNVrecord != null) {
            iHeader.append("xap-header\n{\n");
            iHeader.append(iNVrecord.getName() + "=" + iNVrecord.getValue() + "\n");
            do {
                if ((iNVrecord = this.getNextNameValuePairInBlock("xap-header")) == null) continue;
                iHeader.append(iNVrecord.getName() + "=" + iNVrecord.getValue() + "\n");
            } while (iNVrecord != null);
            iHeader.append("}\n");
        }
        return iHeader.toString();
    }

    public String getBodyAsString() {
        StringBuffer iBody = new StringBuffer();
        String iBlock = this.getFirstBlockName();
        if (iBlock.compareToIgnoreCase("xap-header") == 0) {
            iBlock = this.getNextBlockName();
        }
        if (iBlock == null) {
            return null;
        }
        do {
            xAPNameValuePair iNVPair = this.getFirstNameValuePairInBlock(iBlock);
            iBody.append(iBlock);
            iBody.append("\n{\n");
            do {
                iBody.append(iNVPair.getName() + "=" + iNVPair.getValue() + "\n");
            } while ((iNVPair = this.getNextNameValuePairInBlock(iBlock)) != null);
            iBody.append("}\n");
            while ((iBlock = this.getNextBlockName()) != null && iBlock.compareToIgnoreCase("xap-header") == 0) {
            }
        } while (iBlock != null);
        return iBody.toString();
    }

    public String toString() {
        return this.getHeaderAsString() + "\n" + this.getBodyAsString() + "\n";
    }
}

